#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_38/sys/src/install56/perl/SAPDB/Install/BuildPackage.pm#1 $
# $DateTime: 2006/08/14 15:36:46 $
# $Change: 133140 $
#
# Desc: create MaxDB / SAP DB installation packages
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::BuildPackage;

$VERSION = 1.01;

sub BEGIN {
      my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Values',
		'Misc',
		'System',
		'StdIO',
#		'Version',
		'MD5Sum',
		'SetDebug',
		'Tools',
		'Getopt::Long',
		'SigHandler',
		'Trace',
		'GnuTar'
	);

	$DEBUG = 0;

	push @neededPackages, 'Uninstall::RemoveFilesInUse' if ($^O =~ /mswin/i);
	push @neededPackages, 'Term::ReadKey' if $SAPDB::Install::Config{'HasOwnConsole'};

	
	@EXPORT=('main');
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
}


sub checkOpts{
	my $rc = 1;
	if($opt_backup){
		unless(-f $opt_backup){
			print2stderr("wrong usage: -backup: $!\n");
			$rc = 0;
		}
	}
	else{
		print2stderr("wrong usage: \"-backup\" switch required\n");
		$rc = 0;
	}
	if($opt_package){
		unless($opt_package eq 'DB Instance'){
			print2stderr("wrong usage: -package: package \"$opt_package\" unknown\n");
			$rc = 0;
		
		}			
	}
	else{
		print2stderr("wrong usage: \"-package\" switch required\n");
		$rc = 0;
	}

	if($opt_dir){
		unless(-d $opt_dir){
			print2stderr("wrong usage: -dir: $!\n");
			$rc = 0;
		} 
	}
	if( $opt_archivename=~ /\S/ ){
		unless($opt_archivename =~ /^IA[A-Z0-9]{0,6}\.TGZ$/){
			print2stderr("wrong usage: -archivename: archive name need conventions IA<your string>.TGZ,\n".
										"\t\twith <your string> max length of 6 characters and\n".
										"\t\tcharacter set A-Z 0-9\n");
			$rc=0;
		}
	}

			
	return $rc;
}


sub getPackageFiles{
	my ($package) = @_;

	my %packdefs = (
						'DB Instance' => {	
											'subdir' => 'instance'
						}
	);

	my %returnvalue;
	my ($repo) = @SAPDB::Install::Repository::AllRepo;
	unless(defined $repo){
		print2stderr("cannot get repository\n");
	}
	#my $sdbinst_tgz = $repo->{'tgz'};
	#unless(defined $sdbinst_tgz){
	#	print2stderr("cannot get SDBINST archive handle\n");
	#	diesoft($diemsg);
	#}
	#my $subdir;
	
	#$subdir = $packdefs{$package}->{'subdir'};
		
	#$sdbinst_tgz->Rewind();
	#my $packagedata_name = 'SAPDB/Install/BuildPackage/packages/'.$subdir.'/PACKAGEDATA';
	#my $packagedata;
	#my $script_name;
	#my $script;
	#while(1){
    #	my $header = $sdbinst_tgz->Next();
	#	last unless $header=~ /\S/;
	#	my ($file) = ($header =~ /(\S+)$/);
	#	$file =~ s/^\.\///;
	#	if($packagedata !~ /\S/ and $file eq $packagedata_name){
	#		$sdbinst_tgz->ExtractScalar($packagedata);
	#		foreach (split("\n",$packagedata)){
	#			($script_name) = (/SCRIPT\s*=\s*\"(\S+)\"/);
	#			if($script_name =~ /\S/){
	#				$returnvalue{'scriptname'} = $script_name;
	#				$script_name = 'SAPDB/Install/BuildPackage/packages/'.$subdir.'/'.$script_name;
	#				$sdbinst_tgz->Rewind();
	#				last;
	#			}
	#		}
	#	}
	#	if($script_name =~ /\S/ and $file eq $script_name){
	#		$sdbinst_tgz->ExtractScalar($script);
	#		last;
	#	}
	#}
	#if($packagedata =~ /\S/){
	#	$returnvalue{'packagedata'} = $packagedata;	
	#}

	#if($script =~ /\S/){
	#	$returnvalue{'script'} = $script;	
	#}
	
	unless (defined $repo->Eval ("SAPDB::Install::BuildPackage::packages::".$packdefs{$opt_package}->{'subdir'}, 1.01)) {
		 print join ("\n", $repo->GetErr)."\n";
         die;
    }
	$returnvalue{'packagedata'} = ${'SAPDB::Install::BuildPackage::packages::'.$packdefs{$opt_package}->{'subdir'}.'::packagedata'};
	$returnvalue{'script'} = ${'SAPDB::Install::BuildPackage::packages::'.$packdefs{$opt_package}->{'subdir'}.'::script'};
	$returnvalue{'scriptname'} = ${'SAPDB::Install::BuildPackage::packages::'.$packdefs{$opt_package}->{'subdir'}.'::script_name'};
	return \%returnvalue;
}



sub main{
	local (@ARGV) = @_;

	SetDebug(\@ARGV);
	printVersion(\@ARGV);

	%opt_ctrl=(
		'h' => \$opt_help,
		'help' => \$opt_help,
		'package=s' => \$opt_package,
		'dir=s' => \$opt_dir,
		'backup=s' => \$opt_backup,
		'archivename=s' => \$opt_archivename
	);	

	$opt_package = 'DB Instance'; # default
	
	my $usage= " [-h|--help] | [-v|--version] | --backup <backup file>\n".
				"\t[-package <package name>] [-dir <package directory>] [-archivename IA<your string>.TGZ]\n"; 
	my $usage_desc =	"\t\t-h --help\t\t\tshow this\n".
				"\t\t-v --version\t\t\tshow version\n".
				"\t\t-package <package name>\n".
				"\t\t-dir <package directory>\tcreate package in <package directory>\n".
				"\t\t-backup <backup file>\n".
				"\t\t-archivename IA<your string>.TGZ\t create archive with this name\n";	
							
	chdir($SAPDB::Install::Config{'CallerDir'});
	SAPDB::Install::Getopt::Long::Configure ('no_pass_through');					
	if(!GetOptions(%opt_ctrl) || $opt_help || !checkOpts()){
		print ("\n\nusage: ".$SAPDB::Install::Config{'ProgramName'}."$usage \n\n $usage_desc\n\n\n");
		if($SAPDB::Install::Config{'HasOwnConsole'}){
			print2stdout("\npress any key...");
			SAPDB::Install::Term::ReadKey::ReadMode('raw');
			SAPDB::Install::Term::ReadKey::ReadKey();
		}
		die("\n\n\n");
	}
 	
	$SAPDB::Install::Values::diemsg = 'MaxDB buildpackage tool exited abnormally';
	setSigHandler();
	my $archive_name = 'IASDB.TGZ';
	if($opt_archivename =~ /\S/){
		$archive_name = $opt_archivename;
	}
	
	
	my $archive = $opt_dir ? "$opt_dir/$archive_name" : $archive_name;
	if(-f $archive){
		print2stderr("achive $archive already exists\n");
		diesoft($diemsg);		
	}
	
	my $packagefiles = getPackageFiles($opt_package);

	unless (exists $packagefiles->{'packagedata'}){
		print2stderr("cannot get PACKAGEDATA of package $package\n");
		diesoft($diemsg);
	}
	
	unless (exists $packagefiles->{'script'}){
		print2stderr("cannot get script of package $package\n");
		diesoft($diemsg);
	}
		
	my $gtar = SAPDB::Install::GnuTar->new();
	$gtar->OpenArchive($archive,'w9');
	print2stdout("adding PACKAGEDATA...\n");
	$gtar->AddScalar("PACKAGEDATA",$packagefiles->{'packagedata'});
	print2stdout("adding script...\n");
	$gtar->AddScalar($packagefiles->{'scriptname'},$packagefiles->{'script'});
	print2stdout("adding backup...\n");
	$gtar->Add($opt_backup,'BACKUP');
	$gtar->CloseArchive($archive);
	print2stdout("instance archive \"$archive\" packed successfully!\n");
	return 0;
}

1;