#
# =====================================================
# @(#) SYSINFOCOM                7.4        2003-04-08
# =====================================================
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing comments for SYSINFO tables
    """

    loaderCmd (session, 'USE USER SYSINFO %s' % options.dompwd)

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    # Table sysinfo.activeconfiguration

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.ACTIVECONFIGURATION IS 'Names and values of the currently active database parameters'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.ACTIVECONFIGURATION.PARAMETERNAME IS 'Name of the database parameter'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.ACTIVECONFIGURATION.VALUE IS 'Value of the database parameter'""")

    # Table sysinfo.cachestatistics

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.CACHESTATISTICS IS 'Information on accesses to caches since the last time the database instance was started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICS.SESSIONID IS 'ID of the session owning the cache or NULL for global caches'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICS.NAME IS 'Name of the cache'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICS.ACCESSCOUNT IS 'Name of accesses to the cache'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICS.SUCCESSFULACCESSCOUNT IS 'Number of successful accesses to the cache'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICS.UNSUCCESSFULACCESSCOUNT IS 'Number of unsuccessful accesses to the cache'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICS.HITRATE IS 'Hit rate (successful cache accesses as a percentage of total cache accesses)'""")

    # Table sysinfo.cachestatisticsreset

    #stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.CACHESTATISTICSRESET IS 'Information on accesses to caches since the last RESET ALL STATISTICES or RESET CACHESTATISTICS'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICS.SESSIONID IS 'ID of the session owning the cache or NULL for global caches'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICSRESET.NAME IS 'Name of the cache'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICSRESET.ACCESSCOUNT IS 'Number of accesses to the cache'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICSRESET.SUCCESSFULACCESSCOUNT IS 'Number of successful accesses to the cache'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICSRESET.UNSUCCESSFULACCESSCOUNT IS 'Number of unsuccessful accesses to the cache'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.CACHESTATISTICSRESET.HITRATE IS 'Hit rate'""")

    # Table sysinfo.commandcachestatistics

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.COMMANDCACHESTATISTICS IS 'Statistical information about the command cache activities since the last time the database instance was started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.USABLESIZE IS 'Size of the command cache (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.USEDSIZE IS 'Size of the area of the command cache that is actually used (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.USEDSIZEPERCENTAGE IS 'Size of the area of the command cache that is actually used (percent)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.MAXUSEDSIZE IS 'Maximum used area of the command cache (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.MAXUSEDSIZEPERCENTAGE IS 'Maximum used area of the command cache (percent)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.COMMANDCOUNT IS 'Number of stored commands'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.MAXCOMMANDCOUNT IS 'Maximum number of stored commands'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.INSERTCOMMANDCOUNT IS 'Number of inserts'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.DELETECOMMANDCOUNT IS 'Number of deletes'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.FAILEDALLOCATECOUNT IS 'Number of memory requests not fulfilled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.CLEANUPCOUNT IS 'Number of operations that encountered a lack of space in the main memory'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.CLEANUPCOMMANDCOUNT IS 'Number of commands modified due to lack of space in the main memory'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.INVALIDATECOUNT IS 'Number of data definition statements that made execution plans invalid'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.UNLOADSTATEMENTCOUNT IS 'Number of SQL statements displaced to disk'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.CURRENTUNLOADSTATEMENTCOUNT IS 'Number of SQL statements currently displaced to disk'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.RELOADSTATEMENTCOUNT IS 'Number of SQL statements reloaded to the main memory'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.DELETEPLANCOUNT IS 'Number of execution plans deleted due to lack of space in the main memory'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.HASHTABLESLOTCOUNT IS 'Number of slots in the hash table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.USEDHASHTABLESLOTCOUNT IS 'Number of used slots in the hash table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.MAXUSEDHASHTABLESLOTCOUNT IS 'Maximum number of used slots in the hash table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.AVGHASHTABLECHAINENTRYCOUNT IS 'Average length of the hash entry overflow chains'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICS.MAXHASHTABLECHAINENTRYCOUNT IS 'Maximum length of the hash entry overflow chains'""")

    # Table sysinfo.commandcachestatisticsreset

    #stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.COMMANDCACHESTATISTICSRESET IS 'Statistical Information about command cache activities since the last RESET ALL STATISTICS or RESET COMMANDCACHESTATISTICS'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.USABLESIZE IS 'Size of the database command cache (KB)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.MAXUSEDSIZE IS 'Maximum used area of the command cache (KB)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.MAXUSEDSIZEPERCENTAGE IS 'Maximum used area of the command cache (percent)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.MAXCOMMANDCOUNT IS 'Maximum number of stored SQL commands'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.INSERTCOMMANDCOUNT IS 'Number of inserts'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.DELETECOMMANDCOUNT IS 'Number of deletes'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.FAILEDALLOCATECOUNT IS 'Number of memory requests not fulfilled'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.CLEANUPCOUNT IS 'Number of operations that encountered a lack of space in the main memory'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.CLEANUPCOMMANDCOUNT IS 'Number of commands modified due to lack of space in the main memory'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.UNLOADSTATEMENTCOUNT IS 'Number of SQL statements displaced to disk'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.RELOADSTATEMENTCOUNT IS 'Number of SQL statements reloaded to the main memory'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.DELETEPLANCOUNT IS 'Number of execution plans deleted due to lack of space in the main memory'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.MAXUSEDHASHTABLESLOTCOUNT IS 'Maximum number of used slots in the hash table'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDCACHESTATISTICSRESET.MAXHASHTABLECHAINENTRYCOUNT IS 'Maximum length of the hash entry overflow chains'""")

    # Table sysinfo.commandstatistics

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.COMMANDSTATISTICS IS 'SQL statements that are stored in the command cache and statistical information on the activities of these SQL statements since the last time the database instance was started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.COMMANDID IS 'ID of the SQL statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.INTERNAL IS 'SQL statement was created in the server (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.HASHVALUE IS 'Hash value'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.HASHTABLESLOT IS 'Slot in the hash table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.STATUS IS 'Status (PREPARING|PREPARED|INVALID)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.USERNAME IS 'Name of the database user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.SCHEMANAME IS 'Current schema'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.SQLMODE IS 'SQL mode'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.ISOLATIONLEVEL IS 'Isolation level'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.DATEFORMAT IS 'Date and time format'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.USERDEFINEDDATEFORMAT IS 'Date and time format defined by the user in sqlmode Oracle'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.MASSCOMMAND IS 'Command can be used as an array command (YES/NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.STATEMENTSIZE IS 'Length of the SQL statement (bytes)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.STATEMENT IS 'SQL  statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.PLANSIZE IS 'Memory requirements of the execution plan (bytes)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.PREPARECOUNT IS 'Number of execution preparations'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.REFERENCECOUNT IS 'Number of database sessions for which the SQL statement has been prepared for execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.EXECUTECOUNT IS 'Number of executions'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.CURRENTEXECUTECOUNT IS 'Current number of executions'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.PREPARETIME IS 'Parse time (nanoseconds)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.EXECUTETIME IS 'Total duration of executions (nanoseconds)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.AVGEXECUTETIME IS 'Average execution time (nanoseconds)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.MINEXECUTETIME IS 'Minimum execution time (nanoseconds)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.MAXEXECUTETIME IS 'Maximum execution time (nanoseconds)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.READROWCOUNT IS 'Number of rows read'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.QUALIFIEDROWCOUNT IS 'Number of qualified rows'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.VIRTUALREADCOUNT IS 'Number of reads in the data cache'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.PHYSICALREADCOUNT IS 'Number of reads in the data cache that triggered reads on the disk'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.FETCHROWCOUNT IS 'Number of rows (in the result tables generated by the SQL statement) sent to the application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.SUSPENDCOUNT IS 'Number of suspends'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICS.WAITCOUNT IS 'Number of waits caused by lock collisions'""")

    # Table sysinfo.commandstatisticsreset

    #stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.COMMANDSTATISTICSRESET IS 'SQL statements that are stored in the command cache and statistical information on the activities of these SQL statements since the last RESET ALL STATISTICS or RESET COMMANDSTATISTICS'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.COMMANDID IS 'ID of the SQL statement'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.PREPARECOUNT IS 'Number of execution preparations'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.EXECUTECOUNT IS 'Number of executions'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.EXECUTETIME IS 'Total duration of executions (nanoseconds)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.AVGEXECUTETIME IS 'Average execution time (nanoseconds)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.MINEXECUTETIME IS 'Minimum execution time (nanoseconds)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.MAXEXECUTETIME IS 'Maximum execution time (nanoseconds)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.READROWCOUNT IS 'Number of rows read'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.QUALIFIEDROWCOUNT IS 'Number of qualified rows'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.VIRTUALREADCOUNT IS 'Number of reads in the data cache'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.PHYSICALREADCOUNT IS 'Number of reads in the data cache that triggered reads on the disk'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.FETCHROWCOUNT IS 'Number of rows (in the result tables generated by the SQL statement) sent to the application'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.SUSPENDCOUNT IS 'Number of suspends'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.COMMANDSTATISTICSRESET.WAITCOUNT IS 'Number of waits caused by lock collisions'""")

    # Table sysinfo.datastatistics

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.DATASTATISTICS IS 'Current and maximum fill level of the database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.USABLESIZE IS 'Data area available for data (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.USEDSIZE IS 'Memory in data area that is actually used for data (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.USEDSIZEPERCENTAGE IS 'Percentage of the memory in the data area that is used for data'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.DATAFULL IS 'Data area is full (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.USEDSIZEONVOLUMES IS 'Amount of data written to the data area (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.USEDSIZENOTONVOLUMES IS 'Amount of permanent data that has to be written to the data area at the next savepoint (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.USEDPERMANENTSIZE IS 'Data area used for permanent data (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.USEDTEMPORARYSIZE IS 'Data area used for temporary data (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.MAXUSEDSIZE IS 'Maximum data area used for data at a savepoint (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.MAXUSEDPERMANENTSIZE IS 'Maximum data area used for permanent data at the last savepoint (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.MAXUSEDTEMPORARYSIZE IS 'Maximum data area used for temporary data at the last savepoint (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.INCREMENTALBACKUPSIZE IS 'Amount of data that needs to be backed up in the next incremental backup (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.LASTEMERGENCYHISTORYCLEANUP IS 'Time at which the undo log files were last deleted due to lack of space in the data area (according to the history file)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.CONVERTERVERSION IS 'Unique number given to the converter data saved to the data area at the last savepoint'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.MAXTEMPORARYDATAPAGENUMBER IS 'Highest page number available for temporary pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.MAXPERMANENTDATAPAGENUMBER IS 'Highest page number available for permanent pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATASTATISTICS.MAXPERMANENTSTATICDATAPAGENUMBER IS 'Highest page number available for permanent, static pages'""")

    # Table sysinfo.datavolumes

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.DATAVOLUMES IS 'Description of volumes in which data is stored'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATAVOLUMES.ID IS 'Number of the volume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATAVOLUMES.MODE IS 'Mode of the volume (NORMAL|SEQUENTIAL)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATAVOLUMES.PATH IS 'Name of the volume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATAVOLUMES.CONFIGUREDSIZE IS 'Configured size of the volume (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATAVOLUMES.USABLESIZE IS 'Area of the volume that can be used for data (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATAVOLUMES.USEDSIZE IS 'Area of the volume used for data (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.DATAVOLUMES.USEDSIZEPERCENTAGE IS 'Area of the volume used as a percentage of the total area that can be used for data'""")

    # Table sysinfo.hotstandbycomponent

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.HOTSTANDBYCOMPONENT IS 'Description of details of the hot standy component in which the information of this system table is queried'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.LOCALNODE IS 'Name with which the hot standby component can be addressed'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.MASTERLOCALNODE IS 'Name with which the corresponding master hot standby component can be addressed'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.STANDBYROLE IS 'Role within the hot standby configuration (MASTER|STANDBY|UNKNOWN)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.TAKEOVERDATE IS 'Time at which the TAKEOVER statement was received'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.DELAYTIME IS 'Minimum number of seconds that must pass between the change being made in the master hot standby component and in this hot standby component'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.STANDBYSTATEDATE IS 'Time at which the STANDBY state was reached'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.SYNCHRONIZERECEIVECOUNT IS 'Number of received SYNCHRONIZE statements'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.FIRSTNEEDEDLOGOFFSET IS 'Oldest position in the log area from which the log entries have to be redone'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.LASTVALIDLOGOFFSETRECEIVED IS 'Position in the log area up to which the log entries can be redone by this hot standby component with the STANDBY role'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.INITSTANDBYDATE IS 'Time at which the INIT STANDBY statement was received'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.RESTARTSTANDBYDATE IS 'Time at which the RESTART STANDBY statement was sent'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.LASTSYNCHRONIZEDATE IS 'Time at which the last SYNCHRONIZE statement was received'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.PREPARESTANDBYDATE IS 'Time at which the PREPARE STANDBY statement was sent'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYCOMPONENT.REGISTERSTANDBYDATE IS 'Time at which the REGISTER STANDBY statement was sent'""")

    # Table sysinfo.hotstandbygroup

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.HOTSTANDBYGROUP IS 'Description of information that the hot standby components holds about the other hot standby components with the STANDBY role'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.LOCALNODE IS 'Name with which the hot standby component can be addressed'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.ADDNODEDATE IS 'Time at which the hot standby component was added to the hot standby configuration'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.REMOVENODEDATE IS 'Time at which the hot standby component was deleted from the hot standby configuration'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.STATE IS 'Status of the hot standy component (UNKNOWN|BELIEVED TO BE DEAD|PREPARE PENDING|REGISTER PENDING|SYNC PENDING|STANDBY)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.PREPARESTANDBYDATE IS 'Time at which the PREPARE STANDBY statement was sent'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.REGISTERSTANDBYDATE IS 'Time at which the REGISTER STANDBY statement was sent'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.SYNCHRONIZEDATE IS 'Time at which the last SYNCHRONIZE statement was sent'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.SUCCESSFULSYNCHRONIZEDATE IS 'Time at which the last successfull SYNCHRONIZE statement was executed'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.LASTVALIDLOGOFFSETSENT IS 'Last position sent by the master component in the log area up to which the log entries can be redone by hot standby component with the STANDBY role'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.FIRSTNEEDEDLOGOFFSET IS 'Oldest position in the log area from which the log entries have to be redone'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.SYNCHRONIZESENDCOUNT IS 'Number of sent SYNCHRONIZE statements'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.HOTSTANDBYGROUP.SYNCHRONIZERETRYCOUNT IS 'Number of SYNCHRONIZE statements sent repeatedly'""")

    # Table sysinfo.instance

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.INSTANCE IS 'Information on accesses to caches since the last time the database instance was started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.INSTANCE.NODE IS 'Name with which the database instance can be addressed'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.INSTANCE.LOCALNODE IS 'Name with which the hot standby component can be addressed (if you have a hot standby configuration'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.INSTANCE.ADMINSTATEDATE IS 'Time at which the ADMIN operational state was reached'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.INSTANCE.ONLINESTATEDATE IS 'Time at which the ONLINE operational state was reached'""")

    # Table sysinfo.locks

    #stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.LOCKS IS 'Description of the current lock entries and entries for lock requests'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.TRANSACTIONID IS 'ID of the transaction'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.LOCKREQUESTTIMEOUT IS 'Timeout for this lock request (s)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.LOCKMODE IS 'Lock mode'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.LOCKSTATE IS 'Lock state'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.REQUESTMODE IS 'Mode of the lock request'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.REQUESTSTATE IS 'State of the lock request'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.TABLEOWNER IS 'Owner of the locked table/table row'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.TABLENAME IS 'Name of the table'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.TABLEID IS 'ID of the table'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.ROWIDLENGTH IS 'Length of the primary key of the locked row'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.ROWIDHEX IS 'Hexadecimal output of lock key'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOCKS.ROWID IS 'Readable display of lock key'""")

   # Table sysinfo.logvolumes

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.LOGVOLUMES IS 'Describes the volumes in which log entries are stored'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOGVOLUMES.ID IS 'Number of the volume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOGVOLUMES.PATH IS 'Name of the volume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOGVOLUMES.CONFIGUREDSIZE IS 'Configured size of the volume (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.LOGVOLUMES.USABLESIZE IS 'Area of the volume that can be used for log entries (KB)'""")

   # Table sysinfo.machineconfiguration

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.MACHINECONFIGURATION IS 'Describes the configuration of the machine the database kernel is running on'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINECONFIGURATION.CPUNUMBER IS 'Number of cpus installed'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINECONFIGURATION.PHYSICALMEMORYSIZE IS 'Size of the physical memory installed (MB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINECONFIGURATION.VIRTUALMEMORYSIZE IS 'Size of the virtual memory installed (MB)'""")

   # Table sysinfo.machineutilization

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.MACHINEUTILIZATION IS 'Describes the utilization of the machine the database kernel is running on'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINEUTILIZATION.PHYSICALMEMORYUSABLE IS 'Size of the physical memory reported as free by the operating system (MB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINEUTILIZATION.VIRTUALMEMORYUSABLE IS 'Size of the virtual memory reported as free by the operating system (MB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINEUTILIZATION.PROCESSUSEDUSERTIME IS 'Time the database kernel process has spent in user mode since startup (s)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINEUTILIZATION.PROCESSUSEDSYSTEMTIME IS 'Time the database kernel process has spent in system mode since startup (s)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINEUTILIZATION.MACHINEUSEDUSERTIME IS 'Time the machine has spent in user mode since startup (s)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINEUTILIZATION.MACHINEUSEDSYSTEMTIME IS 'Time the machine has spent in system mode since startup (s)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINEUTILIZATION.MACHINEIDLETIME IS 'Time the machine has spent in idle mode since startup (s)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MACHINEUTILIZATION.CPULOAD IS 'Cpu load of the machine'""")

    # Table sysinfo.memoryallocatorstatistics

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.MEMORYALLOCATORSTATISTICS IS 'Information on accesses to allocators since the last time the database instance was started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.ALLOCATORNAME IS 'Name of the allocator'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.USEDSIZE IS 'Reserved area of the memory (bytes)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.MAXUSEDSIZE IS 'Maximum reserved area of the memory (bytes)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.ALLOCATEDSIZE IS 'Used area of the memory (bytes)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.ALLOCATECOUNT IS 'Number of memory allocations'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.DEALLOCATECOUNT IS 'Number of memory deallocations'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.FAILEDALLOCATECOUNT IS 'Number of memory requests not fulfilled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.FOUNDERRORCOUNT IS 'Number of found and internally corrected errors in the allocator'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.BASEALLOCATORNAME IS 'Name of the allocator that provides this allocator with memory'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.BASEALLOCATECOUNT IS 'Number of memory reservation for the allocator BASEALLOCATORNAME'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICS.BASEDEALLOCATECOUNT IS 'Number of memory deallocations sent to the allocator BASEALLOCATORNAME'""")

    # Table sysinfo.memoryallocatorstatisticsreset

    #stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.MEMORYALLOCATORSTATISTICSRESET IS 'Information on accesses to allocators since the last RESET ALL STATISTICS or RESET MEMORYALLOCATORSTATISTICS'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICSRESET.ALLOCATORNAME IS 'Name of the allocator'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICSRESET.MAXUSEDSIZE IS 'Maximum reserved area of the memory (bytes)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICSRESET.ALLOCATECOUNT IS 'Number of memory allocations'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICSRESET.DEALLOCATECOUNT IS 'Number of memory deallocations'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICSRESET.FAILEDALLOCATECOUNT IS 'Number of memory requests not fulfilled'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICSRESET.BASEALLOCATECOUNT IS 'Number of memory reservation for the allocator BASEALLOCATORNAME'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYALLOCATORSTATISTICSRESET.BASEDEALLOCATECOUNT IS 'Number of memory deallocations sent to the allocator BASEALLOCATORNAME'""")

    # Table sysinfo.memoryholders

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.MEMORYHOLDERS IS 'Information on which call stack resulted in requests being made for memory that is currently held'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYHOLDERS.CHUNKCOUNT IS 'Number of equally sized memory chunks requested by this call stack'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYHOLDERS.CHUNKSIZE IS 'Size of a single memory chunk (bytes)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MEMORYHOLDERS.CALLSTACK IS 'Call stack of the routines'""")

    # Table sysinfo.multiversionreadstatistics

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.MULTIVERSIONREADSTATISTICS IS 'Information pertaining to multiversionread isolation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.MULTIVERSIONREADSTATISTICS.MINTRANSACTIONID IS 'Id of oldest transaction for which history data needs to be kept'""")

    # Table sysinfo.omslocks

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.OMSLOCKS IS 'Information on locks requested explicitly by the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OMSLOCKS.ID IS 'ID of the lock object'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OMSLOCKS.TASKID IS 'ID of the database task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OMSLOCKS.LOCKREQUESTTIMEOUT IS 'Timeout for this lock request (s)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OMSLOCKS.LOCKMODE IS 'Lock mode'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OMSLOCKS.REQUESTMODE IS 'Mode of the lock request'""")

    # Table sysinfo.optimizerinformation

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.OPTIMIZERINFORMATION IS 'Information about value distributions that is determined by the UPDATE STATISTICS statement, and used by the optimizer'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OPTIMIZERINFORMATION.OWNER IS 'Owner of the table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OPTIMIZERINFORMATION.TABLENAME IS 'Name of the table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OPTIMIZERINFORMATION.COLUMNNAME IS 'Name of a single non-inverted column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OPTIMIZERINFORMATION.INDEXNAME IS 'Name of the index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OPTIMIZERINFORMATION.DISTINCTVALUECOUNT IS 'Number of distinct values in the column, index, or primary key'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.OPTIMIZERINFORMATION.CALCULATEDSIZE IS 'Memory requirements of the (primary key) index calculated by the last UPDATE STATISTICS (KB)'""")

    # Table sysinfo.sessions

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.SESSIONID IS 'ID of the session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.OWN IS 'Current session (YES/NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.STARTDATE IS 'Timestamp of session start'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.APPLICATIONNODE IS 'Node where connected application is running'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.APPLICATIONPROCESS IS 'OS identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.APPLICATIONTYPE  IS 'ID of the tool or interface used by the connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.USERNAME IS  'Database user name'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.PEERPROCESSID IS  'ID of the communication partner of the kernel task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.CONNECTSTATE IS  'Connection state'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.TASKID IS  'ID of the database task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.OMSHEAPUSEDSIZE IS  'Memory usage of liveCache applications (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.TRACE IS 'Trace for this session/all sessions enabled (YES/NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.CATALOGCACHEUSEDSIZE IS 'Memory usage of session catalog cache (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.USEDTEMPORARYSIZE IS 'Space used for temporary information (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.PAGINGFILEUSEDSIZE IS 'Paged catalog cache information (KB)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.SQLMODE  IS 'The sessions sqlmode'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.ISOLATIONLEVEL IS 'The sessions isolation level'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.TIMEOUT  IS 'The sessions timeout'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SESSIONS.DATEFORMAT   IS 'The sessions date and time format'""")

    # Table sysinfo.snapshots

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.SNAPSHOTS IS 'Information about defined view of the data'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SNAPSHOTS.ID IS 'Current converter version when the snapshot was defined'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SNAPSHOTS.CREATEDATE IS 'Time when the snapshot was defined'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SNAPSHOTS.USEDSIZE IS 'Amount of data used for the snapshot (KB)'""")

    # Table sysinfo.spinlockstatistics

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.SPINLOCKSTATISTICS IS 'Information on internal lock mechanisms since the last time the database instance was started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.NAME IS 'Name of the spin lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.LOCKCOUNT IS 'Number of attempts to get the spin lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.COLLISIONCOUNT IS 'Number of failed attempts to get the spin lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.SPINLOOPCOUNT IS 'Number of attempts to get the spin lock without releasing the CPU'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.YIELDLOOPCOUNT IS 'Number of attempts to get the spin lock while releasing the CPU'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.MAXSPINLOOPCOUNT IS 'Maximum number of attempts to get the spin lock without releasing the CPU'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.MAXYIELDLOOPCOUNT IS 'Maximum number of attempts to get the spin lock while releasing the CPU'""")

    # Table sysinfo.spinlockstatisticsreset

    #stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.SPINLOCKSTATISTICS IS 'Information on internal lock mechanisms since the last RESET ALL STATISTICS or RESET SPINLOCKSTATISTICS'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.NAME IS 'Name of the spin lock'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.LOCKCOUNT IS 'Number of attempts to get the spin lock'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.COLLISIONCOUNT IS 'Number of failed attempts to get the spin lock'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.SPINLOOPCOUNT IS 'Number of attempts to get the spin lock without releasing the CPU'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.YIELDLOOPCOUNT IS 'Number of attempts to get the spin lock while releasing the CPU'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.MAXSPINLOOPCOUNT IS 'Maximum number of attempts to get the spin lock without releasing the CPU'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.SPINLOCKSTATISTICS.MAXYIELDLOOPCOUNT IS 'Maximum number of attempts to get the spin lock while releasing the CPU'""")

    # Table sysinfo.transactions

    #stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.TRANSACTIONS IS 'Information about active transactions of a database instance'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.SESSIONID IS 'ID of the database session'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.TRANSCOUNTID IS 'ID of the transaction'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.STARTDATE IS 'Start time of the transaction'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.WRITETRANSACTIONID IS 'ID of a write transaction'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.SQLLOCKREQUESTTIMEOUT IS 'Timeout for lock requests for database objects in SQL operations (s)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.OMSLOCKREQUESTTIMEOUT IS 'Timeout for lock requests for OMS objects (s)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.LASTWRITE IS 'Time since last write request (s)'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.SQLLOCKMODE IS 'Lock mode for database objects in SQL operations'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.OMSLOCKMODE IS 'Lock mode for OMS objects'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.REQUESTMODE IS 'Mode of the lock request'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.HISTORYROOT IS 'First page in the chain of history pages'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.HISTRORYLAST IS 'Last page in the chain of history pages'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.HISTORYPAGECOUNT IS 'Number of used history pages'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.LASTHISTORYSEQUENCE IS 'Last number assigned for a history entry'""")

    #stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.TRANSACTIONS.CONSISTENTVIEWID IS 'ID of the currently valid consistent view'""")

    # Table sysinfo.version

    stopIfSqlNotOK (session, """COMMENT ON Table sysinfo.VERSION IS 'Description of version of the SAP DB database software (kernel and runtime environment)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.OPERATINGSYSTEM IS 'Name of the operating system'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.PROCESSORTYPE IS 'Name of the processor vendor'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.ADDRESSINGMODE IS 'Specifies whether a 32 bit or 64 bit platform is being used'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.ID IS 'Current version, including build level'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.MAJORVERSION IS 'Number of the major version'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.MINORVERSION IS 'Number of the minor version'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.CORRECTIONLEVEL IS 'Number of the correction level'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.BUILD IS 'Build level'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSINFO.VERSION.KERNELVARIANT IS 'Variant of the kernel (SLOW|QUICK|FAST)'""")

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install

    switchToDefaultUser (session, options)

if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


