#SAY --- Installing SYSINFO catalog views ...
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def createSysinfoSynonym (session, view):
    stopIfSqlNotOK (session, 'grant select on sysinfo.' + view
        + ' to public')
    stopIfSqlNotErr (session, -4007, 'drop public synonym ' + view)
    stopIfSqlNotOK (session, 'create public synonym ' + view
        + ' for sysinfo.' + view + ' internal')

def install (session,options):
    """Installing SYSINFO tables
    """
    switchToDefaultUser (session, options)

    rc = stopIfSqlNotErr (session, -6006,
        "CREATE USER SYSINFO PASSWORD %s RESOURCE NOT EXCLUSIVE" % options.dompwd)

    if rc == -6006:
        stopIfSqlNotOK (session, "ALTER PASSWORD SYSINFO %s " % options.dompwd)

    sqlOK (session, "COMMIT")

    loaderCmd (session, 'USE USER SYSINFO %s' % options.dompwd)

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW  SYSINFO.DIAGNOSE')

    createReplaceView (session, 'SYSINFO.ACTIVECONFIGURATION',
        """AS SELECT *
           FROM SYSDD.ACTIVECONFIGURATION
        INTERNAL""")

    createSysinfoSynonym (session, 'ACTIVECONFIGURATION')


    createReplaceView (session, 'SYSINFO.CACHESTATISTICS',
        """AS SELECT *
           FROM SYSDD.CACHESTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'CACHESTATISTICS')


    createReplaceView (session, 'SYSINFO.COMMANDCACHESTATISTICS ',
        """AS SELECT *
           FROM SYSDD.COMMANDCACHESTATISTICS
           WHERE USER IN(SELECT USERNAME
                         FROM SYSDD.USERS
                         WHERE USERNAME = USERGROUP
                         AND USERMODE IN('DBA','SYSDBA','ADMIN'))
        INTERNAL""")

    createSysinfoSynonym (session, 'COMMANDCACHESTATISTICS')


    createReplaceView (session, 'SYSINFO.COMMANDSTATISTICS',
        """AS SELECT *
           FROM SYSDD.COMMANDSTATISTICS
           WHERE USER IN(SELECT USERNAME
                         FROM SYSDD.USERS
                         WHERE USERNAME = USERGROUP
                         AND USERMODE IN('DBA','SYSDBA','ADMIN'))
        INTERNAL""")

    createSysinfoSynonym (session, 'COMMANDSTATISTICS')


    createReplaceView (session, 'SYSINFO.DATASTATISTICS',
        """AS SELECT *
           FROM SYSDD.DATASTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'DATASTATISTICS')


    createReplaceView (session, 'SYSINFO.DATAVOLUMES',
        """AS SELECT *
           FROM SYSDD.DATAVOLUMES
        INTERNAL""")

    createSysinfoSynonym (session, 'DATAVOLUMES')


    createReplaceView (session, 'SYSINFO.HOTSTANDBYCOMPONENT',
        """AS SELECT *
           FROM SYSDD.HOTSTANDBYCOMPONENT
        INTERNAL""")

    createSysinfoSynonym (session, 'HOTSTANDBYCOMPONENT')


    createReplaceView (session, 'SYSINFO.HOTSTANDBYGROUP',
        """AS SELECT *
           FROM SYSDD.HOTSTANDBYGROUP
        INTERNAL""")

    createSysinfoSynonym (session, 'HOTSTANDBYGROUP')


    createReplaceView (session, 'SYSINFO.INSTANCE ',
        """AS SELECT *
           FROM SYSDD.INSTANCE
        INTERNAL""")

    createSysinfoSynonym (session, 'INSTANCE')


    createReplaceView (session, 'SYSINFO.LOGVOLUMES',
        """AS SELECT *
           FROM SYSDD.LOGVOLUMES
        INTERNAL""")

    createSysinfoSynonym (session, 'LOGVOLUMES')


    createReplaceView (session, 'SYSINFO.MACHINECONFIGURATION',
        """AS SELECT *
           FROM SYSDD.MACHINECONFIGURATION
        INTERNAL""")

    createSysinfoSynonym (session, 'MACHINECONFIGURATION')


    createReplaceView (session, 'SYSINFO.MACHINEUTILIZATION',
        """AS SELECT *
           FROM SYSDD.MACHINEUTILIZATION
        INTERNAL""")

    createSysinfoSynonym (session, 'MACHINEUTILIZATION')


    createReplaceView (session, 'SYSINFO.MEMORYALLOCATORSTATISTICS',
        """AS SELECT *
           FROM SYSDD.MEMORYALLOCATORSTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'MEMORYALLOCATORSTATISTICS')


    createReplaceView (session, 'SYSINFO.MEMORYHOLDERS',
        """AS SELECT *
           FROM SYSDD.MEMORYHOLDERS
        INTERNAL""")

    createSysinfoSynonym (session, 'MEMORYHOLDERS')

    createReplaceView (session, 'SYSINFO.MULTIVERSIONREADSTATISTICS',
        """AS SELECT *
           FROM SYSDD.MULTIVERSIONREADSTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'MULTIVERSIONREADSTATISTICS')

    createReplaceView (session, 'SYSINFO.OMSLOCKS',
        """AS SELECT *
           FROM SYSDD.OMSLOCKS
        INTERNAL""")

    createSysinfoSynonym (session, 'OMSLOCKS')


    createReplaceView (session, 'SYSINFO.OPTIMIZERINFORMATION',
        """AS SELECT *
           FROM SYSDD.OPTIMIZERINFORMATION
        INTERNAL""")

    createSysinfoSynonym (session, 'OPTIMIZERINFORMATION')

    createReplaceView (session, 'SYSINFO.READERWRITERLOCKSTATISTICS',
        """AS SELECT *
           FROM SYSDD.READERWRITERLOCKSTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'READERWRITERLOCKSTATISTICS')


    createReplaceView (session, 'SYSINFO.SESSIONS',
        """AS SELECT *
           FROM SYSDD.SESSIONS
        INTERNAL""")

    createSysinfoSynonym (session, 'SESSIONS')


    createReplaceView (session, 'SYSINFO.SNAPSHOTS',
        """AS SELECT *
           FROM SYSDD.SNAPSHOTS
        INTERNAL""")

    createSysinfoSynonym (session, 'SNAPSHOTS')


    createReplaceView (session, 'SYSINFO.SPINLOCKPOOLSTATISTICS',
        """AS SELECT *
           FROM SYSDD.SPINLOCKPOOLSTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'SPINLOCKPOOLSTATISTICS')


    createReplaceView (session, 'SYSINFO.SPINLOCKSTATISTICS',
        """AS SELECT *
           FROM SYSDD.SPINLOCKSTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'SPINLOCKSTATISTICS')


    createReplaceView (session, 'SYSINFO.VERSION',
        """AS SELECT *
           FROM SYSDD.VERSION_NEW
        INTERNAL""")

    createSysinfoSynonym (session, 'VERSION')


    rc = sqlRC (session, 'COMMIT WORK')
    loaderCmd (session, 'INSTALLATION OFF')

    switchToDefaultUser (session, options)
