#
# =====================================================
# @(#) SHOWCMD                   7.3.0.02    2000-11-17
# =====================================================
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing Views as replacement for SHOWs
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    #ADIS 1103033

    # Hier folgen DOMAIN-Views, die entfallen koennten, wenn sie nicht mehr von der
    # DBSL-Lib oder vom CCMS genutzt werden wuerden.

    # SERVERDBS sollte entfallen, weil es keine Verteilung mehr gibt.
    # Ueber DOMAIN.INFO_PARAMETERS kann man den SERVERDB-Namen erfahren

    createReplaceView (session, 'DOMAIN.SERVERDBS', """
            AS SELECT SERVERDB, SERVERNODE
               FROM SYSDD.SERVERDBS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SERVERDBS TO PUBLIC WITH GRANT OPTION""")

    # Table domain.serverdbs

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SERVERDBS IS 'Name of database instance and servernode'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SERVERDBS.SERVERDB IS 'Name of database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SERVERDBS.SERVERNODE IS 'Servernode the database instance is on'""")

    # COLUMNPRIVILEGES wird in 7.2 vermutlich nicht genutzt. Soll ab 7.3
    # entfallen.

    createReplaceView (session, 'DOMAIN.COLUMNPRIVILEGES', """
              (TABLE_QUALIFIER,TABLE_OWNER,TABLE_NAME,
               COLUMN_NAME,GRANTOR,GRANTEE,PRIVILEGE,IS_GRANTABLE)
            AS SELECT
                 NULL,C.OWNER,C.TABLENAME,
                 C.COLUMNNAME,P.GRANTOR, P.GRANTEE,
                 ASCII(DECODE(SUBSTR(P.PRIVILEGES, LENGTH(P.PRIVILEGES),1),'+',
                              SUBSTR(P.PRIVILEGES,1,LENGTH(P.PRIVILEGES) - 1),
                              P.PRIVILEGES)),
                 ASCII(DECODE(SUBSTR(P.PRIVILEGES,LENGTH(P.PRIVILEGES),1),'+',
                              'YES','NO'))
               FROM SYSDD.NEW_PRIVILEGES P, DOMAIN.COLUMNS C
               WHERE P.TYPE NOT IN('SEQUENCE', 'DBPROC')
               AND C.OWNER = P.OWNER AND C.TABLENAME = P.NAME1
               AND (C.COLUMNNAME = P.NAME2 OR P.NAME2 IS NULL)
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.COLUMNPRIVILEGES TO PUBLIC WITH GRANT OPTION""")

    # Table domain.columnprivileges

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.COLUMNPRIVILEGES IS 'Information about privileges granted to tables or columns'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNPRIVILEGES.TABLE_QUALIFIER IS 'Always NULL'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNPRIVILEGES.TABLE_OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNPRIVILEGES.TABLE_NAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNPRIVILEGES.COLUMN_NAME IS 'Name of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNPRIVILEGES.GRANTOR IS 'Database user who granted the privilege'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNPRIVILEGES.GRANTEE IS 'Database user who received the privilege'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNPRIVILEGES.PRIVILEGE IS 'Privilege'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNPRIVILEGES.IS_GRANTABLE IS 'Grantee is allowed to grant privilege further  (YES|NO)'""")


    createReplaceView (session, 'DOMAIN.FKC_REFS_COL', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,DEFCOLUMNNAME,DEFFKEYNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFCOLUMNNAME,
               RULE,CREATEDATE,CREATETIME,FKEYCOMMENT)
            AS SELECT
                 'COLUMN',OWNER,TABLENAME,COLUMNNAME,REFNAME,'REFERS',
                 'COLUMN',REFOWNER,REFTABLENAME,REFCOLUMNNAME,
                 RULE,"DATE","TIME",COMMENT
               FROM SYSDD.FOREIGN_KEYS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.FKC_REFS_COL TO PUBLIC WITH GRANT OPTION""")

    createReplaceView (session, 'DOMAIN.COL_REFS_DOM', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,DEFCOLUMNNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFDOMAINNAME,CREATEDATE,CREATETIME)
            AS SELECT
                 'COLUMN',OWNER,TABLENAME,COLUMNNAME,'REFERS',
                 'DOMAIN',DOMAINOWNER,DOMAINNAME,"DATE","TIME"
               FROM SYSDD.COLUMNS
               WHERE type IN('TABLE','RESULT','SYNONYM','SNAPSHOT','VIEW')
               AND domainname IS NOT NULL
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.COL_REFS_DOM TO PUBLIC WITH GRANT OPTION""")

    createReplaceView (session, 'DOMAIN.COL_USES_COL', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,DEFCOLUMNNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFCOLUMNNAME,CREATEDATE,CREATETIME)
            AS SELECT
                 'COLUMN',OWNER,TABLENAME,COLUMNNAME,'USES',
                 'COLUMN',REFOWNER,REFTABLENAME,REFCOLUMNNAME,DATE,TIME
               FROM SYSDD.REFERENCED_COLUMNS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.COL_USES_COL TO PUBLIC WITH GRANT OPTION""")

    createReplaceView (session, 'DOMAIN.FOK_REFS_TAB', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,DEFFKEYNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,CREATEDATE,CREATETIME)
            AS SELECT DISTINCT
                'FOREIGNKEY',OWNER,TABLENAME,REFNAME,'REFERS',
                'TABLE',REFOWNER,REFTABLENAME,"DATE","TIME"
               FROM SYSDD.FOREIGN_KEYS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.FOK_REFS_TAB TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.FOK_USES_COL', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,DEFFKEYNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFCOLUMNNAME,CREATEDATE,CREATETIME)
            AS SELECT
                 'FOREIGNKEY',OWNER,TABLENAME,REFNAME,'USES',
                 'COLUMN',REFOWNER,REFTABLENAME,REFCOLUMNNAME,"DATE","TIME"
               FROM SYSDD.FOREIGN_KEYS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.FOK_USES_COL TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.IND_USES_COL', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,DEFINDEXNAME,
               RELTYPE,REFOBJTYPE,REFOWNER,REFTABLENAME,REFCOLUMNNAME,
               TYPE,POS,SORT,CREATEDATE,CREATETIME,INDEXCOMMENT)
            AS SELECT
                 'INDEX',OWNER,TABLENAME,DECODE(INDEXNAME,' ',COLUMNNAME,INDEXNAME),
                 'USES','COLUMN',OWNER,TABLENAME,COLUMNNAME,
                 TYPE,COLUMNNO,SORT,"DATE","TIME",COMMENT
               FROM SYSDD.INDEXES
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.IND_USES_COL TO PUBLIC WITH GRANT OPTION""")

    createReplaceView (session, 'DOMAIN.TAB_CONT_COL', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFCOLUMNNAME,
               POS,CREATEDATE,CREATETIME)
            AS SELECT
                 TYPE,OWNER,TABLENAME,'CONTAINS',
                 'COLUMN',OWNER,TABLENAME,COLUMNNAME,
                 COLUMNNO,"DATE","TIME"
               FROM SYSDD.COLUMNS
               WHERE type IN('TABLE','RESULT','SYNONYM','SNAPSHOT','VIEW')
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.TAB_CONT_COL TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.TAB_CONT_FOK', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFFKEYNAME,CREATEDATE,CREATETIME)
            AS SELECT DISTINCT
                 'TABLE',OWNER,TABLENAME,'CONTAINS',
                 'FOREIGNKEY',OWNER,TABLENAME,REFNAME,"DATE","TIME"
               FROM SYSDD.FOREIGN_KEYS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.TAB_CONT_FOK TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.TAB_CONT_IND', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFINDEXNAME,
               CREATEDATE,CREATETIME)
            AS SELECT
                 'TABLE',OWNER,TABLENAME,'CONTAINS',
                 'INDEX',OWNER,TABLENAME,INDEXNAME,
                 CREATEDATE,CREATETIME
               FROM DOMAIN.INDEXES
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.TAB_CONT_IND TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.TAB_CONT_TRG', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFTRIGGERNAME,CREATEDATE,CREATETIME)
            AS SELECT
                 'TABLE',OWNER,TABLENAME,'CONTAINS',
                 'TRIGGER',OWNER,TABLENAME,TRIGGERNAME,"DATE","TIME"
               FROM SYSDD.TRIGGERS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.TAB_CONT_TRG TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.TAB_USES_CON', """
              (DEFOBJTYPE,DEFOWNER,DEFTABLENAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFCONSTRAINTNAME)
            AS SELECT
                 'TABLE',OWNER,TABLENAME,'USES',
                 'CONSTRAINT',OWNER,TABLENAME,CONSTRAINTNAME
               FROM SYSDD.CONSTRAINTS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.TAB_USES_CON TO PUBLIC WITH GRANT OPTION""")

    createReplaceView (session, 'DOMAIN.USR_OWNS_DOM', """
              (DEFOBJTYPE,DEFOWNER,DEFGROUPNAME,DEFUSERNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFDOMAINNAME,CREATEDATE,CREATETIME)
            AS SELECT
                 'USER',U.OWNER_OWNER,D.OWNER,D.OWNER,'OWNS',
                 'DOMAIN',D.OWNER,D.DOMAINNAME,D."DATE",D."TIME"
               FROM SYSDD.DOMAINS D,SYSDD.USERS U
               WHERE D.owner IN(U.username,U.groupname)
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.USR_OWNS_DOM TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.USR_OWNS_USR', """
              (DEFOBJTYPE,DEFOWNER,DEFGROUPNAME,DEFUSERNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFGROUPNAME,REFUSERNAME,CREATEDATE,CREATETIME)
            AS SELECT
                 'USER',OWNER_OWNER,OWNER,OWNER,'OWNS',
                 'USER',OWNER,GROUPNAME,USERNAME,"DATE","TIME"
               FROM SYSDD.USERS
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.USR_OWNS_USR TO PUBLIC WITH GRANT OPTION""")


    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        createReplaceView (session, 'DOMAIN.USR_USES_COL', """
                  (DEFOBJTYPE,DEFOWNER,DEFGROUPNAME,DEFUSERNAME,RELTYPE,
                   REFOBJTYPE,REFOWNER,REFTABLENAME,REFCOLUMNNAME,
                   PRIVILEGES,CREATEDATE,CREATETIME,GRANTOR)
                AS SELECT
                     'USER',GRANTEEOWNER,GRANTEE,GRANTEE,'USES',
                     'COLUMN',OWNER,NAME1,
                     DECODE(NAME2,NULL,UNICODE('- ALL COLUMNS -'),NAME2),
                     PRIVILEGES,"DATE","TIME",GRANTOR
                   FROM SYSDD.PRIVILEGES
                   WHERE type NOT IN('DBPROC','SEQUENCE')
                INTERNAL""")

    else:
        createReplaceView (session, 'DOMAIN.USR_USES_COL', """
                  (DEFOBJTYPE,DEFOWNER,DEFGROUPNAME,DEFUSERNAME,RELTYPE,
                   REFOBJTYPE,REFOWNER,REFTABLENAME,REFCOLUMNNAME,
                   PRIVILEGES,CREATEDATE,CREATETIME,GRANTOR)
                AS SELECT
                     'USER',GRANTEEOWNER,GRANTEE,GRANTEE,'USES',
                     'COLUMN',OWNER,NAME1,DECODE(NAME2,NULL,'- ALL COLUMNS -',NAME2),
                     PRIVILEGES,"DATE","TIME",GRANTOR
                   FROM SYSDD.PRIVILEGES
                   WHERE type NOT IN('DBPROC','SEQUENCE')
                INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.USR_USES_COL TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.USR_USES_DBP', """
              (DEFOBJTYPE,DEFOWNER,DEFGROUPNAME,DEFUSERNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFPROGRAMNAME,REFDBPROCNAME,CREATEDATE,CREATETIME)
            AS SELECT
                 'USER',GRANTEEOWNER,GRANTEE,GRANTEE,'USES',
                 'DBPROCEDURE',OWNER,NAME1,NAME2,"DATE","TIME"
               FROM SYSDD.PRIVILEGES
               WHERE type = 'DBPROC' AND grantee <> owner
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.USR_USES_DBP TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.USR_USES_TAB', """
              (DEFOBJTYPE,DEFOWNER,DEFGROUPNAME,DEFUSERNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,PRIVILEGES,CREATEDATE,CREATETIME)
            AS SELECT
                 'USER',GRANTEEOWNER,GRANTEE,GRANTEE,'USES',
                 TYPE,OWNER,NAME1,PRIVILEGES,"DATE","TIME"
               FROM SYSDD.PRIVILEGES
               WHERE name2 IS NULL AND type NOT IN('DBPROC','SEQUENCE')
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.USR_USES_TAB TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.USR_USES_VIE', """
              (DEFOBJTYPE,DEFOWNER,DEFGROUPNAME,DEFUSERNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFVIEWNAME,PRIVILEGES,CREATEDATE,CREATETIME)
            AS SELECT
                 'USER',GRANTEEOWNER,GRANTEE,GRANTEE,'USES',
                 TYPE,OWNER,NAME1,PRIVILEGES,"DATE","TIME"
               FROM SYSDD.PRIVILEGES
               WHERE name2 IS NULL AND type = 'VIEW'
               AND type NOT IN('DBPROC','SEQUENCE')
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.USR_USES_VIE TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.VIE_CONT_COL', """
              (DEFOBJTYPE,DEFOWNER,DEFVIEWNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,REFCOLUMNNAME,
               POS,CREATEDATE,CREATETIME)
            AS SELECT
                 TYPE,OWNER,TABLENAME,'CONTAINS',
                 'COLUMN',OWNER,TABLENAME,COLUMNNAME,
                 COLUMNNO,"DATE","TIME"
               FROM SYSDD.COLUMNS
               WHERE type = 'VIEW'
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.VIE_CONT_COL TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.VIE_USES_SNP', """
              (DEFOBJTYPE,DEFOWNER,DEFVIEWNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFSNAPSHOTNAME,CREATEDATE,CREATETIME)
            AS SELECT DISTINCT
                 TYPE,OWNER,TABLENAME,'USES',
                 REFKIND,REFNAME,REFTABLENAME,DATE,TIME
               FROM SYSDD.VIEW_USES_TABLE
               WHERE type = 'VIEW' AND refkind = 'SNAPSHOT'
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.VIE_USES_SNP TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.VIE_USES_SYN', """
              (DEFOBJTYPE,DEFOWNER,DEFVIEWNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFSYNONYMNAME,CREATEDATE,CREATETIME)
            AS SELECT DISTINCT
                 TYPE,OWNER,TABLENAME,'USES',
                 REFKIND,REFNAME,REFTABLENAME,DATE,TIME
               FROM SYSDD.VIEW_USES_TABLE
               WHERE type = 'VIEW' AND refkind = 'SYNONYM'
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.VIE_USES_SYN TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.VIE_USES_TAB', """
              (DEFOBJTYPE,DEFOWNER,DEFVIEWNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFTABLENAME,CREATEDATE,CREATETIME)
            AS SELECT DISTINCT
                 TYPE,OWNER,TABLENAME,'USES',
                 REFKIND,REFNAME,REFTABLENAME,DATE,TIME
               FROM SYSDD.VIEW_USES_TABLE
               WHERE type = 'VIEW'
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.VIE_USES_TAB TO PUBLIC WITH GRANT OPTION""")


    createReplaceView (session, 'DOMAIN.VIE_USES_VIE', """
              (DEFOBJTYPE,DEFOWNER,DEFVIEWNAME,RELTYPE,
               REFOBJTYPE,REFOWNER,REFVIEWNAME,CREATEDATE,CREATETIME)
            AS SELECT DISTINCT
                 TYPE,OWNER,TABLENAME,'USES',
                 REFKIND,REFNAME,REFTABLENAME,DATE,TIME
               FROM SYSDD.VIEW_USES_TABLE
               WHERE type = 'VIEW' AND refkind = 'VIEW'
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.VIE_USES_VIE TO PUBLIC WITH GRANT OPTION""")




    createReplaceView (session, 'DOMAIN.SHOW_COLUMN', """
            AS SELECT *
               FROM DOMAIN.COLUMNS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_COLUMN TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_CONNECT_PARAM', """
            AS SELECT *
               FROM DOMAIN.CONNECTPARAMETERS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_CONNECT_PARAM TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_CONSTRAINT', """
            AS SELECT *
               FROM DOMAIN.CONSTRAINTS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_CONSTRAINT TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_CHECK', """
            AS SELECT definition
               FROM DOMAIN.CONSTRAINTS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_CHECK TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_DBPROCEDURE', """
            AS SELECT *
               FROM DOMAIN.DBPROCEDURES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_DBPROCEDURE TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_PARAM_DBPROC', """
            AS SELECT *
               FROM DOMAIN.DBPROCPARAMS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_PARAM_DBPROC TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_DOMAIN', """
            AS SELECT *
               FROM DOMAIN.DOMAINS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_DOMAIN TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_DOMAINDEF', """
            AS SELECT definition
               FROM DOMAIN.DOMAINS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_DOMAINDEF TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_FOREIGN_KEY', """
            AS SELECT
                 owner, tablename, columnname,
                 refname, refowner, reftablename, refcolumnname,rule,
                 "DATE", "TIME", "COMMENT" fkeycomment
               FROM SYSDD.FOREIGN_KEYS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_FOREIGN_KEY TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_INDEX', """
                 (owner, tablename, indexname, type,
                 columnname, sort, "DATE", "TIME")
            AS SELECT
                 owner, tablename, DECODE(INDEXNAME,' ',COLUMNNAME,INDEXNAME), type,
                 columnname, sort, "DATE", "TIME"
               FROM SYSDD.INDEXES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_INDEX TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MAPCHARSET', """
            AS SELECT *
               FROM DOMAIN.MAPCHARSETS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MAPCHARSET TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_PRIMARY_KEY', """
            AS SELECT *
               FROM DOMAIN.COLUMNS
               WHERE keypos IS NOT NULL
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_PRIMARY_KEY TO PUBLIC""")

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        createReplaceView (session, 'DOMAIN.SHOW_PRIV_GRANTED', """
                     (owner, tablename, columnname,
                     privileges, grantee)
                AS SELECT
                     owner, NAME1,
                     DECODE(NAME2,NULL,UNICODE('- ALL COLUMNS -'),NAME2),
                     privileges, grantee
                   FROM SYSDD.PRIVILEGES
                   WHERE type NOT IN('DBPROC','SEQUENCE')
                INTERNAL""")

    else:
        createReplaceView (session, 'DOMAIN.SHOW_PRIV_GRANTED', """
                     (owner, tablename, columnname,
                     privileges, grantee)
                AS SELECT
                     owner, NAME1, DECODE(NAME2,NULL,'- ALL COLUMNS -',NAME2),
                     privileges, grantee
                   FROM SYSDD.PRIVILEGES
                   WHERE type NOT IN('DBPROC','SEQUENCE')
                INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_PRIV_GRANTED TO PUBLIC""")

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        createReplaceView (session, 'DOMAIN.SHOW_PRIV_ON', """
                     (owner, tablename, columnname,
                     privileges, grantee)
                AS SELECT
                     owner, NAME1,
                     DECODE(NAME2,NULL,UNICODE('- ALL COLUMNS -'),NAME2),
                     privileges, grantee
                   FROM SYSDD.PRIVILEGES
                   WHERE type NOT IN('DBPROC','SEQUENCE')
                INTERNAL""")

    else:
        createReplaceView (session, 'DOMAIN.SHOW_PRIV_ON', """
                     (owner, tablename, columnname,
                     privileges, grantee)
                AS SELECT
                     owner, NAME1, DECODE(NAME2,NULL,'- ALL COLUMNS -',NAME2),
                     privileges, grantee
                   FROM SYSDD.PRIVILEGES
                   WHERE type NOT IN('DBPROC','SEQUENCE')
                INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_PRIV_ON TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_SERVERDB', """
            AS SELECT *
               FROM DOMAIN.SERVERDBS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_SERVERDB TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_SYNONYM', """
            AS SELECT
                 synonymname, owner, tablename
               FROM SYSDD.SYNONYMS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_SYNONYM TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_SYSDBA', """
            AS SELECT SYSDBA "USERNAME"
               FROM SYSDBA.DUAL
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_SYSDBA TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_TABLE', """
            AS SELECT *
               FROM DOMAIN.TABLES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_TABLE TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_TABLEDEF', """
            AS SELECT *
               FROM DOMAIN.COLUMNS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_TABLEDEF TO PUBLIC""")

    # PTS 1116602

    createReplaceView (session, 'DOMAIN.SHOW_TRIGGER', """
            AS SELECT *
               FROM DOMAIN.TRIGGERS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_TRIGGER TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_TRIGGERDEF', """
            AS SELECT definition
               FROM DOMAIN.TRIGGERS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_TRIGGERDEF TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_USER', """
            AS SELECT *
               FROM DOMAIN.USERS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_USER TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_USER_CURRENT', """
            AS SELECT *
               FROM DOMAIN.USERS
               WHERE ((username = ' ' AND groupname = USERGROUP)
               OR username = USERGROUP)
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_USER_CURRENT TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_USER_CONNECTED', """
            AS SELECT *
               FROM DOMAIN.CONNECTEDUSERS
            INTERNAL""")



    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_USER_CONNECTED TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_VERSION', """
            AS SELECT *
               FROM DOMAIN.VERSIONS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_VERSION TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_VIEW', """
               (OWNER,VIEWNAME,DEFINITION)
            AS SELECT owner,tablename,definition
               FROM SYSDD.SHOWVIEW
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_VIEW TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_OPTIMIZE_STAT', """
            AS SELECT
                 columnname,indexname,distinctvalues,
                 pagecount
               FROM SYSDBA.OPTIMIZERSTATISTICS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_OPTIMIZE_STAT TO PUBLIC""")

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        createReplaceView (session, 'DOMAIN.SHOW_STAT_CONFIG', """
                AS SELECT
                     SUBSTR(DESCRIPTION,1,40) "DESCRIPTION",
                     DECODE(CHAR_VALUE,NULL,UNICODE(LFILL(CHR(NUMERIC_VALUE),' ',12)),
                     SUBSTR(CHAR_VALUE,1,40)) "VALUE"
                   FROM SYSDBA.CONFIGURATION
                INTERNAL""")

    else:
        createReplaceView (session, 'DOMAIN.SHOW_STAT_CONFIG', """
                AS SELECT
                     SUBSTR(DESCRIPTION,1,40) "DESCRIPTION",
                     DECODE(CHAR_VALUE,NULL,LFILL(CHR(NUMERIC_VALUE),' ',12),
                     SUBSTR(CHAR_VALUE,1,40)) "VALUE"
                   FROM SYSDBA.CONFIGURATION
                INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_CONFIG TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_VOLUME', """
            AS SELECT SUBSTR('PAGES',1,40), FIXED(VOLUMESIZE,12)
               FROM SYSDBA.DATAVOLUMES
            UNION ALL
               SELECT 'USED PERM PAGES', USEDPAGES
               FROM SYSDBA.DATAVOLUMES
            UNION ALL
               SELECT 'USED PERM PAGES (%)', PCTUSEDPAGES
               FROM SYSDBA.DATAVOLUMES
            UNION ALL
               SELECT 'UNUSED    PAGES', UNUSEDPAGES
               FROM SYSDBA.DATAVOLUMES
            UNION ALL
               SELECT 'UNUSED    PAGES (%)', PCTUNUSED
               FROM SYSDBA.DATAVOLUMES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_VOLUME TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_BAD_INDEX', """
            AS SELECT
                 OWNER,TABLENAME,INDEXNAME
               FROM SYSDD.BAD_INDEXES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_BAD_INDEX TO PUBLIC""")

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        createReplaceView (session, 'DOMAIN.SHOW_STAT_INDEX', """
                AS SELECT
                     TABLENAME,OWNER,
                     SUBSTR(DESCRIPTION,1,40),
                     DECODE(CHAR_VALUE,NULL,UNICODE(LFILL(CHR(NUMERIC_VALUE),' ',12)),
                     SUBSTR(CHAR_VALUE,1,40))
                   FROM SYSDBA.INDEXSTATISTICS
                INTERNAL""")

    else:
        createReplaceView (session, 'DOMAIN.SHOW_STAT_INDEX', """
                AS SELECT
                     TABLENAME,OWNER,
                     SUBSTR(DESCRIPTION,1,40),
                     DECODE(CHAR_VALUE,NULL,LFILL(CHR(NUMERIC_VALUE),' ',12),
                     SUBSTR(CHAR_VALUE,1,40))
                   FROM SYSDBA.INDEXSTATISTICS
                INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_INDEX  TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_LOCK', """
             (OWNER,TABLENAME,ROWIDLENGTH,ROWIDHEX,LOCKMODE,
                 PENDINGLOCK,SERVERDBNO,SESSION,TRANSCOUNT,USERNAME,
                 TERMID,PROCESS)
              AS SELECT
                 OWNER,TABLENAME,ROWIDLENGTH,ROWIDHEX,
                 DECODE(LOCKMODE,NULL,REQMODE,LOCKMODE) LOCKMODE,
                 'NO ',0,SESSION,TRANSCOUNT,USERNAME,
                 TERMID,PROCESS
               FROM SYSDBA.LOCKSTATISTICS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_LOCK TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_LOCK_CONFIG', """
            AS SELECT *
               FROM SYSDBA.LOCKLISTSTATISTICS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_LOCK_CONFIG  TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_LOCK_TABLE', """
                 (OWNER,TABLENAME,LOCKMODE,
                 PENDINGLOCK,SERVERDBNO,SESSION,TRANSCOUNT,USERNAME,
                 TERMID,PROCESS)
            AS SELECT DISTINCT
                 OWNER,TABLENAME,
                 DECODE(LOCKMODE,NULL,REQMODE,LOCKMODE) LOCKMODE,
                 'NO ',0,SESSION,TRANSCOUNT,USERNAME,
                 TERMID,PROCESS
               FROM SYSDBA.LOCKSTATISTICS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_LOCK_TABLE TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_LOCK_USER', """
                 (SERVERDBNO,SESSION,TRANSCOUNT,USERNAME,
                 TERMID,PROCESS,LOCKMODE,PENDINGLOCK)
            AS SELECT
                 0,SESSION,TRANSCOUNT,USERNAME,
                 TERMID,PROCESS,
                 DECODE(LOCKMODE,NULL,REQMODE,LOCKMODE) LOCKMODE,
                 'NO '
               FROM SYSDBA.TRANSACTIONS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_LOCK_USER TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_LOG', """
            AS SELECT SUBSTR(DESCRIPTION,1,40) "DESCRIPTION", SUBSTR(CHAR_VALUE,1,12) "VALUE"
               FROM SYSDBA.CONFIGURATION
               WHERE DESCRIPTION = 'LOG MODE'
            UNION ALL
               SELECT 'LOG PAGES', LFILL(CHR(LOGSIZE),' ',12)
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'USED     LOG PAGES', LFILL(CHR(USEDLOG),' ',12)
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'USED     LOG PAGES (%)', LFILL(CHR(PCTUSEDLOG),' ',12)
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'NOT SAVED LOG PAGES', LFILL(CHR(LOGNOTSAVED),' ',12)
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'NOT SAVED LOG PAGES (%)', LFILL(CHR(PCTLOGNOTSAVED),' ',12)
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'LOG SEGMENT SIZE', LFILL(CHR(LOGSEGMENTSIZE),' ',12)
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL     SELECT 'SAVEPOINTS', LFILL(CHR(SAVEPOINTS),' ',12)
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'CHECKPOINTS', LFILL(CHR(CHECKPOINTS),' ',12)
               FROM SYSDBA.SERVERDBSTATISTICS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_LOG  TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_MAPCHAR_SET', """
            AS SELECT
                 INTERN,map_code "MAP CODE",map_character "MAP CHARACTER"
               FROM DOMAIN.MAPCHARSETS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_MAPCHAR_SET TO PUBLIC""")

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        createReplaceView (session, 'DOMAIN.SHOW_STAT_TABLE', """
                AS SELECT
                     TABLENAME,OWNER,
                     UPPER(SUBSTR(DESCRIPTION,1,40)),
                     DECODE(CHAR_VALUE,NULL,UNICODE(LFILL(CHR(NUMERIC_VALUE),' ',12)),
                     SUBSTR(CHAR_VALUE,1,40))
                   FROM SYSDBA.TABLESTATISTICS
                INTERNAL""")

    else:
        createReplaceView (session, 'DOMAIN.SHOW_STAT_TABLE', """
                AS SELECT
                     TABLENAME,OWNER,
                     UPPER(SUBSTR(DESCRIPTION,1,40)),
                     DECODE(CHAR_VALUE,NULL,LFILL(CHR(NUMERIC_VALUE),' ',12),
                     SUBSTR(CHAR_VALUE,1,40))
                   FROM SYSDBA.TABLESTATISTICS
                INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_TABLE TO PUBLIC""")

    # PTS 1116602

    createReplaceView (session, 'DOMAIN.SHOW_STAT_USER', """
            AS SELECT *
               FROM SYSDBA.USERSTATISTICS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_USER TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_ALL', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_ALL TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_CACHES', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR_CACHES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_CACHES TO PUBLIC""")

    #createReplaceView (session, 'DOMAIN.SHOW_MONITOR_DBPROC', """
    #        AS SELECT description, "VALUE"
    #           FROM SYSDBA.MONITOR_DBPROC
    #        INTERNAL""")


    #stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_DBPROC TO PUBLIC""")


    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_LOAD', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR_LOAD
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_LOAD TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_LOCK', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR_LOCK
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_LOCK TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_LOG', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR_LOG
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_LOG TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_LONG', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR_LONG
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_LONG TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_PAGES', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR_PAGES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_PAGES TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_ROW', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR_ROW
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_ROW TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_MONITOR_TRANSACTION', """
            AS SELECT description, "VALUE"
               FROM SYSDBA.MONITOR_TRANS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_MONITOR_TRANSACTION TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_STATE', """
            AS SELECT description ,"VALUE"
               FROM SYSDD.SERVER_DB_STATE
               WHERE "VALUE" IS NOT NULL
            UNION ALL
               SELECT description, CHR(numeric_value)
               FROM SYSDD.SERVER_DB_STATE
               WHERE numeric_value IS NOT NULL
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_STATE TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_SERVERDB', """
            AS SELECT SUBSTR('PAGES',1,40) "DESCRIPTION", FIXED(SERVERDBSIZE,12) "VALUE"
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'MAX DATA  PAGE NO', MAXDATAPAGENO
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'USED PERM PAGES', USEDPERM
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'USED PERM PAGES (%)', PCTUSEDPERM
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'USED TEMP PAGES', USEDTMP
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'USED TEMP PAGES (%)', PCTUSEDTMP
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'UNUSED    PAGES', UNUSED
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'UNUSED    PAGES (%)', PCTUNUSED
               FROM SYSDBA.SERVERDBSTATISTICS
            UNION ALL
               SELECT 'UPDATED PERM PAGES', UPDATEDPERM
               FROM SYSDBA.SERVERDBSTATISTICS
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_SERVERDB TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_STAT_PAGES', """
            AS SELECT
                 OWNER,TABLENAME,DESCRIPTION,CHAR_VALUE,NUMERIC_VALUE
               FROM SYSDBA.PAGES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_PAGES TO PUBLIC""")

    createReplaceView (session, 'DOMAIN.SHOW_ESTIMATED_PAGES', """
            AS SELECT
                 OWNER,TABLENAME,DESCRIPTION,ESTIMATED_PAGES
               FROM SYSDBA.ESTIMATED_PAGES
            INTERNAL""")


    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_ESTIMATED_PAGES TO PUBLIC""")


    createReplaceView (session, 'DOMAIN.SHOW_STAT_INDEXPAGES', """
            AS SELECT
                 OWNER,TABLENAME,INDEXNAME,COLUMNNAME,DESCRIPTION,NUMERIC_VALUE
               FROM SYSDD.INDEXPAGES
            INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT ON DOMAIN.SHOW_STAT_INDEXPAGES TO PUBLIC""")

    #           	REMOTEUSER und
    #           	PENDINGLOCK nicht in Liste drin



    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


