/*  MaxDB ODBC example, 2000-09-26

    Progname      HelloMaxDB.c

    Build:        make all

    Description:  Connects to database and executes a simple SELECT

    Note:         For convinience, not all return codes of the ODBC functions
                  are evaluated.


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "WINDOWS.H"
#include "sql.h"
#include "sqlext.h"

#define MAX_NAME_LEN 50
#define MAX_STMT_LEN 300

int printSQLError (SQLHDBC hdbc, SQLHSTMT hstmt);

typedef struct ConnectArgsT {
    char * username;
    char * password;
    char * dbname;
    char * host;
} ConnectArgsT;


static void parseArgs (ConnectArgsT * connectArgs, int argc, char **argv)
{
    /*
     * setting defaults for demo database
     */
    connectArgs->username = "MONA";
    connectArgs->password = "RED";
    connectArgs->dbname = "MAXDB1";
    connectArgs->host = "";
    /*
     * use values from command line
     */
    if (argc > 4) {
        connectArgs->host = argv [4];
    }
    if (argc > 3) {
        connectArgs->dbname = argv [3];
    }
    if (argc > 2) {
        connectArgs->password = argv [2];
    }
    if (argc > 1) {
        connectArgs->username = argv [1];
    }
}

int main (int argc, char **argv)
{
  ConnectArgsT connectArgs;
  SQLHENV   henv;
  SQLHDBC   hdbc;
  SQLHSTMT  hstmt;
  SQLCHAR   inConnectString[512];
  SQLCHAR   outConnectString[512];
  SQLSMALLINT length;


  UCHAR   result[MAX_NAME_LEN + 1];
  UCHAR   select[MAX_STMT_LEN];
  UCHAR   server[MAX_STMT_LEN];
  SDWORD  resultLen;
  RETCODE rc;

  parseArgs (&connectArgs, argc, argv);

  sprintf (server, "%s:%s", connectArgs.host, connectArgs.dbname);

/* Allocate environment, connection, and statement handle  */
  rc = SQLAllocHandle (SQL_HANDLE_ENV, SQL_NULL_HANDLE, &henv);
  if (rc != 0) {
      printf("Alloc Environment failed\n");
      exit (1);
  }

  rc = SQLSetEnvAttr(henv, SQL_ATTR_ODBC_VERSION, (void*)SQL_OV_ODBC3, 0);
  if (rc != 0) {
      printf("Set Environment failed\n");
      exit (1);
  }

  rc = SQLAllocHandle (SQL_HANDLE_DBC, henv, &hdbc);
  if (rc != 0) {
      printf("Alloc Connection failed\n");
      exit (1);
  }

/* Connect to data source                                  */
  sprintf (inConnectString,"DRIVER={MaxDB}; UID=%s; PWD=%s; SERVERDB=%s; SERVERNODE=%s",
           connectArgs.username ,connectArgs.password ,connectArgs.dbname ,connectArgs.host);
  /*
  sprintf (inConnectString,"DRIVER={SAP DB 7.4}; UID=%s;  SERVERDB=%s; SERVERNODE=%s",
           connectArgs.username ,connectArgs.dbname ,connectArgs.host);
  printf ("%s\n", inConnectString);
  */

  rc = SQLDriverConnect (hdbc, NULL, inConnectString, SQL_NTS,
                         outConnectString, sizeof (outConnectString), &length,
                         SQL_DRIVER_COMPLETE);

  if (rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO)
    return (printSQLError (hdbc, SQL_NULL_HSTMT));
  SQLAllocHandle (SQL_HANDLE_STMT, hdbc, &hstmt);

/* Select from table */
  strcpy (select, "SELECT 'Hello, MaxDB' from dual");
  if (SQLExecDirect (hstmt, select, SQL_NTS) != SQL_SUCCESS)
    return (printSQLError (hdbc, hstmt));

/* Bind columns of the result set. */
  SQLBindCol (hstmt, 1, SQL_C_CHAR, result, (SDWORD)sizeof(result), &resultLen);

/* fetch all rows and print them */
  while (1)
    {
    rc = SQLFetch (hstmt);
    if (rc == SQL_SUCCESS || rc == SQL_SUCCESS_WITH_INFO)
      printf ("%s\n", result);
    else if (rc == SQL_NO_DATA)
      break;
    else
      {
      printSQLError (hdbc, hstmt);
      break;
      }
    }


/* Disconnect from the data source and free all handles. */
  SQLDisconnect (hdbc);
  SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
  SQLFreeHandle (SQL_HANDLE_DBC,  hdbc);
  SQLFreeHandle (SQL_HANDLE_ENV,  henv);

  return (0);
}

int printSQLError (SQLHDBC hdbc, SQLHSTMT hstmt)
{
   UCHAR  sqlstate[10];
   SDWORD sqlcode;
   UCHAR  errortxt[MAX_STMT_LEN+1];
   SWORD  usederrortxt;

   SQLError (SQL_NULL_HENV, hdbc, hstmt, sqlstate, &sqlcode, errortxt,
	     MAX_STMT_LEN, &usederrortxt);

   printf (" SQL state: %s\n", sqlstate);
   printf (" SQL code:  %ld\n", sqlcode);
   printf (" SQL Errortext:\n%s\n\n", errortxt);
   return (0);
}

