/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.io.*;
import java.sql.*;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.util.*;
import com.sap.dbtech.vsp00.*;
/**
 *
 */
public class Putval
{
    private byte[] descriptor;
    /**
     * Set if the Putval instance was created from a byte array
     * (to that byte array).
     */
    private byte[] sourceBytes;
    
    protected StructuredMem descriptorMark;
    private InputStream stream;
    /*
     * the following is used to reread data
     *  to recover from a timeout
     */
    protected StructuredMem requestedData = null;
    protected int requestedLen;
    private int bufpos;
    /**
     *
     * @param stream java.io.InputStream
     */
    Putval(InputStream stream, int length, int bufpos)
    {
        if (length >= 0)
          this.stream = new InputStreamFilter(stream,length);
        else
          this.stream = stream;
        this.bufpos = bufpos;
    }
    
    Putval(byte[] bytes, int bufpos)
    {
    	this.stream=new ByteArrayInputStream(bytes);
    	this.sourceBytes = bytes;
        this.bufpos = bufpos;
    }
    
    Object cloneForBatch()
    {
    	if(this.sourceBytes==null) {
    		return this;
    	} else {
    		return new Putval(sourceBytes, bufpos);
    	}
    }
    
    /**
     *
     */
    protected Putval(int bufpos)
    {
        this.bufpos = bufpos;
        this.stream = null;
    }
    /**
     *
     * @return boolean
     */
    public boolean atEnd ()
    {
        return this.stream == null;
    }
    /**
     *
     * @return byte[]
     */
    private byte [] newDescriptor ()
    {
        byte [] result = new byte [LongDesc.Size_C];
        return result;
    }
    /**
     *
     * @param mem com.sap.dbtech.util.StructuredMem
     * @param pos int
     */
    public void putDescriptor (
        DataPart mem,
        int pos)
    {
        if (this.descriptor == null) {
            this.descriptor = this.newDescriptor ();
        }
        this.descriptorMark = mem.putDescriptor(pos, this.descriptor);
    }
    /**
     *
     * @param descriptor byte[]
     */
    public void setDescriptor (
        byte [] descriptor)
    {
        this.descriptor = descriptor;
    }
    
    /**
     */
    public void markErrorStream() {
        descriptorMark.putInt1(LongDesc.Error_C, LongDesc.Valmode_O);
        descriptorMark.putInt4(0,
                LongDesc.Valpos_O);
        descriptorMark.putInt4(0, LongDesc.Vallen_O);
        try {
            this.stream.close ();
        }
        catch (IOException exc) {
            // ignore
        }
        this.stream = null;
    }

    /**
     *
     * @param dataPart com.sap.dbtech.jdbc.packet.DataPart
     */
    public void transferStream (
        DataPart dataPart)
        throws SQLException
    {
        boolean streamExhausted;

        if (this.atEnd ()) {
            dataPart.markEmptyStream (this.descriptorMark);
        }
        else {
            streamExhausted = dataPart.fillWithStream (
                this.stream, this.descriptorMark, this);
            if (streamExhausted) {
                try {
                    this.stream.close ();
                }
                catch (IOException exc) {
                    // ignore
                }
                this.stream = null;
            }
        }
    }
    /**
     *
     * @param dataPart com.sap.dbtech.jdbc.packet.DataPart
     */
    public void transferStream (
        DataPart dataPart,
        int streamIndex)
        throws SQLException
    {
        this.transferStream (dataPart);
        this.descriptorMark.putInt2 (streamIndex, LongDesc.Valind_O);
    }
    /**
     *
     */
    public String toString ()
    {
        return "<Putval " + this.stream + ">";
    }
    /**
     *
     */
    public void markAsLast (
        DataPart dataPart)
    {
        // avoid putting it in if this would break the aligned boundary.
        if(dataPart.size() - dataPart.getExtent() - 8 - LongDesc.Size_C - 1 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int descriptorPos = dataPart.getExtent ();
        this.putDescriptor (dataPart, descriptorPos);
        dataPart.addArg (descriptorPos, LongDesc.Size_C + 1);
        this.descriptorMark.putInt1 (LongDesc.LastPutval_C, LongDesc.Valmode_O);
    }
    /**
     *
     */
    public void
    markRequestedChunk (
        StructuredMem requestedData,
        int requestedLen)
    {
        this.requestedData = requestedData;
        this.requestedLen = requestedLen;
    }
    /**
     *
     */
    public void
    reset ()
    {
        if (this.requestedData != null) {
            byte [] data = this.requestedData.getBytes (0, this.requestedLen);
            InputStream firstChunk = new ByteArrayInputStream (data);
            if (this.stream == null) {
                this.stream = firstChunk;
            }
            else {
                this.stream = new com.sap.dbtech.util.JoinStream (
                    new InputStream [] {firstChunk, this.stream});
            }
            this.requestedData = null;
        }
    }

    public final int getBufpos()
    {
        return this.bufpos;
    }

}
