/*



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end





*/
#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <math.h>
#include <string.h>

#ifdef _WIN32
#include <windows.h>
#else
#include <sys/times.h>
#include <unistd.h>
#include <sys/utsname.h>
#endif

#ifdef _WIN32
#define  sleep(x)  Sleep (x * 1000)
#else
#define  Sleep(x)  usleep (x * 1000)
#endif

#define SQLSTRCPY(x1,x2) {memset(x1,' ',sizeof x1); \
		memcpy (x1,x2,strlen(x2));x1[sizeof x1-1]=0;}

EXEC SQL BEGIN DECLARE SECTION ;

int		ReleaseOids ;
int		ReadOidsLocked ;
int		LockModeOptimistic ;
int		ListNo ;

long	elements ;
long	cre_elements ;
long	del_elements ;
long	listno ;
long	listpos = 0;
long	sum ;
long	NoToTraverse ;
char    FiOidIn [9] ;
char    FiOidOut [9] ;
long	rc ;
int		useVersions = 0 ;
char	VerString [23] ;
int		vrc ;
char	user[19] ;
char    password[19] ;
char    hostname[19] ;
char	serverdb[19] ;
char    omsHostname[19] ;
char    collhostname[19] ;
char	collserverdb[19] ;
char	kversion [41] ;
char	omsuser[40] ;
char    omspassword[40] ;
char	omsserverdb[19] ;
int		ColSeq ; ;
char	ColText [36] ;
float	ColRealTime ;
char	ColMachine [11] ;
char	ColOS [6] ;
char	ColModel [6] ;
char	ColZeit [11] ;
char	ColKernelVersion [41] ;
int		ColDurch ;
int		ColLines ;
int		ColMonitoring ;
char    ColVersions [7] ;
char    ColKind [36] ;
char    ColSubKind [36] ;
char	dbcollString [40] ;
char	*dbcoll = "DBCOLL" ;
char	dateString [40] ;
EXEC SQL END DECLARE SECTION ;

long	StClock ;
time_t	aclock;
int     sqlco ;

void	CreateDbprocs () ;
void	CreateList (long elems, int	LockModeOptimistic) ;
void	CreateVarList () ;
void	CreateSqlList (long elems) ;
void	CreateNativeList (long elems) ;
void	CreateKeyOidList (long elems) ;
void	DeleteElememtsFromList (long lno, int OptLock) ;
void	DeleteList (long lno, int Optimistic) ;
void	DeleteVarList (long lno, int Optimistic) ;
void	DeleteNativeList () ;
void	DeleteKeyOidList (long lno) ;
void	commit (char *s,int sqlcode, int CommitTrans ) ;
/*void	ReleaseConnect () ;*/
void	ConsistentRead ( int NoOfActLists ) ;
void	Dump(char *s, int sqlcode) ;
void	DeleteProcs () ;
void	DebugOmsOff () ;
void    DeleteVersions () ;
void	ReleaseAll () ;
void    sleepAfterDelete () ;

int 	collectInit ()  ;

long	TraverseList (long Lno, long lno, int ReleaseObjs ,
			long NoToTraverse, int LockOids) ;
long	TraverseVarList (long Lno, long lno, int ReleaseObjs ,
			long NoToTraverse, int LockOids) ;
long	TraverseSqlList (long Lno, long lno, int ReleaseObjs ,
			long NoToTraverse, int LockOids) ;
long	TraverseNativeList (long Lno, long lno, int ReleaseObjs ,
			long NoToTraverse, int LockOids) ;
long	TraverseKeyOidList (long Lno, long lno, int ReleaseObjs ,
			long NoToTraverse, int LockOids) ;

void	DropSqlListCpc () ;
void	CreateSqlListCpc (long elems) ;
void	TraverseSqlListCpc () ;
void    collectData () ;
double	TimeInMilli () ;

int		verbose = 0 ;
int		noSleep = 0 ;
int		pid ;
int		ElementsInList ;
int		kind,subkind ;
int		loop ;
int		storeResultsInDb = 0 ;
int		Collect = 0 ;
long	ln ;

double	ta,tb ;
FILE	*fprot ;

float	td,td1,tdo ;
long	clk_tick ;

#define MAXKIND 6
#define MAXSUBKIND 8

struct
{
	int anz ;
	double tm ;
} mess [MAXKIND][MAXSUBKIND] ;

#define TA	ta = TimeInMilli () ;
#define TB  { tb=TimeInMilli();td=(float)(tb-ta); \
				if ( loop ) { mess[kind][subkind].anz += 1 ; \
						      mess[kind][subkind].tm += td ; } }

char *skind [] = {"Native", "OMS" , "Keyed OMS" , "Varlen OMS", "Varlen OMS 512" , "CSQL"} ;
char *ssubkind [] = {"Insert","Update","Delete","Read+release", "Read+keep", "Read cached",
					 "Delete+Commit", "Insert+Commit" } ;
int	MaxLoops = 10 ;

/*------------------------------------------------------------------------*/
/*                                Main                                    */
/*------------------------------------------------------------------------*/

main (argc,argv)
int	argc ;
char **argv ;
{
	int i ,j ;
	int codb = 0 ;
	int NoOfActLists = 6 ;
	int collectRc = 0 ;

	int	inproc = 1 ;

	cre_elements = 20000 ;

	pid = getpid () ;

#ifndef _WIN32
	clk_tick = sysconf ( _SC_CLK_TCK ) ;
#endif

	for ( i = 1 ; i < argc ; i++ )
    {
		if ( argv[i][0] == '-' )
		{
			switch ( argv[i][1] )
			{
			case 'v' : verbose = 1 ;
				break ;
			case 'V' : useVersions = 1 ;
				break ;
			case 'h' : wrong_usage () ;
				break ;
			case 'l' : MaxLoops = atoi ( argv[++i] ) ;
				break ;
			case 'e' : cre_elements = atoi (argv[++i] ) ;
				break ;
			case 'i' : inproc = 0 ;
				break ;
			case 'F' : noSleep = 1 ;
				break ;
			/*
			case 'c' : UseCSql = 1 ;
				break ;
			*/
			case 'U' : sscanf ( argv[++i] , "%[A-Za-z0-9]%*[,]%[A-Za-z0-9]" , omsuser , omspassword ) ;
				break ;
			case 'D' : strcpy ( omsserverdb ,argv[++i] ) ;
				break ;
			case 'u' : sscanf ( argv[++i] , "%[A-Za-z0-9]%*[,]%[A-Za-z0-9]" , user , password ) ;
				codb++ ;
				break ;
			case 'd' : strcpy ( collserverdb ,argv[++i] ) ;
				storeResultsInDb = 1 ;
				Collect = 1 ;
				codb++ ;
				break ;
			case 'n' : strcpy ( collhostname ,argv[++i] ) ;
				codb++ ;
				break ;
			default  : wrong_usage () ;
            }
        }
    }

	if ( cre_elements < 10 )
		wrong_usage () ;

	if ( codb != 0 && codb != 3 )
		wrong_usage () ;

	del_elements = cre_elements / 20 ;

	srand ((unsigned)time( NULL )) ;

	time( &aclock );
	StClock = aclock ;
	SQLSTRCPY ( dateString , ctime ( &aclock ) ) ;
    dateString [ 39 ] = 0 ;

	if ( ( fprot = fopen (useVersions?"omstime_TransSim.prot":"omstime.prot", "w" ) ) == (FILE *) 0 )
	{
		perror ("open omstime.prot") ;
		exit (1) ;
	}

	/* initialize stored procedure and commit!!!!*/
	EXEC SQL SET SERVERDB :omsserverdb ;
	/* printf ( "CONNECT >%s< IDENTIFIED BY >%s< (USING %s)\n",omsuser,omspassword,omsserverdb) ; */
	EXEC SQL CONNECT :omsuser IDENTIFIED BY :omspassword ;

	if ( sqlca.sqlcode )
	{
		fprintf (fprot,"omstime: Connect Error %d\n", sqlca.sqlcode ) ;
		printf ("omstime: Connect Error %d\n", sqlca.sqlcode ) ;
		return (1) ;
	}

	EXEC SQL SELECT SERVERNODE INTO :omsHostname FROM SHOW_USER_CURRENT ;


    EXEC SQL SELECT KERNEL
	  INTO :kversion
	  FROM domain.SHOW_VERSION ;

	DeleteProcs () ;

	/*printf ("Create Dbprovs") ;*/
	CreateDbprocs (inproc) ;
	DeleteVersions () ;
	ReleaseAll () ;
	EXEC SQL COMMIT ;
	DebugOmsOff () ;



	EXEC SQL DBPROC INIT_FIRSTOID_LIST	(20, :rc) ;
	EXEC SQL DBPROC OMS1_INIT_FIRSTOID_LIST (20, :rc) ;

	ElementsInList = cre_elements ;

	/* CreateList (ElementsInList, rand () % 2 ) ; */

	/* CreateSqlList (ElementsInList ) ; */

	/* CreateNativeList (ElementsInList) ; */

	if ( useVersions )
	{
		char pidString [20] ;
		sprintf ( pidString , "%ld" , (long) pid ) ;

		memset ( VerString , 'y' , 22 ) ;
		VerString [22] = 0 ;
		memcpy ( VerString , pidString , strlen (pidString) ) ;

		EXEC SQL COMMIT ;

		EXEC SQL DBPROC CHL_FORCE_DROP_VERSION (:VerString , :vrc ) ;
		printf ( "Drop Version; sqlcode = %d\n" , sqlca.sqlcode ) ;
		fprintf (fprot, "Drop Version; sqlcode = %d\n" , sqlca.sqlcode ) ;

		EXEC SQL COMMIT ;

		EXEC SQL DBPROC CHL_CREATE_VERSION (:VerString , :vrc ) ;
		printf ( "Create Version; sqlcode = %d\n" , sqlca.sqlcode ) ;
		fprintf ( fprot, "Create Version; sqlcode = %d\n" , sqlca.sqlcode ) ;

		if ( sqlca.sqlcode )
		{
			printf("Error in Open Version ---> EXIT") ;
			fprintf(fprot,"Error in Open Version ---> EXIT") ;
			exit (1) ;
		}
	}

	for ( i = 0 ; i < MAXKIND ; i++ )
	{
		for ( j = 0 ; j < MAXSUBKIND ; j++ )
		{
			mess[i][j].anz = 0 ;
			mess[i][j].tm = 0.0 ;
		}
	}

	DeleteNativeList () ;
    DeleteList (1,1) ;
    DeleteVarList (1,1) ;
    DeleteKeyOidList (1) ;
	sleepAfterDelete () ;

	for ( loop = 0 ; loop < MaxLoops ; loop++ )
	{
		printf ("===================================================================== %d\n",loop) ;
		fprintf (fprot,"===================================================================== %d\n",loop) ;

		/************************************************/
		/**************** Native C++ ********************/
		/************************************************/

		printf ("*** Native C++ ***\n") ;
		fprintf (fprot,"*** Native C++ ***\n") ;
		kind = 0 ;
		subkind = 0 ; CreateNativeList (ElementsInList) ;
		subkind = 3 ; TraverseNativeList ( 1,0,0,0,0 ) ;
		subkind = 3 ; TraverseNativeList ( 1,0,0,0,0 ) ;
		subkind = 3 ; TraverseNativeList ( 1,0,0,0,0 ) ;
		subkind = 2 ; DeleteNativeList () ;

		/************************************************/
		/**************** Native C++ ********************/
		/************************************************/

		printf ("***  OMS   ***\n") ;
		fprintf (fprot,"***  OMS   ***\n") ;
		kind = 1 ;
		subkind = 0 ; CreateList (ElementsInList, rand () % 2 ) ;

		/* Read from database and release OIDs */
		subkind = 3 ; TraverseList ( ListNo , ListNo , 1 , 0 , 0 ) ;

		/* Read from database and keep Oids */
		if ( sqlca.sqlcode == 0 )
		{
			subkind = 4 ; TraverseList ( ListNo , 0 , 0 , 0 , 0 ) ;

			/* Read on local OID images and release Oids afterwards */
			if ( sqlca.sqlcode == 0 )
			{
				subkind = 5 ; TraverseList ( ListNo , 0 , 1 , 0 , 0 ) ;
			}
		}
		subkind = 2 ; DeleteList (ListNo,1) ;
		sleepAfterDelete () ;

		/************************************************/
		/******************* OMS KEY ********************/
		/************************************************/

		printf ("*** OMS KEY **\n") ;
		fprintf (fprot,"*** OMS KEY **\n") ;
		kind = 2 ;
		subkind = 0 ; CreateKeyOidList (ElementsInList ) ;

		/* Read from database and release OIDs */
		subkind = 3 ; TraverseKeyOidList ( ListNo , ListNo , 1 , 0 , 0 ) ;

		/* Read from database and keep Oids */
		if ( sqlca.sqlcode == 0 )
		{
			subkind = 4 ; TraverseKeyOidList ( ListNo , 0 , 0 , 0 , 0 ) ;

			/* Read on local OID images and release Oids afterwards */
			if ( sqlca.sqlcode == 0 )
			{
				subkind = 5 ; TraverseKeyOidList ( ListNo , 0 , 1 , 0 , 0 ) ;
			}
		}
		subkind = 2 ; DeleteKeyOidList (ListNo) ;

		/************************************************/
		/*************** OMS varlen = 50 ****************/
		/************************************************/

		printf ("***  OMS varlength=50 ***\n") ;
		fprintf (fprot,"***  OMS variable length=50  ***\n") ;
		kind = 3 ;
		subkind = 0 ; CreateVarList (ElementsInList, rand () % 2, 50 ) ;

		/* Read from database and release OIDs */
		subkind = 3 ; TraverseVarList ( ListNo , ListNo , 1 , 0 , 0 ) ;

		/* Read from database and keep Oids */
		if ( sqlca.sqlcode == 0 )
		{
			subkind = 4 ; TraverseVarList ( ListNo , 0 , 0 , 0 , 0 ) ;

			/* Read on local OID images and release Oids afterwards */
			if ( sqlca.sqlcode == 0 )
			{
				subkind = 5 ; TraverseVarList ( ListNo , 0 , 1 , 0 , 0 ) ;
			}
		}
		subkind = 2 ; DeleteVarList (ListNo,1) ;
		sleepAfterDelete () ;

		/************************************************/
		/*************** OMS varlen = 512 ***************/
		/************************************************/

		printf ("***  OMS varlength=512 ***\n") ;
		fprintf (fprot,"***  OMS variable length=512  ***\n") ;
		kind = 4 ;
		subkind = 0 ; CreateVarList (ElementsInList, rand () % 2, 512 ) ;

		/* Read from database and release OIDs */
		subkind = 3 ; TraverseVarList ( ListNo , ListNo , 1 , 0 , 0 ) ;

		/* Read from database and keep Oids */
		if ( sqlca.sqlcode == 0 )
		{
			subkind = 4 ; TraverseVarList ( ListNo , 0 , 0 , 0 , 0 ) ;

			/* Read on local OID images and release Oids afterwards */
			if ( sqlca.sqlcode == 0 )
			{
				subkind = 5 ; TraverseVarList ( ListNo , 0 , 1 , 0 , 0 ) ;
			}
		}
		subkind = 2 ; DeleteVarList (ListNo,1) ;
		sleepAfterDelete () ;

#ifdef CPP_KLASSE

		/************************************************/
		/******************* SQL Klasse *****************/
		/************************************************/

		printf ("***  SQL StoPr (COM)  ***\n") ;
		fprintf (fprot,"***  SQL StoPr (COM)  ***\n") ;
		kind = -99 ;
		DropSqlListCpc () ;
		subkind = 0 ; CreateSqlList   (ElementsInList) ;
		subkind = 3 ; TraverseSqlList ( 1,0,0,0,0 ) ;
		/*
		subkind = 3 ; TraverseSqlList ( 1,0,0,0,0 ) ;
		subkind = 3 ; TraverseSqlList ( 1,0,0,0,0 ) ;
		*/
#endif
#define OMSTIME_SQL
#ifdef OMSTIME_SQL

		/************************************************/
		/*************** SQL Precompiler ****************/
		/************************************************/

		printf ("***  native SQL (cpc)  ***\n") ;
		fprintf (fprot,"***  native SQL (cpc)  ***\n") ;
		kind = 5 ;
		DropSqlListCpc () ;
		subkind = 0 ; CreateSqlListCpc   (ElementsInList) ;
		subkind = 3 ; TraverseSqlListCpc () ;
		/*
		subkind = 3 ; TraverseSqlListCpc () ;
		subkind = 3 ; TraverseSqlListCpc () ;
		*/
#endif
	}

	if ( storeResultsInDb )
	{
		collectRc = collectInit () ;
		collectData () ;
	}

	/*EXEC SQL COMMIT RELEASE ;*/

	if ( fprot != (FILE *) 0 )
		fclose (fprot) ;

	if ( collectRc )
		return collectRc ;
	else
		return 0 ;

}

/*------------------------------------------------------------------------*/

void ConsistentRead (int NoOfLists)
{
	int i ;
	long sum1, sum2, sum3 ;

	for ( i = 1 ; i < NoOfLists ; i++ )
			{
				elements = 0 ;

				/*
				long TraverseList :
				long lno ,		// List number (just for output protocol)
				long Lno,		// List number; 0: use start OID of last traverse
				int	 RelOids ,	// Release OIDs after reading
				long Ntt		// no of elements to traverse. 0: traverse all
				int  ReadLocked // lock OIDs when reading.
				*/

				/*  Read from database and release OIDs */
				sum1 = TraverseList ( i , i , 1 , 0 , 0 ) ;

				/* ReleaseAll () ; */
				/* Sleep ( rand () % 1000 ) ; */

				/* Read from database and keep Oids */
				if ( sqlca.sqlcode == 0 )
				{
					sum2 = TraverseList ( i , 0 , 0 , 0 , 0 ) ;

					if ( sum1 != sum2 )
						Dump ("Sum1 <> Sum2", sqlca.sqlcode ) ;

					commit ("Traverse List",sqlca.sqlcode,0) ;

					Sleep ( rand () % 1000 ) ;

					/* Read on local OID images and release Oids afterwards */
					if ( sqlca.sqlcode == 0 )
					{
						sum3 = TraverseList ( i , 0 , 1 , 0 , 0 ) ;

						if ( sum2 != sum3 )
							Dump ("Sum2 <> Sum3" , sqlca.sqlcode ) ;
					}
				}
				commit ("Traverse List",sqlca.sqlcode,2) ;

			}
}

/*------------------------------------------------------------------------*/

void DeleteProcs ()
{
	EXEC SQL DROP DBPROC CREATELIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CREATELIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC CREATE_SQL_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CREATE_SQL_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC CREATE_NATIVE_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CREATE_SQL_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC CREATE_KEYOID_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CREATE_SQL_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC DELETE_NATIVE_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CREATE_SQL_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC TRAVERSE_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP TRAVERSE_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC TRAVERSE_SQL_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP TRAVERSE_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC TRAVERSE_NATIVE_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP TRAVERSE_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC TRAVERSE_KEYOID_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP TRAVERSE_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC DELETE_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP DELETE_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC DELETE_KEYOID_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP DELETE_KEYOID_LIST", sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC ADD_ELEMENT_TO_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP ADD_ELEMENT_TO_LIST",sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC DELETE_ELEMENT_FROM_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP DELETE_ELEMENT_FROM_LIST",sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC CHL_RELEASE_OIDS ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CHL_RELEASE_OIDS",sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC CHL_DEBUG ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CHL_DEBUG",sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC INIT_FIRSTOID_LIST ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CHL_DEBUG",sqlca.sqlcode,2) ;

	EXEC SQL DROP DBPROC CHL_CREATE_VERSION ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CHL_DEBUG",sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC CHL_OPEN_VERSION ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CHL_DEBUG",sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC CHL_CLOSE_VERSION ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CHL_DEBUG",sqlca.sqlcode,2) ;
	EXEC SQL DROP DBPROC CHL_FORCE_DROP_VERSION ;
	if ( sqlca.sqlcode && sqlca.sqlcode != -4016 )
		printf ( "DROP DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
	commit ("DROP CHL_DEBUG",sqlca.sqlcode,2) ;

}

/*------------------------------------------------------------------------*/

void CreateDbprocs (inproc)
{

	EXEC SQL DROP PACKAGE OMST_PACK ;
	EXEC SQL DROP PACKAGE OMS1_PACK ;

	EXEC SQL  AT :dbcoll WHENEVER SQLERROR CALL fehler () ;

	EXEC SQL CREATE PACKAGE OMST_PACK FILE 'chainedlist' INPROC;
	if ( sqlca.sqlcode && sqlca.sqlcode != -6006 )
		printf ( "CREATE PACKAGE OMST_PACK: sqlcode %d\n" , sqlca.sqlcode ) ;

	EXEC SQL CREATE PACKAGE OMS1_PACK FILE 'OmsMut1' INPROC;
	if ( sqlca.sqlcode && sqlca.sqlcode != -6006 )
		printf ( "CREATE PACKAGE OMS1_PACK: sqlcode %d\n" , sqlca.sqlcode ) ;

	if ( inproc )
	{

		EXEC SQL CREATE DBPROC CREATELIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006 )
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CREATE_SQL_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006 )
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CREATE_NATIVE_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006 )
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CREATE_KEYOID_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006 )
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC DELETE_NATIVE_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006 )
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC TRAVERSE_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC TRAVERSE_SQL_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC TRAVERSE_NATIVE_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC TRAVERSE_KEYOID_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC DELETE_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC DELETE_KEYOID_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC ADD_ELEMENT_TO_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC DELETE_ELEMENT_FROM_LIST IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_RELEASE_OIDS IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_DEBUG IN OMST_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC INIT_FIRSTOID_LIST IN OMST_PACK EXECUTE INPROC;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_CREATE_VERSION IN OMST_PACK EXECUTE INPROC;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_OPEN_VERSION IN OMST_PACK EXECUTE INPROC;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_CLOSE_VERSION IN OMST_PACK EXECUTE INPROC;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_FORCE_DROP_VERSION IN OMST_PACK EXECUTE INPROC;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;

		EXEC SQL CREATE DBPROC OMS_CREATE_VAROBJ_LIST IN OMS1_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;

		EXEC SQL CREATE DBPROC OMS_DELETE_VAROBJ_LIST IN OMS1_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;

		EXEC SQL CREATE DBPROC OMS_TRAVERSE_VAROBJ_LIST IN OMS1_PACK EXECUTE INPROC ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC OMS1_INIT_FIRSTOID_LIST IN OMS1_PACK EXECUTE INPROC  ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;

	}
	else
	{
		EXEC SQL CREATE DBPROC CREATELIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CREATE_SQL_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CREATE_NATIVE_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CREATE_KEYOID_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC DELETE_NATIVE_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC TRAVERSE_LIST IN OMST_PACK  ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC TRAVERSE_SQL_LIST IN OMST_PACK  ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC TRAVERSE_NATIVE_LIST IN OMST_PACK  ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC TRAVERSE_KEYOID_LIST IN OMST_PACK  ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC DELETE_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC DELETE_KEYOID_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC ADD_ELEMENT_TO_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC DELETE_ELEMENT_FROM_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_RELEASE_OIDS IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_DEBUG IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC INIT_FIRSTOID_LIST IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_CREATE_VERSION IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_OPEN_VERSION IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_CLOSE_VERSION IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC CHL_FORCE_DROP_VERSION IN OMST_PACK ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC OMS_CREATE_VAROBJ_LIST IN OMS1_PACK   ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC OMS_DELETE_VAROBJ_LIST IN OMS1_PACK   ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC OMS_TRAVERSE_VAROBJ_LIST IN OMS1_PACK   ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;
		EXEC SQL CREATE DBPROC OMS1_INIT_FIRSTOID_LIST IN OMS1_PACK   ;
		if ( sqlca.sqlcode && sqlca.sqlcode != -6006)
			printf ( "CREATE DBPROC: sqlcode %d\n" , sqlca.sqlcode ) ;
		commit (" " , sqlca.sqlcode,2) ;




	}
}

/*------------------------------------------------------------------------*/

#define FPC(n,t) n?(float)((float) t / (float) n ):0.0

/*------------------------------------------------------------------------*/

void CreateList (long elems, int Optimistic)
{
	int sc ;
	cre_elements = elems ;

	TA ;
	EXEC SQL DBPROC CREATELIST ( :cre_elements, 0 , :ListNo ) ;
	TB ;

	tdo = td ;
	sc = sqlca.sqlcode ;

	commit ( "CREATELIST", sc, 2) ;
	subkind = 7 ; TB ;

	if ( sc )
		elems = 0 ;

	printf ( "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems ,(int) tdo , FPC (cre_elements,tdo) ) ;
	fprintf ( fprot, "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems ,(int) tdo , FPC (cre_elements,tdo) ) ;

	printf ( "CREATE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode , (int) elems ,(int) td , FPC (cre_elements,td) ) ;
	fprintf ( fprot, "CREATE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode , (int) elems ,(int) td , FPC (cre_elements,td) ) ;
}

/*------------------------------------------------------------------------*/


void CreateVarList (long elems, int Optimistic, int len)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int vlen ;
	EXEC SQL END DECLARE SECTION ;
	int sc ;
	vlen = len ;
	cre_elements = elems ;

	TA ;
	EXEC SQL DBPROC OMS_CREATE_VAROBJ_LIST ( :cre_elements, :vlen , 1 , :ListNo ) ;
	TB ;
	tdo = td ;
	sc = sqlca.sqlcode ;

	commit ( "CREATE_VAROBJ_LIST", sc, 2) ;
	subkind = 7 ; TB ;

	if ( sc )
		elems = 0 ;

	printf ( "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems ,(int) tdo , FPC (cre_elements,tdo) ) ;
	fprintf ( fprot, "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems ,(int) tdo , FPC (cre_elements,tdo) ) ;

	printf ( "CREATE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode , (int) elems ,(int) td , FPC (cre_elements,td) ) ;
	fprintf ( fprot, "CREATE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode , (int) elems ,(int) td , FPC (cre_elements,td) ) ;
}
/*------------------------------------------------------------------------*/


void CreateSqlList (long elems)
{
	int sc ;
	cre_elements = elems ;

	TA ;
	EXEC SQL DBPROC CREATE_SQL_LIST ( :cre_elements ) ;
	TB ;

	tdo = td ;
	sc = sqlca.sqlcode ;

	commit ( "CREATE_SQL_LIST", sc, 2 ) ;
	subkind = 7 ; TB ;

	if ( sc )
		elems = 0 ;

	printf ( "CREATE S: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems , (int) tdo , FPC (cre_elements,tdo) ) ;
	fprintf (fprot, "CREATE S: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems , (int) tdo , FPC (cre_elements,tdo) ) ;

	printf ( "CREATE S: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode  , (int) elems , (int) td , FPC (cre_elements,td) ) ;
	fprintf (fprot, "CREATE S: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode  , (int) elems , (int) td , FPC (cre_elements,td) ) ;
}

/*------------------------------------------------------------------------*/

void CreateNativeList (long elems)
{
	int sc ;
	cre_elements = elems ;

	TA ;
	EXEC SQL DBPROC CREATE_NATIVE_LIST ( :cre_elements, :sum ) ;
	TB ;
	tdo = td ;
	sc = sqlca.sqlcode ;

	commit ( "CREATE_SQL_LIST", sc, 2 ) ;

	if ( sc )
		elems = 0 ;

	subkind = 7 ; TB ;

	if ( sc )
		elems = 0 ;

	printf ( "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems , (int) tdo , FPC (cre_elements,tdo) ) ;
	fprintf (fprot, "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems , (int) tdo , FPC (cre_elements,tdo) ) ;

	printf ( "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode  , (int) elems , (int) td , FPC (cre_elements,td) ) ;
	fprintf (fprot, "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode  , (int) elems , (int) td , FPC (cre_elements,td) ) ;
}

/*------------------------------------------------------------------------*/

void DeleteElememtsFromList (long lno, int lm )
{
	int sc ;
	listno = lno ;
	LockModeOptimistic = lm ;

	TA ;
	EXEC SQL DBPROC DELETE_ELEMENT_FROM_LIST ( :listno , :del_elements ,
		:LockModeOptimistic, :elements ) ;
	TB ;
	commit ("DELETE_ELEMENT_FROM_LIST", sc = sqlca.sqlcode, 1+(rand()%4)) ;

	printf ( "DELETE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elements , (int) td , FPC (del_elements,td)) ;

	fprintf ( fprot, "DELETE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elements , (int) td , FPC (del_elements,td)) ;

}
/*------------------------------------------------------------------------*/

void CreateKeyOidList (long elems)
{
	int sc ;
	cre_elements = elems ;

	TA ;
	EXEC SQL DBPROC CREATE_KEYOID_LIST ( :cre_elements, :ListNo ) ;
	TB ;

	tdo = td ;
	sc = sqlca.sqlcode ;

	commit ( "CREATELIST", sc, 2) ;
	TB ;
	subkind=7 ;

	if ( sc )
		elems = 0 ;

	printf ( "CREATE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems ,(int) tdo , FPC (cre_elements,tdo) ) ;
	fprintf (fprot, "CREATE : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems ,(int) tdo , FPC (cre_elements,tdo) ) ;

	printf ( "CREATE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems ,(int) td , FPC (cre_elements,td) ) ;
	fprintf (fprot, "CREATE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sc , (int) elems ,(int) td , FPC (cre_elements,td) ) ;
}

/*------------------------------------------------------------------------*/

void DeleteList (long lno, int Optimistic )
{
	LockModeOptimistic = Optimistic ;
	listno = lno ;

	TA ;
	EXEC SQL DBPROC DELETE_LIST ( :listno , :listpos , :elements, :LockModeOptimistic ) ;
	TB ;
	tdo = td ;
	sqlco = sqlca.sqlcode ;

	commit ("DELETE_LIST " , sqlca.sqlcode,2 ) ;

	subkind = 6 ;
	TB ;
	printf ( "DELETE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
	sqlca.sqlcode , (int) elements , (int) tdo , FPC (elements,tdo)) ;
	fprintf (fprot, "DELETE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
	sqlca.sqlcode , (int) elements , (int) tdo , FPC (elements,tdo)) ;

	printf ( "DELETE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
	sqlca.sqlcode , (int) elements , (int) td , FPC (elements,td)) ;
	fprintf (fprot, "DELETE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
	sqlca.sqlcode , (int) elements , (int) td , FPC (elements,td)) ;
}

/*------------------------------------------------------------------------*/

void DeleteVarList (long lno, int Optimistic )
{
	LockModeOptimistic = Optimistic ;
	listno = lno ;

	TA ;
	EXEC SQL DBPROC OMS_DELETE_VAROBJ_LIST ( :listno , :listpos , :elements ) ;
	TB ;
	tdo = td ;
	sqlco = sqlca.sqlcode ;

	commit ("DELETE_LIST " , sqlca.sqlcode,2 ) ;
	subkind = 6 ;
	TB ;

	printf ( "DELETE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
	sqlco , (int) elements , (int) tdo , FPC (elements,tdo)) ;
	fprintf (fprot, "DELETE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
	sqlco , (int) elements , (int) tdo , FPC (elements,tdo)) ;

	printf ( "DELETE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
	sqlca.sqlcode , (int) elements , (int) td , FPC (elements,td)) ;
	fprintf (fprot, "DELETE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
	sqlca.sqlcode , (int) elements , (int) td , FPC (elements,td)) ;

}

/*------------------------------------------------------------------------*/

void DeleteNativeList ( )
{
	TA ;
	EXEC SQL DBPROC DELETE_NATIVE_LIST ( :elements ) ;
	TB ;

	printf ( "DELETE N: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode , (int) elements , (int) td , FPC (elements,td)) ;
	fprintf ( fprot,"DELETE N: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode , (int) elements , (int) td , FPC (elements,td)) ;

	commit ("DELETE_NATIVE_LIST " , sqlca.sqlcode,2 ) ;
}

/*------------------------------------------------------------------------*/

void DeleteKeyOidList ( long ListNo )
{
	listno = ListNo ;
	elements = 0 ;
	TA ;
	EXEC SQL DBPROC DELETE_KEYOID_LIST ( :listno, :elements ) ;
	TB ;
	tdo = td ;
	sqlco = sqlca.sqlcode ;

	commit ("DELETE_KEYOID_LIST " , sqlca.sqlcode,2 ) ;

	subkind = 6 ;
	TB ;

	printf ( "DELETE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlco , (int) elements , (int) tdo , FPC (elements,tdo)) ;
	fprintf ( fprot,"DELETE  : sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlco , (int) elements , (int) tdo , FPC (elements,tdo)) ;

	printf ( "DELETE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode , (int) elements , (int) td , FPC (elements,td)) ;
	fprintf (fprot, "DELETE+C: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec\n" ,
		sqlca.sqlcode , (int) elements , (int) td , FPC (elements,td)) ;
}

/*------------------------------------------------------------------------*/

long TraverseList (long lno ,		/* List number (just for output protocol) */
				   long Lno,		/* List number; 0: use start OID of last traverse*/
				   int	RelOids ,	/* 1: Release OIDs after reading*/
				   long Ntt,		/* no of elements to traverse. 0: traverse all*/
				   int	ReadLocked) /* 1: lock OIDs when reading */
{
	int sc ;

	listno = Lno ;
	ReleaseOids = RelOids ;
    NoToTraverse = Ntt ;
	ReadOidsLocked = ReadLocked ;
	elements = 0 ;
	sum = 0 ;

	if ( Lno == 0 )
	{
		memcpy ( FiOidIn , FiOidOut , sizeof FiOidIn ) ;
	}
	else
		strcpy ( FiOidIn , "12345678" ) ; /* for Debug*/

	TA ;
	EXEC SQL DBPROC TRAVERSE_LIST ( :listno , :NoToTraverse , :elements,
		:sum , :ReleaseOids, :ReadOidsLocked, :FiOidIn , :FiOidOut ) ;
	TB ;

	if ( ( sc = sqlca.sqlcode ) <= -8000 )
		commit (" " , sqlca.sqlcode,0) ;

	printf ( "TRAVERSE: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc , (int) elements, (int) td, FPC (elements,td), sum) ;
	fprintf ( fprot,"TRAVERSE: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc ,(int) elements, (int) td, FPC (elements,td), sum) ;

	return sum ;
}

/*------------------------------------------------------------------------*/

long TraverseVarList (long lno ,		/* List number (just for output protocol) */
				   long Lno,		/* List number; 0: use start OID of last traverse*/
				   int	RelOids ,	/* 1: Release OIDs after reading*/
				   long Ntt,		/* no of elements to traverse. 0: traverse all*/
				   int	ReadLocked) /* 1: lock OIDs when reading */
{
	int sc ;

	listno = Lno ;
	ReleaseOids = RelOids ;
    NoToTraverse = Ntt ;
	ReadOidsLocked = ReadLocked ;
	elements = 0 ;
	sum = 0 ;

	if ( Lno == 0 )
	{
		memcpy ( FiOidIn , FiOidOut , sizeof FiOidIn ) ;
	}
	else
		strcpy ( FiOidIn , "12345678" ) ; /* for Debug*/

	TA ;
	EXEC SQL DBPROC OMS_TRAVERSE_VAROBJ_LIST ( :listno , :NoToTraverse , :elements,
		:sum , :ReleaseOids, :ReadOidsLocked, 0, :FiOidIn , :FiOidOut ) ;
	TB ;

	if ( ( sc = sqlca.sqlcode ) <= -8000 )
		commit (" " , sqlca.sqlcode,0) ;

	printf ( "TRAVERSE: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc , (int) elements, (int) td, FPC (elements,td), sum) ;
	fprintf ( fprot,"TRAVERSE: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc ,(int) elements, (int) td, FPC (elements,td), sum) ;

	return sum ;
}

/*------------------------------------------------------------------------*/

long TraverseSqlList (long lno ,		/* List number (just for output protocol) */
				   long Lno,		/* List number; 0: use start OID of last traverse */
				   int	RelOids ,	/* 1: Release OIDs after reading */
				   long Ntt,		/* no of elements to traverse. 0: traverse all */
				   int	ReadLocked) /* 1: lock OIDs when reading */
{
	int sc ;

	listno = Lno ;
	ReleaseOids = RelOids ;
    NoToTraverse = Ntt ;
	ReadOidsLocked = ReadLocked ;
	elements = 0 ;
	sum = 0 ;

	TA ;
	EXEC SQL DBPROC TRAVERSE_SQL_LIST ( :listno , :NoToTraverse , :elements, :sum ) ;
	TB ;

	if ( ( sc = sqlca.sqlcode ) <= -8000 )
		commit (" " , sqlca.sqlcode,0) ;

	printf ( "TRAVERSE: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc ,(int) elements, (int) td, FPC (elements,td), sum) ;
	fprintf ( fprot,"TRAVERSE: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc ,(int) elements, (int) td, FPC (elements,td), sum) ;

	return sum ;
}

/*------------------------------------------------------------------------*/

long TraverseKeyOidList (long lno ,		/* List number (just for output protocol) */
				   long Lno,		/* List number; 0: use start OID of last traverse */
				   int	RelOids ,	/* 1: Release OIDs after reading */
				   long Ntt,		/* no of elements to traverse. 0: traverse all */
				   int	ReadLocked) /* 1: lock OIDs when reading */
{
	int sc ;

	listno = Lno ;
	ReleaseOids = RelOids ;
    NoToTraverse = Ntt ;
	ReadOidsLocked = ReadLocked ;
	elements = 0 ;
	sum = 0 ;

	TA ;
	EXEC SQL DBPROC TRAVERSE_KEYOID_LIST ( :listno , :NoToTraverse , :elements,
		:sum , :ReleaseOids, :ReadOidsLocked ) ;
	TB ;

	if ( ( sc = sqlca.sqlcode ) <= -8000 )
		commit (" " , sqlca.sqlcode,0) ;

	printf ( "TRAV KEY: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc , (int) elements, (int) td, FPC (elements,td), sum) ;
	fprintf ( fprot, "TRAV KEY: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc , (int) elements, (int) td, FPC (elements,td), sum) ;

	return sum ;
}

/*------------------------------------------------------------------------*/

long TraverseNativeList (long lno ,		/* List number (just for output protocol) */
				   long Lno,		/* List number; 0: use start OID of last traverse */
				   int	RelOids ,	/* 1: Release OIDs after reading */
				   long Ntt,		/* no of elements to traverse. 0: traverse all */
				   int	ReadLocked) /* 1: lock OIDs when reading */
{
	int sc ;

	listno = Lno ;
	ReleaseOids = RelOids ;
    NoToTraverse = Ntt ;
	ReadOidsLocked = ReadLocked ;
	elements = 0 ;
	sum = 0 ;

	TA ;
	EXEC SQL DBPROC TRAVERSE_NATIVE_LIST ( :elements, :sum ) ;
	TB ;

	if ( ( sc = sqlca.sqlcode ) <= -8000 )
		commit (" " , sqlca.sqlcode,0) ;

	printf ( "TRAVERSE: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc , (int) elements, (int) td, FPC (elements,td), sum) ;
	fprintf (fprot, "TRAVERSE: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc , (int) elements, (int) td, FPC (elements,td), sum) ;

	return sum ;
}

/*------------------------------------------------------------------------*/

void ReleaseAll()
{
	EXEC SQL DBPROC CHL_RELEASE_OIDS ( 0) ;
}

/*------------------------------------------------------------------------*/

void	DropSqlListCpc ()
{
	EXEC SQL  AT :dbcoll WHENEVER SQLERROR CONTINUE ;
	EXEC SQL DROP TABLE SQLOBJECTS ;
	EXEC SQL  AT :dbcoll WHENEVER SQLERROR CALL fehler () ;
}

/*------------------------------------------------------------------------*/

void	CreateSqlListCpc (long ElementsInList )
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int key1 ;
	int valint ;
	int key2 ;
	EXEC SQL END DECLARE SECTION ;

	long i ;
	int sc ;
	int sum = 0 ;

	TA ;

	EXEC SQL
		create table SQLOBJECTS
		( KEY1 INTEGER ,
		VALINT INTEGER ,
		KEY2 INTEGER,
		PRIMARY KEY (KEY1)) ;

	if ( sqlca.sqlcode == 0 /*|| sqlca.sqlcode == -955 */ )
		EXEC SQL COMMIT ;
	else
	{
		fprintf ( stderr,"ERROR: CREATE TABLE, sqlcode = %d\n" , sqlca.sqlcode ) ;
		fprintf ( fprot,"ERROR: CREATE TABLE, sqlcode = %d\n" , sqlca.sqlcode ) ;
		return ;
	}

	for ( key1 = 0 ; key1 < ElementsInList-1 ; key1++ )
	{
		valint = rand () % 64 ;
		sum += valint ;
		key2 = key1 + 1 ;

		EXEC SQL  INSERT INTO SQLOBJECTS VALUES ( :key1 , :valint , :key2 ) ;

		if ( sc = sqlca.sqlcode )
		{
			fprintf ( stderr,"ERROR: INSERT SQLOBJECTS, sqlcode = %d\n" , sqlca.sqlcode ) ;
			fprintf ( fprot,"ERROR: INSERT SQLOBJECTS, sqlcode = %d\n" , sqlca.sqlcode ) ;
			return ;
		}
	}

	valint = rand () % 64 ;
	key2 = 0 ;
	sum += valint ;

	EXEC SQL INSERT INTO SQLOBJECTS VALUES ( :key1 , :valint , :key2 ) ;

	if ( sc = sqlca.sqlcode )
	{
		fprintf ( stderr,"ERROR: INSERT SQLOBJECTS, sqlcode = %d\n" , sqlca.sqlcode ) ;
		fprintf ( fprot,"ERROR: INSERT SQLOBJECTS, sqlcode = %d\n" , sqlca.sqlcode ) ;
		return ;
	}

	TB ;

	tdo = td ;
	sc = sqlca.sqlcode ;

	commit ("INSERT SQL" , sc,2 ) ;
	subkind=7 ; TB ;

	printf ( "INS SQL  :sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc ,ElementsInList, (int) tdo, FPC (ElementsInList,tdo), sum) ;
	fprintf (fprot, "INS SQL  :sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc ,ElementsInList, (int) tdo, FPC (ElementsInList,tdo), sum) ;

	printf ( "INS SQL+C:sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sqlca.sqlcode ,ElementsInList, (int) td, FPC (ElementsInList,td), sum) ;
	fprintf (fprot, "INS SQL+C:sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sqlca.sqlcode ,ElementsInList, (int) td, FPC (ElementsInList,td), sum) ;


}

/*------------------------------------------------------------------------*/

void	TraverseSqlListCpc ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int key1 ;
	int valint ;
	int key2 ;
	EXEC SQL END DECLARE SECTION ;

	long sum = 0 ;
	int  els = 0 ;
	int	 sc = 0 ;

	key1 = 0 ;
	TA ;
	do
	{
		EXEC SQL
			SELECT valint , key2
			INTO :valint, :key2
			FROM sqlobjects
			WHERE key1 = :key1 ;

		if ( sqlca.sqlcode )
		{
			fprintf ( stderr,"ERROR: SELECT SQLOBJECTS, sqlcode = %d\n" , sqlca.sqlcode ) ;
			fprintf ( fprot,"ERROR: SELECT SQLOBJECTS, sqlcode = %d\n" , sqlca.sqlcode ) ;
			return ;
		}

		els++ ;
		sum += valint ;
		key1 = key2 ;

	} while ( key2 != 0 ) ;
	TB ;

	commit (" " , sqlca.sqlcode,0) ;

	printf ( "TR C SQL: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc , (int) els, (int) td, FPC (els,td), sum) ;
	fprintf (fprot, "TR C SQL: sqlc=%-5d elems=%-7d time=%-5d/ %9.5f msec sum=%-7ld \n",
		sc , (int) els, (int) td, FPC (els,td), sum) ;
}

/*------------------------------------------------------------------------*/

void DebugOmsOff ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long iIn, iOut ;
	EXEC SQL END DECLARE SECTION ;

	EXEC SQL DBPROC CHL_DEBUG ( 0 , :iOut ) ;
}

/*------------------------------------------------------------------------*/
/*
void ReleaseConnect ()
{
	EXEC SQL COMMIT RELEASE ;
	Sleep (1000) ;
	EXEC SQL CONNECT ;
	commit ("CONNECT" , sqlca.sqlcode , 2 ) ;
}
*/
/*------------------------------------------------------------------------*/

void commit (char *s, int sqlcode, int CommitTrans )
{
	FILE *f ;
	char    da [40] ;
	time_t    tm ;

	if ( ( sqlcode == 0 || sqlcode == 100 || sqlcode == -28814 ) && CommitTrans )
	{
		if ( CommitTrans > 1 )
			EXEC SQL COMMIT ;
		else
			EXEC SQL ROLLBACK ;
	}
	else
	{
		tm = time ( (time_t *) 0) ;
		strncpy ( da , ctime ( &tm ) , 39 ) ;
		da [ 39 ] = 0 ;

		/*
		fprintf ( stderr , "pid %d , %.19s , %s :  ERR = %d\n" , pid , da , s , sqlcode ) ;
		*/

		if ( ( f = fopen ("omstime.err" , "a" ) ) != NULL )
		{
			fprintf ( f , "pid %d , %.19s , %s :  ERR = %d\n" ,
				pid , da , s , sqlcode ) ;
			fclose (f) ;
		}

		if ( CommitTrans )
			EXEC SQL ROLLBACK ;
	}

	if ( sqlcode == -807 || sqlcode == -7500 )
	{
		EXEC SQL COMMIT WORK RELEASE ;
		exit (99) ;
	}


	if ( sqlcode <= -8000 && sqlcode > -10000 )
	{
		/* set mark in vtrace */
		EXEC SQL COMMIT WORK RELEASE ;
		exit (99) ;
		/* Dump(s,sqlcode)	; */
	}


}

/*------------------------------------------------------------------------*/

void Dump (char	*s, int sqlcode)
{
	char    da [40] ;
	time_t  tm ;

	EXEC SQL BEGIN DECLARE SECTION ;
	char	*Illcmd = "SQLADUMP" ;
	EXEC SQL END DECLARE SECTION ;
	tm = time ( (time_t *) 0) ;
	strncpy ( da , ctime ( &tm ) , 39 ) ;
	da [ 39 ] = 0 ;

	EXEC SQL EXECUTE IMMEDIATE :Illcmd ;
	fprintf ( stderr , "pid %d , %.19s , %s :  ERR = %d\n" ,
		pid , da , s , sqlcode ) ;
	fprintf ( fprot , "pid %d , %.19s , %s :  ERR = %d\n" ,
		pid , da , s , sqlcode ) ;
	sqladump() ;
	exit (99) ;
}

/*------------------------------------------------------------------------*/

void DeleteVersions ()
{
	exec sql begin declare section ;
	char vid [23] ;
	long rc ;
	exec sql end declare section ;
	char s [100] ;

	EXEC SQL SELECT
		oms_version_id FROM domain.oms_versions ;

	while ( sqlca.sqlcode == 0 )
	{
		EXEC SQL FETCH INTO :vid ;
		if ( sqlca.sqlcode )
			return ;
		vid[22] = 0 ;
		EXEC SQL DBPROC chl_force_drop_version (:vid, :rc );
		sprintf ( s , "Drop Version '%s', rc = %d" , vid, sqlca.sqlcode ) ;
		printf ("%s\n" , s ) ;
		EXEC SQL commit ;
	}
}
/*------------------------------------------------------------------------*/

void sleepAfterDelete ()
{
	/* sleep some seconds so that garbage collectors can run */

	if ( noSleep == 0 )
		sleep ( 10 * ( 1 + ElementsInList / 20000 ) ) ;

}
/*------------------------------------------------------------------------*/

double TimeInMilli ()
{
#ifdef _WIN32
	return ((double) GetTickCount() );
#else
	struct tms	bf ;
	clock_t		tcks  ;
	tcks = times ( &bf ) ;
	return (double) ( (double) tcks / (double) clk_tick ) * 1000.0 ;
#endif
}

/*------------------------------------------------------------------------*/

collectInit ()
{
	int connectRc = 0 ;

	EXEC SQL BEGIN DECLARE SECTION ;
	char rdate[40] ;
	int	 seqcnt ;
	EXEC SQL END DECLARE SECTION ;

	if ( Collect )
	{
		/* EXEC SQL COMMIT RELEASE ;  */
		sprintf (dbcollString, "%s-%s", collhostname,collserverdb) ;
		printf ( "collserverdb = %s, collhostname = %s\n" , collserverdb, collhostname ) ;

		EXEC SQL AT :dbcoll WHENEVER SQLERROR CONTINUE ;
		EXEC SQL WHENEVER SQLERROR CONTINUE ;

		printf ( "CONNECT %s IDENTIFIED BY %s AT %s USING %s\n",user,password,dbcoll,dbcollString) ;
		EXEC SQL CONNECT :user IDENTIFIED BY :password AT :dbcoll USING :dbcollString ;

		connectRc = sqlca.sqlcode ;

		if ( connectRc == 0 )
		{
			EXEC SQL AT :dbcoll CREATE TABLE OMSTIME_VERDATA (
				SEQ INTEGER,
				MACHINE VARCHAR(37),
				OS VARCHAR(20),
				MODEL VARCHAR(20),
				DATETIME VARCHAR(40),
				KERNELVERSION VARCHAR (36),
				LOOPS INTEGER,
				LINES INTEGER,
				TRANSSIM CHAR (6), PRIMARY KEY (SEQ,MACHINE,DATETIME) );

			EXEC SQL AT :dbcoll CREATE TABLE OMSTIME_RESULT (
				SEQ INTEGER, KIND CHAR(20), SUBKIND CHAR (20),
				REALTIME INTEGER, PRIMARY KEY (SEQ,KIND,SUBKIND) ) ;

			EXEC SQL AT :dbcoll CREATE TABLE OMSTIME_SEQ (
				SEQ INTEGER DEFAULT 0,
				PRIMARY KEY (SEQ) ) ;

			EXEC SQL AT :dbcoll COMMIT ;

			EXEC SQL AT :dbcoll create view omstime_overview as
				select a.kind "Access" , b.transsim "TransSim", a.subkind "Operation",
				b.machine "Host" , a.realtime "Microsecs" ,
				b.kernelversion "Kernelversion", b.datetime "Date"
				from
				OMSTIME_RESULT a , OMSTIME_VERDATA b
				where a.seq = b.seq ;

			EXEC SQL AT :dbcoll COMMIT ;

			EXEC SQL AT :dbcoll SELECT COUNT(*) INTO :seqcnt FROM OMSTIME_SEQ ;

			if ( seqcnt == 0 )
			{
				EXEC SQL AT :dbcoll INSERT INTO OMSTIME_SEQ VALUES (0) ;
				EXEC SQL AT :dbcoll COMMIT ;
			}
		}
		else
		{
			printf ("WARNING No Connect to COLLECT database possible, sqlcode = %d\n",connectRc) ;
			fprintf (fprot, "WARNING No Connect to COLLECT database possible, sqlcode = %d\n",connectRc) ;
			Collect = 0 ;
			return connectRc ;
		}

		EXEC SQL  AT :dbcoll WHENEVER SQLERROR CALL collWarnung () ;

		if ( Collect )
		{
			EXEC SQL  AT :dbcoll UPDATE OMSTIME_SEQ SET SEQ = SEQ + 1 ;
			EXEC SQL  AT :dbcoll SELECT SEQ INTO :ColSeq FROM OMSTIME_SEQ ;
			EXEC SQL  AT :dbcoll COMMIT ;
			/* EXEC SQL  AT :dbcoll COMMIT RELEASE ; */
		}

		if ( sqlca.sqlcode != 0 )
		{
			printf ("No Connect to COLLECT database possible\n") ;
			Collect = 0 ;
		}
		else
		{
			SQLSTRCPY ( ColMachine , omsHostname ) ;
			printf ( "ColMachine = >%s<\n" , ColMachine ) ;
			/*
			#ifdef win32

			SQLSTRCPY ( ColOS , "NT" ) ;
			SQLSTRCPY ( ColModel , " " ) ;
			#else
			SQLSTRCPY ( ColOS , "UNIX" ) ;
			#ifdef dec_os
			SQLSTRCPY ( ColModel , "DEC" ) ;
			#else
			#ifdef sun
			SQLSTRCPY ( ColModel , "Sun" ) ;
			#else
			#ifdef hp
			SQLSTRCPY ( ColModel , "HP" ) ;
			#else
			#ifdef sni
			SQLSTRCPY ( ColModel , "SNI" ) ;
			#else
			#ifdef ibm_aix
			SQLSTRCPY ( ColModel , "IBM" ) ;
			#endif
			#endif
			#endif
			#endif
			#endif
			#endif
			*/
			SQLSTRCPY ( ColModel , " " ) ;

			sprintf ( ColZeit , "%d" , StClock ) ;
			ColDurch = MaxLoops ;
			ColLines = cre_elements ;

			if ( useVersions )
			{
				SQLSTRCPY ( ColVersions , "yes" )
			}
			else
			{
				SQLSTRCPY ( ColVersions , "no" ) ;
			}

			kversion [40] = 0 ;

			EXEC SQL AT :dbcoll INSERT INTO OMSTIME_VERDATA (SEQ, MACHINE, OS, MODEL,
				DATETIME, KERNELVERSION, LOOPS, LINES, TRANSSIM )
				VALUES (:ColSeq , :ColMachine, :ColOS ,
				:ColModel, :dateString,:kversion, :ColDurch ,
				:ColLines, :ColVersions ) ;

			EXEC SQL  AT :dbcoll COMMIT ;

			Collect = 1 ;

			return 0 ;

		}
	}
	return 0 ;
}

/*------------------------------------------------------------------------*/

void collectData ()
{
	printf ("\n************ Summary ***********\n\n" , skind [kind] ) ;
	fprintf (fprot,"\n********* Summary *********\n" , skind [kind] ) ;
	for ( kind = 0 ; kind < MAXKIND ; kind++ )
	{
		printf ("*** %s ***\n" , skind [kind] ) ;
		fprintf (fprot,"*** %s ***\n" , skind [kind] ) ;

		for ( subkind = 0 ; subkind < MAXSUBKIND ; subkind++ )
		{
			if ( mess[kind][subkind].anz )
			{

				printf ("%-20s %4d %7.4f\n" , ssubkind[subkind] ,
					mess[kind][subkind].anz ,
					mess[kind][subkind].tm / mess[kind][subkind].anz / cre_elements ) ;

				fprintf (fprot, "%-20s %4d %7.4f\n" , ssubkind[subkind] ,
					mess[kind][subkind].anz ,
					mess[kind][subkind].tm / mess[kind][subkind].anz / cre_elements ) ;

				if ( Collect )
				{

					SQLSTRCPY ( ColKind , skind [kind]  ) ;
					SQLSTRCPY ( ColSubKind , ssubkind[subkind] ) ;
					ColRealTime = mess[kind][subkind].tm / mess[kind][subkind].anz / cre_elements * 1000 ;

					EXEC SQL AT :dbcoll INSERT INTO OMSTIME_RESULT ( SEQ, KIND, SUBKIND, REALTIME )
						VALUES ( :ColSeq , :ColKind, :ColSubKind , :ColRealTime ) ;
				}
			}
		}
	}

	if ( Collect )
	{
		EXEC SQL  AT :dbcoll COMMIT ;
	}

	EXEC SQL WHENEVER SQLERROR CALL fehler () ;
}

/*------------------------------------------------------------------------*/

fehler ()
{
    fprintf(stderr,"\n Fehlercode: %d", sqlca.sqlcode);
    fprintf(fprot,"Fatal Error %d --> EXIT", sqlca.sqlcode);

    exit(sqlca.sqlcode);
}

/*------------------------------------------------------------------------*/

warnung ()
{
    fprintf(stderr,"\n Fehlercode: %d", sqlca.sqlcode);
    fprintf(fprot,"\n Fehlercode: %d", sqlca.sqlcode);
    /*exit(sqlca.sqlcode);*/
}

/*------------------------------------------------------------------------*/

collWarnung ()
{
    fprintf(stderr,"\n Fehlercode: %d", sqlca.sqlcode);
    fprintf(fprot,"\n Fehlercode: %d", sqlca.sqlcode);
	Collect = 0 ;
    /*exit(sqlca.sqlcode);*/
    return sqlca.sqlcode;
}

/*------------------------------------------------------------------------*/

wrong_usage ()
{
    fprintf (stderr, "Usage: omstime -u <us,pw> -n <serverhost> -d <serverdb> [-V]\n");
	fprintf (stderr, "	 -U us,pw       user/password for OMS serverdb\n");
	fprintf (stderr, "	 -D serverdb    dbname of OMS serverdb\n");
	fprintf (stderr, "	 -u us,pw       user/password for data collection\n");
	fprintf (stderr, "	 -n serverhost	serverhost for data collection\n");
	fprintf (stderr, "	 -d serverdb    dbname for data collection\n");
	fprintf (stderr, "	 -V				use versions (transactional simulations)\n");

	fprintf (stderr, "	 -l loops       number of loops\n");
	fprintf (stderr, "	 -e elements    number of elements in each list\n");

	/*fprintf (stderr, "	 -i             inproc: run in kernel address space\n");*/
	fprintf (stderr, "	 -d             drop and recreate dbprocs at start time\n");

    exit (99) ;
}

/*------------------------------------------------------------------------*/
