package com.sap.sapdb.DBMTest;

/*!
  -----------------------------------------------------------------------------
  module: DBMTrace.java
  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 1998-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
import java.sql.*;
import com.sap.sapdb.testframe.testcase.*;
import com.sap.sapdb.testframe.driver.*;

/**
 * DBMServer trace test
 * <xmp>
 * -----------------------------------------------------------------------------
 * Class:        DBMTrace
 * -----------------------------------------------------------------------------
 * responsible:  BerndV
 * special area: DBMServer Java Test
 * description:  checks the trace commands of the DBMServer
 * version:      7.2.*
 * copyright:    (c) 1998-2004 SAP AG
 * -----------------------------------------------------------------------------
 * </xmp>
 */
public class DBMTrace extends TestCase {

  /**
   * A minimal constructor.Constructor.
   */
  public DBMTrace() throws SQLException, TestDatabaseException {
          super();
  } // end DBMTrace

  /**
   * Clean up test, i.e. delete data created in prepare, ...
   * @exception TestCaseException Should be thrown, when cleanUp fails
   */
  public static void cleanUp() throws TestCaseException {
    // do nothing
  } // end cleanUp

  /**
   * Returns (defines) the name of the test class. If this method doesn't exist, the test driver
   * will set the name to the name of the java class. To make the test name independend
   * from the java implementation, this method should return a unique string.
   * Attention: The uniqueness is not automatically checked by anybody.
   * @return The UNIQUE name of the test class
   */
  public static String getTestClassId() {
    return "DBMTrace";
  } // end getTestClassId

  /**
   * Sets the timeout value in milliseconds. After the timeout is reached, the test will be aborted
   * by the test driver.
   * @return The default return value is 0, which means there is no timeout value set. Test will never
   * be aborted by the test driver.
   */
  public static long getTimeout() {
    return 0;
  } // end getTimeout

  /**
   * Sets weather test can create and work with verification data or not.
   * @return The default return value is false, which means that no verification data
   * is used to verify the test results. In this case the test has to implement the verification
   * itself.
   */
  public static boolean isReferenceEnabled() {
    return false;
  } // end isReferenceEnabled

  /**
   * Sets weather test can be executed only on SAPDB or not.
   * @return The default return value is true. This means, the test can run on SAPDB only.
   */
  public static boolean isSAPOnly() {
          return true;
  } // end isSAPOnly

  /**
   * Prepare test, i.e. create users, tables and data
   * @exception TestCaseException Should be thrown, when preparation fails
   */
  public static void prepare() throws TestCaseException {
    // do nothing
  } // end prepare

  /**
   * run() contains the test implementation
   */
  public void run() {

    DBMUtility     oDBM    = new  DBMUtility(getDatabase(), this);
    DBMAnswerTable oAnswer = new DBMAnswerTable();
    String         sTemp;

    //  create one global try-catch block to handle exceptions
    try {

      // *** 1. Create a defined trace statev ***

      // switch db_state to warm
      oDBM.execCmd("db_online", DBMUtility.OK_OK);

      // switch all trace off
      oDBM.execCmd("trace_off all", DBMUtility.OK_OK);

      // check trace state (all OFF?)
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // find a line with value ON
      if (oAnswer.getField("ON", "state", "state").length() > 0) {
        // error there are rows with "ON" in state
        addMessage("trace_off all", TestProtocol.ERROR , "Could not switch off all traces!");
        return;
      } // end if

      // *** 2. Check all trace options ***

      // on
      oDBM.execCmd("trace_on DEFAULT"         , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on INDEX"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on LOCK"            , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on LONG"            , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on PAGES"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on STANDARD"        , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TABLE"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on OBJECT"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on OBJECTADD"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on OBJECTGET"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on OBJECTALTER"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on OBJECTFREE"      , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on SELECT"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on INSERT"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on UPDATE"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on DELETE"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on ORDER"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on OPTIMIZER"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TIME"            , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECK"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on COMMANDS"        , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICCONVERTER"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICDATA"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICFRAMECTRL"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICLOG"        , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICIOMAN"      , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICMEMORY"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICVOLUME"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICRUNTIME"    , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICALLOCATOR"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKCONVERTER"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKDATA"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKFRAMECTRL"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKLOG"        , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKIOMAN"      , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKMEMORY"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKVOLUME"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKRUNTIME"    , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKALLOCATOR"  , DBMUtility.OK_OK);

      // off
      oDBM.execCmd("trace_off DEFAULT"         , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off INDEX"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off LOCK"            , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off LONG"            , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off PAGES"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off STANDARD"        , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TABLE"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off OBJECT"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off OBJECTADD"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off OBJECTGET"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off OBJECTALTER"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off OBJECTFREE"      , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off SELECT"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off INSERT"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off UPDATE"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off DELETE"          , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off ORDER"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off OPTIMIZER"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TIME"            , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECK"           , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off COMMANDS"        , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICCONVERTER"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICDATA"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICFRAMECTRL"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICLOG"        , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICIOMAN"      , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICMEMORY"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICVOLUME"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICRUNTIME"    , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off TOPICALLOCATOR"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKCONVERTER"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKDATA"       , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKFRAMECTRL"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKLOG"        , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKIOMAN"      , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKMEMORY"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKVOLUME"     , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKRUNTIME"    , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off CHECKALLOCATOR"  , DBMUtility.OK_OK);

      // all option
      oDBM.execCmd("trace_on  all"    , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off all"    , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on  all 7"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off all"    , DBMUtility.OK_OK);

      // check trace state (all OFF?)
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // find a line with value ON
      if (oAnswer.getField("ON", "state", "state").length() > 0) {
        // error there are rows with "ON" in state
        addMessage("trace_off all", TestProtocol.ERROR , "There are values on: " + oAnswer.getField("ON", "state", "Name"));
        return;
      } // end if

      // *** 3. Check the restart shutdown behaviour ***

      // switch some on
      oDBM.execCmd("trace_on INDEX"             , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on DELETE"            , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on TOPICALLOCATOR 3"  , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on CHECKMEMORY 4"     , DBMUtility.OK_OK);

      // check trace state
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      if (oAnswer.getField("INDEX", "name", "state").compareTo("ON") != 0) {
        addMessage("INDEX", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("LOCK", "name", "state").compareTo("OFF") != 0) {
        addMessage("LOCK", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("DELETE", "name", "state").compareTo("ON") != 0) {
        addMessage("DELETE", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "state").compareTo("ON") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "level").compareTo("3") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "state").compareTo("ON") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "level").compareTo("4") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if

      // state to offline
      oDBM.execCmd("db_offline" , DBMUtility.OK_OK);

      // check trace state
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // "INDEX"
      if (oAnswer.getField("INDEX", "name", "state").compareTo("ON") != 0) {
        addMessage("INDEX", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("LOCK", "name", "state").compareTo("OFF") != 0) {
        addMessage("LOCK", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("DELETE", "name", "state").compareTo("ON") != 0) {
        addMessage("DELETE", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "state").compareTo("ON") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "level").compareTo("3") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "state").compareTo("ON") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "level").compareTo("4") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if

      // negative testing
      oDBM.execCmd("trace_on LOCK" , DBMUtility.ERR_DBNORUN);

      // check trace state
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // "INDEX"
      if (oAnswer.getField("INDEX", "name", "state").compareTo("ON") != 0) {
        addMessage("INDEX", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("LOCK", "name", "state").compareTo("OFF") != 0) {
        addMessage("LOCK", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("DELETE", "name", "state").compareTo("ON") != 0) {
        addMessage("DELETE", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "state").compareTo("ON") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "level").compareTo("3") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "state").compareTo("ON") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "level").compareTo("4") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if

      // state to cold
      oDBM.execCmd("db_cold" , DBMUtility.OK_OK);

      // check trace state
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // "INDEX"
      if (oAnswer.getField("INDEX", "name", "state").compareTo("ON") != 0) {
        addMessage("INDEX", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("LOCK", "name", "state").compareTo("OFF") != 0) {
        addMessage("LOCK", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("DELETE", "name", "state").compareTo("ON") != 0) {
        addMessage("DELETE", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "state").compareTo("ON") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "level").compareTo("3") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "state").compareTo("ON") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "level").compareTo("4") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if

      // change in cold mode
      oDBM.execCmd("trace_on LOCK"   , DBMUtility.OK_OK);
      oDBM.execCmd("trace_off INDEX" , DBMUtility.OK_OK);

      // check trace state
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // "INDEX"
      if (oAnswer.getField("INDEX", "name", "state").compareTo("OFF") != 0) {
        addMessage("INDEX", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("LOCK", "name", "state").compareTo("ON") != 0) {
        addMessage("LOCK", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("DELETE", "name", "state").compareTo("ON") != 0) {
        addMessage("DELETE", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "state").compareTo("ON") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "level").compareTo("3") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "state").compareTo("ON") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "level").compareTo("4") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("LOCK", "name", "state").compareTo("ON") != 0) {
        addMessage("LOCK", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if

      // state to warm
      oDBM.execCmd("db_online" , DBMUtility.OK_OK);

      // check trace state
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // "INDEX"
      if (oAnswer.getField("INDEX", "name", "state").compareTo("OFF") != 0) {
        addMessage("INDEX", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("LOCK", "name", "state").compareTo("ON") != 0) {
        addMessage("LOCK", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("DELETE", "name", "state").compareTo("ON") != 0) {
        addMessage("DELETE", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "state").compareTo("ON") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("TOPICALLOCATOR", "name", "level").compareTo("3") != 0) {
        addMessage("TOPICALLOCATOR", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "state").compareTo("ON") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("CHECKMEMORY", "name", "level").compareTo("4") != 0) {
        addMessage("CHECKMEMORY", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if
      if (oAnswer.getField("LOCK", "name", "state").compareTo("ON") != 0) {
        addMessage("LOCK", TestProtocol.ERROR , "Wrong trace state");
        return;
      } // end if

      // *** 4. switch all to off again ***

      oDBM.execCmd("trace_off all"    , DBMUtility.OK_OK);
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // find a line with value ON
      if (oAnswer.getField("ON", "state", "state").length() > 0) {
        // error there are rows with "ON" in state
        addMessage("trace_off all", TestProtocol.ERROR , "There are values on: " + oAnswer.getField("ON", "state", "Name"));
        return;
      } // end if


      // *** 5. create a trace file

      // empty trace in warm mode
      oDBM.execCmd("trace_clear"             , DBMUtility.OK_OK);
      oDBM.execCmd("trace_flush"             , DBMUtility.OK_OK);
      oDBM.execCmd("trace_prot a"            , DBMUtility.OK_OK);
      oDBM.execCmd("file_getfirst KNLTRCPRT" , DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      if (oAnswer.getRowCount() > 20) {
        // error there are rows with "ON" in state
        addMessage("trace_prot", TestProtocol.ERROR , "Trace not empty");
        return;
      } // end if

      // filled trace in warm mode
      oDBM.execCmd("trace_clear"             , DBMUtility.OK_OK);
      oDBM.execCmd("trace_on DEFAULT"        , DBMUtility.OK_OK);
      oDBM.execCmd("sql_execute select * from users", DBMUtility.OK_OK);
      oDBM.execCmd("trace_flush"             , DBMUtility.OK_OK);
      oDBM.execCmd("trace_prot a"            , DBMUtility.OK_OK);
      oDBM.execCmd("file_getfirst KNLTRCPRT" , DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      if (oAnswer.getRowCount() < 20) {
        // error there are rows with "ON" in state
        addMessage("trace_prot", TestProtocol.ERROR , "Trace is empty");
        return;
      } // end if

      // *** 6. switch all to off again ***

      oDBM.execCmd("trace_off all"    , DBMUtility.OK_OK);
      oDBM.execCmd("trace_show", DBMUtility.OK_OK);
      oAnswer.analyzeFixColsByHeader(oDBM.getAnswer());
      // find a line with value ON
      if (oAnswer.getField("ON", "state", "state").length() > 0) {
        // error there are rows with "ON" in state
        addMessage("trace_off all", TestProtocol.ERROR , "There are values on: " + oAnswer.getField("ON", "state", "Name"));
        return;
      } // end if
      oDBM.execCmd("trace_clear"             , DBMUtility.OK_OK);
      oDBM.execCmd("trace_flush"             , DBMUtility.OK_OK);


    }
    // catch any kind of exception and write it to the protocol
    catch (Exception e) {
      // standard error handler
      this.handleExceptions(e);
    } // end try catch

    // clean up, i.e. close statements and connections
    finally {
      try {
        // print all parameters from the parameter object to the protocol.
        printParametersToProtocol();
      }
      catch (Exception e) {
      } // end try catch
    } // end finally
  } // end run

} // end class DBMTrace
