/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.oltptest.sqlmanager.DatabaseObject;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Pattern;

public class QueryTests {
    private TestCase testcase;
    private long creationTime;
    private int usercount;
    private TestDatabaseSap database;
    private Vector tablelist;
    private Vector FunctionQueryTestPropertyList = new Vector();
    private Vector groupByTestPropertiesList = new Vector();
    private Properties defaultConnectionProperties = new Properties();
    private boolean useviews;
    private String databaseversion;
    private TestLogger[] logList;
    private int[] testnumber;
    private String testcasename;
    private static Random randomValue = new Random();
    private DecimalFormat STEP_FORMAT = new DecimalFormat("00000");
    private SimpleDateFormat TEST_TIME_FORMAT = new SimpleDateFormat("mm:ss.SSS");
    private static String[] JOINTYPELIST = new String[]{"Integer", "Fixed", "Char", "VarChar", "TIMESTAMP", "TIME", "DATE"};
    private Properties warningOnlyList;

    private String getTableDescription(String schemaname, String ownername, String tablename) {
        String columnQuery1 = "select COLUMNNAME,DATATYPE,CODETYPE,LEN,DEC from columns where tablename = ";
        String columnQuery2 = " and owner = ";
        String columnQuery3 = " and schemaname = ";
        String columnQuery4 = " order by POS";
        String tableQuery1 = "select SCHEMANAME, OWNER, TABLENAME,TYPE,TABLETYPE, COMMENT from tables where tablename = ";
        String tableQuery2 = " and owner = ";
        String tableQuery3 = " and schemaname = ";
        String tableDescription = null;
        String tableQuery = String.valueOf(tableQuery1) + "'" + tablename + "'" + tableQuery2 + "'" + ownername + "'" + tableQuery3 + "'" + schemaname + "'";
        String columnQuery = String.valueOf(columnQuery1) + "'" + tablename + "'" + columnQuery2 + "'" + ownername + "'" + columnQuery3 + "'" + schemaname + "'" + columnQuery4;
        ResultSet res1 = null;
        VerificationDataComplete vdc = null;
        Connection DatabaseConnection = null;
        TestStatement runStatement = null;
        tableDescription = "Description of the Table " + tablename + "\n";
        try {
            DatabaseConnection = this.database.connect(this.defaultConnectionProperties);
            runStatement = new TestStatement(null, DatabaseConnection);
            res1 = runStatement.executeQuery(tableQuery);
            vdc = new VerificationDataComplete(res1);
            vdc.setTheCellLengthOfTheResultset(30);
            tableDescription = String.valueOf(tableDescription) + vdc;
            tableDescription = String.valueOf(tableDescription) + "\n";
            tableDescription = String.valueOf(tableDescription) + "Column list: \n";
            res1 = runStatement.executeQuery(columnQuery);
            vdc = new VerificationDataComplete(res1);
            vdc.setTheCellLengthOfTheResultset(30);
            tableDescription = String.valueOf(tableDescription) + vdc;
        }
        catch (Exception e) {
            System.err.println(runStatement.getSqlString());
            e.printStackTrace();
        }
        return tableDescription;
    }

    private static String stringReplace(String inputString, String searchString, String replaceString) {
        int i = inputString.indexOf(searchString);
        while (i > -1) {
            String s1 = inputString.substring(0, i);
            String s2 = inputString.substring(i + searchString.length());
            inputString = String.valueOf(s1) + replaceString + s2;
            i = inputString.indexOf(searchString);
        }
        return inputString;
    }

    public static void fetchAllResults(ResultSet res) throws Exception {
        int columnCount = res.getMetaData().getColumnCount();
        int i = 1;
        while (i <= 100 && res.next()) {
            int k = 1;
            while (k <= columnCount) {
                res.getObject(k);
                ++k;
            }
            ++i;
        }
    }

    private void setParameters() throws Exception {
        this.databaseversion = String.valueOf(this.database.getKernelVersion()) + "." + this.database.getKernelBuild().substring(0, 3);
        Properties queryTestProperties3 = new Properties();
        queryTestProperties3.setProperty("SQLMODE", "INTERNAL");
        queryTestProperties3.setProperty("activated", "yes");
        queryTestProperties3.setProperty("CHAR", "UPPER(#)");
        queryTestProperties3.setProperty("CHAR BYTE", "VALUE(NULL,#)");
        queryTestProperties3.setProperty("VARCHAR", "UPPER(#)");
        queryTestProperties3.setProperty("VARCHAR BYTE", "VALUE(NULL,#)");
        queryTestProperties3.setProperty("FIXED", "ROUND(#,10)");
        queryTestProperties3.setProperty("INTEGER", "ROUND(#,10)");
        queryTestProperties3.setProperty("SMALLINT", "ROUND(#,10)");
        queryTestProperties3.setProperty("FLOAT", "ROUND(#,10)");
        queryTestProperties3.setProperty("DATE", "CHAR(#,ISO)");
        queryTestProperties3.setProperty("TIME", "CHAR(#,ISO)");
        queryTestProperties3.setProperty("TIMESTAMP", "CHAR(#,ISO)");
        queryTestProperties3.setProperty("BOOLEAN", "CHR(#)");
        this.FunctionQueryTestPropertyList.add(queryTestProperties3);
        Properties queryTestProperties4 = new Properties();
        queryTestProperties4.setProperty("SQLMODE", "INTERNAL");
        queryTestProperties4.setProperty("activated", "yes");
        queryTestProperties4.setProperty("CHAR", "LOWER(#)");
        queryTestProperties4.setProperty("CHAR BYTE", "HEX(#)");
        queryTestProperties4.setProperty("VARCHAR", "LOWER(#)");
        queryTestProperties4.setProperty("VARCHAR BYTE", "HEX(#)");
        queryTestProperties4.setProperty("FIXED", "TRUNC(#,5)");
        queryTestProperties4.setProperty("INTEGER", "TRUNC(#,5)");
        queryTestProperties4.setProperty("SMALLINT", "TRUNC(#,5)");
        queryTestProperties4.setProperty("FLOAT", "TRUNC(#,5)");
        queryTestProperties4.setProperty("DATE", "SUBDATE(#,356)");
        queryTestProperties4.setProperty("TIME", "SUBTIME(#,'00:01:00')");
        queryTestProperties4.setProperty("TIMESTAMP", "SUBTIME(#,'00:01:00')");
        queryTestProperties4.setProperty("BOOLEAN", "NUM(#)");
        this.FunctionQueryTestPropertyList.add(queryTestProperties4);
        Properties queryTestProperties5 = new Properties();
        queryTestProperties5.setProperty("SQLMODE", "INTERNAL");
        queryTestProperties5.setProperty("activated", "yes");
        queryTestProperties5.setProperty("CHAR", "SUBSTR(#,1)");
        queryTestProperties5.setProperty("CHAR BYTE", "SUBSTR(#,1)");
        queryTestProperties5.setProperty("VARCHAR", "SUBSTR(#,1)");
        queryTestProperties5.setProperty("VARCHAR BYTE", "SUBSTR(#,1)");
        queryTestProperties5.setProperty("FIXED", "POWER(#,2)");
        queryTestProperties5.setProperty("INTEGER", "POWER(#,2)");
        queryTestProperties5.setProperty("SMALLINT", "POWER(#,2)");
        queryTestProperties5.setProperty("FLOAT", "POWER(#,2)");
        queryTestProperties5.setProperty("DATE", "DATEDIFF(#,'2000-01-01')");
        queryTestProperties5.setProperty("TIME", "TIMEDIFF(#,'12:00:00')");
        queryTestProperties5.setProperty("TIMESTAMP", "TIMEDIFF(#,'1111-11-11 11:11:11')");
        queryTestProperties5.setProperty("BOOLEAN", "LENGTH(NUM(#))");
        this.FunctionQueryTestPropertyList.add(queryTestProperties5);
        Properties queryTestProperties6 = new Properties();
        queryTestProperties6.setProperty("SQLMODE", "ORACLE");
        queryTestProperties6.setProperty("activated", "yes");
        this.FunctionQueryTestPropertyList.add(queryTestProperties6);
        Properties queryTestProperties7 = new Properties();
        queryTestProperties7.setProperty("SQLMODE", "ORACLE");
        queryTestProperties7.setProperty("activated", "yes");
        queryTestProperties7.setProperty("CHAR", "INSTR(#,'a')");
        queryTestProperties7.setProperty("CHAR BYTE", "INSTR(#,X'00')");
        queryTestProperties7.setProperty("VARCHAR", "INSTR(#,'a')");
        queryTestProperties7.setProperty("VARCHAR BYTE", "INSTR(#,X'00')");
        queryTestProperties7.setProperty("FIXED", "TO_CHAR(#)");
        queryTestProperties7.setProperty("INTEGER", "TO_CHAR(#)");
        queryTestProperties7.setProperty("SMALLINT", "TO_CHAR(#)");
        queryTestProperties7.setProperty("FLOAT", "TO_CHAR(#)");
        queryTestProperties7.setProperty("DATE", "MONTHS_BETWEEN(TO_DATE(#,'YYYY-MM-DD'),TO_DATE('2000-01-01','YYYY-MM-DD'))");
        queryTestProperties7.setProperty("TIME", "LAST_DAY(TO_DATE(#,'HH24-MI-SS'))");
        queryTestProperties7.setProperty("TIMESTAMP", "NEXT_DAY(#,1)");
        this.FunctionQueryTestPropertyList.add(queryTestProperties7);
        Properties groupByTestProperties1 = new Properties();
        groupByTestProperties1.setProperty("SQLMODE", "INTERNAL");
        groupByTestProperties1.setProperty("activated", "yes");
        groupByTestProperties1.setProperty("CHAR", "COUNT(#)");
        groupByTestProperties1.setProperty("CHAR BYTE", "MAX(HEX(#))");
        groupByTestProperties1.setProperty("VARCHAR", "COUNT(#)");
        groupByTestProperties1.setProperty("VARCHAR BYTE", "MIN(HEX(#))");
        groupByTestProperties1.setProperty("FIXED", "SUM(#)");
        groupByTestProperties1.setProperty("INTEGER", "SUM(#)");
        groupByTestProperties1.setProperty("SMALLINT", "STDDEV(#)");
        groupByTestProperties1.setProperty("FLOAT", "Variance(#)");
        groupByTestProperties1.setProperty("DATE", "MAX(#)");
        groupByTestProperties1.setProperty("TIME", "MIN(#)");
        groupByTestProperties1.setProperty("TIMESTAMP", "MIN(#)");
        groupByTestProperties1.setProperty("BOOLEAN", "AVG(NUM(#))");
        this.groupByTestPropertiesList.add(groupByTestProperties1);
    }

    public void verifyMetaDataTest(int usernumber, Properties ConProperties) throws Exception {
        long time = System.currentTimeMillis();
        int n = usernumber;
        this.testnumber[n] = this.testnumber[n] + 1;
        String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
        Properties ConnectionProperties = ConProperties;
        if (ConnectionProperties == null) {
            ConnectionProperties = this.defaultConnectionProperties;
        }
        TestLogger logger = this.logList[usernumber];
        logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
        Connection DatabaseConnection = this.database.connect(ConnectionProperties);
        TestStatement runStatement = new TestStatement(null, DatabaseConnection);
        DatabaseObject table = null;
        ResultSet res1 = null;
        Vector<String> columnDataTypeList = null;
        Vector<String> columnNameList = null;
        String metatdatacolumndatatype = "";
        String columnstablecolumndatatype = "";
        String columnstablecolumnname = "";
        String metadatacolumnname = "";
        String testQuery = "";
        String testQuery1 = "select columnname,datatype from columns where tablename = ";
        String testQuery2a = " and owner = ";
        String testQuery2b = " and schemaname = ";
        String testQuery3 = " order by POS";
        Iterator it = this.tablelist.iterator();
        while (it.hasNext()) {
            table = (DatabaseObject)it.next();
            testQuery = TestDriver.compareRelease((String)this.databaseversion, (String)"<=", (String)"7.6.00.00") ? String.valueOf(testQuery1) + table.getObjectName().replace('\"', '\'') + testQuery2a + "'" + table.getObjectOwner() + "'" + testQuery3 : String.valueOf(testQuery1) + table.getObjectName().replace('\"', '\'') + testQuery2b + "'" + table.getObjectOwner() + "'" + testQuery3;
            try {
                logger.add(testQuery);
                res1 = runStatement.executeQuery(testQuery);
                columnDataTypeList = new Vector<String>();
                columnNameList = new Vector<String>();
                boolean rowsFound = false;
                while (res1.next()) {
                    rowsFound = true;
                    columnNameList.add(res1.getString(1));
                    columnDataTypeList.add(res1.getString(2));
                }
                if (!rowsFound) {
                    this.testcase.addMessage(testNumber, 'T', "Informations on the table " + table.getObjectName() + " are not available to the user " + ConnectionProperties.getProperty("user") + "\nPlease add the table to the excluded tables for the SystemTablesMultiUserTest");
                    throw new TestCaseException("The contents of the saved metadata of the databaseobject " + table.getObjectIdentifier() + " could not be validated. For further informations read the infos printed above.");
                }
                boolean columnsEqual = true;
                if (columnDataTypeList.size() == table.getColumnCount()) {
                    int i = 0;
                    while (i < columnDataTypeList.size()) {
                        columnstablecolumndatatype = (String)columnDataTypeList.get(i);
                        metatdatacolumndatatype = table.getColumnTypeWithoutEncoding(i + 1).replaceFirst(" BYTE", "").replaceFirst(" ASCII", "").replaceFirst(" UNICODE", "");
                        metadatacolumnname = table.getColumnName(i + 1).replaceAll("\"", "");
                        columnstablecolumnname = (String)columnNameList.get(i);
                        if (!columnstablecolumndatatype.equalsIgnoreCase(metatdatacolumndatatype) || !columnstablecolumnname.equalsIgnoreCase(metadatacolumnname)) {
                            columnsEqual = false;
                        }
                        ++i;
                    }
                } else {
                    columnsEqual = false;
                }
                if (columnsEqual) continue;
                this.testcase.addMessage(testNumber, 'I', "Contents of the saved Metadata for the table " + table.getObjectName() + ": \n" + table + "\n" + "The Results of tables \"Tables\" and \"Columns\" for the  " + table.getObjectIdentifier() + ": \n" + this.getTableDescription(table.getObjectOwner(), table.getObjectOwner(), table.getObjectName().replaceAll("\"", "")));
                throw new TestCaseException("The contents of the saved metadata for the databaseobject " + table.getObjectIdentifier() + " is incorrect. For further informations read the infos printed above.");
            }
            catch (SQLException e) {
                logger.addError(e.toString());
                System.out.println(e.toString());
                this.testcase.addMessage(testNumber, 'E', e.toString());
                if (e.toString().indexOf("The number ") < 0) continue;
                this.testcase.addMessage("Additional Info", 'W', "The used statment is:" + testQuery);
            }
        }
        logger.flush();
        runStatement.close();
        DatabaseConnection.close();
        System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ") verifyMetaDataTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
    }

    public void createViews(int usernumber, Properties ConProperties) throws Exception {
        int n = usernumber;
        this.testnumber[n] = this.testnumber[n] + 1;
        String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
        long time = System.currentTimeMillis();
        Properties ConnectionProperties = ConProperties;
        if (ConnectionProperties == null) {
            ConnectionProperties = this.defaultConnectionProperties;
        }
        TestLogger logger = this.logList[usernumber];
        logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
        Connection DatabaseConnection = this.database.connect(ConnectionProperties);
        TestStatement runStatement = new TestStatement(null, DatabaseConnection);
        DatabaseObject table = null;
        ResultSet res1 = null;
        ResultSet res2 = null;
        String createView = "";
        String queryView = "";
        String queryTable = "";
        String dropView = "";
        String dropView1 = "drop view ";
        String createView1 = "create view ";
        String createView2 = " as select * from ";
        String queryView1 = "select * from ";
        String queryTable1 = "select * from ";
        String grantView1 = "grant all on ";
        String grantView2 = " to public";
        Iterator it2 = this.tablelist.iterator();
        int cV = 0;
        while (it2.hasNext()) {
            table = (DatabaseObject)it2.next();
            dropView = String.valueOf(dropView1) + table.getObjectViewName();
            createView = String.valueOf(createView1) + table.getObjectViewName() + createView2 + table.getObjectIdentifier();
            String grantView = String.valueOf(grantView1) + table.getObjectViewName() + grantView2;
            queryView = String.valueOf(queryView1) + table.getObjectViewName();
            queryTable = String.valueOf(queryTable1) + table.getObjectIdentifier();
            try {
                logger.add(dropView);
                runStatement.enableExceptions(false);
                runStatement.execute(dropView);
                runStatement.enableExceptions(true);
                logger.add(createView);
                runStatement.execute(createView);
                runStatement.executeUpdateIgnoreErrors(grantView);
                ++cV;
                res2 = runStatement.executeQuery(queryTable);
                QueryTests.fetchAllResults(res2);
                res1 = runStatement.executeQuery(queryView);
                QueryTests.fetchAllResults(res1);
            }
            catch (SQLException e) {
                if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                    this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                    continue;
                }
                logger.addError(e.toString());
                this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
            }
        }
        res1 = runStatement.executeQuery("select count (*) from views  where  viewname like 'V:_%' escape ':'");
        res1.next();
        logger.flush();
        int viewCount = res1.getInt(1);
        if (this.tablelist.size() != viewCount) {
            System.out.println(String.valueOf(this.tablelist.size()) + " views should be created");
            System.out.println(String.valueOf(viewCount) + " views are listed in the \"Views\"-Table");
            this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + "createView Incorrect number of Views found", 'W', "Expected: " + this.tablelist.size() + " Found: " + viewCount);
        } else {
            System.out.println(String.valueOf(this.tablelist.size()) + " views successfully created");
        }
        runStatement.close();
        DatabaseConnection.close();
        System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ") createViews" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
    }

    public void countResultsetsTest(int usernumber, Properties ConProperties) throws Exception {
        int n = usernumber;
        this.testnumber[n] = this.testnumber[n] + 1;
        String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
        long time = System.currentTimeMillis();
        Properties ConnectionProperties = ConProperties;
        if (ConnectionProperties == null) {
            ConnectionProperties = this.defaultConnectionProperties;
        }
        TestLogger logger = this.logList[usernumber];
        logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
        Connection DatabaseConnection = this.database.connect(ConnectionProperties);
        TestStatement runStatement = new TestStatement(null, DatabaseConnection);
        DatabaseObject table = null;
        ResultSet res1 = null;
        ResultSet res2 = null;
        String testQueryView = "";
        String testQueryTable = "";
        String testQuery = "";
        Iterator it = this.tablelist.iterator();
        while (it.hasNext()) {
            table = (DatabaseObject)it.next();
            testQuery = "select count(*) from ";
            testQueryView = String.valueOf(testQuery) + table.getObjectViewName();
            testQueryTable = String.valueOf(testQuery) + table.getObjectIdentifier();
            try {
                logger.add(testQueryTable);
                res1 = runStatement.executeQuery(testQueryTable);
                res1.next();
                int res1count = res1.getInt(1);
                if (!this.useviews) continue;
                logger.add(testQueryView);
                res2 = runStatement.executeQuery(testQueryView);
                res2.next();
                int res2count = res2.getInt(1);
                if (res1count == res2count) continue;
                this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " countResultsetsTest", 'I', "The result of " + testQueryTable + " differs from the result of " + testQueryView);
            }
            catch (SQLException e) {
                if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                    this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                    continue;
                }
                logger.addError(e.toString());
                this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " countResultsetsTest\n" + " The SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
            }
        }
        runStatement.close();
        DatabaseConnection.close();
        logger.flush();
        System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ")" + " countResultsetsTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
    }

    public void orderByTest(int usernumber, Properties ConProperties) throws Exception {
        int n = usernumber;
        this.testnumber[n] = this.testnumber[n] + 1;
        String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
        long time = System.currentTimeMillis();
        Properties ConnectionProperties = ConProperties;
        if (ConnectionProperties == null) {
            ConnectionProperties = this.defaultConnectionProperties;
        }
        TestLogger logger = this.logList[usernumber];
        logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
        Connection DatabaseConnection = this.database.connect(ConnectionProperties);
        TestStatement runStatement = new TestStatement(null, DatabaseConnection);
        DatabaseObject table = null;
        String testQueryTable = "";
        String testQuery1 = "";
        String testQuery2 = "";
        String testQuery3 = "";
        Iterator it = this.tablelist.iterator();
        while (it.hasNext()) {
            table = (DatabaseObject)it.next();
            testQuery1 = "select * from ";
            testQuery2 = " order by ";
            testQuery3 = randomValue.nextBoolean() ? " ASC" : " DESC";
            if (!table.hasUsableColumn()) continue;
            int orderColumn = table.getRandomColumn();
            if (table.getTableLength() + (long)table.getColumnLength(orderColumn) >= 4048L) continue;
            testQueryTable = String.valueOf(testQuery1) + table.getObjectIdentifier() + testQuery2 + table.getColumnName(orderColumn) + testQuery3;
            try {
                logger.add(testQueryTable);
                ResultSet res2 = runStatement.executeQuery(testQueryTable);
                QueryTests.fetchAllResults(res2);
            }
            catch (SQLException e) {
                if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                    this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                    continue;
                }
                logger.addError(e.toString());
                this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " orderByTest\n" + " The SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
            }
        }
        runStatement.close();
        DatabaseConnection.close();
        logger.flush();
        System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ")" + " orderByTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
    }

    public void functionQueryTest(int usernumber, Properties ConProperties) throws Exception {
        Iterator testIterator = this.FunctionQueryTestPropertyList.iterator();
        while (testIterator.hasNext()) {
            int n = usernumber;
            this.testnumber[n] = this.testnumber[n] + 1;
            String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
            Properties testProperties = (Properties)testIterator.next();
            long time = System.currentTimeMillis();
            Properties ConnectionProperties = ConProperties != null ? new Properties(ConProperties) : new Properties(this.defaultConnectionProperties);
            TestLogger logger = this.logList[usernumber];
            logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
            Connection DatabaseConnection = null;
            TestStatement runStatement = null;
            DatabaseObject table = null;
            ResultSet res1 = null;
            ResultSet res2 = null;
            if (testProperties.getProperty("activated", "yes").equalsIgnoreCase("yes")) {
                if (testProperties.getProperty("SQLMODE", "INTERNAL").equalsIgnoreCase("Oracle")) {
                    ConnectionProperties.setProperty("sqlmode", "ORACLE");
                }
                DatabaseConnection = this.database.connect(ConnectionProperties);
                runStatement = new TestStatement(null, DatabaseConnection);
                String testQueryView1 = "";
                String testQueryTable1 = "";
                String testQuery1 = "";
                Iterator it = this.tablelist.iterator();
                while (it.hasNext()) {
                    table = (DatabaseObject)it.next();
                    if (!table.hasOnlyUsableColumns()) continue;
                    testQuery1 = "select ";
                    int t = 1;
                    while (t <= table.getColumnCount()) {
                        if (testProperties.containsKey(table.getColumnType(t)) && table.isUsableColumn(t)) {
                            testQuery1 = String.valueOf(testQuery1) + QueryTests.stringReplace(testProperties.getProperty(table.getColumnType(t)), "#", table.getColumnName(t));
                            if (t < table.getColumnCount()) {
                                testQuery1 = String.valueOf(testQuery1) + ",";
                            }
                        } else if (table.isUsableColumn(t)) {
                            testQuery1 = String.valueOf(testQuery1) + table.getColumnName(t);
                            if (t < table.getColumnCount()) {
                                testQuery1 = String.valueOf(testQuery1) + ",";
                            }
                        }
                        ++t;
                    }
                    if (testQuery1.endsWith(",") && testQuery1.length() > 1) {
                        testQuery1 = testQuery1.substring(0, testQuery1.length() - 1);
                    }
                    testQueryView1 = String.valueOf(testQuery1) + " from " + table.getObjectViewName();
                    testQueryTable1 = String.valueOf(testQuery1) + " from " + table.getObjectIdentifier();
                    try {
                        logger.add(testQueryTable1);
                        res2 = runStatement.executeQuery(testQueryTable1);
                        QueryTests.fetchAllResults(res2);
                        if (!this.useviews) continue;
                        logger.add(testQueryView1);
                        res1 = runStatement.executeQuery(testQueryView1);
                        QueryTests.fetchAllResults(res1);
                    }
                    catch (SQLException e) {
                        if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                            this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                            continue;
                        }
                        logger.addError(e.toString());
                        this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " functionQueryTest\n" + " The SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
                    }
                }
                runStatement.close();
                DatabaseConnection.close();
                logger.flush();
                System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ")" + " functionQueryTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
                continue;
            }
            System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ")" + " functionQueryTest" + " is disabled");
        }
    }

    public void groupByQueryTest(int usernumber, Properties ConProperties) throws Exception {
        Iterator groupByIterator = this.groupByTestPropertiesList.iterator();
        while (groupByIterator.hasNext()) {
            int n = usernumber;
            this.testnumber[n] = this.testnumber[n] + 1;
            String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
            long time = System.currentTimeMillis();
            Properties ConnectionProperties = ConProperties != null ? new Properties(ConProperties) : new Properties(this.defaultConnectionProperties);
            TestLogger logger = this.logList[usernumber];
            logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
            Connection DatabaseConnection = null;
            TestStatement runStatement = null;
            DatabaseObject table = null;
            Properties testProperties = (Properties)groupByIterator.next();
            ResultSet res1 = null;
            ResultSet res2 = null;
            if (testProperties.getProperty("activated", "yes").equalsIgnoreCase("yes")) {
                if (testProperties.getProperty("SQLMODE", "INTERNAL").equalsIgnoreCase("Oracle")) {
                    ConnectionProperties.setProperty("sqlmode", "ORACLE");
                }
                DatabaseConnection = this.database.connect(ConnectionProperties);
                runStatement = new TestStatement(null, DatabaseConnection);
                String testQueryView1 = "";
                String testQueryTable1 = "";
                String testQuery1 = "";
                String groupby = null;
                Iterator it = this.tablelist.iterator();
                while (it.hasNext()) {
                    table = (DatabaseObject)it.next();
                    testQuery1 = "select ";
                    if (!table.hasUsableColumn()) continue;
                    int t = 1;
                    while (t <= table.getColumnCount()) {
                        if (testProperties.containsKey(table.getColumnType(t)) && table.isUsableColumn(t)) {
                            testQuery1 = String.valueOf(testQuery1) + QueryTests.stringReplace(testProperties.getProperty(table.getColumnType(t)), "#", table.getColumnName(t)) + ",";
                        } else if (!table.getColumnType(t).startsWith("LONG")) {
                            testQuery1 = String.valueOf(testQuery1) + "count(" + table.getColumnName(t) + ")" + ",";
                        }
                        ++t;
                    }
                    groupby = " group by " + table.getColumnName(table.getRandomColumn());
                    if (testQuery1.endsWith(",")) {
                        testQuery1 = testQuery1.substring(0, testQuery1.length() - 1);
                    }
                    testQueryView1 = String.valueOf(testQuery1) + " from " + table.getObjectViewName() + groupby;
                    testQueryTable1 = String.valueOf(testQuery1) + " from " + table.getObjectIdentifier() + groupby;
                    try {
                        logger.add(testQueryTable1);
                        res2 = runStatement.executeQuery(testQueryTable1);
                        QueryTests.fetchAllResults(res2);
                        if (!this.useviews) continue;
                        logger.add(testQueryView1);
                        res1 = runStatement.executeQuery(testQueryView1);
                        QueryTests.fetchAllResults(res1);
                    }
                    catch (SQLException e) {
                        if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                            this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                            continue;
                        }
                        logger.addError(e.toString());
                        this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " groupByQueryTest\n" + " The SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
                    }
                }
                logger.flush();
                runStatement.close();
                DatabaseConnection.close();
                System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ")" + " groupByQueryTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
                continue;
            }
            System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ")" + " groupByQueryTest" + " is disabled");
        }
    }

    public void unionQueryTest(int usernumber, Properties ConProperties) throws Exception {
        int n = usernumber;
        this.testnumber[n] = this.testnumber[n] + 1;
        String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
        long time = System.currentTimeMillis();
        Properties ConnectionProperties = ConProperties != null ? new Properties(ConProperties) : new Properties(this.defaultConnectionProperties);
        TestLogger logger = this.logList[usernumber];
        logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
        Connection DatabaseConnection = this.database.connect(ConnectionProperties);
        TestStatement runStatement = new TestStatement(null, DatabaseConnection);
        DatabaseObject table = null;
        ResultSet res1 = null;
        String testQueryUnion = "";
        String testQuery1 = "";
        String testQuery2 = "";
        Iterator it = this.tablelist.iterator();
        while (it.hasNext()) {
            table = (DatabaseObject)it.next();
            if (!table.hasOnlyUsableColumns()) continue;
            testQuery1 = "select * from ";
            testQuery2 = " union select * from ";
            testQueryUnion = this.useviews ? String.valueOf(testQuery1) + table.getObjectIdentifier() + testQuery2 + table.getObjectViewName() : String.valueOf(testQuery1) + table.getObjectIdentifier() + testQuery2 + table.getObjectIdentifier();
            try {
                logger.add(testQueryUnion);
                res1 = runStatement.executeQuery(testQueryUnion);
                QueryTests.fetchAllResults(res1);
            }
            catch (SQLException e) {
                if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                    this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                    continue;
                }
                logger.addError(e.toString());
                this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ") unionQueryTest\n The SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
            }
        }
        logger.flush();
        runStatement.close();
        DatabaseConnection.close();
        System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ") unionQueryTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
    }

    public void subselectViewQueryTest(int usernumber, Properties ConProperties) throws Exception {
        int n = usernumber;
        this.testnumber[n] = this.testnumber[n] + 1;
        String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
        long time = System.currentTimeMillis();
        Properties ConnectionProperties = ConProperties != null ? new Properties(ConProperties) : new Properties(this.defaultConnectionProperties);
        TestLogger logger = this.logList[usernumber];
        logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
        Connection DatabaseConnection = this.database.connect(ConnectionProperties);
        TestStatement runStatement = new TestStatement(null, DatabaseConnection);
        DatabaseObject table = null;
        ResultSet res1 = null;
        String testQuerySubSelectView = "";
        String testQuery1 = "";
        String testQuery2 = "";
        String testQuery3 = "";
        String testQuery4 = "";
        String testQuery5 = "";
        String whereColumn1 = "";
        Iterator it = this.tablelist.iterator();
        while (it.hasNext()) {
            table = (DatabaseObject)it.next();
            if (!table.hasUsableColumn()) continue;
            testQuery1 = "select * from ";
            testQuery2 = " where ";
            testQuery3 = " in(select ";
            testQuery4 = " from ";
            testQuery5 = ")";
            whereColumn1 = table.getColumnName(table.getRandomColumn());
            testQuerySubSelectView = String.valueOf(testQuery1) + table.getObjectIdentifier() + testQuery2 + whereColumn1 + testQuery3 + whereColumn1 + testQuery4 + table.getObjectViewName() + testQuery5;
            try {
                logger.add(testQuerySubSelectView);
                res1 = runStatement.executeQuery(testQuerySubSelectView);
                QueryTests.fetchAllResults(res1);
            }
            catch (SQLException e) {
                if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                    this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                    continue;
                }
                logger.addError(e.toString());
                this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ") subselectViewQueryTest \nThe SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
            }
        }
        logger.flush();
        runStatement.close();
        DatabaseConnection.close();
        System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ") subselectViewQueryTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
    }

    public void subselectQueryTest(int usernumber, Properties ConProperties) throws Exception {
        String testQuerySubSelect = "";
        String testQuery1 = "select * from ";
        String testQuery2 = " where ";
        String testQuery3 = " in(select ";
        String testQuery4 = " from ";
        String testQuery5 = ")";
        String testQuery9 = "";
        String whereColumn1 = "";
        String whereColumn2 = "";
        String columnType = "";
        int i = 0;
        while (i < JOINTYPELIST.length) {
            int n = usernumber;
            this.testnumber[n] = this.testnumber[n] + 1;
            String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
            long time = System.currentTimeMillis();
            columnType = JOINTYPELIST[i];
            Properties ConnectionProperties = ConProperties != null ? new Properties(ConProperties) : new Properties(this.defaultConnectionProperties);
            TestLogger logger = this.logList[usernumber];
            logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
            Connection DatabaseConnection = this.database.connect(ConnectionProperties);
            TestStatement runStatement = new TestStatement(null, DatabaseConnection);
            DatabaseObject table = null;
            runStatement.setQueryTimeout(120);
            Vector tableColumTypeList = new Vector();
            ResultSet res1 = null;
            DatabaseObject subSelectTable = null;
            int columnTypeObjectCount = 0;
            int executedQuerys = 0;
            Iterator it1 = this.tablelist.iterator();
            while (it1.hasNext()) {
                Object obj = it1.next();
                if (!((DatabaseObject)obj).hasColumnType(columnType)) continue;
                tableColumTypeList.add(obj);
            }
            Iterator it = tableColumTypeList.iterator();
            columnTypeObjectCount = tableColumTypeList.size();
            while (it.hasNext() && columnTypeObjectCount > 1) {
                table = (DatabaseObject)it.next();
                testQuery9 = randomValue.nextBoolean() ? " order by 1 ASC" : " order by 1 DESC";
                while ((subSelectTable = (DatabaseObject)tableColumTypeList.get(randomValue.nextInt(columnTypeObjectCount))) == table) {
                }
                whereColumn1 = table.getColumnName(table.getRandomColumn(columnType));
                whereColumn2 = subSelectTable.getColumnName(subSelectTable.getRandomColumn(columnType));
                testQuerySubSelect = String.valueOf(testQuery1) + table.getObjectIdentifier() + testQuery2 + whereColumn1 + testQuery3 + whereColumn2 + testQuery4 + subSelectTable.getObjectIdentifier() + testQuery5 + testQuery9;
                try {
                    logger.add(testQuerySubSelect);
                    res1 = runStatement.executeQuery(testQuerySubSelect);
                    QueryTests.fetchAllResults(res1);
                    ++executedQuerys;
                }
                catch (SQLException e) {
                    if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                        this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                        continue;
                    }
                    logger.addError(e.toString());
                    this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ") subselectQueryTest(" + columnType + ")\nThe SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
                }
            }
            logger.flush();
            runStatement.close();
            DatabaseConnection.close();
            System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ") subselectQueryTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)) + "\t" + executedQuerys + " Sub-Querys on " + columnType + " executed");
            ++i;
        }
    }

    public void joinQueryTest(int usernumber, Properties ConProperties) throws Exception {
        String testQueryJoin = "";
        String testQuery1 = "select ";
        String testQuery6 = " from ";
        String testQuery2 = " where ";
        String testQuery3 = " = ";
        String testQuery4 = ",";
        String testQuery5 = ".";
        String testQuery7 = " order by ";
        String testQuery8 = "";
        String testQuery9 = "";
        String joinColumn1 = "";
        String joinColumn2 = "";
        String columnType = "";
        int i = 0;
        while (i < JOINTYPELIST.length) {
            int n = usernumber;
            this.testnumber[n] = this.testnumber[n] + 1;
            String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
            long time = System.currentTimeMillis();
            columnType = JOINTYPELIST[i];
            Properties ConnectionProperties = ConProperties != null ? new Properties(ConProperties) : new Properties(this.defaultConnectionProperties);
            TestLogger logger = this.logList[usernumber];
            logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
            Connection DatabaseConnection = this.database.connect(ConnectionProperties);
            TestStatement runStatement = new TestStatement(null, DatabaseConnection);
            DatabaseObject table = null;
            runStatement.setQueryTimeout(60);
            Vector<DatabaseObject> tableColumTypeList = new Vector<DatabaseObject>();
            DatabaseObject joinTable = null;
            ResultSet res1 = null;
            DatabaseObject dbobj = null;
            int executedQuerys = 0;
            Iterator it1 = this.tablelist.iterator();
            while (it1.hasNext()) {
                dbobj = (DatabaseObject)it1.next();
                if (!dbobj.hasColumnType(columnType)) continue;
                tableColumTypeList.add(dbobj);
            }
            Iterator it = tableColumTypeList.iterator();
            int columnTypeObjectCount = tableColumTypeList.size();
            if (columnTypeObjectCount > 1) {
                while (it.hasNext()) {
                    table = (DatabaseObject)it.next();
                    testQuery8 = randomValue.nextBoolean() ? "1" : "2";
                    testQuery9 = randomValue.nextBoolean() ? " ASC" : " DESC";
                    while ((joinTable = (DatabaseObject)tableColumTypeList.get(randomValue.nextInt(columnTypeObjectCount))) == table) {
                    }
                    joinColumn1 = table.getColumnName(table.getRandomColumn(columnType));
                    joinColumn2 = joinTable.getColumnName(joinTable.getRandomColumn(columnType));
                    testQueryJoin = String.valueOf(testQuery1) + "\"" + table.getObjectOwner() + "\"" + testQuery5 + table.getObjectName() + testQuery5 + joinColumn1 + ", " + "\"" + joinTable.getObjectOwner() + "\"" + testQuery5 + joinTable.getObjectName() + testQuery5 + joinColumn2 + testQuery6 + table.getObjectIdentifier() + testQuery4 + joinTable.getObjectIdentifier() + testQuery2 + table.getObjectOwner() + "." + table.getObjectName() + testQuery5 + joinColumn1 + testQuery3 + joinTable.getObjectOwner() + "." + joinTable.getObjectName() + testQuery5 + joinColumn2 + testQuery7 + testQuery8 + testQuery9;
                    try {
                        logger.add(testQueryJoin);
                        res1 = runStatement.executeQuery(testQueryJoin);
                        QueryTests.fetchAllResults(res1);
                        ++executedQuerys;
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == -904) {
                            String sqlstring = runStatement.getSqlString();
                            this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " The SQL-statement " + sqlstring + " failed", 'W', e.toString());
                            runStatement.executeQuery("Explain " + sqlstring);
                            VerificationDataComplete vdata = new VerificationDataComplete(runStatement.getResultSet());
                            this.testcase.addMessage("Additional Info", 'I', vdata.toString());
                            continue;
                        }
                        if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                            this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                            continue;
                        }
                        if (e.getErrorCode() == -2009) {
                            this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement.getSqlString() + " failed. No error. It's an unsolveable problem of the Testcase", 'I', e.toString());
                            continue;
                        }
                        logger.addError(e.toString());
                        this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ") joinQueryTest(" + columnType + ")\nThe SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
                    }
                }
            }
            logger.flush();
            runStatement.close();
            DatabaseConnection.close();
            System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ") joinQueryTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)) + "\t        " + executedQuerys + " joined Querys on " + columnType + " executed");
            ++i;
        }
    }

    public void hintQueryTest(int usernumber, Properties ConProperties, Vector SQLStatementList, Vector HintList, boolean checkDataIntegrety, int precision, int queriesPerStatement) throws Exception {
        int n = usernumber;
        this.testnumber[n] = this.testnumber[n] + 1;
        String testNumber = this.STEP_FORMAT.format(this.testnumber[usernumber]);
        long testCaseRuntime = System.currentTimeMillis();
        Properties ConnectionProperties = ConProperties;
        if (ConnectionProperties == null) {
            ConnectionProperties = this.defaultConnectionProperties;
        }
        TestLogger logger = this.logList[usernumber];
        logger.addComment(String.valueOf(this.testcasename) + " " + ConnectionProperties.getProperty("user") + " " + testNumber + " ");
        Connection DatabaseConnection = this.database.connect(ConnectionProperties);
        TestStatement runStatement1 = new TestStatement(null, DatabaseConnection);
        TestStatement runStatement2 = new TestStatement(null, DatabaseConnection);
        runStatement1.enableExplain(true);
        runStatement2.enableExplain(true);
        int comparedQueries = 0;
        int executedQueries = 0;
        runStatement1.execute("set current_schema = " + ((DatabaseObject)this.tablelist.get(0)).getObjectOwner());
        runStatement2.execute("set current_schema = " + ((DatabaseObject)this.tablelist.get(0)).getObjectOwner());
        String hint = null;
        VerificationDataComplete ver1 = null;
        ResultSet res1 = null;
        ResultSet res2 = null;
        Iterator statementListIterator = SQLStatementList.iterator();
        while (statementListIterator.hasNext()) {
            String sqlstatement = (String)statementListIterator.next();
            sqlstatement = Pattern.compile("select", 2).matcher(sqlstatement).replaceFirst("SELECT");
            try {
                logger.add(sqlstatement);
                long predictedQueryCost = this.getRuncost(DatabaseConnection, sqlstatement);
                long queryRuntime = 0L;
                long queryRuntimeTemp = 0L;
                int i = 0;
                while (i < precision) {
                    queryRuntimeTemp = System.currentTimeMillis();
                    res1 = runStatement1.executeQuery(sqlstatement);
                    ++executedQueries;
                    queryRuntimeTemp = System.currentTimeMillis() - queryRuntimeTemp;
                    queryRuntime += queryRuntimeTemp;
                    ++i;
                }
                queryRuntime /= (long)precision;
                if (checkDataIntegrety) {
                    ver1 = new VerificationDataComplete(res1);
                }
                i = 0;
                while (i < queriesPerStatement) {
                    hint = "";
                    int hintCount = randomValue.nextInt(4) + 1;
                    int j = 1;
                    while (j <= hintCount) {
                        hint = String.valueOf(hint) + "," + (String)HintList.get(randomValue.nextInt(HintList.size()));
                        ++j;
                    }
                    hint = hint.replaceFirst(",", "");
                    String sqlstatementhint = sqlstatement.replaceFirst("SELECT", "SELECT /*+" + hint + "*/");
                    try {
                        logger.add(sqlstatementhint);
                        long predictedQueryCostWithHint = this.getRuncost(DatabaseConnection, sqlstatementhint);
                        long queryRuntimeWithHintTemp = 0L;
                        long queryRuntimeWithHint = 0L;
                        int j2 = 0;
                        while (j2 < precision) {
                            queryRuntimeWithHintTemp = System.currentTimeMillis();
                            res2 = runStatement2.executeQuery(sqlstatementhint);
                            ++executedQueries;
                            queryRuntimeWithHintTemp = System.currentTimeMillis() - queryRuntimeWithHintTemp;
                            queryRuntimeWithHint += queryRuntimeWithHintTemp;
                            ++j2;
                        }
                        queryRuntimeWithHint /= (long)precision;
                        if (checkDataIntegrety) {
                            boolean correct = ver1.equals(res2);
                            ++comparedQueries;
                            if (!correct) {
                                this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " hintQueryTest\n" + " Result Comparison failed", 'E', "The Results of the Queries \n" + sqlstatement + "\n and \n" + sqlstatementhint + "\n are different.");
                            }
                        }
                        if (queryRuntime == 0L && queryRuntimeWithHint != 0L) {
                            queryRuntime = queryRuntimeWithHint;
                        }
                        if (queryRuntimeWithHint == 0L && queryRuntime != 0L) {
                            queryRuntimeWithHint = queryRuntime;
                        }
                        if ((predictedQueryCost > predictedQueryCostWithHint && queryRuntime < queryRuntimeWithHint || predictedQueryCost < predictedQueryCostWithHint && queryRuntime > queryRuntimeWithHint) && predictedQueryCost != 0L && predictedQueryCostWithHint != 0L) {
                            System.out.println("Query Number " + sqlstatementhint);
                            System.out.println("Info: runcost " + predictedQueryCost + " runcosthint " + predictedQueryCostWithHint + " runtime " + queryRuntime + " runtimehint " + queryRuntimeWithHint);
                        }
                        if (queryRuntimeWithHint != 0L && queryRuntime != 0L && queryRuntime / queryRuntimeWithHint > 2L) {
                            System.out.println("The Runtime of \n" + sqlstatement + "(" + queryRuntime + ")" + "\nis more then twice as long as \n" + sqlstatementhint + "(" + queryRuntimeWithHint + ")");
                        }
                    }
                    catch (SQLException e) {
                        logger.addError(e.toString());
                        if (this.warningOnlyList.containsKey(String.valueOf(e.getErrorCode()))) {
                            this.testcase.addMessage(String.valueOf(testNumber) + " The SQL-statement " + runStatement1.getSqlString() + " failed. This database error has been classified as a warning with the test parameter WARNINGONLY.", 'W', e.toString());
                        }
                        this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " hintQueryTest\n" + sqlstatement + "\n" + sqlstatementhint, 'E', e.toString());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.addError(e.toString());
                e.printStackTrace();
                System.out.println(res1.getObject("PAGECOUNT"));
                this.testcase.addMessage(String.valueOf(testNumber) + " (" + ConnectionProperties.getProperty("user") + ")" + " hintQueryTest\n" + sqlstatement + " failed", 'E', e.toString());
            }
        }
        System.out.println(String.valueOf(SQLStatementList.size()) + " Querystatements");
        System.out.println(String.valueOf(HintList.size()) + " Hints");
        System.out.println(String.valueOf(executedQueries) + " Statements executed");
        System.out.println(String.valueOf(comparedQueries) + " Results compared");
        runStatement1.close();
        runStatement2.close();
        DatabaseConnection.close();
        logger.flush();
        System.out.println("Test " + testNumber + " (" + ConnectionProperties.getProperty("user") + ")" + " hintQueryTest" + " finished in " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - testCaseRuntime)) + "  Overall runtime: " + this.TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - this.creationTime)));
    }

    public String getLogFile() {
        boolean logadded = false;
        File theZipFile = new File(String.valueOf(this.testcase.getDataOutputPath()) + System.getProperty("file.separator") + this.testcasename + ".zip");
        if (theZipFile.exists()) {
            theZipFile.delete();
        }
        Zipper myZipper = new Zipper(theZipFile);
        int i = 0;
        while (i < this.usercount) {
            StringBuffer log = this.logList[i].getLog();
            if (log != null) {
                logadded = true;
                try {
                    File logfile = new File(String.valueOf(this.testcase.getDataOutputPath()) + System.getProperty("file.separator") + this.testcasename + "_" + i + ".txt");
                    if (logfile.exists()) {
                        logfile.delete();
                    }
                    FileWriter fwriter = new FileWriter(logfile);
                    fwriter.write(log.toString());
                    fwriter.close();
                    myZipper.addFile(logfile);
                }
                catch (IOException ioe) {
                    this.testcase.addMessage(this.testcasename, 'W', "Can not write the Log File. Reason:\n" + ioe.getLocalizedMessage());
                }
            }
            ++i;
        }
        if (logadded) {
            try {
                myZipper.zip();
            }
            catch (IOException e) {
                this.testcase.addMessage(this.testcasename, 'W', "Failed to create a zipfile with the protocol files\n" + e.getLocalizedMessage());
                return null;
            }
            return theZipFile.getAbsolutePath();
        }
        return null;
    }

    public QueryTests(TestCase test, String TestCaseName, TestDatabaseSap database, Vector tableList, Properties connectionProperties, int usercount, boolean useViews, Properties warningOnlyList) throws Exception {
        this.usercount = usercount;
        if (this.usercount <= 0) {
            throw new Exception("At least one user is requiered");
        }
        this.creationTime = System.currentTimeMillis();
        this.testcase = test;
        this.tablelist = tableList;
        this.database = database;
        this.useviews = useViews;
        this.warningOnlyList = warningOnlyList;
        this.testcasename = TestCaseName;
        this.testnumber = new int[usercount];
        this.logList = new TestLogger[usercount];
        int i = 0;
        while (i < this.usercount) {
            this.logList[i] = new TestLogger(TestCaseName);
            ++i;
        }
        this.defaultConnectionProperties = connectionProperties;
        this.setParameters();
    }

    private long getRuncost(Connection dbcon, String statement) throws SQLException {
        TestStatement stmt = new TestStatement(null, dbcon);
        ResultSet res1 = stmt.executeQuery("explain " + statement);
        while (!res1.isLast()) {
            res1.next();
        }
        String runcostbuffer = res1.getString("PAGECOUNT").trim();
        if (runcostbuffer.equals("")) {
            return 0L;
        }
        if (runcostbuffer.indexOf(69) > -1) {
            return 20000000001L;
        }
        return Long.parseLong(runcostbuffer);
    }

    public class TestLogger {
        private StringBuffer log = new StringBuffer();
        private StringBuffer logBuffer = new StringBuffer();
        private boolean TestCaseError = false;
        private boolean TestError = false;

        public TestLogger(String testCaseName) {
            this.log.append("// " + testCaseName + " //\n//");
        }

        public void add(String sqlString) {
            this.logBuffer.append("\n" + sqlString + "\n//");
        }

        public void addComment(String sqlString) {
            this.logBuffer.append("\n//" + sqlString + "//\n//");
        }

        public void addError(String errorString) {
            this.logBuffer.append(String.valueOf(errorString) + " //\n//");
            this.TestCaseError = true;
            this.TestError = true;
        }

        public void flush() {
            if (this.TestError) {
                this.log.append(this.logBuffer);
                this.log.append("//\n//\n//\n");
            }
            this.TestError = false;
            this.logBuffer = new StringBuffer();
        }

        public StringBuffer getLog() {
            this.flush();
            if (this.TestCaseError) {
                return this.log;
            }
            return null;
        }
    }
}

