/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.oltptest.simple.SQLMaster;
import com.sap.sapdb.oltptest.simple.StressTestActor;
import com.sap.sapdb.oltptest.simple.TestActor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.RandomGenerator;
import java.sql.SQLException;
import java.util.Date;

public class StressTest
extends SQLMaster {
    private static int mNumberOfTasks;
    private static int mMaximumRuntime;
    private static final String sVersion = "5.0";

    private Date attemptActorsStop(TestActor[] Actors) {
        int i = 0;
        while (i < Actors.length) {
            Actors[i].shouldStop();
            ++i;
        }
        return new Date();
    }

    TestActor[] createActors() throws Exception {
        int j = 0;
        TestActor[] Actors = new TestActor[mNumberOfTasks];
        int i = 0;
        while (i < mNumberOfTasks) {
            Actors[j] = new StressTestActor();
            Actors[j].setMaster(this);
            Actors[j].setTitle("StressTester" + i);
            ++i;
        }
        i = 0;
        while (i < Actors.length) {
            Actors[i].start();
            ++i;
        }
        return Actors;
    }

    private void forceActorsStop(TestActor[] Actors) {
        int i = 0;
        while (i < Actors.length) {
            Actors[i].interrupt();
            ++i;
        }
    }

    public static void prepare() throws TestCaseException {
        StressTest.readParameters();
        StressTest.printParameters();
    }

    private static void printParameters() throws TestCaseException {
        StressTest.printInfo("StressTest", "Starting StressTest 5.0");
        StressTest.printInfo("StressTest", "Number of parallel tasks= " + mNumberOfTasks);
        StressTest.printInfo("StressTest", "Maximum row count per table= " + StressTest.getParameterInt((String)"MaxRownumber", (int)1024));
        StressTest.printInfo("StressTest", "Initial row count per table= " + StressTest.getParameterInt((String)"InitialRownumber", (int)1024));
        StressTest.printInfo("StressTest", "Table row size= " + StressTest.getParameterInt((String)"RowLength", (int)1024) + " Bytes");
        StressTest.printInfo("StressTest", "Drop the tables when finished= " + StressTest.getParameterBoolean((String)"DropAfterExecution", (boolean)true));
        StressTest.printInfo("StressTest", "Percentage of INSERT commands= " + StressTest.getParameterInt((String)"InsertPercentage", (int)25) + " %");
        StressTest.printInfo("StressTest", "Percentage of UPDATE commands= " + StressTest.getParameterInt((String)"UpdatePercentage", (int)25) + " %");
        StressTest.printInfo("StressTest", "Percentage of DELETE commands= " + StressTest.getParameterInt((String)"DeletePercentage", (int)25) + " %");
        StressTest.printInfo("StressTest", "Percentage of SELECT commands= " + StressTest.getParameterInt((String)"SelectPercentage", (int)25) + " %");
        StressTest.printInfo("StressTest", "Commit percentage= " + StressTest.getParameterInt((String)"CommitPercentage", (int)67) + " %");
        StressTest.printInfo("StressTest", "Maximum statements per transaction= " + StressTest.getParameterInt((String)"MaxStatementsPerTransaction", (int)5));
        StressTest.printInfo("StressTest", "Maximum runtime= " + mMaximumRuntime + " min");
    }

    private static void readParameters() throws TestCaseException {
        mTraceOn = StressTest.getParameterBoolean((String)"TraceOn", (boolean)true);
        mNumberOfTasks = StressTest.getParameterInt((String)"NumberOfTasks", (int)1);
        mMaximumRuntime = StressTest.getParameterInt((String)"MaximumRuntime", (int)5);
        mRandomSeed = StressTest.getParameterInt((String)"RandomSeed", (int)-1);
        if (mRandomSeed != -1) {
            RandomGenerator.setRandomSeed((int)mRandomSeed);
        }
        if (mNumberOfTasks < 1) {
            throw new TestCaseException("NumberOfTasks has to be greater than 0");
        }
        if (mMaximumRuntime <= 0) {
            throw new TestCaseException("MaximumRuntime has to be greater than 0");
        }
    }

    public void run() {
        boolean Finished = false;
        boolean AttemptToStop = false;
        Date AttemptToStopTime = null;
        try {
            int i;
            TestActor[] Actors = this.createActors();
            Date StartTime = new Date();
            while (!Finished) {
                long TimeDiff;
                if (!AttemptToStop) {
                    if (mMaximumRuntime != -1 && (TimeDiff = (new Date().getTime() - StartTime.getTime()) / 60000L) > (long)mMaximumRuntime) {
                        AttemptToStopTime = this.attemptActorsStop(Actors);
                    }
                } else {
                    TimeDiff = new Date().getTime() - AttemptToStopTime.getTime();
                    if (TimeDiff > 5000L) {
                        this.forceActorsStop(Actors);
                    }
                }
                int NumberOfRunningActors = 0;
                i = 0;
                while (i < Actors.length) {
                    if (Actors[i].isRunning()) {
                        ++NumberOfRunningActors;
                    } else if (Actors[i].hasError()) {
                        AttemptToStopTime = this.attemptActorsStop(Actors);
                    }
                    ++i;
                }
                if (NumberOfRunningActors == 0) {
                    Finished = true;
                    continue;
                }
                Thread.sleep(100L);
            }
            i = 0;
            while (i < Actors.length) {
                if (Actors[i].hasError()) {
                    StressTest.addGlobalMessage((String)Actors[i].getTitle(), (char)'E', (String)Actors[i].getStatusMessage());
                } else {
                    StressTest.addGlobalMessage((String)Actors[i].getTitle(), (char)'I', (String)Actors[i].getStatusMessage());
                }
                ++i;
            }
        }
        catch (Exception e) {
            StressTest.addGlobalMessage((String)"StressTest", (char)'E', (String)e.getMessage());
        }
    }
}

