/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbFullTest
extends TestCase {
    private static final int DBERR_DUPLICATE_NAME = -6006;
    private static final int DBERR_DB_TIMEOUT = 700;
    private static final int NO_ROWS_ADDED = 10000;
    private static final String sUser = "VOLLEDB";
    private static final String sPassword = "VOLLEDB";
    private static final boolean m_consoleMsg = true;
    private DBM mDBMan = null;
    private boolean isFull = false;
    private static int mNoRowsObserver = 0;
    private static Connection mConnection = null;
    private static TestStatement mTstmt = null;

    public static String getTestClassId() {
        return "DbFullTest";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            try {
                block10: {
                    lDefConnection = DbFullTest.getDatabase().connect(DbFullTest.getUser(), DbFullTest.getPassword());
                    lDefTstmt = new TestStatement(null, lDefConnection);
                    lDefTstmt.enableExceptions(false);
                    lDefTstmt.executeUpdate("drop user VOLLEDB");
                    lDefTstmt.enableExceptions(true);
                    try {
                        lDefTstmt.executeUpdate("Create user VOLLEDB password VOLLEDB dba not exclusive");
                    }
                    catch (DatabaseException e) {
                        if (e.getErrorCode() == -6006) break block10;
                        DbFullTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : VOLLEDB not possible");
                        throw e;
                    }
                }
                DbFullTest.createTable();
                DbFullTest.createDBProcedure();
                mConnection = DbFullTest.getDatabase().connect("VOLLEDB", "VOLLEDB");
                mTstmt = new TestStatement(null, mConnection);
                mConnection.commit();
            }
            catch (Exception e) {
                DbFullTest.handleGlobalExceptions((Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                lDefTstmt.close();
                lDefConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        lDefTstmt.close();
        lDefConnection.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection lConnection = null;
        TestStatement lTstmt = null;
        Object lTPstmt = null;
        String dbmCmdOut = "";
        try {
            block13: {
                try {
                    int cnt;
                    lConnection = DbFullTest.getDatabase().connect("VOLLEDB", "VOLLEDB");
                    lTstmt = new TestStatement((TestCase)this, lConnection);
                    FillDbThread superSizeMe = new FillDbThread();
                    DbFullTest.Trace(true, 'I', "Started FillDbThread");
                    while (true) {
                        int start;
                        if (this.isFull) {
                            this.executeDBMCmd("db_stop");
                            this.executeDBMCmd("db_admin");
                            DbFullTest.Trace(true, 'I', "Before addvolume!");
                            this.executeDBMCmd("db_addvolume DATA DAT02.dat F 5000");
                            this.executeDBMCmd("db_online");
                            DbFullTest.Trace(true, 'I', "After addvolume and db_online!");
                            ResultSet rs = lTstmt.executeQuery("select count(*) as cnt from growing");
                            if (rs.next()) {
                                cnt = rs.getInt("cnt");
                                if (cnt != mNoRowsObserver) break;
                                DbFullTest.Trace(true, 'I', "Jipiiieee!! Check found out that data are consistent!");
                            }
                            break block13;
                        }
                        dbmCmdOut = this.executeDBMCmd("db_state -v");
                        String answer = dbmCmdOut.substring((start = dbmCmdOut.indexOf("Database Full = ")) + 16, start + 19);
                        if (!answer.equalsIgnoreCase("yes")) continue;
                        this.isFull = true;
                        superSizeMe.pleaseStop();
                    }
                    DbFullTest.Trace(true, 'E', "Mimimimi!! Check found out that data are not consistent!\nExpected records in database : " + mNoRowsObserver + "\n" + "Found records in database    : " + cnt);
                }
                catch (SQLException e) {
                    if (700 == e.getErrorCode()) {
                        DbFullTest.Trace(true, 'E', "Error is DB FULL or timeout after online: " + e.getErrorCode());
                    }
                }
                catch (Exception e) {
                    this.handleExceptions(e);
                }
            }
            Object var8_14 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            try {
                lTstmt.close();
                lTPstmt.close();
                lConnection.close();
                DbFullTest.Trace(true, 'I', "restart DB kernel");
                this.executeDBMCmd("db_restart");
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        lTstmt.close();
        lTPstmt.close();
        lConnection.close();
        DbFullTest.Trace(true, 'I', "restart DB kernel");
        this.executeDBMCmd("db_restart");
    }

    public static void cleanUp() throws TestCaseException {
    }

    private static void createTable() {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = DbFullTest.getDatabase().connect("VOLLEDB", "VOLLEDB");
            stmt = new TestStatement(null, con);
            stmt.executeUpdate("CREATE TABLE GROWING (KEY1  int, FILLER  CHAR (250))");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createDBProcedure() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            try {
                con = DbFullTest.getDatabase().connect("VOLLEDB", "VOLLEDB");
                stmt = new TestStatement(null, con);
                stmt.executeUpdate("CREATE DBPROC FILLDB(IN I_NOROWSOBSERV INT) AS VAR x INT;  y CHAR(250); SET x=I_NOROWSOBSERV; SET y='This is a test that is supposed to fill the database until it is completely full then tries to restart it and possible needs an addvolume to do so - afterwards it checks data consistency'; WHILE x < (I_NOROWSOBSERV + 10000) DO BEGIN \t\tx = x + 1; \t\tINSERT INTO VOLLEDB.GROWING VALUES(:x, :y); END; ");
                con.commit();
            }
            catch (Exception e) {
                DbFullTest.addGlobalMessage((String)"DPProc creation failed", (char)'E', (String)("SQL Error while creating DBProcedure: " + e.getMessage()));
                throw new TestCaseException("DbFullTest.createDBProcedure() failed");
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        stmt.close();
        con.close();
    }

    public static long getTimeout() {
        return 0L;
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = DbFullTest.getDatabase().getHost();
            mName = DbFullTest.getDatabase().getName();
            int mPort = DbFullTest.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                logon = "USER_LOGON " + DbFullTest.getDatabase().getDBMUser() + "," + DbFullTest.getDatabase().getDBMPassword();
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private static void Trace(boolean consoleMsg, char iwe, String msg) {
        if (consoleMsg) {
            System.out.println(msg);
        }
        if (iwe == 'I') {
            DbFullTest.addGlobalMessage((String)DbFullTest.getTestClassId(), (char)'I', (String)msg);
        }
        if (iwe == 'W') {
            DbFullTest.addGlobalMessage((String)DbFullTest.getTestClassId(), (char)'W', (String)msg);
        }
        if (iwe == 'E') {
            DbFullTest.addGlobalMessage((String)DbFullTest.getTestClassId(), (char)'E', (String)msg);
        }
    }

    static /* synthetic */ void access$5(String string, char c, String string2) {
        TestCase.addGlobalMessage((String)string, (char)c, (String)string2);
    }

    class FillDbThread
    extends Thread {
        String dbmCmdOut = "";
        boolean keepRunning = true;

        FillDbThread() {
            this.start();
            DbFullTest.Trace(true, 'I', "Just started db fill thread!");
        }

        public void run() {
            String CallString = "";
            try {
                while (this.keepRunning) {
                    CallString = "CALL FILLDB(" + mNoRowsObserver + ")";
                    mTstmt.execute(CallString);
                    mNoRowsObserver = mNoRowsObserver + 10000;
                    if (!DbFullTest.this.isFull) continue;
                    this.keepRunning = false;
                }
            }
            catch (SQLException se) {
                if (700 == se.getErrorCode()) {
                    this.pleaseStop();
                    DbFullTest.Trace(true, 'I', "Got timeout:   " + se.getMessage());
                    DbFullTest.access$5("FillDB error", 'I', "DB full reached - getting timeout!");
                } else {
                    DbFullTest.Trace(true, 'I', "FillDB error 'E' Some dbm command did not work:   " + se.getMessage());
                    DbFullTest.access$5("FillDB error", 'E', "Some dbm command did not work");
                    this.pleaseStop();
                }
            }
            catch (Exception e) {
                this.keepRunning = false;
                DbFullTest.access$5("FillDB error", 'E', "Some dbm command did not work");
            }
        }

        public void pleaseStop() {
            this.keepRunning = false;
        }
    }
}

