/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.mut;

import com.sap.sapdb.oltptest.mut.OLTPTestActor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;

public class MultiUserTemplateOltp
extends TestCase {
    protected static int mNumberOfConcurrentUsers;
    protected static int mNumberOfReaders;
    protected static int mNumberOfWriters;
    private static Random mRandomGenerator;
    protected int mCycleNumber = 0;
    protected static int mStartDistance;
    protected static int mWaitTimeAfterStart;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;

    static {
        mRandomGenerator = new Random();
    }

    public MultiUserTemplateOltp() throws SQLException, TestDatabaseException {
        mNumberOfReaders = MultiUserTemplateOltp.getParameterInt((String)"NumberOfReaders", (int)1);
        mNumberOfWriters = MultiUserTemplateOltp.getParameterInt((String)"NumberOfWriters", (int)2);
        mNumberOfConcurrentUsers = mNumberOfReaders + mNumberOfWriters;
        this.mCycleNumber = MultiUserTemplateOltp.getParameterInt((String)"CycleNumber", (int)500);
        mStartDistance = MultiUserTemplateOltp.getParameterInt((String)"StartDistance", (int)1);
        mWaitTimeAfterStart = MultiUserTemplateOltp.getParameterInt((String)"WaitTimeAfterStart", (int)1);
    }

    public static int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + MultiUserTemplateOltp.getTestClassId());
    }

    private static boolean createConnections() {
        try {
            mConnections = new Connection[mNumberOfConcurrentUsers];
            mStatements = new TestStatement[mNumberOfConcurrentUsers];
            System.out.println("Creating " + mNumberOfConcurrentUsers + " connections!");
            int i = 0;
            while (i < mNumberOfConcurrentUsers) {
                MultiUserTemplateOltp.mConnections[i] = MultiUserTemplateOltp.getDatabase().connect("DBA", "DBA");
                mConnections[i].setAutoCommit(false);
                MultiUserTemplateOltp.mStatements[i] = new TestStatement(null, mConnections[i]);
                mConnections[i].commit();
                ++i;
            }
        }
        catch (Exception e) {
            MultiUserTemplateOltp.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public static String getTestClassId() {
        return "MultiUserTemplateOltp";
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    public static void prepare() throws TestCaseException {
    }

    public void startingMultipleThreads(int StartDistance) throws TestCaseException {
        block14: {
            try {
                boolean areRAlive;
                boolean areWAlive;
                long SleepTime = 1000 * StartDistance;
                Reader[] ReaderSet = new Reader[mNumberOfReaders + 1];
                Writer[] WriterSet = new Writer[mNumberOfWriters + 1];
                this.addMessage("startingMultipleThreads()", 'I', "Start Actors" + Integer.toString(mNumberOfConcurrentUsers));
                int i = 0;
                while (i < mNumberOfWriters) {
                    this.addMessage("startingMultipleThreads()", 'I', "Start Writer" + Integer.toString(i));
                    MultiUserTemplateOltp multiUserTemplateOltp = this;
                    ((Object)((Object)multiUserTemplateOltp)).getClass();
                    WriterSet[i] = multiUserTemplateOltp.new Writer(i, i);
                    Thread.sleep(SleepTime);
                    ++i;
                }
                int j = 0;
                while (j < mNumberOfReaders) {
                    this.addMessage("startingMultipleThreads()", 'I', "Start Reader" + Integer.toString(j));
                    MultiUserTemplateOltp multiUserTemplateOltp = this;
                    ((Object)((Object)multiUserTemplateOltp)).getClass();
                    ReaderSet[j] = multiUserTemplateOltp.new Reader(j, i + j);
                    Thread.sleep(SleepTime);
                    ++j;
                }
                SleepTime = 60000 * mWaitTimeAfterStart;
                Thread.sleep(SleepTime);
                this.addMessage("startingMultipleThreads()", 'I', "Stop all threads");
                i = 0;
                while (i < mNumberOfWriters) {
                    if (WriterSet[i] != null) {
                        WriterSet[i].pleaseStop();
                    }
                    System.out.println("asked to stop writers: i = " + i + " Status: " + WriterSet[i].isAlive());
                    ++i;
                }
                j = 0;
                while (j < mNumberOfReaders) {
                    if (ReaderSet[j] != null) {
                        ReaderSet[j].pleaseStop();
                    }
                    System.out.println("asked to stop readers: j = " + j + " Status: " + ReaderSet[j].isAlive());
                    ++j;
                }
                int k = 0;
                do {
                    ++k;
                    areRAlive = false;
                    areWAlive = false;
                    i = 0;
                    while (i < mNumberOfWriters) {
                        if (WriterSet[i] != null) {
                            areWAlive |= WriterSet[i].isAlive();
                            Thread.sleep(200L);
                        }
                        ++i;
                    }
                    j = 0;
                    while (j < mNumberOfReaders) {
                        if (ReaderSet[j] != null) {
                            areRAlive |= ReaderSet[j].isAlive();
                            Thread.sleep(200L);
                        }
                        ++j;
                    }
                } while ((areWAlive || areRAlive) && k < 100);
                System.out.println("Writers: " + areWAlive + "   Readers: " + areRAlive);
                if (!areWAlive && !areRAlive) {
                    this.addMessage("startingMultipleThreads()", 'I', "All threads stopped...");
                    break block14;
                }
                throw new TestCaseException("Not all threads stopped");
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
    }

    public static long getTimeout() {
        return 1800000L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block17: {
            try {
                try {
                    this.setStatus("createConnections");
                    MultiUserTemplateOltp.createConnections();
                    this.addMessage("run()", 'I', " Number of concurrent users: " + MultiUserTemplateOltp.mNumberOfConcurrentUsers);
                    this.setStatus("Multi Users on DB");
                    this.startingMultipleThreads(MultiUserTemplateOltp.mStartDistance);
                }
                catch (Exception e) {
                    this.handleExceptions(e);
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var3_2) {
                var2_3 = null;
                try {
                    i = 0;
                    while (i < MultiUserTemplateOltp.mNumberOfConcurrentUsers) {
                        MultiUserTemplateOltp.mStatements[i].close();
                        ++i;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            try {
                i = 0;
                while (true) {
                    if (i >= MultiUserTemplateOltp.mNumberOfConcurrentUsers) {
                        throw var3_2;
                    }
                    MultiUserTemplateOltp.mConnections[i].commit();
                    MultiUserTemplateOltp.mConnections[i].close();
                    ++i;
                }
            }
            catch (Exception var4_8) {
                // empty catch block
            }
            throw var3_2;
lbl-1000:
            // 2 sources

            {
                var2_4 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 71->100)] { 
lbl39:
            // 1 sources

            i = 0;
            while (i < MultiUserTemplateOltp.mNumberOfConcurrentUsers) {
                MultiUserTemplateOltp.mStatements[i].close();
                ++i;
            }
            break block17;
lbl45:
            // 1 sources

            catch (Exception i) {
                // empty catch block
            }
        }
        ** try [egrp 3[TRYBLOCK] [4 : 102->144)] { 
lbl49:
        // 1 sources

        i = 0;
        while (true) {
            if (i >= MultiUserTemplateOltp.mNumberOfConcurrentUsers) {
                return;
            }
            MultiUserTemplateOltp.mConnections[i].commit();
            MultiUserTemplateOltp.mConnections[i].close();
            ++i;
        }
lbl57:
        // 1 sources

        catch (Exception var4_12) {
            return;
        }
    }

    static /* synthetic */ void access$2(String string, char c, String string2) {
        TestCase.addGlobalMessage((String)string, (char)c, (String)string2);
    }

    class Writer
    extends OLTPTestActor {
        boolean keepRunning = true;
        String name;
        int number;
        int StmtCount;
        int connectionNo;

        Writer(int writerNo, int conNo) {
            this.name = "Writer" + writerNo;
            this.number = writerNo;
            this.connectionNo = conNo;
            System.out.println(String.valueOf(this.name) + " constucted!");
            this.StmtCount = 0;
            this.start();
            System.out.println(String.valueOf(this.name) + " just started!");
        }

        public void check() {
            System.out.println("in check");
        }

        public void run() {
            Connection con = null;
            try {
                System.out.println(String.valueOf(this.name) + " uses Connection number " + this.connectionNo);
                con = mConnections[this.connectionNo];
                while (this.keepRunning) {
                    ++this.StmtCount;
                    this.executeWritingOps(con, this.number);
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                MultiUserTemplateOltp.this.handleException(e);
            }
        }

        public void pleaseStop() {
            System.out.println(String.valueOf(this.name) + ": Asking thread to please stop!");
            this.keepRunning = false;
        }

        private void executeWritingOps(Connection pConnection, int user) throws TestCaseException {
            int CurrentCycle = 0;
            this.mRunning = true;
            try {
                while (this.keepRunning) {
                    if (CurrentCycle % 50 == 0) {
                        System.out.println(String.valueOf(this.name) + " - CurrentCycle:" + CurrentCycle);
                    }
                    System.out.println("Connection is closed: " + pConnection.isClosed() + "; user: " + user);
                    Writer.sleep(25L);
                    if (MultiUserTemplateOltp.this.mCycleNumber != -1 && ++CurrentCycle > MultiUserTemplateOltp.this.mCycleNumber) {
                        System.out.println(String.valueOf(this.name) + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                        this.keepRunning = false;
                        this.setStatus(1);
                    }
                    if (!this.mShouldStop) continue;
                    System.out.println(String.valueOf(this.name) + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                    this.keepRunning = false;
                    this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                }
            }
            catch (InterruptedException e) {
                System.out.println(String.valueOf(this.name) + ": Hard interrupted");
                this.setStatus(2);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.name) + ": ** ERROR **  General exception: " + e.getMessage());
                this.setStatus(-3, "Exception: " + e.getMessage());
            }
        }
    }

    class Reader
    extends OLTPTestActor {
        boolean keepRunning = true;
        String name;
        int number;
        int StmtCount;
        int connectionNo;

        Reader(int readerNo, int conNo) {
            this.name = "Reader" + readerNo;
            this.number = readerNo;
            this.connectionNo = conNo;
            System.out.println(String.valueOf(this.name) + " constucted!");
            this.StmtCount = 0;
            this.start();
            System.out.println(String.valueOf(this.name) + " just started!");
        }

        public void check() {
            System.out.println("in check");
        }

        public void run() {
            Connection con = null;
            try {
                System.out.println(String.valueOf(this.name) + " uses Connection number " + this.connectionNo);
                con = mConnections[this.connectionNo];
                while (this.keepRunning) {
                    ++this.StmtCount;
                    this.executeReadingOps(con, this.number);
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                MultiUserTemplateOltp.this.handleException(e);
            }
        }

        public void pleaseStop() {
            System.out.println(String.valueOf(this.name) + ": Asking thread to please stop!");
            this.keepRunning = false;
        }

        private void executeReadingOps(Connection pConnection, int user) throws TestCaseException {
            block5: {
                int CurrentCycle = 0;
                this.mRunning = true;
                try {
                    while (this.keepRunning) {
                        if (CurrentCycle % 50 == 0) {
                            System.out.println(String.valueOf(this.name) + " - CurrentCycle:" + CurrentCycle);
                        }
                        System.out.println("Connection is closed: " + pConnection.isClosed() + "; user: " + user);
                        Reader.sleep(25L);
                        if (MultiUserTemplateOltp.this.mCycleNumber != -1 && ++CurrentCycle > MultiUserTemplateOltp.this.mCycleNumber) {
                            System.out.println(String.valueOf(this.name) + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                            this.keepRunning = false;
                            this.setStatus(1);
                        }
                        if (!this.mShouldStop) continue;
                        System.out.println(String.valueOf(this.name) + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                        this.keepRunning = false;
                        this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                    }
                }
                catch (Exception e) {
                    MultiUserTemplateOltp.access$2("Thread " + this.name + ": Method executeCmd ", 'E', " execute failed: " + ((SQLException)e).getErrorCode());
                    if (((SQLException)e).getErrorCode() != -807) break block5;
                    this.keepRunning = false;
                }
            }
        }
    }
}

