/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.lock;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class LockList3
extends TestCase {
    private static String sUser = "BERLIN";
    private static String sPassword = "BERLIN";
    private static int sRequestTimeout = 30;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanUp() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            try {
                con = LockList3.getDatabase().connect(sUser, sPassword);
                stmt = new TestStatement(null, con);
                stmt.enableExceptions(false);
                stmt.executeUpdate("Drop user " + sUser);
                stmt.enableExceptions(true);
            }
            catch (Exception e) {
                LockList3.addGlobalMessage((String)"Clean up", (char)'E', (String)"failed");
                throw new TestCaseException("Error during clean up: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        stmt.close();
        con.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void createLock(Connection pConnection, boolean pExclusiveMode) {
        TestStatement stmt = null;
        try {
            block9: {
                try {
                    stmt = new TestStatement(null, pConnection);
                    if (pExclusiveMode) {
                        stmt.executeUpdate("LOCK ROW LOCKTEST KEY S0 = 'ABC' IN EXCLUSIVE MODE");
                        break block9;
                    }
                    stmt.executeUpdate("LOCK ROW LOCKTEST KEY S0 = 'ABC' IN SHARE MODE");
                }
                catch (Exception exception) {}
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                stmt.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        stmt.close();
    }

    public static String getTestClassId() {
        return "LockList3";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            try {
                con = LockList3.getDatabase().connect(LockList3.getUser(), LockList3.getPassword());
                stmt = new TestStatement(null, con);
                stmt.enableExceptions(false);
                stmt.executeUpdate("Drop user " + sUser);
                stmt.enableExceptions(true);
                stmt.executeUpdate("Create user " + sUser + " password " + sPassword + " resource not exclusive");
                stmt.close();
                con.close();
                con = LockList3.getDatabase().connect(sUser, sPassword);
                stmt = new TestStatement(null, con);
                stmt.enableExceptions(false);
                stmt.executeUpdate("DROP TABLE LOCKTEST");
                stmt.enableExceptions(true);
                stmt.executeUpdate("CREATE TABLE LOCKTEST (S0 VARCHAR(3) KEY)");
                sRequestTimeout = LockList3.getParameterInt((String)"RequestTimeout", (int)30);
                LockList3.addGlobalMessage((String)"", (char)'I', (String)("RequestTimeout = " + sRequestTimeout));
            }
            catch (Exception e) {
                LockList3.addGlobalMessage((String)"Preparation", (char)'E', (String)("failed: " + e.getMessage()));
                throw new TestCaseException("Error during preparation: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        stmt.close();
        con.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection con1 = null;
        Connection con2 = null;
        int orgRequestTimeout = 0;
        try {
            try {
                orgRequestTimeout = Integer.parseInt(((TestDatabaseSap)LockList3.getDatabase()).getParameter("REQUEST_TIMEOUT"));
                this.setRequestTimeout(sRequestTimeout);
                if (LockList3.getDatabase().isSap()) {
                    ((TestDatabaseSap)LockList3.getDatabase()).enableOLTPTrace();
                }
                Properties conProps = new Properties();
                conProps.put("user", sUser);
                conProps.put("password", sPassword);
                conProps.put("timeout", new Integer(sRequestTimeout));
                con1 = LockList3.getDatabase().connect(conProps);
                con2 = LockList3.getDatabase().connect(conProps);
                con1.setAutoCommit(false);
                con2.setAutoCommit(false);
                this.createLock(con1, false);
                this.createLock(con2, false);
                this.createLock(con2, true);
                long startTime = System.currentTimeMillis();
                long deltaTime = 0L;
                long threshold = (long)(sRequestTimeout + 5) * 1000L;
                while (true) {
                    if (deltaTime >= threshold) {
                        con1.commit();
                        con2.commit();
                    }
                    deltaTime = System.currentTimeMillis() - startTime;
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            try {
                this.setRequestTimeout(orgRequestTimeout);
                if (LockList3.getDatabase().isSap()) {
                    TestDatabaseSap sapdb = (TestDatabaseSap)LockList3.getDatabase();
                    sapdb.disableOLTPTrace();
                }
                con1.close();
                con2.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var11_11 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        this.setRequestTimeout(orgRequestTimeout);
        if (LockList3.getDatabase().isSap()) {
            TestDatabaseSap sapdb = (TestDatabaseSap)LockList3.getDatabase();
            sapdb.disableOLTPTrace();
        }
        con1.close();
        con2.close();
    }

    private void setRequestTimeout(int pRequestTimeout) throws TestDatabaseException {
        ((TestDatabaseSap)LockList3.getDatabase()).setParameter("REQUEST_TIMEOUT", Integer.toString(pRequestTimeout));
    }
}

