/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.lock;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class LockList2
extends TestCase {
    static final String TIME_OUT = "TimeOut";
    static final String NUMBER_OF_TRANSACTIONS = "NumberOfTransactions";
    static final String SLEEP_TIME = "SleepTime";
    static final String WATCH_TIME = "WatchTime";
    static final String SELECTOR_TIME = "SelectorTime";
    static final String DISPLAY_LOCKS = "DisplayLocks";
    static final String COMMIT_RATE = "CommitRate";
    static final String SLEEP_RATE = "SleepRate";
    static final String CONCURRENT_RATE = "ConcurrentRate";
    static boolean sDevTrace = false;
    private static String sUser = "BERLIN";
    private static String sPassword = "BERLIN";
    static long sLockCounter = 0L;
    private static Properties sTestParameter = null;
    private static Properties sDbParameter = null;
    private List mWatchListUser = null;
    private Map mWatchListRequest = null;

    static {
        sTestParameter = new Properties();
        sDbParameter = new Properties();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanUp() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            try {
                con = LockList2.getDatabase().connect(sUser, sPassword);
                stmt = new TestStatement(null, con);
                stmt.enableExceptions(false);
                stmt.executeUpdate("Drop user " + sUser);
                stmt.enableExceptions(true);
            }
            catch (Exception e) {
                LockList2.addGlobalMessage((String)"Clean up", (char)'E', (String)"failed");
                throw new TestCaseException("Error during clean up: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        stmt.close();
        con.close();
    }

    private String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
        Date date = new Date(System.currentTimeMillis());
        return df.format(date);
    }

    public static String getTestClassId() {
        return "LockList2";
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        TestPreparedStatement pstmt = null;
        try {
            try {
                con = LockList2.getDatabase().connect(LockList2.getUser(), LockList2.getPassword());
                stmt = new TestStatement(null, con);
                stmt.enableExceptions(false);
                stmt.executeUpdate("Drop user " + sUser);
                stmt.enableExceptions(true);
                stmt.executeUpdate("Create user " + sUser + " password " + sPassword + " resource not exclusive");
                stmt.close();
                con.close();
                con = LockList2.getDatabase().connect(sUser, sPassword);
                stmt = new TestStatement(null, con);
                stmt.executeUpdate("CREATE TABLE LOCKTEST (S0 VARCHAR(4) KEY, S1 VARCHAR(10))");
                Random randomGenerator = new Random(System.currentTimeMillis());
                pstmt = new TestPreparedStatement(null, con, "insert LOCKTEST values (?,?)");
                int i = 0;
                while (true) {
                    block15: {
                        String timeout;
                        String maxuser;
                        String maxlocks;
                        if (i < 10000) break block15;
                        pstmt.executeBatch();
                        LockList2.setTestParameter(TIME_OUT, LockList2.getParameterString((String)TIME_OUT, (String)"900"));
                        LockList2.setTestParameter(NUMBER_OF_TRANSACTIONS, LockList2.getParameterString((String)NUMBER_OF_TRANSACTIONS, (String)"5"));
                        LockList2.setTestParameter(WATCH_TIME, LockList2.getParameterString((String)WATCH_TIME, (String)"30"));
                        LockList2.setTestParameter(SLEEP_TIME, LockList2.getParameterString((String)SLEEP_TIME, (String)"60"));
                        LockList2.setTestParameter(DISPLAY_LOCKS, LockList2.getParameterString((String)DISPLAY_LOCKS, (String)"1000"));
                        LockList2.setTestParameter(COMMIT_RATE, LockList2.getParameterString((String)COMMIT_RATE, (String)"1000"));
                        LockList2.setTestParameter(SLEEP_RATE, LockList2.getParameterString((String)SLEEP_RATE, (String)"50"));
                        LockList2.setTestParameter(CONCURRENT_RATE, LockList2.getParameterString((String)CONCURRENT_RATE, (String)"50"));
                        LockList2.setTestParameter(SELECTOR_TIME, LockList2.getParameterString((String)SELECTOR_TIME, (String)"30"));
                        String maxcpu = LockList2.getParameterString((String)"MAXCPU", (String)"");
                        if (maxcpu != null && maxcpu.length() != 0) {
                            LockList2.setDbParameter("MAXCPU", maxcpu);
                        }
                        if ((maxlocks = LockList2.getParameterString((String)"MAXLOCKS", (String)"")) != null && maxlocks.length() != 0) {
                            LockList2.setDbParameter("MAXLOCKS", maxlocks);
                        }
                        if ((maxuser = LockList2.getParameterString((String)"MAXUSERTASKS", (String)"")) != null && maxuser.length() != 0) {
                            LockList2.setDbParameter("MAXUSERTASKS", maxuser);
                        }
                        if ((timeout = LockList2.getParameterString((String)"REQUEST_TIMEOUT", (String)"")) != null && timeout.length() != 0) {
                            LockList2.setDbParameter("REQUEST_TIMEOUT", timeout);
                        }
                        break;
                    }
                    if (i < 100) {
                        pstmt.setString(1, "LL" + Integer.toString(i));
                    } else {
                        pstmt.setString(1, Integer.toString(i));
                    }
                    pstmt.setString(2, Integer.toString(Math.abs(randomGenerator.nextInt())));
                    pstmt.addBatch();
                    ++i;
                }
            }
            catch (Exception e) {
                throw new TestCaseException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                pstmt.close();
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        pstmt.close();
        stmt.close();
        con.close();
    }

    private void print(String pOut) {
        try {
            this.addMessage("", 'I', String.valueOf(Thread.currentThread().getName()) + " " + this.getDate() + " " + pOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            Thread.sleep(90000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LockList2.addGlobalMessage((String)"Test execution", (char)'I', (String)"Everything works fine");
    }

    private static void setDbParameter(String pKey, String pValue) {
        sDbParameter.setProperty(pKey, pValue);
        LockList2.addGlobalMessage((String)"", (char)'I', (String)("Db parameter " + pKey + " = " + pValue));
    }

    private static void setTestParameter(String pKey, String pValue) {
        sTestParameter.setProperty(pKey, pValue);
        LockList2.addGlobalMessage((String)"", (char)'I', (String)("Testparameter " + pKey + " = " + pValue));
    }

    class LockRequestor
    extends Thread {
        boolean keepRuning = true;

        LockRequestor() {
            this.start();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Connection con = null;
            TestPreparedStatement pstmt = null;
            Thread currentThread = null;
            long startTime = System.currentTimeMillis();
            try {
                try {
                    con = LockList2.getDatabase().connect(sUser, sPassword);
                    con.setAutoCommit(false);
                    pstmt = new TestPreparedStatement(null, con, "UPDATE LOCKTEST SET S1 = ? WHERE S0 = ?");
                    currentThread = Thread.currentThread();
                    LockList2.this.mWatchListUser.add(currentThread.getName());
                    LockList2.this.mWatchListRequest.put(currentThread.getName(), new Date(System.currentTimeMillis()));
                    Random randomGenerator = new Random(System.currentTimeMillis());
                    int counter = 0;
                    String commitRate = sTestParameter.getProperty(LockList2.COMMIT_RATE);
                    int CommitRate = Integer.parseInt(commitRate);
                    String concurrentRate = sTestParameter.getProperty(LockList2.CONCURRENT_RATE);
                    int ConcurrentRate = Integer.parseInt(concurrentRate);
                    String sleepRate = sTestParameter.getProperty(LockList2.SLEEP_RATE);
                    int SleepRate = Integer.parseInt(sleepRate);
                    String sleepTime = sTestParameter.getProperty(LockList2.SLEEP_TIME);
                    long SleepTime = 1000L * Long.parseLong(sleepTime);
                    while (this.keepRuning) {
                        LockList2.this.print("Lock counter = " + ++counter);
                        if (counter % CommitRate == 0) {
                            con.commit();
                            LockList2.this.print("Commit");
                        } else {
                            String key;
                            if (counter % ConcurrentRate == 0) {
                                key = "LL " + Integer.toString(randomGenerator.nextInt());
                                if (key.length() > 4) {
                                    key = key.substring(0, 4);
                                }
                                LockList2.this.print("Concurrent lock");
                            } else {
                                key = Integer.toString(randomGenerator.nextInt());
                                LockList2.this.print("Regular lock");
                            }
                            pstmt.setString(1, key);
                            pstmt.setString(2, Integer.toString(randomGenerator.nextInt()));
                            pstmt.executeUpdate();
                            ++sLockCounter;
                        }
                        if (counter % SleepRate == 0) {
                            Thread.sleep(SleepTime);
                            LockList2.this.print("Sleep");
                        }
                        if (counter % 100 == 0) {
                            LockList2.this.mWatchListRequest.put(currentThread.getName(), new Date(System.currentTimeMillis()));
                        }
                        Thread.yield();
                    }
                }
                catch (Exception e) {
                    LockList2.this.handleException(e);
                }
            }
            catch (Throwable throwable) {
                Object var18_18 = null;
                try {
                    pstmt.close();
                    con.close();
                    LockList2.this.mWatchListUser.remove(currentThread.getName());
                    long timeDiff = System.currentTimeMillis() - startTime;
                    long Timeout = 1000L * Long.parseLong(sTestParameter.getProperty(LockList2.TIME_OUT));
                    LockList2.this.print("stopped after " + timeDiff / 1000L + "(" + Timeout / 1000L + ")");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var18_19 = null;
            }
            try {}
            catch (Exception exception) {
                return;
            }
            pstmt.close();
            con.close();
            LockList2.this.mWatchListUser.remove(currentThread.getName());
            long timeDiff = System.currentTimeMillis() - startTime;
            long Timeout = 1000L * Long.parseLong(sTestParameter.getProperty(LockList2.TIME_OUT));
            LockList2.this.print("stopped after " + timeDiff / 1000L + "(" + Timeout / 1000L + ")");
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }

    class Watcher
    extends Thread {
        boolean keepRuning = true;

        Watcher() {
            LockList2.this.mWatchListUser = Collections.synchronizedList(new ArrayList());
            LockList2.this.mWatchListRequest = Collections.synchronizedMap(new HashMap());
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            String watchTime = sTestParameter.getProperty(LockList2.WATCH_TIME);
            long WatchTime = 1000L * Long.parseLong(watchTime);
            while (this.keepRuning) {
                List list = LockList2.this.mWatchListUser;
                synchronized (list) {
                    ListIterator it = LockList2.this.mWatchListUser.listIterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        Date LastRequest = (Date)LockList2.this.mWatchListRequest.get(key);
                        long timediff = System.currentTimeMillis() - LastRequest.getTime();
                        if (timediff <= WatchTime) continue;
                        LockList2.this.print(String.valueOf(key) + " not responding since " + df.format(LastRequest).toString());
                    }
                }
                try {
                    Thread.sleep(WatchTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }

    class Sysmon
    extends Thread {
        boolean keepRuning = true;

        Sysmon() {
            this.start();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
            con = null;
            stmt = null;
            try {
                try {
                    con = LockList2.getDatabase().connect(LockList2.access$3(), LockList2.access$4());
                    stmt = new TestStatement(null, con);
                    rs = null;
                    UserInit = 0;
                    UserConnected = 0;
                    UserActive = 0;
                    rs = stmt.executeQuery("select count(*) from SYSMON_US");
                    while (true) {
                        if (!rs.next()) {
                            LockList2.access$2(LockList2.this, "Users initially connected = " + UserInit);
                            WatchTime = 1000L * Long.parseLong(LockList2.access$1().getProperty("WatchTime"));
                            break;
                        }
                        UserInit = rs.getInt(1);
                    }
                    while (this.keepRuning) {
                        rs = stmt.executeQuery("select count(*) from SYSMON_US");
                        while (true) {
                            if (!rs.next()) break;
                            UserConnected = rs.getInt(1);
                        }
                        rs = stmt.executeQuery("select count(*) from SYSMON_US_ACTIVE");
                        while (true) {
                            if (!rs.next()) {
                                if (UserActive != UserInit) {
                                    LockList2.access$2(LockList2.this, "Active users = " + UserActive + "(" + UserInit + ")");
                                }
                                if (UserConnected != UserInit) {
                                    LockList2.access$2(LockList2.this, "Connected users = " + UserConnected + "(" + UserInit + ")");
                                }
                                ** try [egrp 3[TRYBLOCK] [1 : 268->276)] { 
lbl38:
                                // 1 sources

                                break;
                            }
                            UserActive = rs.getInt(1);
                        }
                        {
                            Thread.sleep(WatchTime);
                            continue;
                        }
lbl43:
                        // 1 sources

                        catch (InterruptedException var9_10) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception e) {
                    LockList2.access$2(LockList2.this, e.getMessage());
                }
            }
            catch (Throwable var11_11) {
                var10_12 = null;
                try {
                    stmt.close();
                    con.close();
                    throw var11_11;
                }
                catch (Exception var12_14) {
                    // empty catch block
                }
                throw var11_11;
            }
            {
                var10_13 = null;
            }
            try {}
            catch (Exception var12_15) {
                return;
            }
            stmt.close();
            con.close();
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }

    class Selector
    extends Thread {
        boolean keepRuning = true;

        Selector() {
            this.start();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Connection con = null;
            TestStatement stmt = null;
            try {
                try {
                    con = LockList2.getDatabase().connect(sUser, sPassword);
                    stmt = new TestStatement(null, con);
                    String selectorTime = sTestParameter.getProperty(LockList2.SELECTOR_TIME);
                    long SelectorTime = Long.parseLong(selectorTime);
                    while (this.keepRuning) {
                        try {
                            Thread.sleep(SelectorTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ResultSet rs = stmt.executeQuery("select * from LOCKTEST");
                        rs.next();
                    }
                }
                catch (Exception e) {
                    LockList2.this.print(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    stmt.close();
                    con.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var7_10 = null;
            }
            try {}
            catch (Exception exception) {
                return;
            }
            stmt.close();
            con.close();
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }
}

