/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.loader;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class TransferDom
implements ErrorHandler {
    private Document document;
    private ArrayList tables;

    public TransferDom(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(this);
        System.out.println("Parsing: " + file);
        this.document = builder.parse(file);
        this.tables = this.getTables();
    }

    private ArrayList getTables() {
        this.tables = new ArrayList();
        NodeList nl = this.document.getElementsByTagName("sapdbm:DeployedTable");
        int i = 0;
        while (i < nl.getLength()) {
            NamedNodeMap attrs = nl.item(i).getAttributes();
            String table = attrs.getNamedItem("oim:name").getNodeValue();
            if (table != null) {
                this.tables.add(table);
            }
            ++i;
        }
        return this.tables;
    }

    public Iterator iterator() {
        return this.tables.iterator();
    }

    public void warning(SAXParseException exception) throws SAXParseException {
        System.err.println("WARNING: line " + exception.getLineNumber() + ": " + exception.getMessage());
    }

    public void error(SAXParseException exception) throws SAXParseException {
        System.err.println("ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        System.err.println("FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }
}

