/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.loader;

import com.sap.dbtech.powertoys.Loader;
import com.sap.dbtech.powertoys.LoaderException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.sqltest.interpreter.Cache;
import com.sap.sapdb.sqltest.interpreter.Catalog;
import com.sap.sapdb.sqltest.interpreter.Reference;
import com.sap.sapdb.sqltest.parser.StatementBean;
import com.sap.sapdb.sqltest.parser.TestCaseBean;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.utilities.TestCaseDBVersionScope;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class LoaderTestInterpreter
extends TestCase {
    private static final String mTestUser = "LOADER";
    private static final String mTestUserPw = "LOADER";
    private static String mTestRoot = null;
    private String mDataInputPath = null;
    private static String mTestCatalogFile = null;
    private Catalog mTestCaseCatalog = null;
    private Reference m_CurrentRef = null;
    private Cache mTestCaseCache = null;
    private static Connection mSQLConnection = null;
    private static final String mDBName = LoaderTestInterpreter.getDatabase().getName();
    private Loader mLoader = null;

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + LoaderTestInterpreter.getTestClassId());
    }

    public static String getTestClassId() {
        return "LoaderTest";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        TestStatement myStatement = null;
        mTestRoot = TestDriver.getJTestRoot();
        System.out.println("Start of " + LoaderTestInterpreter.getTestClassId());
        try {
            try {
                mSQLConnection = LoaderTestInterpreter.getDatabase().connect(LoaderTestInterpreter.getUser(), LoaderTestInterpreter.getPassword());
                System.out.println("Driver given user " + LoaderTestInterpreter.getUser());
                myStatement = new TestStatement(null, mSQLConnection);
                myStatement.executeUpdateIgnoreErrors("Drop user LOADER");
                myStatement.executeUpdate("Create user LOADER password LOADER dba not exclusive");
                myStatement.close();
                mSQLConnection.close();
                mSQLConnection = LoaderTestInterpreter.getDatabase().connect("LOADER", "LOADER");
            }
            catch (Exception e) {
                LoaderTestInterpreter.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
                throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                myStatement.close();
                mSQLConnection.commit();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        myStatement.close();
        mSQLConnection.commit();
    }

    public void run() {
        this.mDataInputPath = String.valueOf(this.getDataInputPath()) + File.separator;
        mTestCatalogFile = String.valueOf(this.mDataInputPath) + "LOADERTESTS.xml";
        String URIPrefix = "file:///" + this.mDataInputPath;
        Properties loaderProperties = null;
        loaderProperties = new Properties();
        loaderProperties.setProperty("dbname", mDBName);
        loaderProperties.setProperty("host", "localhost:" + LoaderTestInterpreter.getDatabase().getPort());
        try {
            this.mLoader = new Loader(loaderProperties);
            this.mLoader.cmd("SET");
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        TestCaseBean LoaderTestCase = null;
        int numberOfSelectedTestCases = 0;
        String Scope_charEncType = null;
        String Scope_sqlmode = LoaderTestInterpreter.getParameterString((String)"SQLMODE", (String)"INTERNAL");
        String Scope_version = null;
        try {
            this.mTestCaseCatalog = new Catalog(mTestCatalogFile);
            this.mTestCaseCache = new Cache(URIPrefix);
            Iterator itReference = this.mTestCaseCatalog.iterator();
            int numberOfPlannedTestCases = this.mTestCaseCatalog.getNumberOfReferences();
            TestDatabaseSap myDb = (TestDatabaseSap)LoaderTestInterpreter.getDatabase();
            Scope_sqlmode = myDb.getSqlMode();
            Scope_charEncType = myDb.getParameter("_UNICODE").equalsIgnoreCase("YES") ? (myDb.getParameter("DEFAULT_CODE").equalsIgnoreCase("UNICODE") ? "unicode" : "mixed") : "ascii";
            Scope_version = myDb.getVersion();
            this.addMessage("Testcontext", 'T', "The context for these tests is: \nRelease     : " + Scope_version + "\nCharEncType : " + Scope_charEncType + "\nSQLMode     : " + Scope_sqlmode + "\n\ndb parameter:" + "\n _UNICODE      = " + myDb.getParameter("_UNICODE") + "\n DEFAULT_CODE  = " + myDb.getParameter("DEFAULT_CODE") + "\n _PACKET_SIZE  = " + myDb.getParameter("_PACKET_SIZE"));
            while (itReference.hasNext()) {
                TestCaseDBVersionScope t;
                this.m_CurrentRef = (Reference)itReference.next();
                if (!this.m_CurrentRef.getSelected()) continue;
                ++numberOfSelectedTestCases;
                LoaderTestCase = this.mTestCaseCache.getCaseForReference(this.m_CurrentRef);
                if (LoaderTestCase == null) {
                    this.addMessage("File = " + this.m_CurrentRef.getFileName(), 'W', "the test case for this " + this.m_CurrentRef.toString() + " does not exist.");
                    continue;
                }
                if (LoaderTestCase.getExcludeProperty() != null && LoaderTestCase.getExcludeProperty().length() != 0 && !(t = new TestCaseDBVersionScope(LoaderTestCase.getExcludeProperty())).isInScope(Scope_charEncType, Scope_sqlmode, Scope_version)) {
                    this.addMessage("Exclude rule", 'T', "Test " + this.m_CurrentRef.toString() + " \nwas not executed because exclude rule \"" + LoaderTestCase.getExcludeProperty() + "\" matched.");
                    continue;
                }
                this.ProcessLoaderTestCase(LoaderTestCase);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            mSQLConnection.close();
        }
        catch (SQLException se) {
            this.handleExceptions(se);
        }
    }

    public int ProcessLoaderTestCase(TestCaseBean LoaderTestCase) {
        int rc = 0;
        try {
            this.mLoader.cmd("use user LOADER LOADER serverdb " + mDBName);
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        if (LoaderTestCase.getPrepareStatemets().size() > 0) {
            try {
                this.LoaderTest_Prepare(LoaderTestCase.getPrepareStatemets());
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        if (LoaderTestCase.getRunStatements().size() > 0) {
            try {
                rc = this.LoaderTest_Run(LoaderTestCase);
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        if (LoaderTestCase.getCleanUpStatements().size() > 0) {
            try {
                this.LoaderTest_Cleanup(LoaderTestCase.getCleanUpStatements());
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return rc;
    }

    private int LoaderTest_Prepare(ArrayList PrepareStmtArray) {
        int rc = 0;
        int NoOfStmts = PrepareStmtArray.size();
        StatementBean LoaderStmt = null;
        int i = 0;
        while (i < NoOfStmts) {
            try {
                LoaderStmt = (StatementBean)PrepareStmtArray.get(i);
                this.mLoader.cmd(LoaderStmt.getCallString());
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
            ++i;
        }
        return rc;
    }

    private int LoaderTest_Run(TestCaseBean LoaderTestCase) throws RTEException, TestCaseException {
        int rc = 0;
        ArrayList RunStmtArray = LoaderTestCase.getRunStatements();
        int NoOfStmts = RunStmtArray.size();
        StatementBean LoaderStmt = null;
        String _callString = null;
        String _tmpString = null;
        int _pos = 0;
        VerificationData _ReferenceData = null;
        boolean _bError = false;
        boolean _bTestFailed = false;
        TestStatement _SQLStmt = null;
        StringBuffer _sb_stmt = new StringBuffer();
        StringBuffer _sb_test = new StringBuffer();
        try {
            _SQLStmt = new TestStatement((TestCase)this, mSQLConnection, 1005, 1007);
        }
        catch (SQLException se) {
            this.handleExceptions(se);
        }
        int i = 0;
        while (i < NoOfStmts) {
            block16: {
                try {
                    LoaderStmt = (StatementBean)RunStmtArray.get(i);
                    _callString = LoaderStmt.getCallString();
                    if (!LoaderStmt.isVerify()) {
                        _pos = _callString.indexOf("<infile_path>");
                        while (-1 != _pos) {
                            _tmpString = _callString.substring(0, _pos);
                            _tmpString = String.valueOf(_tmpString) + this.mDataInputPath;
                            _callString = _tmpString = String.valueOf(_tmpString) + _callString.substring(_pos + 13);
                            _pos = _callString.indexOf("<infile_path>");
                        }
                        _tmpString = _callString;
                        this.mLoader.cmd(_tmpString);
                        String _szExpectedErrorCodes = LoaderStmt.getListOfExpectedErrorCodes();
                        if (3 < _szExpectedErrorCodes.length()) {
                            _sb_stmt.append("Expected error " + _szExpectedErrorCodes + " but return code was ( 0 )\n");
                            _bError = true;
                        }
                    } else {
                        _ReferenceData = LoaderStmt.getVerificationData();
                        ResultSet rs = null;
                        rs = _SQLStmt.executeQuery(_callString);
                        if (!_ReferenceData.equals(rs)) {
                            VerificationDataComplete vercom = new VerificationDataComplete(rs);
                            _sb_stmt.append("Expected resultset:\n" + _ReferenceData.toString() + "\nReal resultset:\n" + vercom.toString() + "\n");
                            _bError = true;
                        }
                    }
                }
                catch (LoaderException le) {
                    if (!LoaderStmt.checkErrorCodes(le.getErrorCode()) && !LoaderStmt.isIgnoreErrors()) {
                        _sb_stmt.append(String.valueOf(le.toString()) + "\nexecuting Loader statement\n\"" + _callString + "\"\n");
                        _bError = true;
                    }
                }
                catch (SQLException se) {
                    boolean bDoWeNeedToHandleException = true;
                    if (LoaderStmt.isVerify() && 100 == se.getErrorCode()) {
                        bDoWeNeedToHandleException = false;
                    }
                    if (!bDoWeNeedToHandleException) break block16;
                    this.handleExceptions(se);
                    _bError = true;
                }
            }
            if (_bError) {
                _sb_test.append("Statement (run) " + i + " failed with error message:\n" + _sb_stmt.toString());
                _sb_stmt.delete(0, _sb_stmt.length() - 1);
                _bError = false;
                if (!_bTestFailed) {
                    _bTestFailed = true;
                }
            }
            ++i;
        }
        if (_bTestFailed) {
            this.addMessage(LoaderTestInterpreter.getTestClassId(), 'E', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "; phase = run\n" + _sb_test.toString());
            rc = -1;
        }
        return rc;
    }

    private int LoaderTest_Cleanup(ArrayList CleanupStmtArray) {
        int rc = 0;
        int NoOfStmts = CleanupStmtArray.size();
        StatementBean LoaderStmt = null;
        int i = 0;
        while (i < NoOfStmts) {
            try {
                LoaderStmt = (StatementBean)CleanupStmtArray.get(i);
                this.mLoader.cmd(LoaderStmt.getCallString());
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
            ++i;
        }
        return rc;
    }
}

