/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.wisconsin;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.MutableDBDescProperties;
import com.sap.sapdb.benchmark.common.PropertyContainer;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.Session;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.User;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestStatementMonitor;
import com.sap.sapdb.testframe.driver.TestStatementMonitorException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Execute;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class WisconsinBenchmark
extends TestCase
implements PropertyContainer {
    public static final String VERSION = "2.0";
    private static final int STRINGLEN = 52;
    private static final int MIDCHARPOS = 27;
    private static final int FILLLENGTH = 200;
    private static final int MAX_FILLLENGTH = 250;
    private static final int MAXNOSTATEMENTS = 500;
    private static final int MAXSTMT_GROUPS = 120;
    private static final int MAX_NUMBER_ROWS = 100000;
    private static final int MAX_NUMBER_STRING_ROWS = 250;
    private static final int NO_INT_ATTRIBUTES = 15;
    private static final int NO_OF_CHAR = 16;
    private static final long STARTING_AT = 55L;
    private static final long COUNT_THOUSAND = 1000L;
    private static final int MAX_RAND_TRIES = 3;
    private static final int NO_DIFF_CHARS = 22;
    private static StringBuffer mBasisstring = new StringBuffer(53);
    private static StringBuffer mAlphabet = new StringBuffer(27);
    private static String mFillValue = "";
    private static String mUpdFillValue = "";
    private static String[] string4 = new String[4];
    private static char[] tempstrng = new char[52];
    private static long[][] mStorage = new long[100000][15];
    private static String[] mCharStorage = new String[100000];
    private static int mNumberOfRows;
    private static int mNumberOfStringRows;
    public static int mTraceLevel;
    private static String mUserType;
    private static boolean mTraceOn;
    private static String mHostName;
    private static int mTestNumber;
    private TestStatementMonitor mMonitor = null;
    private Connection mExclusiveConnection = null;
    private TestStatement mExclusiveStatement = null;
    private int mStatementTaskId = 0;
    private Connection mPrepExclusiveConnection = null;
    private TestPreparedStatement mPrepExclusiveStatement = null;
    private int mPrepStatementTaskId = 0;
    private Connection mMeasureConnection = null;
    private TestStatement mMeasureStatement = null;
    private Connection mMainConnection = null;
    private TestStatement mMainStatement = null;
    private long mRememberRuntime;
    private Random mRandomGenerator = new Random();
    private static final String mExUser = "WISCONSIN";
    private static final String mExPassword = "WISCONSIN";
    private DBM mDBMan = null;
    private Properties mDefResult;
    private Properties mOneResultRecord;
    private Properties[] mResults = new Properties[500];
    private int mTestRunId = 0;
    private int mStatementCounter = 0;
    private String mStmtDescription = "";
    private static TestDatabaseSap mTestDB;
    private static DBDescription mDbdescription;
    private static ServerNode mServernode;
    private static String mKernelVersion;

    static {
        mUserType = null;
        mTestNumber = 0;
        mTestDB = null;
        mDbdescription = null;
        mServernode = null;
    }

    public static long getTimeout() {
        return 0L;
    }

    public static void prepare() throws TestCaseException {
    }

    private void alterTables() {
        try {
            this.mMainStatement.executeUpdate("ALTER TABLE ONEKTUP  ADD PRIMARY KEY (UNIQUE2A)");
            this.mMainStatement.executeUpdate("ALTER TABLE TENKTUP1 ADD PRIMARY KEY (UNIQUE2B)");
            this.mMainStatement.executeUpdate("ALTER TABLE TENKTUP2 ADD PRIMARY KEY (UNIQUE2C)");
            this.mMainStatement.execute("COMMIT");
            WisconsinBenchmark.printInfo(2, "alterTables()", "Define primary keys for benchmark tables");
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"alterTables()", (char)'E', (String)("SQLException: " + se.getClass() + se.getMessage()));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block13: {
            try {
                try {
                    WisconsinBenchmark.mTraceLevel = WisconsinBenchmark.getParameterInt((String)"TraceLevel", (int)2);
                    WisconsinBenchmark.mTraceOn = WisconsinBenchmark.getParameterBoolean((String)"TraceOn", (boolean)false);
                    WisconsinBenchmark.mUserType = WisconsinBenchmark.getParameterString((String)"benchmark.case.user", (String)System.getProperty("user.name"));
                    WisconsinBenchmark.printInfo(1, "WisconsinBenchmark", "*************************************************");
                    WisconsinBenchmark.printInfo(1, "WisconsinBenchmark", "Starting WisconsinBenchmark - Version: 2.0");
                    WisconsinBenchmark.printInfo(1, "WisconsinBenchmark", "*************************************************");
                    WisconsinBenchmark.printInfo(2, "WisconsinBenchmark", "TraceLevel    = " + WisconsinBenchmark.mTraceLevel);
                    WisconsinBenchmark.printInfo(2, "WisconsinBenchmark", "TraceOn       = " + WisconsinBenchmark.mTraceOn + "\n");
                    WisconsinBenchmark.printInfo(2, "WisconsinBenchmark", "TestUser      = " + WisconsinBenchmark.mUserType + "\n");
                    this.setStatus("Creating DB users and connections");
                    this.startUp();
                    this.mDefResult = new Properties();
                    this.storeDefInPTS();
                    this.setStatus("Creating benchmark tables");
                    this.createTables();
                    this.setStatus("Preparing table entries");
                    this.prepareInsertData();
                    if (WisconsinBenchmark.mTraceOn) {
                        this.executeDBMCmd("util_connect");
                        this.executeDBMCmd("util_execute diagnose vtrace default on");
                        this.executeDBMCmd("util_execute diagnose vtrace object on");
                        this.executeDBMCmd("util_execute diagnose check pages on");
                        this.executeDBMCmd("util_execute diagnose vtrace time on");
                        this.executeDBMCmd("util_release");
                    }
                    this.setStatus("Filling table ONEKTUP");
                    WisconsinBenchmark.mNumberOfRows = 10000;
                    this.mStmtDescription = "Filling table ONEKTUP with " + WisconsinBenchmark.mNumberOfRows + " records         ";
                    this.fillTable("ONEKTUP", 100);
                    this.setStatus("Filling table TENKTUP1");
                    WisconsinBenchmark.mNumberOfRows = 100000;
                    this.mStmtDescription = "Filling table TENKTUP1 with " + WisconsinBenchmark.mNumberOfRows + " records         ";
                    this.fillTable("TENKTUP1", 101);
                    this.setStatus("Filling table TENKTUP2");
                    WisconsinBenchmark.mNumberOfRows = 100000;
                    this.mStmtDescription = "Filling table TENKTUP2 with " + WisconsinBenchmark.mNumberOfRows + " records         ";
                    this.fillTable("TENKTUP2", 102);
                    this.setStatus("1 % selection");
                    this.mStmtDescription = "1 % selection - no index (tscan)                  ";
                    this.selOneTOneF(792900L, 892800L, "TENKTUP1", "UNIQUE2B", "B", 1);
                    this.selOneTOneF(473700L, 573600L, "TENKTUP2", "UNIQUE2C", "C", 1);
                    this.selOneTOneF(431800L, 531700L, "TENKTUP1", "UNIQUE2B", "B", 1);
                    this.selOneTOneF(117500L, 217400L, "TENKTUP2", "UNIQUE2C", "C", 1);
                    this.selOneTOneF(613900L, 713800L, "TENKTUP1", "UNIQUE2B", "B", 1);
                    this.selOneTOneF(394400L, 494300L, "TENKTUP2", "UNIQUE2C", "C", 1);
                    this.selOneTOneF(154600L, 254500L, "TENKTUP1", "UNIQUE2B", "B", 1);
                    this.selOneTOneF(686800L, 786700L, "TENKTUP2", "UNIQUE2C", "C", 1);
                    this.selOneTOneF(683300L, 783200L, "TENKTUP1", "UNIQUE2B", "B", 1);
                    this.selOneTOneF(298800L, 398700L, "TENKTUP2", "UNIQUE2C", "C", 1);
                    this.setStatus("10 % selection");
                    this.mStmtDescription = "10 % selection - no index (tscan)                 ";
                    this.selOneTOneF(7698000L, 8697900L, "TENKTUP1", "UNIQUE2B", "B", 2);
                    this.selOneTOneF(2708000L, 3707900L, "TENKTUP2", "UNIQUE2C", "C", 2);
                    this.selOneTOneF(4431000L, 5430900L, "TENKTUP1", "UNIQUE2B", "B", 2);
                    this.selOneTOneF(6441000L, 7440900L, "TENKTUP2", "UNIQUE2C", "C", 2);
                    this.selOneTOneF(7593000L, 8592900L, "TENKTUP1", "UNIQUE2B", "B", 2);
                    this.selOneTOneF(7853000L, 8852900L, "TENKTUP2", "UNIQUE2C", "C", 2);
                    this.selOneTOneF(5911000L, 6910900L, "TENKTUP1", "UNIQUE2B", "B", 2);
                    this.selOneTOneF(7488000L, 8487900L, "TENKTUP2", "UNIQUE2C", "C", 2);
                    this.selOneTOneF(6325000L, 7324900L, "TENKTUP1", "UNIQUE2B", "B", 2);
                    this.selOneTOneF(5793000L, 6792900L, "TENKTUP2", "UNIQUE2C", "C", 2);
                    this.setStatus("10 % selection/join");
                    this.mStmtDescription = "JoinAselB: 10 % selection/join - no index (tscan) ";
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE2B", "UNIQUE2C", "", 1, 9);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE2B", "UNIQUE2C", "", 2, 9);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE2B", "UNIQUE2C", "", 3, 9);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE2B", "UNIQUE2C", "", 4, 9);
                    this.setStatus("Create table BPRIME");
                    this.mStmtDescription = "create table BPRIME                               ";
                    this.createTableBPrime(99);
                    this.setStatus("10 % selection/join");
                    this.mStmtDescription = "JoinABprime: 10 % sel/join - no index (tscan, range cond. for key)";
                    this.selMultiTMultiF("TENKTUP1", "BPRIME", "", "UNIQUE2B", "UNIQUE2C", "", 5, 10);
                    this.selMultiTMultiF("TENKTUP2", "BPRIME", "", "UNIQUE2C", "UNIQUE2C", "", 5, 10);
                    this.selMultiTMultiF("TENKTUP1", "BPRIME", "", "UNIQUE2B", "UNIQUE2C", "", 6, 10);
                    this.selMultiTMultiF("TENKTUP2", "BPRIME", "", "UNIQUE2C", "UNIQUE2C", "", 6, 10);
                    this.setStatus("10 % selection/join");
                    this.mStmtDescription = "JoinCselAselB: 10 % sel/join - no index (tscan)";
                    this.selMultiTMultiF("ONEKTUP", "TENKTUP1", "TENKTUP2", "UNIQUE2A", "UNIQUE2B", "UNIQUE2C", 7, 11);
                    this.selMultiTMultiF("ONEKTUP", "TENKTUP2", "TENKTUP1", "UNIQUE2A", "UNIQUE2C", "UNIQUE2B", 7, 11);
                    this.selMultiTMultiF("TENKTUP2", "ONEKTUP", "TENKTUP1", "UNIQUE2C", "UNIQUE2A", "UNIQUE2B", 8, 11);
                    this.selMultiTMultiF("TENKTUP1", "ONEKTUP", "TENKTUP2", "UNIQUE2B", "UNIQUE2A", "UNIQUE2C", 8, 11);
                    this.setStatus("1 % projection");
                    this.mStmtDescription = "1 % projection - no index (tscan)                 ";
                    this.selProjection("TENKTUP1", "THOUSANDB", 18);
                    this.selProjection("TENKTUP2", "THOUSANDC", 18);
                    this.selProjection("TENKTUP1", "THOUSANDB", 18);
                    this.selProjection("TENKTUP2", "THOUSANDC", 18);
                    this.setStatus("100 % projection");
                    this.mStmtDescription = "100 % projection - no index (tscan)               ";
                    this.selProjection("TENKTUP1", "*", 19);
                    this.selProjection("TENKTUP2", "*", 19);
                    this.selProjection("TENKTUP1", "*", 19);
                    this.selProjection("TENKTUP2", "*", 19);
                    this.setStatus("MIN, MAX aggregation");
                    this.mStmtDescription = "MIN, MAX aggregation - no index (tscan)           ";
                    this.selAggregate("MIN", "TENKTUP1", "UNIQUE2B", "", 20);
                    this.selAggregate("MIN", "TENKTUP2", "UNIQUE2C", "", 20);
                    this.selAggregate("MAX", "TENKTUP1", "UNIQUE2B", "", 20);
                    this.selAggregate("MAX", "TENKTUP2", "UNIQUE2C", "", 20);
                    this.mStmtDescription = "MIN, MAX aggregation group by - no index (tscan)  ";
                    this.selAggregate("MIN", "TENKTUP1", "UNIQUE2B", "THOUSANDB", 21);
                    this.selAggregate("MIN", "TENKTUP2", "UNIQUE2C", "THOUSANDC", 21);
                    this.selAggregate("MAX", "TENKTUP1", "UNIQUE2B", "THOUSANDB", 21);
                    this.selAggregate("MAX", "TENKTUP2", "UNIQUE2C", "THOUSANDC", 21);
                    this.setStatus("SUM aggregation");
                    this.mStmtDescription = "SUM aggregation group by - no index (tscan)       ";
                    this.selAggregate("SUM", "TENKTUP1", "UNIQUE2B", "EVEN100B", 22);
                    this.selAggregate("SUM", "TENKTUP2", "UNIQUE2C", "EVEN100C", 22);
                    this.selAggregate("SUM", "TENKTUP1", "UNIQUE2B", "ODD100B", 22);
                    this.selAggregate("SUM", "TENKTUP2", "UNIQUE2C", "ODD100C", 22);
                    this.setStatus("INSERT 1 tuple");
                    this.mStmtDescription = "INSERT 1 tuple - no index                         ";
                    this.insertOne(10000001L, "TENKTUP1", 26);
                    this.insertOne(10000001L, "TENKTUP2", 26);
                    this.insertOne(10000002L, "TENKTUP1", 26);
                    this.insertOne(10000002L, "TENKTUP2", 26);
                    this.insertOne(10000003L, "TENKTUP1", 26);
                    this.insertOne(10000003L, "TENKTUP2", 26);
                    this.insertOne(10000004L, "TENKTUP1", 26);
                    this.insertOne(10000004L, "TENKTUP2", 26);
                    this.insertOne(10000005L, "TENKTUP1", 26);
                    this.insertOne(10000005L, "TENKTUP2", 26);
                    this.setStatus("DELETE 1 tuple");
                    this.mStmtDescription = "DELETE 1 tuple - no index                         ";
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000001L, 27);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000001L, 27);
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000002L, 27);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000002L, 27);
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000003L, 27);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000003L, 27);
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000004L, 27);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000004L, 27);
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000005L, 27);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000005L, 27);
                    this.setStatus("UPDATE 1 tuple");
                    this.mStmtDescription = "UPDATE 1 tuple - no index                         ";
                    this.updateOne("TENKTUP1", "UNIQUE2B", 396900L, 10000001L, 28);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 396900L, 10000001L, 28);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 579900L, 10000002L, 28);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 579900L, 10000002L, 28);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 673900L, 10000003L, 28);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 673900L, 10000003L, 28);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 409800L, 10000004L, 28);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 409800L, 10000004L, 28);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 845700L, 10000005L, 28);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 845700L, 10000005L, 28);
                    this.setStatus("Reverse previous UPDATES");
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000001L, 396900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000001L, 396900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000002L, 579900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000002L, 579900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000003L, 673900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000003L, 673900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000004L, 409800L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000004L, 409800L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000005L, 845700L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000005L, 845700L, -1);
                    this.setStatus("Add primary keys");
                    this.alterTables();
                    this.setStatus("Create INDICES");
                    this.mStmtDescription = "Create index                                      ";
                    this.createOneIndex("TENKTUP1", "TK1UQ1", "UNIQUE1B", "", 103);
                    this.createOneIndex("TENKTUP1", "TK1THOUS", "THOUSANDB", "", 103);
                    this.createOneIndex("TENKTUP2", "TK2UQ1", "UNIQUE1C", "", 103);
                    this.createOneIndex("TENKTUP2", "TK2THOUS", "THOUSANDC", "", 103);
                    this.setStatus("1 % selection");
                    this.mStmtDescription = "1 % selection - key (range cond. for key)         ";
                    this.selOneTOneF(792900L, 892800L, "TENKTUP1", "UNIQUE2B", "B", 3);
                    this.selOneTOneF(473700L, 573600L, "TENKTUP2", "UNIQUE2C", "C", 3);
                    this.selOneTOneF(431800L, 531700L, "TENKTUP1", "UNIQUE2B", "B", 3);
                    this.selOneTOneF(117500L, 217400L, "TENKTUP2", "UNIQUE2C", "C", 3);
                    this.selOneTOneF(613900L, 713800L, "TENKTUP1", "UNIQUE2B", "B", 3);
                    this.selOneTOneF(394400L, 494300L, "TENKTUP2", "UNIQUE2C", "C", 3);
                    this.selOneTOneF(154600L, 254500L, "TENKTUP1", "UNIQUE2B", "B", 3);
                    this.selOneTOneF(686800L, 786700L, "TENKTUP2", "UNIQUE2C", "C", 3);
                    this.selOneTOneF(683300L, 783200L, "TENKTUP1", "UNIQUE2B", "B", 3);
                    this.selOneTOneF(298800L, 398700L, "TENKTUP2", "UNIQUE2C", "C", 3);
                    this.setStatus("10 % selection");
                    this.mStmtDescription = "10 % selection - key (range cond. for key)        ";
                    this.selOneTOneF(7698000L, 8697900L, "TENKTUP1", "UNIQUE2B", "B", 4);
                    this.selOneTOneF(2708000L, 3707900L, "TENKTUP2", "UNIQUE2C", "C", 4);
                    this.selOneTOneF(4431000L, 5430900L, "TENKTUP1", "UNIQUE2B", "B", 4);
                    this.selOneTOneF(6441000L, 7440900L, "TENKTUP2", "UNIQUE2C", "C", 4);
                    this.selOneTOneF(7593000L, 8592900L, "TENKTUP1", "UNIQUE2B", "B", 4);
                    this.selOneTOneF(7853000L, 8852900L, "TENKTUP2", "UNIQUE2C", "C", 4);
                    this.selOneTOneF(5911000L, 6910900L, "TENKTUP1", "UNIQUE2B", "B", 4);
                    this.selOneTOneF(7488000L, 8487900L, "TENKTUP2", "UNIQUE2C", "C", 4);
                    this.selOneTOneF(6325000L, 7324900L, "TENKTUP1", "UNIQUE2B", "B", 4);
                    this.selOneTOneF(5793000L, 6792900L, "TENKTUP2", "UNIQUE2C", "C", 4);
                    this.setStatus("1 % selection");
                    this.mStmtDescription = "1 % selection - index (range cond. for index)     ";
                    this.selOneTOneF(7929L, 8928L, "TENKTUP1", "UNIQUE1B", "B", 5);
                    this.selOneTOneF(4737L, 5736L, "TENKTUP2", "UNIQUE1C", "C", 5);
                    this.selOneTOneF(4318L, 5317L, "TENKTUP1", "UNIQUE1B", "B", 5);
                    this.selOneTOneF(1175L, 2174L, "TENKTUP2", "UNIQUE1C", "C", 5);
                    this.selOneTOneF(6139L, 7138L, "TENKTUP1", "UNIQUE1B", "B", 5);
                    this.selOneTOneF(3944L, 4943L, "TENKTUP2", "UNIQUE1C", "C", 5);
                    this.selOneTOneF(1546L, 2545L, "TENKTUP1", "UNIQUE1B", "B", 5);
                    this.selOneTOneF(6868L, 7867L, "TENKTUP2", "UNIQUE1C", "C", 5);
                    this.selOneTOneF(6833L, 7832L, "TENKTUP1", "UNIQUE1B", "B", 5);
                    this.selOneTOneF(2988L, 3987L, "TENKTUP2", "UNIQUE1C", "C", 5);
                    this.setStatus("10 % selection");
                    this.mStmtDescription = "10 % selection - index (range cond. for index)    ";
                    this.selOneTOneF(76980L, 86979L, "TENKTUP1", "UNIQUE1B", "B", 6);
                    this.selOneTOneF(27080L, 37079L, "TENKTUP2", "UNIQUE1C", "C", 6);
                    this.selOneTOneF(44310L, 54309L, "TENKTUP1", "UNIQUE1B", "B", 6);
                    this.selOneTOneF(64410L, 74409L, "TENKTUP2", "UNIQUE1C", "C", 6);
                    this.selOneTOneF(75930L, 85929L, "TENKTUP1", "UNIQUE1B", "B", 6);
                    this.selOneTOneF(78530L, 88529L, "TENKTUP2", "UNIQUE1C", "C", 6);
                    this.selOneTOneF(59110L, 69109L, "TENKTUP1", "UNIQUE1B", "B", 6);
                    this.selOneTOneF(74880L, 84879L, "TENKTUP2", "UNIQUE1C", "C", 6);
                    this.selOneTOneF(63250L, 73249L, "TENKTUP1", "UNIQUE1B", "B", 6);
                    this.selOneTOneF(57930L, 67929L, "TENKTUP2", "UNIQUE1C", "C", 6);
                    this.setStatus("10 % selection/join");
                    this.mStmtDescription = "JoinAselB: 10 % sel/join - key (tscan, join via key)";
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE2B", "UNIQUE2C", "", 1, 12);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE2B", "UNIQUE2C", "", 2, 12);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE2B", "UNIQUE2C", "", 3, 12);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE2B", "UNIQUE2C", "", 4, 12);
                    this.setStatus("10 % select/join");
                    this.mStmtDescription = "JoinAselB: 10 % sel/join - index (tscan, join via idx.)";
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE1B", "UNIQUE1C", "", 1, 15);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE1B", "UNIQUE1C", "", 2, 15);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE1B", "UNIQUE1C", "", 3, 15);
                    this.selMultiTMultiF("TENKTUP1", "TENKTUP2", "", "UNIQUE1B", "UNIQUE1C", "", 4, 15);
                    this.setStatus("10 % select/join");
                    this.mStmtDescription = "JoinABprime: 10 % sel/join - key (tscan bprime, join via key)";
                    this.selMultiTMultiF("TENKTUP1", "BPRIME", "", "UNIQUE2B", "UNIQUE2C", "", 5, 13);
                    this.selMultiTMultiF("TENKTUP2", "BPRIME", "", "UNIQUE2C", "UNIQUE2C", "", 5, 13);
                    this.selMultiTMultiF("TENKTUP1", "BPRIME", "", "UNIQUE2B", "UNIQUE2C", "", 6, 13);
                    this.selMultiTMultiF("TENKTUP2", "BPRIME", "", "UNIQUE2C", "UNIQUE2C", "", 6, 13);
                    this.setStatus("10 % selectivity: sel/join");
                    this.mStmtDescription = "JoinABprime: 10 % sel/join - index (tscan bprime, join via idx.)";
                    this.selMultiTMultiF("TENKTUP1", "BPRIME", "", "UNIQUE1B", "UNIQUE1C", "", 5, 16);
                    this.selMultiTMultiF("TENKTUP2", "BPRIME", "", "UNIQUE1C", "UNIQUE1C", "", 5, 16);
                    this.selMultiTMultiF("TENKTUP1", "BPRIME", "", "UNIQUE1B", "UNIQUE1C", "", 6, 16);
                    this.selMultiTMultiF("TENKTUP2", "BPRIME", "", "UNIQUE1C", "UNIQUE1C", "", 6, 16);
                    this.setStatus("10 % select/join");
                    this.mStmtDescription = "JoinCselAselB: 10 % sel/join - idx./key (tscan, join via idx./key)";
                    this.selMultiTMultiF("ONEKTUP", "TENKTUP1", "TENKTUP2", "UNIQUE2A", "UNIQUE2B", "UNIQUE2C", 7, 14);
                    this.selMultiTMultiF("ONEKTUP", "TENKTUP2", "TENKTUP1", "UNIQUE2A", "UNIQUE2C", "UNIQUE2B", 7, 14);
                    this.selMultiTMultiF("TENKTUP2", "ONEKTUP", "TENKTUP1", "UNIQUE2C", "UNIQUE2A", "UNIQUE2B", 8, 14);
                    this.selMultiTMultiF("TENKTUP1", "ONEKTUP", "TENKTUP2", "UNIQUE2B", "UNIQUE2A", "UNIQUE2C", 8, 14);
                    this.setStatus("10 % select/join");
                    this.mStmtDescription = "JoinCselAselB: 10 % sel/join - index (ts, 2x join via idx.)";
                    this.selMultiTMultiF("ONEKTUP", "TENKTUP1", "TENKTUP2", "UNIQUE1A", "UNIQUE1B", "UNIQUE1C", 7, 17);
                    this.selMultiTMultiF("ONEKTUP", "TENKTUP2", "TENKTUP1", "UNIQUE1A", "UNIQUE1C", "UNIQUE1B", 7, 17);
                    this.selMultiTMultiF("TENKTUP2", "ONEKTUP", "TENKTUP1", "UNIQUE1C", "UNIQUE1A", "UNIQUE1B", 8, 17);
                    this.selMultiTMultiF("TENKTUP1", "ONEKTUP", "TENKTUP2", "UNIQUE1B", "UNIQUE1A", "UNIQUE1C", 8, 17);
                    this.setStatus("MIN, MAX");
                    this.mStmtDescription = "MIN, MAX aggregation - key (tscan)                ";
                    this.selAggregate("MIN", "TENKTUP1", "UNIQUE2B", "", 23);
                    this.selAggregate("MIN", "TENKTUP2", "UNIQUE2C", "", 23);
                    this.selAggregate("MAX", "TENKTUP1", "UNIQUE2B", "", 23);
                    this.selAggregate("MAX", "TENKTUP2", "UNIQUE2C", "", 23);
                    this.mStmtDescription = "MIN, MAX aggr. group by - key/index (index scan)  ";
                    this.selAggregate("MIN", "TENKTUP1", "UNIQUE2B", "THOUSANDB", 24);
                    this.selAggregate("MIN", "TENKTUP2", "UNIQUE2C", "THOUSANDC", 24);
                    this.selAggregate("MAX", "TENKTUP1", "UNIQUE2B", "THOUSANDB", 24);
                    this.selAggregate("MAX", "TENKTUP2", "UNIQUE2C", "THOUSANDC", 24);
                    this.setStatus("SUM");
                    this.mStmtDescription = "SUM aggregation group by - key/index (tscan)      ";
                    this.selAggregate("SUM", "TENKTUP1", "UNIQUE2B", "EVEN100B", 25);
                    this.selAggregate("SUM", "TENKTUP2", "UNIQUE2C", "EVEN100C", 25);
                    this.selAggregate("SUM", "TENKTUP1", "UNIQUE2B", "ODD100B", 25);
                    this.selAggregate("SUM", "TENKTUP2", "UNIQUE2C", "ODD100C", 25);
                    this.setStatus("INSERT");
                    this.mStmtDescription = "INSERT 1 tuple                                    ";
                    this.insertOne(10000001L, "TENKTUP1", 29);
                    this.insertOne(10000001L, "TENKTUP2", 29);
                    this.insertOne(10000002L, "TENKTUP1", 29);
                    this.insertOne(10000002L, "TENKTUP2", 29);
                    this.insertOne(10000003L, "TENKTUP1", 29);
                    this.insertOne(10000003L, "TENKTUP2", 29);
                    this.insertOne(10000004L, "TENKTUP1", 29);
                    this.insertOne(10000004L, "TENKTUP2", 29);
                    this.insertOne(10000005L, "TENKTUP1", 29);
                    this.insertOne(10000005L, "TENKTUP2", 29);
                    this.setStatus("DELETE");
                    this.mStmtDescription = "DELETE 1 tuple - key                              ";
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000001L, 30);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000001L, 30);
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000002L, 30);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000002L, 30);
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000003L, 30);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000003L, 30);
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000004L, 30);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000004L, 30);
                    this.deleteOne("TENKTUP1", "UNIQUE2B", 10000005L, 30);
                    this.deleteOne("TENKTUP2", "UNIQUE2C", 10000005L, 30);
                    this.setStatus("UPDATE");
                    this.mStmtDescription = "UPDATE 1 tuple - key                              ";
                    this.updateOne("TENKTUP1", "UNIQUE2B", 396900L, 10000001L, 31);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 396900L, 10000001L, 31);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 579900L, 10000002L, 31);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 579900L, 10000002L, 31);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 673900L, 10000003L, 31);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 673900L, 10000003L, 31);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 409800L, 10000004L, 31);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 409800L, 10000004L, 31);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 845700L, 10000005L, 31);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 845700L, 10000005L, 31);
                    this.setStatus("Reverse UPDATES");
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000001L, 396900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000001L, 396900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000002L, 579900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000002L, 579900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000003L, 673900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000003L, 673900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000004L, 409800L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000004L, 409800L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE2B", 10000005L, 845700L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE2C", 10000005L, 845700L, -1);
                    this.setStatus("UPDATE");
                    this.mStmtDescription = "UPDATE 1 tuple - index                            ";
                    this.updateOne("TENKTUP1", "UNIQUE1B", 396900L, 10000001L, 32);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 396900L, 10000001L, 32);
                    this.updateOne("TENKTUP1", "UNIQUE1B", 579900L, 10000002L, 32);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 579900L, 10000002L, 32);
                    this.updateOne("TENKTUP1", "UNIQUE1B", 673900L, 10000003L, 32);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 673900L, 10000003L, 32);
                    this.updateOne("TENKTUP1", "UNIQUE1B", 409800L, 10000004L, 32);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 409800L, 10000004L, 32);
                    this.updateOne("TENKTUP1", "UNIQUE1B", 845700L, 10000005L, 32);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 845700L, 10000005L, 32);
                    this.setStatus("Reverse UPDATES");
                    this.updateOne("TENKTUP1", "UNIQUE1B", 10000001L, 396900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 10000001L, 396900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE1B", 10000002L, 579900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 10000002L, 579900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE1B", 10000003L, 673900L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 10000003L, 673900L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE1B", 10000004L, 409800L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 10000004L, 409800L, -1);
                    this.updateOne("TENKTUP1", "UNIQUE1B", 10000005L, 845700L, -1);
                    this.updateOne("TENKTUP2", "UNIQUE1C", 10000005L, 845700L, -1);
                    this.setStatus("Drop INDICES");
                    this.mStmtDescription = "Drop index                                        ";
                    this.dropOneIndex("TENKTUP1", "TK1UQ1", 104);
                    this.dropOneIndex("TENKTUP1", "TK1THOUS", 104);
                    this.dropOneIndex("TENKTUP2", "TK2UQ1", 104);
                    this.dropOneIndex("TENKTUP2", "TK2THOUS", 104);
                    this.writeResultsToPTS();
                    this.writeResultsToProtocol();
                    WisconsinBenchmark.addGlobalMessage((String)"run()", (char)'I', (String)"End of measurements! ");
                }
                catch (Exception e) {
                    WisconsinBenchmark.addGlobalMessage((String)"Method run", (char)'E', (String)("Exception: " + e.getClass() + e.getMessage()));
                    System.out.println("Method run Exception: " + e.getClass() + e.getMessage());
                }
            }
            catch (Throwable var3_2) {
                var2_3 = null;
                try {
                    this.mMainStatement.close();
                    this.mExclusiveStatement.close();
                    this.mMeasureStatement.close();
                    this.mPrepExclusiveStatement.close();
                    StorableObject.closeConnection();
                }
                catch (Exception var4_5) {
                    // empty catch block
                }
                try {
                    this.mMainConnection.commit();
                    this.mMainConnection.close();
                    this.mExclusiveConnection.commit();
                    this.mExclusiveConnection.close();
                    this.mMeasureConnection.commit();
                    this.mMeasureConnection.close();
                    this.mPrepExclusiveConnection.commit();
                    this.mPrepExclusiveConnection.close();
                    StorableObject.closeConnection();
                    throw var3_2;
                }
                catch (Exception var4_5) {
                    // empty catch block
                }
                throw var3_2;
            }
            {
                var2_4 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 5301->5335)] { 
lbl388:
            // 1 sources

            this.mMainStatement.close();
            this.mExclusiveStatement.close();
            this.mMeasureStatement.close();
            this.mPrepExclusiveStatement.close();
            StorableObject.closeConnection();
            break block13;
lbl394:
            // 1 sources

            catch (Exception var4_6) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var4_6) {
            return;
        }
        this.mMainConnection.commit();
        this.mMainConnection.close();
        this.mExclusiveConnection.commit();
        this.mExclusiveConnection.close();
        this.mMeasureConnection.commit();
        this.mMeasureConnection.close();
        this.mPrepExclusiveConnection.commit();
        this.mPrepExclusiveConnection.close();
        StorableObject.closeConnection();
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + WisconsinBenchmark.getTestClassId());
    }

    public static String getTestClassId() {
        return "WisconsinBenchmark";
    }

    private void createTables() {
        try {
            this.mMainStatement.executeUpdate("CREATE TABLE ONEKTUP (UNIQUE2A  FIXED (12),     UNIQUE1A   FIXED (11),  TWOA      FIXED (1),     FOURA      FIXED (1), TENA      FIXED (1),     TWENTYA    FIXED (2), HUNDREDA  FIXED (3),     THOUSANDA  FIXED (3), TWOTHOUSA FIXED (4),     FIVETHOUSA FIXED (4), TENTHOUSA FIXED (4),     ODD100A    FIXED (10), EVEN100A  FIXED (10), STRINGLA  CHAR (16),     STRINGU1A  CHAR (52), STRINGU2A CHAR (52),     STRING4A   CHAR (52), FILLERA   CHAR (250),    UPDFILLA   CHAR (250))");
            this.mMainStatement.executeUpdate("CREATE TABLE TENKTUP1 (UNIQUE2B  FIXED (12),     UNIQUE1B   FIXED (11), TWOB      FIXED (1),     FOURB      FIXED (1), TENB      FIXED (1),     TWENTYB    FIXED (2), HUNDREDB  FIXED (3),     THOUSANDB  FIXED (3), TWOTHOUSB FIXED (4),     FIVETHOUSB FIXED (4), TENTHOUSB FIXED (4),     ODD100B    FIXED (10), EVEN100B  FIXED (10), STRINGLB  CHAR (16),     STRINGU1B  CHAR (52), STRINGU2B CHAR (52),     STRING4B   CHAR (52), FILLERB   CHAR (250),    UPDFILLB   CHAR (250))");
            this.mMainStatement.executeUpdate("CREATE TABLE TENKTUP2 (UNIQUE2C  FIXED (12),     UNIQUE1C   FIXED (11), TWOC      FIXED (1),     FOURC      FIXED (1), TENC      FIXED (1),     TWENTYC    FIXED (2), HUNDREDC  FIXED (3),     THOUSANDC  FIXED (3), TWOTHOUSC FIXED (4),     FIVETHOUSC FIXED (4), TENTHOUSC FIXED (4),     ODD100C    FIXED (10), EVEN100C  FIXED (10), STRINGLC  CHAR (16),     STRINGU1C  CHAR (52), STRINGU2C CHAR (52),     STRING4C   CHAR (52), FILLERC   CHAR (250),    UPDFILLC   CHAR (250))");
            this.mMainStatement.executeUpdate("CREATE TABLE RESULTS (QUERY_NO FIXED (4),  STMT_CNT FIXED(4), STMT_DESCRIPTION VARCHAR(100),  METHOD_NAME VARCHAR(32),  DATE_TIME TIMESTAMP DEFAULT TIMESTAMP, RUN_TIME FIXED (20),  CPU_TIME FIXED (20), READIO FIXED(7), WRITEIO FIXED(7), RESULTCNT FIXED(20), VALUES_OK BOOLEAN DEFAULT FALSE)");
            WisconsinBenchmark.printInfo(2, "createTables()", "Creating benchmark tables");
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"createTables()", (char)'E', (String)("SQLException: " + se.getClass() + se.getMessage()));
        }
    }

    private void createTableBPrime(int pQueryNo) {
        String lSqlString = "";
        int lCPUTime = 0;
        int lResCount = 10000;
        try {
            this.mMainStatement.executeUpdate("CREATE TABLE BPRIME (UNIQUE2C  FIXED (12),     UNIQUE1C   FIXED (11), TWOC      FIXED (1),     FOURC      FIXED (1), TENC      FIXED (1),     TWENTYC    FIXED (2), HUNDREDC  FIXED (3),     THOUSANDC  FIXED (3), TWOTHOUSC FIXED (4),     FIVETHOUSC FIXED (4), TENTHOUSC FIXED (4),     ODD100C    FIXED (10), EVEN100C  FIXED (10), STRINGLC  CHAR (16),     STRINGU1C  CHAR (52), STRINGU2C CHAR (52),     STRING4C   CHAR (52), FILLERC   CHAR (250),    UPDFILLC   CHAR (250), PRIMARY KEY (UNIQUE2C))");
            this.mMainStatement.execute("commit");
            lSqlString = "INSERT INTO BPRIME SELECT * FROM TENKTUP2 WHERE TENKTUP2.UNIQUE2C < 1000000 ";
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            this.mPrepExclusiveStatement.execute();
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("createTableBPRIME", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "createTableBPRIME()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"createTableBPRIME()", (char)'E', (String)("ERROR during CREATE or INSERT: " + e.getClass() + e.getMessage()));
        }
    }

    private void fillTable(String pTableName, int pQueryNo) {
        String lSqlString = "";
        int lCPUTime = 0;
        this.fillColumn(1, mNumberOfRows);
        this.fillColumn(2, 2);
        this.fillColumn(3, 4);
        this.fillColumn(4, 10);
        this.fillColumn(5, 20);
        this.fillColumn(6, 100);
        this.fillColumn(7, 1000);
        this.fillColumn(8, 2000);
        this.fillColumn(9, 5000);
        this.fillColumn(10, 10000);
        this.fillColumn(11, 50);
        this.fillColumn(12, 50);
        this.fillColumn(13, 4);
        this.fillLikeColumn(22);
        try {
            lSqlString = "insert " + pTableName + " values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            int k = 0;
            while (k <= mNumberOfRows - 1) {
                this.mPrepExclusiveStatement.setLong(1, (long)(k * 100));
                this.mPrepExclusiveStatement.setLong(2, mStorage[k][0]);
                this.mPrepExclusiveStatement.setLong(3, mStorage[k][1]);
                this.mPrepExclusiveStatement.setLong(4, mStorage[k][2]);
                this.mPrepExclusiveStatement.setLong(5, mStorage[k][3]);
                this.mPrepExclusiveStatement.setLong(6, mStorage[k][4]);
                this.mPrepExclusiveStatement.setLong(7, mStorage[k][5]);
                this.mPrepExclusiveStatement.setLong(8, mStorage[k][6]);
                this.mPrepExclusiveStatement.setLong(9, mStorage[k][7]);
                this.mPrepExclusiveStatement.setLong(10, mStorage[k][8]);
                this.mPrepExclusiveStatement.setLong(11, mStorage[k][9]);
                this.mPrepExclusiveStatement.setLong(12, mStorage[k][10] * 2L + 1L);
                this.mPrepExclusiveStatement.setLong(13, mStorage[k][11] * 2L);
                this.mPrepExclusiveStatement.setString(14, mCharStorage[k]);
                StringBuffer lUniqueString = WisconsinBenchmark.getScalableUniqueString((int)mStorage[k][0]);
                this.mPrepExclusiveStatement.setString(15, lUniqueString.toString());
                lUniqueString = WisconsinBenchmark.getScalableUniqueString(k);
                this.mPrepExclusiveStatement.setString(16, lUniqueString.toString());
                this.mPrepExclusiveStatement.setString(17, string4[k % 4]);
                this.mPrepExclusiveStatement.setString(18, mFillValue);
                this.mPrepExclusiveStatement.setString(19, " ");
                this.mPrepExclusiveStatement.execute();
                if ((k + 1) % mNumberOfRows == 0) {
                    this.mPrepExclusiveConnection.commit();
                }
                ++k;
            }
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("Ins" + pTableName, pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, mNumberOfRows, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "fillTable()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)("fillTable(" + pTableName + ")"), (char)'E', (String)("ERROR: " + e.getClass() + e.getMessage()));
        }
    }

    public void deleteOne(String pTab, String pFieldName, long pFieldVal, int pQueryNo) {
        String lSqlString = "";
        try {
            int lResCount = 1;
            lSqlString = "DELETE FROM " + pTab + " WHERE " + pFieldName + " = " + pFieldVal;
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            this.mPrepExclusiveStatement.executeUpdate();
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            int lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("deleteOne", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "deleteOne()", String.valueOf(this.mStmtDescription) + "Runtime " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"deleteOne()", (char)'E', (String)("ERROR during DELETE: " + e.getClass() + e.getMessage()));
            System.out.println("deleteOne() -- ERROR during DELETE: " + e.getClass() + e.getMessage());
        }
    }

    private void selProjection(String pTab, String pField, int pQueryNo) {
        String lSqlString = "";
        int lCPUTime = 0;
        int lResCount = 0;
        ResultSet rs = null;
        try {
            String lEnding1 = "";
            if (pField == "*") {
                if (pTab == "TENKTUP1") {
                    lEnding1 = "B";
                } else if (pTab == "TENKTUP2") {
                    lEnding1 = "C";
                } else {
                    WisconsinBenchmark.printInfo(2, "selProjection()", "Wrong table name used in projection!");
                }
            }
            lSqlString = "SELECT DISTINCT " + pField + " FROM   " + pTab;
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            rs = this.mPrepExclusiveStatement.executeQuery();
            while (rs.next()) {
                if (pField.length() == 1) {
                    rs.getLong("UNIQUE2" + lEnding1);
                    rs.getLong("UNIQUE1" + lEnding1);
                    rs.getLong("TWO" + lEnding1);
                    rs.getLong("FOUR" + lEnding1);
                    rs.getLong("TEN" + lEnding1);
                    rs.getLong("TWENTY" + lEnding1);
                    rs.getLong("HUNDRED" + lEnding1);
                    rs.getLong("THOUSAND" + lEnding1);
                    rs.getLong("TWOTHOUS" + lEnding1);
                    rs.getLong("FIVETHOUS" + lEnding1);
                    rs.getLong("TENTHOUS" + lEnding1);
                    rs.getLong("ODD100" + lEnding1);
                    rs.getLong("EVEN100" + lEnding1);
                    rs.getString("STRINGU1" + lEnding1);
                    rs.getString("STRINGU2" + lEnding1);
                    rs.getString("STRING4" + lEnding1);
                    rs.getString("FILLER" + lEnding1);
                }
                if (pField.length() > 1) {
                    rs.getLong(pField);
                }
                ++lResCount;
            }
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("selProjection", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "selProjection()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"selProjection()", (char)'E', (String)("ERROR during FETCH: " + e.getClass() + e.getMessage()));
            System.out.println("WisconsinBenchmark: selProjection() -- ERROR during FETCH: " + e.getClass() + e.getMessage());
        }
    }

    private void tenkt1Insert(long pUnique2, long pUnique1) {
        String lSqlString = "INSERT INTO TENKTUP1 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ' ')";
        try {
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.mPrepExclusiveStatement.setLong(1, pUnique2);
            this.mPrepExclusiveStatement.setLong(2, pUnique1);
            this.mPrepExclusiveStatement.setLong(3, 0L);
            this.mPrepExclusiveStatement.setLong(4, 0L);
            this.mPrepExclusiveStatement.setLong(5, 0L);
            this.mPrepExclusiveStatement.setLong(6, 0L);
            this.mPrepExclusiveStatement.setLong(7, 0L);
            this.mPrepExclusiveStatement.setLong(8, 0L);
            this.mPrepExclusiveStatement.setLong(9, 0L);
            this.mPrepExclusiveStatement.setLong(10, 0L);
            this.mPrepExclusiveStatement.setLong(11, 0L);
            this.mPrepExclusiveStatement.setLong(12, 1L);
            this.mPrepExclusiveStatement.setLong(13, 2L);
            this.mPrepExclusiveStatement.setString(14, "lStringl");
            this.mPrepExclusiveStatement.setString(15, "lStringu1");
            this.mPrepExclusiveStatement.setString(16, "lStringu2");
            this.mPrepExclusiveStatement.setString(17, "lString4");
            this.mPrepExclusiveStatement.setString(18, "mFillValue");
            this.mPrepExclusiveStatement.executeUpdate();
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"tenkt1Insert()", (char)'E', (String)("ERROR during INSERT: " + se.getClass() + se.getMessage()));
            System.out.println("tenkt1Insert() -- ERROR during INSERT: " + se.getClass() + se.getMessage());
        }
    }

    private void tenkt1Seldir(long pUnique2) {
        String lSqlString = "SELECT * FROM TENKTUP1 WHERE UNIQUE2B = " + pUnique2;
        try {
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            ResultSet rs = this.mPrepExclusiveStatement.executeQuery();
            while (rs.next()) {
                rs.getLong("UNIQUE2B");
                rs.getLong("UNIQUE1B");
                rs.getLong("TWOB");
                rs.getLong("FOURB");
                rs.getLong("TENB");
                rs.getLong("TWENTYB");
                rs.getLong("HUNDREDB");
                rs.getLong("THOUSANDB");
                rs.getLong("TWOTHOUSB");
                rs.getLong("FIVETHOUSB");
                rs.getLong("TENTHOUSB");
                rs.getLong("ODD100B");
                rs.getLong("EVEN100B");
                rs.getString("STRINGLB");
                rs.getString("STRINGU1B");
                rs.getString("STRINGU2B");
                rs.getString("STRING4B");
                rs.getString("FILLERB");
            }
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"tenkt1Seldir()", (char)'E', (String)("ERROR during SELECT: " + se.getClass() + se.getMessage()));
            System.out.println("tenkt1Seldir() -- ERROR during SELECT: " + se.getClass() + se.getMessage());
        }
    }

    private void tenkt1Update(long pUnique2, long pUnique1, long pHundred, String pString4) {
        String lSqlString = "UPDATE TENKTUP1 SET UNIQUE1B = " + pUnique1 + ", HUNDREDB = " + pHundred + ", STRING4B = '" + pString4 + "' WHERE UNIQUE2B = " + pUnique2;
        try {
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.mPrepExclusiveStatement.executeUpdate();
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"tenkt1Update()", (char)'E', (String)("ERROR during UPDATE: " + se.getClass() + se.getMessage()));
            System.out.println("tenkt1Update() -- ERROR during UPDATE: " + se.getClass() + se.getMessage());
        }
    }

    private void tenkt1Delete(long pUnique2) {
        String lSqlString = "DELETE FROM TENKTUP1 WHERE UNIQUE2B = " + pUnique2;
        try {
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.mPrepExclusiveStatement.executeUpdate();
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"tenkt1Delete()", (char)'E', (String)("ERROR during DELETE: " + se.getClass() + se.getMessage()));
            System.out.println("tenkt1Delete() -- ERROR during DELETE: " + se.getClass() + se.getMessage());
        }
    }

    private void updateOne(String pTab, String pFieldName, long pFieldVal, long pNewVal, int pQueryNo) {
        String lSqlString = "";
        try {
            int lResCount = 1;
            lSqlString = "UPDATE " + pTab + " SET " + pFieldName + " = " + pNewVal + " WHERE " + pFieldName + " = " + pFieldVal;
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            this.mPrepExclusiveStatement.executeUpdate();
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            int lCPUTime = this.mMonitor.getCPUTime() / 1000;
            if (pQueryNo != -1) {
                this.storeResultsInJava("updateOne", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            }
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "updateOne()", String.valueOf(this.mStmtDescription) + "Runtime " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"updateOne()", (char)'E', (String)("ERROR during UPDATE: " + e.getClass() + e.getMessage()));
            System.out.println("updateOne() -- ERROR during UPDATE: " + e.getClass() + e.getMessage());
        }
    }

    private void selOneTOneF(long pBeginRange, long pEndRange, String pTable, String pField, String pEnding, int pQueryNo) {
        String lSqlString = "";
        int lCPUTime = 0;
        int lResCount = 0;
        ResultSet rs = null;
        try {
            lSqlString = "SELECT * FROM   " + pTable + " WHERE " + pTable + "." + pField + " BETWEEN " + pBeginRange + " AND " + pEndRange;
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            rs = this.mPrepExclusiveStatement.executeQuery();
            while (rs.next()) {
                rs.getLong("UNIQUE2" + pEnding);
                rs.getLong("UNIQUE1" + pEnding);
                rs.getLong("TWO" + pEnding);
                rs.getLong("FOUR" + pEnding);
                rs.getLong("TEN" + pEnding);
                rs.getLong("TWENTY" + pEnding);
                rs.getLong("HUNDRED" + pEnding);
                rs.getLong("THOUSAND" + pEnding);
                rs.getLong("TWOTHOUS" + pEnding);
                rs.getLong("FIVETHOUS" + pEnding);
                rs.getLong("TENTHOUS" + pEnding);
                rs.getLong("ODD100" + pEnding);
                rs.getLong("EVEN100" + pEnding);
                rs.getString("STRINGU1" + pEnding);
                rs.getString("STRINGU2" + pEnding);
                rs.getString("STRING4" + pEnding);
                rs.getString("FILLER" + pEnding);
                ++lResCount;
            }
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("selOneTOneF", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "selOneTOneF()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"selOneTOneF()", (char)'E', (String)("ERROR during FETCH: " + e.getClass() + e.getMessage()));
            System.out.println("WisconsinBenchmark: selOneTOneF() -- ERROR during FETCH: " + e.getClass() + e.getMessage());
        }
    }

    private void selMultiTMultiF(String pTab1, String pTab2, String pTab3, String pField1, String pField2, String pField3, int pCallNo, int pQueryNo) {
        String lSqlString = "";
        int lCPUTime = 0;
        int lResCount = 0;
        ResultSet rs = null;
        try {
            String lEnding1 = pField1.substring(pField1.length() - 1, pField1.length());
            String lEnding2 = pField2.substring(pField2.length() - 1, pField2.length());
            String lEnding3 = "";
            if (pField3.length() != 0) {
                lEnding3 = pField3.substring(pField3.length() - 1, pField3.length());
            }
            if (pCallNo == 1) {
                lSqlString = "SELECT  * FROM   " + pTab1 + ", " + pTab2 + " WHERE (" + pTab1 + "." + pField1 + " = " + pTab2 + "." + pField2 + ") AND  (" + pTab2 + "." + pField2 + " < 1000000 )";
            }
            if (pCallNo == 2) {
                lSqlString = "SELECT * FROM   " + pTab1 + ", " + pTab2 + " WHERE (" + pTab2 + "." + pField2 + " = " + pTab1 + "." + pField1 + ") AND  (" + pTab2 + "." + pField2 + " < 1000000 )";
            }
            if (pCallNo == 3) {
                lSqlString = "SELECT * FROM   " + pTab1 + ", " + pTab2 + " WHERE (" + pTab1 + "." + pField1 + " = " + pTab2 + "." + pField2 + ") AND  (" + pTab1 + "." + pField1 + " < 1000000 )";
            }
            if (pCallNo == 4) {
                lSqlString = "SELECT * FROM   " + pTab1 + ", " + pTab2 + " WHERE (" + pTab2 + "." + pField2 + " = " + pTab1 + "." + pField1 + ") AND  (" + pTab1 + "." + pField1 + " < 1000000 )";
            }
            if (pCallNo == 5) {
                lSqlString = "SELECT * FROM   " + pTab1 + ", " + pTab2 + " WHERE (" + pTab1 + "." + pField1 + " = " + pTab2 + "." + pField2 + ")";
            }
            if (pCallNo == 6) {
                lSqlString = "SELECT * FROM   " + pTab1 + ", " + pTab2 + " WHERE (" + pTab2 + "." + pField2 + " = " + pTab1 + "." + pField1 + ")";
            }
            if (pCallNo == 7) {
                lSqlString = "SELECT * FROM   " + pTab1 + ", " + pTab2 + ", " + pTab3 + " WHERE (" + pTab1 + "." + pField1 + " = " + pTab2 + "." + pField2 + ")" + " AND   (" + pTab2 + "." + pField2 + " = " + pTab3 + "." + pField3 + ")" + " AND   (" + pTab2 + "." + pField2 + " < 1000000 )";
            }
            if (pCallNo == 8) {
                lSqlString = "SELECT * FROM   " + pTab1 + ", " + pTab2 + ", " + pTab3 + " WHERE (" + pTab1 + "." + pField1 + " = " + pTab2 + "." + pField2 + ")" + " AND   (" + pTab2 + "." + pField2 + " = " + pTab3 + "." + pField3 + ")" + " AND   (" + pTab3 + "." + pField3 + " < 1000000 )";
            }
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            rs = this.mPrepExclusiveStatement.executeQuery();
            while (rs.next()) {
                rs.getLong("UNIQUE2" + lEnding1);
                rs.getLong("UNIQUE1" + lEnding1);
                rs.getLong("TWO" + lEnding1);
                rs.getLong("FOUR" + lEnding1);
                rs.getLong("TEN" + lEnding1);
                rs.getLong("TWENTY" + lEnding1);
                rs.getLong("HUNDRED" + lEnding1);
                rs.getLong("THOUSAND" + lEnding1);
                rs.getLong("TWOTHOUS" + lEnding1);
                rs.getLong("FIVETHOUS" + lEnding1);
                rs.getLong("TENTHOUS" + lEnding1);
                rs.getLong("ODD100" + lEnding1);
                rs.getLong("EVEN100" + lEnding1);
                rs.getString("STRINGU1" + lEnding1);
                rs.getString("STRINGU2" + lEnding1);
                rs.getString("STRING4" + lEnding1);
                rs.getString("FILLER" + lEnding1);
                rs.getLong("UNIQUE2" + lEnding2);
                rs.getLong("UNIQUE1" + lEnding2);
                rs.getLong("TWO" + lEnding2);
                rs.getLong("FOUR" + lEnding2);
                rs.getLong("TEN" + lEnding2);
                rs.getLong("TWENTY" + lEnding2);
                rs.getLong("HUNDRED" + lEnding2);
                rs.getLong("THOUSAND" + lEnding2);
                rs.getLong("TWOTHOUS" + lEnding2);
                rs.getLong("FIVETHOUS" + lEnding2);
                rs.getLong("TENTHOUS" + lEnding2);
                rs.getLong("ODD100" + lEnding2);
                rs.getLong("EVEN100" + lEnding2);
                rs.getString("STRINGU1" + lEnding2);
                rs.getString("STRINGU2" + lEnding2);
                rs.getString("STRING4" + lEnding2);
                rs.getString("FILLER" + lEnding2);
                if (pTab3.length() != 0) {
                    rs.getLong("UNIQUE2" + lEnding3);
                    rs.getLong("UNIQUE1" + lEnding3);
                    rs.getLong("TWO" + lEnding3);
                    rs.getLong("FOUR" + lEnding3);
                    rs.getLong("TEN" + lEnding3);
                    rs.getLong("TWENTY" + lEnding3);
                    rs.getLong("HUNDRED" + lEnding3);
                    rs.getLong("THOUSAND" + lEnding3);
                    rs.getLong("TWOTHOUS" + lEnding3);
                    rs.getLong("FIVETHOUS" + lEnding3);
                    rs.getLong("TENTHOUS" + lEnding3);
                    rs.getLong("ODD100" + lEnding3);
                    rs.getLong("EVEN100" + lEnding3);
                    rs.getString("STRINGU1" + lEnding3);
                    rs.getString("STRINGU2" + lEnding3);
                    rs.getString("STRING4" + lEnding3);
                    rs.getString("FILLER" + lEnding3);
                }
                ++lResCount;
            }
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("selMultiTMultiF", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "selMultiTMultiF()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"selMultiTMultiF()", (char)'E', (String)("ERROR during FETCH: " + e.getClass() + e.getMessage()));
            System.out.println("selMultiTMultiF() -- ERROR during FETCH: " + e.getClass() + e.getMessage());
        }
    }

    private void selAggregate(String pAggrFct, String pTab, String pFieldSel, String pFieldGrp, int pQueryNo) {
        String lSqlString = "";
        int lCPUTime = 0;
        int lResCount = 0;
        ResultSet rs = null;
        try {
            lSqlString = "SELECT " + pAggrFct + " (" + pTab + "." + pFieldSel + ") FROM   " + pTab;
            if (pFieldGrp != "") {
                lSqlString = String.valueOf(lSqlString) + " group by " + pTab + "." + pFieldGrp;
            }
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            rs = this.mPrepExclusiveStatement.executeQuery();
            while (rs.next()) {
                rs.getLong("EXPRESSION1");
                ++lResCount;
            }
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("selAggregate", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "selAggregate()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"selAggregate()", (char)'E', (String)("ERROR during FETCH: " + e.getClass() + e.getMessage()));
            System.out.println("selAggregate() -- ERROR during FETCH: " + e.getClass() + e.getMessage());
        }
    }

    private String paddTo(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return String.valueOf(str) + new String(ca);
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    private void writeResultsToPTS() {
        String lColumn = "";
        String lValue = "";
        long lQueryNo = 0L;
        long lAvgRuntime = 0L;
        long lAvgCPUTime = 0L;
        long lAvgReadIO = 0L;
        long lAvgWriteIO = 0L;
        String lStmtDesc = "";
        int lExecutionCount = 0;
        String lSql = "";
        Enumeration<?> lContentsOneRecord = null;
        Statement lStmt = null;
        try {
            lStmt = StorableObject.getConnection().createStatement();
            int i = 0;
            while (i <= this.mStatementCounter) {
                if (this.mResults[i] != null) {
                    Properties lOneResultRecord = (Properties)this.mResults[i].clone();
                    lContentsOneRecord = lOneResultRecord.propertyNames();
                    lSql = "INSERT wisc_results set ";
                    while (lContentsOneRecord.hasMoreElements()) {
                        lColumn = lContentsOneRecord.nextElement();
                        lValue = lOneResultRecord.getProperty(lColumn.toString());
                        lSql = String.valueOf(lSql) + lColumn + " = " + lValue + ", ";
                    }
                    lSql = lSql.substring(0, lSql.length() - 2);
                    lStmt.executeUpdate(lSql);
                    StorableObject.getConnection().commit();
                    lSql = "";
                }
                ++i;
            }
            int j = 0;
            while (j <= 120) {
                ResultSet rs = this.mMainStatement.executeQuery("SELECT * FROM RESULTS WHERE QUERY_NO = " + j);
                while (rs.next()) {
                    lQueryNo = rs.getLong("QUERY_NO");
                    lStmtDesc = rs.getString("STMT_DESCRIPTION");
                    lAvgRuntime += rs.getLong("RUN_TIME");
                    lAvgCPUTime += rs.getLong("CPU_TIME");
                    lAvgReadIO += rs.getLong("READIO");
                    lAvgWriteIO += rs.getLong("WRITEIO");
                    rs.getLong("RESULTCNT");
                    if (!rs.getBoolean("VALUES_OK")) continue;
                    ++lExecutionCount;
                }
                if (lExecutionCount != 0) {
                    lSql = "INSERT wisc_result_summary set testrun_id = " + this.mTestRunId + ", query_no = " + lQueryNo + ", stmt_description = '" + lStmtDesc + "', avg_runtime = " + (lAvgRuntime /= (long)lExecutionCount) + ", avg_cputime = " + (lAvgCPUTime /= (long)lExecutionCount) + ", avg_readio = " + (lAvgReadIO /= (long)lExecutionCount) + ", avg_writeio = " + (lAvgWriteIO /= (long)lExecutionCount) + ", number_executions = " + lExecutionCount;
                    lStmt.executeUpdate(lSql);
                    StorableObject.getConnection().commit();
                }
                lSql = "";
                lExecutionCount = 0;
                lAvgRuntime = 0L;
                lAvgCPUTime = 0L;
                lAvgReadIO = 0L;
                lAvgWriteIO = 0L;
                ++j;
            }
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"writeResultsToPTS()", (char)'E', (String)("ERROR while storing results: " + e.getClass() + e.getMessage()));
            System.out.println("writeResultsToPTS() -- ERROR while storing results: " + e.getClass() + e.getMessage());
        }
    }

    private void writeResultsToProtocol() {
        long lQueryNo = 0L;
        long lResultCnt = 0L;
        long lAvgRuntime = 0L;
        long lAvgCPUTime = 0L;
        long lAvgReadIO = 0L;
        long lAvgWriteIO = 0L;
        String lStmtDesc = "";
        int lExecutionCount = 0;
        StringBuffer lOutString = new StringBuffer();
        try {
            lOutString.append("MACHINE INFO: CPUs       : " + this.mDefResult.getProperty("cpu_count".toString()) + "\n");
            lOutString.append("                 Main Memory: " + this.mDefResult.getProperty("main_memory".toString()) + " KB \n");
            lOutString.append("----------------------------------------------------------- \n");
            lOutString.append("RESULT SUMMAY: \n");
            lOutString.append("----------------------------------------------------------------------------------------------------------------- \n");
            lOutString.append("query    statement description                       runtime (ms) cputime (ms) readIO  writeIO  # execs  # records \n");
            lOutString.append("----------------------------------------------------------------------------------------------------------------- \n");
            int j = 0;
            while (j <= 120) {
                ResultSet rs = this.mMainStatement.executeQuery("SELECT * FROM RESULTS WHERE QUERY_NO = " + j);
                while (rs.next()) {
                    lQueryNo = rs.getLong("QUERY_NO");
                    lStmtDesc = rs.getString("STMT_DESCRIPTION");
                    lAvgRuntime += rs.getLong("RUN_TIME");
                    lAvgCPUTime += rs.getLong("CPU_TIME");
                    lAvgReadIO += rs.getLong("READIO");
                    lAvgWriteIO += rs.getLong("WRITEIO");
                    lResultCnt = rs.getLong("RESULTCNT");
                    ++lExecutionCount;
                }
                if (lExecutionCount != 0) {
                    lAvgRuntime /= (long)lExecutionCount;
                    lAvgCPUTime /= (long)lExecutionCount;
                    lAvgReadIO /= (long)lExecutionCount;
                    lAvgWriteIO /= (long)lExecutionCount;
                    this.toString();
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.paddToRightJustified(String.valueOf(lQueryNo), 3))).append("   ").append(this.paddTo(lStmtDesc, 45));
                    this.toString();
                    StringBuffer stringBuffer2 = stringBuffer.append(this.paddToRightJustified(String.valueOf(lAvgRuntime), 12));
                    this.toString();
                    StringBuffer stringBuffer3 = stringBuffer2.append(this.paddToRightJustified(String.valueOf(lAvgCPUTime), 13));
                    this.toString();
                    StringBuffer stringBuffer4 = stringBuffer3.append(this.paddToRightJustified(String.valueOf(lAvgReadIO), 8));
                    this.toString();
                    StringBuffer stringBuffer5 = stringBuffer4.append(this.paddToRightJustified(String.valueOf(lAvgWriteIO), 8));
                    this.toString();
                    StringBuffer stringBuffer6 = stringBuffer5.append(this.paddToRightJustified(String.valueOf(lExecutionCount), 9));
                    this.toString();
                    lOutString.append(stringBuffer6.append(this.paddToRightJustified(String.valueOf(lResultCnt), 8)).append("\n").toString());
                }
                lExecutionCount = 0;
                lAvgRuntime = 0L;
                lAvgCPUTime = 0L;
                lAvgReadIO = 0L;
                lAvgWriteIO = 0L;
                lResultCnt = 0L;
                ++j;
            }
            WisconsinBenchmark.printInfo(2, "RESULT SUMMARY: ", lOutString.toString());
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"writeResultsToProtocol()", (char)'E', (String)("ERROR: " + e.getClass() + e.getMessage()));
            System.out.println("writeResultsToProtocol() -- ERROR: " + e.getClass() + e.getMessage());
        }
    }

    private void insertChar250(String pFillString250, int pQueryNo) {
        String lSqlString = "";
        int lResCount = 0;
        int lCPUTime = 0;
        try {
            lResCount = 0;
            lSqlString = "INSERT INTO CHAR250 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            long lTitle = 1L;
            while (lTitle <= (long)mNumberOfStringRows) {
                this.mPrepExclusiveStatement.setLong(1, lTitle);
                this.mPrepExclusiveStatement.setString(2, pFillString250);
                this.mPrepExclusiveStatement.setString(3, pFillString250);
                this.mPrepExclusiveStatement.setString(4, pFillString250);
                this.mPrepExclusiveStatement.setString(5, pFillString250);
                this.mPrepExclusiveStatement.setString(6, pFillString250);
                this.mPrepExclusiveStatement.setString(7, pFillString250);
                this.mPrepExclusiveStatement.setString(8, pFillString250);
                this.mPrepExclusiveStatement.setString(9, pFillString250);
                this.mPrepExclusiveStatement.setString(10, pFillString250);
                this.mPrepExclusiveStatement.setString(11, pFillString250);
                this.mPrepExclusiveStatement.setString(12, pFillString250);
                this.mPrepExclusiveStatement.setString(13, pFillString250);
                this.mPrepExclusiveStatement.setString(14, pFillString250);
                this.mPrepExclusiveStatement.setString(15, pFillString250);
                this.mPrepExclusiveStatement.setString(16, pFillString250);
                this.mPrepExclusiveStatement.setString(17, pFillString250);
                this.mPrepExclusiveStatement.executeUpdate();
                ++lResCount;
                ++lTitle;
            }
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("insertChar250", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "insertChar250()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"insertChar250()", (char)'E', (String)("ERROR during INSERT: " + e.getClass() + e.getMessage()));
            System.out.println("insertChar250() -- ERROR during INSERT: " + e.getClass() + e.getMessage());
        }
    }

    private void insertChar4000(String plFillString4000, int pQueryNo) {
        String lSqlString = "";
        int lResCount = 0;
        int lCPUTime = 0;
        try {
            lResCount = 0;
            lSqlString = "INSERT INTO CHAR4000 VALUES (?, ?)";
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            long lTitle = 1L;
            while (lTitle <= (long)mNumberOfStringRows) {
                this.mPrepExclusiveStatement.setLong(1, lTitle);
                this.mPrepExclusiveStatement.setString(2, plFillString4000);
                this.mPrepExclusiveStatement.executeUpdate();
                ++lResCount;
                ++lTitle;
            }
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("insertChar4000", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "insertChar4000()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"insertChar4000()", (char)'E', (String)("ERROR during INSERT: " + e.getClass() + e.getMessage()));
            System.out.println("insertChar4000() -- ERROR during INSERT: " + e.getClass() + e.getMessage());
        }
    }

    private void insertOne(long pUnique2, String pTab, int pQueryNo) {
        String lSqlString = "";
        String lStringl = "ABCDEFGHIJKLMNOP";
        String lStringu1 = "MxxxxxxxxxxxxxxxxxxxxxxxxxGxxxxxxxxxxxxxxxxxxxxxxxxC";
        String lStringu2 = "GxxxxxxxxxxxxxxxxxxxxxxxxxCxxxxxxxxxxxxxxxxxxxxxxxxA";
        String lString4 = "OxxxxxxxxxxxxxxxxxxxxxxxxxOxxxxxxxxxxxxxxxxxxxxxxxxO";
        try {
            int lResCount = 1;
            lSqlString = "INSERT INTO " + pTab + " VALUES (" + pUnique2 + ", 10100, 0, 2, 5, 10, 68, 688, 1950, 4950, 9950, 1, 100, '" + lStringl + "', '" + lStringu1 + "', '" + lStringu2 + "', '" + lString4 + "', ' ', ' ')";
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            this.mPrepExclusiveStatement.executeUpdate();
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            int lCPUTime = this.mMonitor.getCPUTime() / 1000;
            lSqlString = "INSERT INTO " + pTab + " VALUES (" + pUnique2 + ", 10100, 0, 2, 5, 10, 68, 688, 1950, 4950, 9950, 1, 100, ...)";
            this.storeResultsInJava("insertOne", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "insertOne()", String.valueOf(this.mStmtDescription) + "Runtime " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"insertOne()", (char)'E', (String)("ERROR during INSERT: " + e.getClass() + e.getMessage()));
            System.out.println("insertOne() -- ERROR during INSERT: " + e.getClass() + e.getMessage());
        }
    }

    private void insertString(String pTable, int pQueryNo) {
        String lSqlString = "";
        int lLength = 0;
        String lShort = "";
        int lResCount = 0;
        int lCPUTime = 0;
        try {
            if (pTable == "STRING4000") {
                lLength = 4000;
                lShort = "4K";
            } else if (pTable == "STRING64k") {
                lLength = 65536;
                lShort = "64K";
            } else if (pTable == "STRING1MB") {
                lLength = 0x100000;
                lShort = "1MB";
            }
            lResCount = 0;
            lSqlString = "INSERT INTO " + pTable + " VALUES (?, ?)";
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            long lTitle = 1L;
            while (lTitle <= (long)mNumberOfStringRows) {
                this.mPrepExclusiveStatement.setLong(1, lTitle);
                this.mPrepExclusiveStatement.setAsciiStream(2, (InputStream)new AsciiStream(lLength), lLength);
                this.mPrepExclusiveStatement.executeUpdate();
                ++lResCount;
                ++lTitle;
            }
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("insertString_" + lShort, pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "insertString()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"insertString()", (char)'E', (String)("ERROR during INSERT: " + e.getClass() + e.getMessage()));
            System.out.println("insertString() -- ERROR during INSERT: " + e.getClass() + e.getMessage());
        }
    }

    private void prepareInsertData() {
        int i = 0;
        while (i <= 51) {
            mBasisstring = mBasisstring.append("x");
            ++i;
        }
        i = 0;
        while (i <= 199) {
            mFillValue = String.valueOf(mFillValue) + "x";
            ++i;
        }
        i = 0;
        while (i <= 3) {
            mBasisstring.setCharAt(0, (char)(65 + i * 7));
            mBasisstring.setCharAt(26, (char)(65 + i * 7));
            mBasisstring.setCharAt(51, (char)(65 + i * 7));
            WisconsinBenchmark.string4[i] = mBasisstring.toString();
            ++i;
        }
        mAlphabet.append("ABCDEFGHIJKLMNOPQRSTUV");
        WisconsinBenchmark.printInfo(2, "prepareInsertData()", ": Preparing data to be INSERTed");
    }

    public void createOneIndex(String pTableName, String pIndexName, String pColumn, String pUniqueInd, int pQueryNo) {
        int lCPUTime = 0;
        try {
            String lSqlString = "CREATE " + pUniqueInd + " INDEX " + pIndexName + " ON " + pTableName + " (" + pColumn + ")";
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            this.mPrepExclusiveStatement.execute();
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("indx" + pIndexName, pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, 1, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "createOneIndex()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"createOneIndex()", (char)'E', (String)("createOneIndex() method failed with SQLException: " + se.getClass() + se.getMessage()));
        }
        catch (TestStatementMonitorException tsme) {
            WisconsinBenchmark.addGlobalMessage((String)"createOneIndex()", (char)'E', (String)("createOneIndex() method failed with TestStatementMonitorException: " + ((Object)((Object)tsme)).getClass() + tsme.getMessage()));
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"createOneIndex()", (char)'E', (String)("createOneIndex() method failed with Exception: " + e.getClass() + e.getMessage()));
        }
    }

    public void dropOneIndex(String pTableName, String pIndexName, int pQueryNo) {
        int lCPUTime = 0;
        try {
            String lSqlString = "DROP INDEX " + pIndexName;
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            this.mPrepExclusiveStatement.execute();
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("dropIndx_" + pIndexName, pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, 1, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            WisconsinBenchmark.printInfo(2, "dropOneIndex()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"dropOneIndex()", (char)'E', (String)("dropOneIndex() method failed with SQLException: " + se.getClass() + se.getMessage()));
        }
        catch (TestStatementMonitorException tsme) {
            WisconsinBenchmark.addGlobalMessage((String)"dropOneIndex()", (char)'E', (String)("dropOneIndex() method failed with TestStatementMonitorException: " + ((Object)((Object)tsme)).getClass() + tsme.getMessage()));
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"dropOneIndex()", (char)'E', (String)("dropOneIndex() method failed with Exception: " + e.getClass() + e.getMessage()));
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = WisconsinBenchmark.getDatabase().getHost();
            mName = WisconsinBenchmark.getDatabase().getName();
            int mPort = WisconsinBenchmark.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"executeDBMCmd()", (char)'W', (String)("Problem with command '" + pCmd + "' --> Exception: " + e.getMessage() + "\n" + e.getClass()));
            return "error";
        }
    }

    public String getHostname() {
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        ProcessOutput.setLength(0);
        String currentCmd = "uname -n";
        SystemProcess = new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
        if (SystemProcess.getExitValue() == 0 && ProcessOutput.length() != 0) {
            String hostName = ProcessOutput.toString().trim().toLowerCase();
            return hostName;
        }
        ProcessOutput.setLength(0);
        currentCmd = "hostname";
        SystemProcess = new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
        if (SystemProcess.getExitValue() == 0 && ProcessOutput.length() != 0) {
            String hostName = ProcessOutput.toString().trim().toLowerCase();
            return hostName;
        }
        return "unknown";
    }

    private void startUp() {
        try {
            mHostName = mTestDriverOptions.getProperty("DBHost");
            this.mMainConnection = WisconsinBenchmark.getDatabase().connect(WisconsinBenchmark.getUser(), WisconsinBenchmark.getPassword());
            this.mMainStatement = new TestStatement(null, this.mMainConnection);
            this.mMainStatement.enableExceptions(false);
            this.mMainStatement.executeUpdate("Drop user WISCONSIN");
            this.mMainStatement.executeUpdateIgnoreErrors("Drop table onektup");
            this.mMainStatement.executeUpdateIgnoreErrors("Drop table tenktup1");
            this.mMainStatement.executeUpdateIgnoreErrors("Drop table tenktup2");
            this.mMainStatement.executeUpdateIgnoreErrors("Drop table results");
            this.mMainStatement.enableExceptions(true);
            this.mMainStatement.executeUpdate("Create user WISCONSIN password WISCONSIN dba not exclusive");
            this.mMainStatement.close();
            this.mMainConnection.close();
            this.mMainConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mMainStatement = new TestStatement(null, this.mMainConnection);
            this.mExclusiveConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mExclusiveConnection.setAutoCommit(false);
            this.mExclusiveStatement = new TestStatement(null, this.mExclusiveConnection);
            this.mPrepExclusiveConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mPrepExclusiveConnection.setAutoCommit(false);
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, "select process from dba.transactions, connectparameters where transactions.session = connectparameters.session");
            ResultSet rs = this.mPrepExclusiveStatement.executeQuery();
            if (rs.next()) {
                this.mPrepStatementTaskId = rs.getInt(1);
                WisconsinBenchmark.printInfo(2, "WisconsinBenchmark", "startUp()            : Prepared statements to be measured use task ID: " + this.mPrepStatementTaskId);
            } else {
                WisconsinBenchmark.addGlobalMessage((String)"startUp()", (char)'E', (String)"Cannot determine TASK ID for prepared statements!");
            }
            this.mPrepExclusiveStatement.close();
            this.mMeasureConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mMeasureStatement = new TestStatement(null, this.mMeasureConnection);
            this.mMonitor = new TestStatementMonitor(this.mMeasureConnection, WisconsinBenchmark.getDatabase().getHost(), WisconsinBenchmark.getDatabase().getName(), WisconsinBenchmark.getDatabase().getPort());
            rs = this.mExclusiveStatement.executeQuery("select process from transactions, connectparameters where transactions.session = connectparameters.session");
            if (rs.next()) {
                this.mStatementTaskId = rs.getInt(1);
            }
            WisconsinBenchmark.printInfo(2, "WisconsinBenchmark", "startUp()            : Statements to be measured use task ID: " + this.mStatementTaskId);
            this.mOneResultRecord = new Properties();
            Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
            StorableObject.initConnection("jdbc:sapdb://pts/qadb?user=benchmark&password=benchmark");
            StorableObject.getConnection().setAutoCommit(true);
            StorableObject.getConnection().setReadOnly(true);
            StorableObject.getConnection().setTransactionIsolation(0);
            mTestDB = (TestDatabaseSap)WisconsinBenchmark.getDatabase();
            MutableDBDescProperties dbDescProp = MutableDBDescProperties.getCommonMutableDBDescProperties();
            mDbdescription = DBDescription.getDBDescription(mTestDB.connect(), mTestDB.getKernelBuild(), mTestDB.getKernelVersion(), dbDescProp);
            mServernode = ServerNode.getServerNode(mHostName);
        }
        catch (TestDatabaseException tde) {
            WisconsinBenchmark.addGlobalMessage((String)"startUp()", (char)'E', (String)("startUp() method failed with TestDatabaseException: " + ((Object)((Object)tde)).getClass() + tde.getMessage()));
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"startUp()", (char)'E', (String)("startUp() method failed with SQLException: " + se.getClass() + se.getMessage()));
        }
        catch (TestStatementMonitorException tsme) {
            WisconsinBenchmark.addGlobalMessage((String)"startUp()", (char)'E', (String)("startUp() method failed with TestStatementMonitorException: " + ((Object)((Object)tsme)).getClass() + tsme.getMessage()));
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"startUp()", (char)'E', (String)("startUp() method failed with Exception: " + e.getClass() + e.getMessage()));
        }
    }

    public void reConnect() {
        try {
            this.mMainConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mMainStatement = new TestStatement(null, this.mMainConnection);
            this.mExclusiveConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mExclusiveConnection.setAutoCommit(false);
            this.mExclusiveStatement = new TestStatement(null, this.mExclusiveConnection);
            this.mPrepExclusiveConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mPrepExclusiveConnection.setAutoCommit(false);
            this.mMeasureConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mMeasureStatement = new TestStatement(null, this.mMeasureConnection);
            this.mMonitor = new TestStatementMonitor(this.mMeasureConnection, WisconsinBenchmark.getDatabase().getHost(), WisconsinBenchmark.getDatabase().getName(), WisconsinBenchmark.getDatabase().getPort());
            ResultSet rs = this.mExclusiveStatement.executeQuery("select process from transactions, connectparameters where transactions.session = connectparameters.session");
            if (rs.next()) {
                this.mStatementTaskId = rs.getInt(1);
            }
            WisconsinBenchmark.addGlobalMessage((String)WisconsinBenchmark.getTestClassId(), (char)'I', (String)("Statements to be measured use task ID: " + this.mStatementTaskId));
            WisconsinBenchmark.printInfo(2, "reConnect()", "Reopened connections to database");
        }
        catch (TestDatabaseException tde) {
            WisconsinBenchmark.addGlobalMessage((String)WisconsinBenchmark.getTestClassId(), (char)'E', (String)("reConnect() failed - TestDatabaseException: " + ((Object)((Object)tde)).getClass() + tde.getMessage()));
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)WisconsinBenchmark.getTestClassId(), (char)'E', (String)("reConnect()  failed - SQLException: " + se.getClass() + se.getMessage()));
        }
        catch (TestStatementMonitorException tsme) {
            WisconsinBenchmark.addGlobalMessage((String)WisconsinBenchmark.getTestClassId(), (char)'E', (String)("reConnect() failed - TestStatementMonitorException: " + ((Object)((Object)tsme)).getClass() + tsme.getMessage()));
        }
    }

    public void restartDB() {
        try {
            TestDatabaseSap sapdb = (TestDatabaseSap)WisconsinBenchmark.getDatabase();
            this.executeDBMCmd("db_offline");
            this.executeDBMCmd("db_online -" + sapdb.getKernelMode());
            WisconsinBenchmark.printInfo(2, "restartDB()", "          : Just restarted database");
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"restartDB()", (char)'E', (String)("restartDB() failed: " + e.getClass() + e.getMessage()));
        }
    }

    public void updateStatistics() {
        try {
            this.mMainConnection = WisconsinBenchmark.getDatabase().connect("WISCONSIN", "WISCONSIN");
            this.mMainStatement = new TestStatement(null, this.mMainConnection);
            this.mMainStatement.execute("update statistics WISCONSIN");
            this.mMainStatement.close();
            this.mMainConnection.close();
            WisconsinBenchmark.printInfo(2, "updateStatistics()", "   : UPDATEd STATISTICS for user WISCONSIN");
        }
        catch (TestDatabaseException tde) {
            WisconsinBenchmark.addGlobalMessage((String)"updateStatistics()", (char)'E', (String)("updateStatistics() failed - TestDatabaseException: " + ((Object)((Object)tde)).getClass() + tde.getMessage()));
        }
        catch (SQLException se) {
            WisconsinBenchmark.addGlobalMessage((String)"updateStatistics()", (char)'E', (String)("updateStatistics() failed - SQLException: " + se.getClass() + se.getMessage()));
        }
    }

    private void fillColumn(int pColumn, int pValueRange) {
        int[] lOccurrence = new int[100001];
        int i = 0;
        while (i <= mNumberOfRows) {
            lOccurrence[i] = 0;
            ++i;
        }
        long lMaxSameNumber = pValueRange >= mNumberOfRows ? 1L : (long)((mNumberOfRows - 1) / pValueRange + 1);
        int lRow = 1;
        while (lRow <= mNumberOfRows) {
            long lRandTries = 0L;
            boolean lFound = false;
            int lRandNumber = this.randomInteger(0, pValueRange - 1);
            while (lRandTries < 3L && !lFound) {
                if ((long)lOccurrence[lRandNumber] < lMaxSameNumber) {
                    lFound = true;
                } else {
                    lRandNumber = this.randomInteger(0, pValueRange - 1);
                }
                ++lRandTries;
            }
            while (!lFound) {
                if (++lRandNumber == pValueRange) {
                    lRandNumber = 0;
                }
                if ((long)lOccurrence[lRandNumber] >= lMaxSameNumber) continue;
                lFound = true;
            }
            WisconsinBenchmark.mStorage[lRow - 1][pColumn - 1] = lRandNumber;
            int n = lRandNumber;
            lOccurrence[n] = lOccurrence[n] + 1;
            ++lRow;
        }
    }

    private void fillLikeColumn(int pValueRange) {
        String lString = "";
        int lRandNumber = this.randomInteger(0, pValueRange - 1);
        int row = 1;
        while (row <= mNumberOfRows) {
            int column = 1;
            while (column <= 2) {
                lRandNumber = this.randomInteger(0, 3);
                lString = String.valueOf(lString) + mAlphabet.charAt(lRandNumber);
                ++column;
            }
            column = 3;
            while (column <= 16) {
                lRandNumber = this.randomInteger(0, pValueRange - 1);
                lString = String.valueOf(lString) + mAlphabet.charAt(lRandNumber);
                ++column;
            }
            WisconsinBenchmark.mCharStorage[row - 1] = lString;
            lString = "";
            ++row;
        }
    }

    private static StringBuffer getUniqueString(int pModValue) {
        StringBuffer lUniqueString = new StringBuffer(53);
        lUniqueString = mBasisstring;
        int ind = pModValue % 22 + 1;
        lUniqueString.setCharAt(51, mAlphabet.charAt(ind - 1));
        ind = (pModValue /= 22) % 22 + 1;
        lUniqueString.setCharAt(26, mAlphabet.charAt(ind - 1));
        ind = (pModValue /= 22) % 22 + 1;
        lUniqueString.setCharAt(0, mAlphabet.charAt(ind - 1));
        return lUniqueString;
    }

    public void getMachineInfo() {
        int CPU = 0;
        long MEMORY = 0L;
        String sDevTool = System.getProperty("env.tool");
        if (sDevTool == null) {
            WisconsinBenchmark.printInfo(2, "getMachineInfo()", "Environment variable TOOL not defined.");
        }
        String sFileSep = System.getProperty("file.separator");
        String sCommand = String.valueOf(sDevTool) + sFileSep + "bin" + sFileSep + "machineInfo";
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        SystemProcess = new Execute(sCommand, null, ProcessOutput);
        SystemProcess.exec();
        StringTokenizer st = new StringTokenizer(ProcessOutput.toString());
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase("PROCESSORS:")) continue;
            CPU = new Integer(st.nextToken().toString());
            break;
        }
        if (CPU == 0) {
            WisconsinBenchmark.printInfo(2, "getMachineInfo()", "WARNING: Could not get number of CPUs!");
            CPU = -1;
            this.toString();
            this.mDefResult.setProperty("cpu_count", String.valueOf(CPU));
        } else {
            WisconsinBenchmark.printInfo(2, "getMachineInfo()", "CPU's for this System: " + CPU);
            this.toString();
            this.mDefResult.setProperty("cpu_count", String.valueOf(CPU));
        }
        sCommand = "";
        sCommand = String.valueOf(sDevTool) + sFileSep + "bin" + sFileSep + "machineInfo -T";
        SystemProcess = new Execute(sCommand, null, ProcessOutput);
        SystemProcess.exec();
        st = new StringTokenizer(ProcessOutput.toString());
        if (st.hasMoreTokens() && st.nextToken().equalsIgnoreCase("TOTAL_MEMORY(KBytes):")) {
            String nextOne = st.nextToken();
            MEMORY = nextOne.equalsIgnoreCase("?") ? -1L : (long)new Integer(nextOne.toString()).intValue();
        }
        if (MEMORY == 0L) {
            WisconsinBenchmark.printInfo(2, "getMachineInfo()", "WARNING: Could not get size of MAIN MEMORY!");
            MEMORY = -1L;
            this.toString();
            this.mDefResult.setProperty("main_memory", String.valueOf(MEMORY));
        } else {
            WisconsinBenchmark.printInfo(2, "getMachineInfo()", "MAIN MEMORY on this System: " + MEMORY + " KB");
            this.toString();
            this.mDefResult.setProperty("main_memory", String.valueOf(MEMORY));
        }
    }

    private static StringBuffer getScalableUniqueString(int pModValue) {
        StringBuffer lTemp = new StringBuffer(7).append("AAAAAAA");
        String l45Xes = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        int i = 6;
        int cnt = 0;
        while (pModValue > 0) {
            int rem = pModValue % 26;
            lTemp.setCharAt(i, (char)(65 + rem));
            pModValue /= 26;
            --i;
            ++cnt;
        }
        StringBuffer lUniqueString = new StringBuffer(53).append(lTemp.toString()).append(l45Xes);
        return lUniqueString;
    }

    private void storeResultsInJava(String pTestCase, int pTestNumber, long pRuntime, int pCPUTime, int pReadIO, int pWriteIO, String pSQLString, int pNumberOfRows, int pTaskId, String pStmtDesc) {
        try {
            ++this.mStatementCounter;
            this.toString();
            this.mOneResultRecord.setProperty("testrun_id", String.valueOf(this.mTestRunId));
            this.toString();
            this.mOneResultRecord.setProperty("query_no", String.valueOf(pTestNumber));
            this.toString();
            this.mOneResultRecord.setProperty("stmt_cnt", String.valueOf(this.mStatementCounter));
            this.mOneResultRecord.setProperty("stmt_description", "'" + pStmtDesc + "'");
            this.mOneResultRecord.setProperty("method_name", "'" + pTestCase + "'");
            this.toString();
            this.mOneResultRecord.setProperty("run_time", String.valueOf(pRuntime));
            this.toString();
            this.mOneResultRecord.setProperty("cpu_time", String.valueOf(pCPUTime));
            this.toString();
            this.mOneResultRecord.setProperty("readio", String.valueOf(pReadIO));
            this.toString();
            this.mOneResultRecord.setProperty("writeio", String.valueOf(pWriteIO));
            this.mOneResultRecord.setProperty("statement", "'" + pSQLString + "'");
            this.toString();
            this.mOneResultRecord.setProperty("resultcnt", String.valueOf(pNumberOfRows));
            this.toString();
            this.mOneResultRecord.setProperty("taskid", String.valueOf(pTaskId));
            this.mResults[this.mStatementCounter] = (Properties)this.mOneResultRecord.clone();
            String lSqlString = "insert RESULTS set query_no = " + pTestNumber + ", stmt_cnt = " + this.mStatementCounter + ", stmt_description = '" + pStmtDesc + "', method_name = '" + pTestCase + "', RUN_TIME = " + pRuntime + ", CPU_TIME = " + pCPUTime + ", READIO = " + pReadIO + ", WRITEIO = " + pWriteIO + ", RESULTCNT = " + pNumberOfRows + ", VALUES_OK = TRUE";
            TestPreparedStatement myPrepStatement = new TestPreparedStatement(null, this.mMeasureConnection, lSqlString);
            myPrepStatement.execute();
        }
        catch (Exception e) {
            System.out.println("storeResultsInJava(): " + e.getClass() + e.getMessage());
            WisconsinBenchmark.addGlobalMessage((String)"storeResultsInJava()", (char)'E', (String)("Exception: " + e.getClass() + e.getMessage()));
        }
    }

    public String getPropertyWithDefault(String key, String defaultVal) {
        return WisconsinBenchmark.getParameterString((String)key, (String)defaultVal);
    }

    private void storeDefInPTS() {
        String sqlCommand = "";
        String svalue = "";
        Session sess = null;
        User myUser = null;
        Statement lStmt = null;
        try {
            svalue = ((TestDatabaseSap)WisconsinBenchmark.getDatabase()).getKernelVersion();
            this.mDefResult.setProperty("version", svalue);
            svalue = ((TestDatabaseSap)WisconsinBenchmark.getDatabase()).getKernelBuild();
            this.mDefResult.setProperty("long_build", svalue);
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"storeDefInPTS()", (char)'E', (String)("ERROR: " + e.getClass() + e.getMessage()));
        }
        try {
            lStmt = StorableObject.getConnection().createStatement();
            sqlCommand = "INSERT INTO wisc_definitions set id                  = wisc_definitions_seq.NEXTVAL, servernode_id       = " + mServernode.getId() + ", " + "dbdescription_id    = " + mDbdescription.getId();
            lStmt.executeUpdate(sqlCommand);
            lStmt.execute("commit");
            ResultSet rs = lStmt.executeQuery("select max(id) from wisc_definitions where servernode_id = " + mServernode.getId());
            if (rs.next()) {
                this.mTestRunId = rs.getInt(1);
            }
            WisconsinBenchmark.addGlobalMessage((String)WisconsinBenchmark.getTestClassId(), (char)'I', (String)("Unique test Run ID is: " + this.mTestRunId));
            WisconsinBenchmark.printInfo(2, "WisconsinBenchmark", "Unique test Run ID    = " + this.mTestRunId);
            int lSessID = -1;
            myUser = User.findOrCreateUser(this);
            sess = Session.findOrCreateSession(myUser, "Wisconsin", this);
            lSessID = sess.getId();
            if (lSessID != -1) {
                lStmt.executeUpdate("INSERT INTO wisc_sessions_results set def_id = " + this.mTestRunId + ", session_id = " + lSessID);
                WisconsinBenchmark.addGlobalMessage((String)"storeDefInPTS()", (char)'I', (String)("\n        ******************************\n        *   S e s s i o n I D : " + lSessID + "\n        ******************************"));
            } else {
                WisconsinBenchmark.printInfo(2, "storeDefInPTS()", "Invalid SessionID: " + lSessID);
            }
        }
        catch (Exception e) {
            WisconsinBenchmark.addGlobalMessage((String)"storeDefInPTS()", (char)'W', (String)("WARNING: Can't save WISCONSIN definitions in PTS database !!!\nException: " + e));
        }
        WisconsinBenchmark.printInfo(2, "\nWisconsinBenchmark", "WisconsinBenchmark measurements follow!\n");
    }

    public static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(String.valueOf(pComponent) + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            WisconsinBenchmark.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            WisconsinBenchmark.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    private String paddToRightJustified(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return String.valueOf(new String(ca)) + str;
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    public int randomInteger(int pMinValue, int pMaxValue) {
        return (int)((double)this.mRandomGenerator.nextFloat() * (double)(pMaxValue - pMinValue + 1)) + pMinValue;
    }

    public static long randomSucc(long pStartNo, long pModulo) {
        return (pStartNo * 421L + 683L) % pModulo;
    }

    static class AsciiStream
    extends InputStream {
        protected long size;
        protected long position;

        public AsciiStream(long size) {
            this.size = size;
            this.position = 0L;
        }

        public int available() throws IOException {
            return (int)(this.size - this.position);
        }

        public void close() {
        }

        public void mark(int readlimit) {
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.position >= this.size) {
                return -1;
            }
            byte result = this.currentByte();
            ++this.position;
            return result;
        }

        private byte currentByte() {
            return (byte)(48 + (byte)(this.position % 10L));
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            long result = Math.min((long)len, this.size - this.position);
            if (result == 0L) {
                return -1;
            }
            int i = 0;
            while ((long)i < result) {
                b[off + i] = this.currentByte();
                ++this.position;
                ++i;
            }
            return (int)result;
        }

        public void reset() throws IOException {
            this.position = 0L;
        }

        public long skip(long count) throws IOException {
            long result = Math.min(count, this.size - this.position);
            this.position += count;
            return result;
        }

        public static void main(String[] args) throws IOException {
            long streamLen = Long.valueOf(args[0]);
            AsciiStream stream = new AsciiStream(streamLen);
            byte[] buf = new byte[1024];
            boolean atEnd = false;
            int pos = 0;
            while (!atEnd) {
                int chunkSize = stream.read(buf);
                if (chunkSize == 0) {
                    atEnd = true;
                    continue;
                }
                System.out.println("at " + (pos += chunkSize) + " of " + streamLen);
            }
        }

        public long getPosition() {
            return this.position;
        }

        public String toString() {
            return "<generators.AsciiStream (" + this.size + ")>";
        }
    }
}

