/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.starter.EditorApplet;
import com.sap.sapdb.benchmark.tp2.util.starter.EditorNode;
import com.sap.sapdb.benchmark.tp2.util.starter.FileEditor;
import com.sap.sapdb.benchmark.tp2.util.starter.Host;
import com.sap.sapdb.benchmark.tp2.util.starter.HostConfigDialog;
import com.sap.sapdb.benchmark.tp2.util.starter.HostNode;
import com.sap.sapdb.benchmark.tp2.util.starter.SeqFileEditor;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterGUI;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

class StarterTreeModel
extends DefaultTreeModel
implements ActionListener {
    private StarterNode rootNode = null;
    private StarterNode seqsNode = null;
    private StarterNode filesNode = null;
    private StarterNode hostsNode = null;
    private StarterGUI starterGUI = StarterEnv.getStarterGUI();

    public StarterTreeModel() {
        super(new StarterNode("TP2 Starter"));
        this.rootNode = (StarterNode)this.getRoot();
        this.initStaticNodes();
    }

    public void restoreLastState() throws StarterException {
        Properties lastLoadedFiles;
        String key;
        Iterator<Object> it;
        Properties lastLoadedSeq = this.getProperties(StarterEnv.getConfFile("lastLoadedSeqFiles.properties"));
        if (lastLoadedSeq != null) {
            it = lastLoadedSeq.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                try {
                    this.addEditor(new SeqFileEditor(new File(key)));
                }
                catch (StarterException e) {
                    StarterEnv.throwException(e);
                }
            }
        }
        if ((lastLoadedFiles = this.getProperties(StarterEnv.getConfFile("lastLoadedFiles.properties"))) != null) {
            it = lastLoadedFiles.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                try {
                    this.addEditor(new FileEditor(new File(key)));
                }
                catch (StarterException e) {
                    StarterEnv.throwException(e);
                }
            }
        }
    }

    private Properties getProperties(File propertiesFile) throws StarterException {
        Properties result = null;
        if (propertiesFile.exists()) {
            result = new Properties();
            try {
                FileInputStream in = new FileInputStream(propertiesFile);
                result.load(in);
                in.close();
            }
            catch (FileNotFoundException e) {
                throw new StarterException("Problem when restoring last state", e);
            }
            catch (IOException e) {
                throw new StarterException("Problem when restoring last state", e);
            }
        }
        return result;
    }

    public void close() {
        try {
            EditorNode node;
            int j;
            DirNode dirNode;
            Properties lastLoadedSeq = new Properties();
            int i = 0;
            while (i < this.seqsNode.getChildCount()) {
                dirNode = (DirNode)this.seqsNode.getChildAt(i);
                j = 0;
                while (j < dirNode.getChildCount()) {
                    node = (EditorNode)dirNode.getChildAt(j);
                    lastLoadedSeq.put(node.getEditor().getRelatedFile().getPath(), "");
                    ++j;
                }
                ++i;
            }
            File lastLoadedSeqFile = StarterEnv.getConfFile("lastLoadedSeqFiles.properties");
            FileOutputStream out = new FileOutputStream(lastLoadedSeqFile);
            lastLoadedSeq.store(out, "Last loaded sequence files " + new Date());
            out.close();
            Properties lastLoadedFiles = new Properties();
            i = 0;
            while (i < this.filesNode.getChildCount()) {
                dirNode = (DirNode)this.filesNode.getChildAt(i);
                j = 0;
                while (j < dirNode.getChildCount()) {
                    node = (EditorNode)dirNode.getChildAt(j);
                    lastLoadedFiles.put(node.getEditor().getRelatedFile().getPath(), "");
                    ++j;
                }
                ++i;
            }
            File lastLoadedFile = StarterEnv.getConfFile("lastLoadedFiles.properties");
            out = new FileOutputStream(lastLoadedFile);
            lastLoadedFiles.store(out, "Last loaded sequence files " + new Date());
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initStaticNodes() {
        this.seqsNode = new StarterNode("Sequences");
        FileAL fileAL = new FileAL(StarterEnv.getSeqFilesDir());
        JPopupMenu popup = this.seqsNode.getPopup();
        JMenuItem item = new JMenuItem("Add sequence file ...");
        item.addActionListener(fileAL);
        item.setActionCommand("addFile");
        popup.add(item);
        item = new JMenuItem("New sequence file ...");
        item.addActionListener(fileAL);
        item.setActionCommand("newFile");
        popup.add(item);
        this.rootNode.add(this.seqsNode);
        this.filesNode = new StarterNode("Files");
        fileAL = new FileAL(StarterEnv.getFilesDir());
        popup = this.filesNode.getPopup();
        item = new JMenuItem("Add file ...");
        item.addActionListener(fileAL);
        item.setActionCommand("addFile");
        popup.add(item);
        item = new JMenuItem("New file ...");
        item.addActionListener(fileAL);
        item.setActionCommand("newFile");
        popup.add(item);
        this.rootNode.add(this.filesNode);
        this.hostsNode = new StarterNode("Hosts");
        popup = this.hostsNode.getPopup();
        item = new JMenuItem("Add host ...");
        item.addActionListener(this);
        item.setActionCommand("newHost");
        popup.add(item);
        this.rootNode.add(this.hostsNode);
    }

    public void addEditor(EditorApplet editor) {
        File relatedFile = editor.getRelatedFile();
        File parentDir = relatedFile.getParentFile();
        DefaultMutableTreeNode parentNode = null;
        StarterNode staticNode = null;
        String ext = StarterEnv.extractExt(relatedFile);
        staticNode = ext.equals("seq") ? this.seqsNode : this.filesNode;
        int i = 0;
        while (i < staticNode.getChildCount()) {
            DirNode node = (DirNode)staticNode.getChildAt(i);
            if (node.getDir().equals(parentDir)) {
                parentNode = node;
                break;
            }
            ++i;
        }
        if (parentNode == null) {
            parentNode = new DirNode(parentDir);
            staticNode.add(parentNode);
        }
        parentNode.add(editor.getEditorNode());
        this.starterGUI.nodeStructureChanged(staticNode);
        this.starterGUI.expandToNode(editor.getEditorNode());
    }

    protected void addHost(Host host) {
        HostNode hostNode = host.getHostNode();
        this.hostsNode.add(hostNode);
        this.starterGUI.nodeStructureChanged(this.hostsNode);
        this.starterGUI.expandToNode(hostNode);
    }

    protected void removeHost(HostNode hostNode) {
        Host.removeHost(hostNode.getHost().getHostName());
        this.hostsNode.remove(hostNode);
        this.starterGUI.nodeStructureChanged(this.hostsNode);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("newHost")) {
            new HostConfigDialog();
        }
    }

    class FileAL
    implements ActionListener {
        private File dir = null;

        public FileAL(File dir) {
            this.dir = dir;
        }

        public void actionPerformed(ActionEvent evt) {
            block10: {
                try {
                    if (evt.getActionCommand().equals("addFile")) {
                        JFileChooser chooser = new JFileChooser(this.dir);
                        chooser.setDialogTitle("Open file");
                        int returnVal = chooser.showOpenDialog(StarterTreeModel.this.starterGUI);
                        if (returnVal == 0) {
                            File file = chooser.getSelectedFile();
                            String ext = StarterEnv.extractExt(file);
                            if (ext.equals("seq")) {
                                StarterTreeModel.this.addEditor(new SeqFileEditor(file));
                            } else {
                                StarterTreeModel.this.addEditor(new FileEditor(file));
                            }
                        }
                        break block10;
                    }
                    if (!evt.getActionCommand().equals("newFile")) break block10;
                    JFileChooser chooser = new JFileChooser(this.dir);
                    chooser.setDialogTitle("New file");
                    int returnVal = chooser.showOpenDialog(StarterTreeModel.this.starterGUI);
                    if (returnVal != 0) break block10;
                    try {
                        File file = chooser.getSelectedFile();
                        String ext = StarterEnv.extractExt(file);
                        if (ext.equals("seq")) {
                            FileWriter out = new FileWriter(file);
                            out.write(SeqFileEditor.getMinimalContentAsString());
                            out.close();
                            StarterTreeModel.this.addEditor(new SeqFileEditor(file));
                        } else {
                            StarterTreeModel.this.addEditor(new FileEditor(file));
                        }
                    }
                    catch (IOException e) {
                        throw new StarterException("Problem when creating new Sequence file", e);
                    }
                }
                catch (StarterException e) {
                    StarterEnv.throwException(e);
                }
            }
        }
    }

    class DirNode
    extends StarterNode {
        private File dir = null;

        public DirNode(File dir) {
            super(dir);
            this.dir = dir;
            FileAL sfAL = new FileAL(dir);
            JMenuItem item = new JMenuItem("Add file ...");
            item.addActionListener(sfAL);
            item.setActionCommand("addFile");
            this.popup.add(item);
            item = new JMenuItem("New file ...");
            item.addActionListener(sfAL);
            item.setActionCommand("newFile");
            this.popup.add(item);
        }

        public boolean equals(Object obj) {
            if (obj instanceof DirNode) {
                return ((DirNode)obj).getDir().equals(this.dir);
            }
            return false;
        }

        public File getDir() {
            return this.dir;
        }
    }
}

