/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.starter.EditorApplet;
import com.sap.sapdb.benchmark.tp2.util.starter.EditorNode;
import com.sap.sapdb.benchmark.tp2.util.starter.Host;
import com.sap.sapdb.benchmark.tp2.util.starter.HostNode;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterApplet;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterNode;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterTreeModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class StarterGUI
extends JFrame
implements TreeSelectionListener {
    private JTree mainTree = null;
    private JTabbedPane tabbedPane = null;
    private JSplitPane splitPane = null;

    public StarterGUI() {
        StarterEnv.registerStarterGUI(this);
        this.initGUI();
    }

    private void initState() {
        try {
            Host.loadSavedTransfers();
        }
        catch (StarterException e) {
            StarterEnv.throwException(e);
        }
        try {
            this.getStarterTreeModel().restoreLastState();
        }
        catch (StarterException e) {
            StarterEnv.throwException(e);
        }
    }

    private void initGUI() {
        this.setSize(600, 400);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StarterGUI.this.close();
                System.exit(0);
            }
        });
        this.setTitle("TP2 Config manager");
        StarterTreeModel starterTreeModel = new StarterTreeModel();
        this.mainTree = new JTree(starterTreeModel);
        ToolTipManager.sharedInstance().registerComponent(this.mainTree);
        this.mainTree.putClientProperty("JTree.lineStyle", "Angled");
        this.mainTree.addMouseListener(new TreeListener());
        this.mainTree.addTreeSelectionListener(this);
        JScrollPane treeScroll = new JScrollPane(this.mainTree);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.addMouseListener(new TabbedPaneListener());
        this.splitPane = new JSplitPane(1);
        this.splitPane.setTopComponent(treeScroll);
        this.splitPane.setBottomComponent(this.tabbedPane);
        this.splitPane.setDividerLocation(150);
        this.getContentPane().add((Component)this.splitPane, "Center");
    }

    public void expandToNode(StarterNode node) {
        TreePath path = new TreePath(node.getPath());
        this.mainTree.expandPath(path);
        this.mainTree.fireTreeExpanded(path);
    }

    public void addStarterApplet(StarterApplet starterApplet) {
        this.tabbedPane.addTab(starterApplet.getName(), starterApplet);
        this.showStarterApplet(starterApplet);
    }

    public void removeStarterApplet(StarterApplet starterApplet) {
        this.tabbedPane.remove(starterApplet);
    }

    public boolean containsStarterApplet(StarterApplet starterApplet) {
        return this.tabbedPane.indexOfComponent(starterApplet) >= 0;
    }

    protected void showStarterApplet(StarterApplet starterApplet) {
        this.tabbedPane.setSelectedComponent(starterApplet);
    }

    public StarterApplet getSelectedStarterApplet() {
        return (StarterApplet)this.tabbedPane.getSelectedComponent();
    }

    private void close() {
        try {
            this.getStarterTreeModel().close();
            Host.saveTransfersConfigs();
        }
        catch (StarterException e) {
            StarterEnv.throwException(e);
        }
    }

    private void showInfoPopup(StarterNode info, int x, int y) {
        JPopupMenu popup = info.getPopup();
        popup.show(this.mainTree, x, y);
    }

    public void nodeStructureChanged(StarterNode node) {
        this.getStarterTreeModel().nodeStructureChanged(node);
        this.mainTree.repaint();
    }

    public void nodeChanged(StarterNode node) {
        if (node instanceof EditorNode) {
            ((EditorNode)node).update();
        }
        this.getStarterTreeModel().nodeChanged(node);
        this.mainTree.repaint();
    }

    public void valueChanged(TreeSelectionEvent evt) {
        EditorApplet editor;
        Object node = evt.getPath().getLastPathComponent();
        if (node instanceof EditorNode && this.containsStarterApplet(editor = ((EditorNode)node).getEditor())) {
            this.showStarterApplet(editor);
        }
    }

    public static void main(String[] arg) {
        StarterGUI starterGUI = new StarterGUI();
        starterGUI.initState();
        starterGUI.show();
    }

    public StarterTreeModel getStarterTreeModel() {
        return (StarterTreeModel)this.mainTree.getModel();
    }

    private class TabbedPaneListener
    extends MouseAdapter {
        TabbedPaneListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.getModifiers() == 4 && StarterGUI.this.tabbedPane.getBoundsAt(StarterGUI.this.tabbedPane.getSelectedIndex()).contains(evt.getX(), evt.getY())) {
                StarterGUI.this.getSelectedStarterApplet().getPopup().show(StarterGUI.this.tabbedPane, evt.getX(), evt.getY());
            }
        }
    }

    private class TreeListener
    extends MouseAdapter {
        TreeListener() {
        }

        public void mousePressed(MouseEvent evt) {
            int x = evt.getX();
            int y = evt.getY();
            StarterNode node = (StarterNode)StarterGUI.this.mainTree.getClosestPathForLocation(x, y).getLastPathComponent();
            if (evt.getModifiers() == 4) {
                StarterGUI.this.showInfoPopup(node, x, y);
            } else if (evt.getModifiers() == 16 && evt.getClickCount() == 2) {
                if (node instanceof EditorNode) {
                    EditorApplet editor = ((EditorNode)node).getEditor();
                    if (!StarterGUI.this.containsStarterApplet(editor)) {
                        StarterGUI.this.addStarterApplet(editor);
                    }
                } else if (node instanceof HostNode) {
                    ((HostNode)node).getHost().showConfigDialog();
                }
            }
        }
    }
}

