/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.SimpleXMLHandler;
import com.sap.sapdb.benchmark.tp2.util.starter.CaseEditor;
import com.sap.sapdb.benchmark.tp2.util.starter.EditorApplet;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class SeqFileEditor
extends EditorApplet {
    private Vector caseEditors = null;
    private JTabbedPane tabbedPane = null;
    private boolean loading = false;
    private SeqFileEditor itSelf = this;

    public SeqFileEditor(File sequenceFile) throws StarterException {
        super(sequenceFile);
        this.caseEditors = new Vector();
        this.initGUI();
        this.loadSeqFile(sequenceFile);
    }

    protected void loadSeqFile(File seqFile) throws StarterException {
        try {
            this.loading = true;
            BufferedReader in = new BufferedReader(new FileReader(seqFile));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("DOCTYPE") >= 0) break;
            }
            new SeqFileHandler().parse(new InputSource(in));
            in.close();
            if (this.caseEditors.size() == 0) {
                this.insertCaseEditor(0, this.createDefaultCaseEditor());
            }
            this.loading = false;
            this.refreshCaseEditorsDisplay();
        }
        catch (SAXException se) {
            throw new StarterException("Problem when loading seqFile", se);
        }
        catch (ParserConfigurationException se) {
            throw new StarterException("Problem when loading seqFile", se);
        }
        catch (IOException se) {
            throw new StarterException("Problem when loading seqFile", se);
        }
    }

    private void initGUI() {
        this.tabbedPane = new JTabbedPane();
        this.refreshCaseEditorsDisplay();
        this.add("Center", this.tabbedPane);
    }

    protected void refreshCaseEditorsDisplay() {
        this.tabbedPane.removeAll();
        int i = 0;
        while (i < this.caseEditors.size()) {
            CaseEditor caseEditor = (CaseEditor)this.caseEditors.get(i);
            this.tabbedPane.removeMouseListener(((CaseEditor)this.caseEditors.get(i)).getCaseTabListener());
            caseEditor.setCaseTabListener(new CaseTabListener(i));
            this.tabbedPane.addMouseListener(caseEditor.getCaseTabListener());
            this.tabbedPane.addTab("Case #" + i, caseEditor.getCaseEditorPanel());
            ++i;
        }
        this.tabbedPane.validate();
    }

    protected void insertCaseEditor(int index, CaseEditor caseEditor) {
        this.caseEditors.insertElementAt(caseEditor, index);
        if (!this.loading) {
            this.refreshCaseEditorsDisplay();
            this.tabbedPane.setSelectedComponent(caseEditor.getCaseEditorPanel());
            this.notifyChange();
        }
    }

    protected void removeCaseEditor(int index) {
        this.tabbedPane.removeMouseListener(((CaseEditor)this.caseEditors.get(index)).getCaseTabListener());
        this.caseEditors.remove(index);
        this.refreshCaseEditorsDisplay();
        this.notifyChange();
    }

    protected CaseEditor createDefaultCaseEditor() throws StarterException {
        return new CaseEditor(this, "com.sap.sapdb.benchmark.tp2.cases", "DynamicCase", "[your d-user]", new TreeMap());
    }

    public String getContentAsString() throws StarterException {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\"?>\n");
        result.append("<!DOCTYPE test-sequence SYSTEM \"TestSequence.dtd\">\n");
        result.append("<!-- Sequence file generated by TP2 Config Manager - " + new GregorianCalendar().getTime() + " -->\n\n");
        result.append("<test-sequence>\n");
        String currPackage = null;
        int i = 0;
        while (i < this.caseEditors.size()) {
            CaseEditor currCaseEditor = (CaseEditor)this.caseEditors.get(i);
            if (i == 0) {
                result.append("\t<package>\n");
                currPackage = currCaseEditor.getPackageName();
                result.append("\t\t<package-name>" + currPackage + "</package-name>\n");
            } else if (!currPackage.equals(currCaseEditor.getPackageName())) {
                currPackage = currCaseEditor.getPackageName();
                result.append("\t</package>\n");
                result.append("\t<package>\n");
                result.append("\t\t<package-name>" + currPackage + "</package-name>\n");
            }
            result.append("\t\t<test>\n");
            result.append("\t\t\t<test-name>" + currCaseEditor.getCaseName() + "</test-name>\n");
            result.append("\t\t\t<test-parameter KEY=\"benchmark.case.user\" VALUE=\"" + currCaseEditor.getUserName() + "\"/>\n");
            Iterator props = currCaseEditor.getNonDefaultProperties().entrySet().iterator();
            while (props.hasNext()) {
                Map.Entry entry = props.next();
                result.append("\t\t\t<test-parameter KEY=\"" + entry.getKey() + "\" VALUE=\"" + entry.getValue() + "\"/>\n");
            }
            result.append("\t\t</test>\n");
            if (i == this.caseEditors.size() - 1) {
                result.append("\t</package>\n");
            }
            ++i;
        }
        result.append("</test-sequence>\n");
        return result.toString();
    }

    public static String getMinimalContentAsString() {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\"?>\n");
        result.append("<!DOCTYPE test-sequence SYSTEM \"TestSequence.dtd\">\n");
        result.append("<test-sequence>\n");
        result.append("</test-sequence>\n");
        return result.toString();
    }

    private class SeqFileHandler
    extends SimpleXMLHandler {
        private String currUserName = null;
        private String currPackage = null;
        private String currCase = null;
        private TreeMap currProp = new TreeMap();

        public void startTag(String qName, Attributes attr) throws SAXException {
            if (qName.equals("test-parameter")) {
                if (attr.getValue("KEY").equals("benchmark.case.user")) {
                    this.currUserName = attr.getValue("VALUE");
                } else {
                    this.currProp.put(attr.getValue("KEY"), attr.getValue("VALUE"));
                }
            }
        }

        public void endTag(String qName) throws SAXException {
            try {
                if (qName.equals("test-name")) {
                    this.currCase = this.getTagText();
                } else if (qName.equals("package-name")) {
                    this.currPackage = this.getTagText();
                } else if (qName.equals("test")) {
                    this.addCase();
                }
            }
            catch (StarterException e) {
                throw new SAXException("Problem because of " + e);
            }
        }

        private void addCase() throws StarterException {
            SeqFileEditor.this.insertCaseEditor(SeqFileEditor.this.caseEditors.size(), new CaseEditor(SeqFileEditor.this.itSelf, this.currPackage, this.currCase, this.currUserName, this.currProp));
            this.currCase = null;
            this.currUserName = null;
            this.currProp = new TreeMap();
        }
    }

    class CaseTabListener
    extends MouseAdapter
    implements ActionListener {
        private int id;
        private JPopupMenu popup = null;

        public CaseTabListener(int id) {
            this.id = id;
            this.popup = new JPopupMenu();
            JMenuItem item = new JMenuItem("Remove");
            item.addActionListener(this);
            item.setActionCommand("remove");
            this.popup.add(item);
            this.popup.add(new JSeparator());
            item = new JMenuItem("Insert a case copy");
            item.addActionListener(this);
            item.setActionCommand("insertCopy");
            this.popup.add(item);
            item = new JMenuItem("Insert new case");
            item.addActionListener(this);
            item.setActionCommand("insertNew");
            this.popup.add(item);
            if (id == 0) {
                item = new JMenuItem("Insert new case before");
                item.addActionListener(this);
                item.setActionCommand("insertNewBefore");
                this.popup.add(item);
            }
        }

        public void mousePressed(MouseEvent evt) {
            if (this.id == SeqFileEditor.this.tabbedPane.getSelectedIndex() && evt.getModifiers() == 4 && SeqFileEditor.this.tabbedPane.getBoundsAt(SeqFileEditor.this.tabbedPane.getSelectedIndex()).contains(evt.getX(), evt.getY())) {
                this.popup.show(SeqFileEditor.this.tabbedPane, evt.getX(), evt.getY());
            }
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                if (evt.getActionCommand().equals("remove")) {
                    SeqFileEditor.this.removeCaseEditor(this.id);
                } else if (evt.getActionCommand().equals("insertNew")) {
                    SeqFileEditor.this.insertCaseEditor(this.id + 1, SeqFileEditor.this.createDefaultCaseEditor());
                } else if (evt.getActionCommand().equals("insertNewBefore")) {
                    SeqFileEditor.this.insertCaseEditor(this.id, SeqFileEditor.this.createDefaultCaseEditor());
                } else if (evt.getActionCommand().equals("insertCopy")) {
                    SeqFileEditor.this.insertCaseEditor(this.id + 1, ((CaseEditor)SeqFileEditor.this.caseEditors.get(this.id)).copy());
                }
            }
            catch (StarterException e) {
                StarterEnv.throwException(e);
            }
        }
    }
}

