/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.starter.Host;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

class HostConfigDialog
extends JDialog
implements ActionListener {
    protected JTextField hostNameTF = null;
    protected JTextField userNameTF = null;
    protected JPasswordField passwordTF = null;
    protected Host host = null;

    public HostConfigDialog() {
        super((Frame)StarterEnv.getStarterGUI(), true);
        this.initGUI();
    }

    public HostConfigDialog(Host host) {
        super((Frame)StarterEnv.getStarterGUI(), false);
        this.host = host;
        this.initGUI();
        this.userNameTF.setText(host.getUserName());
        this.passwordTF.setText(host.getPassword());
    }

    private void initGUI() {
        this.getContentPane().setLayout(new GridLayout(4, 2));
        this.getContentPane().add(new JLabel("Host name : "));
        if (this.host == null) {
            this.setTitle("New host");
            this.hostNameTF = new JTextField("", 20);
            this.getContentPane().add(this.hostNameTF);
        } else {
            this.setTitle(this.host.getHostName());
            this.getContentPane().add(new JLabel(this.host.getHostName()));
        }
        this.getContentPane().add(new JLabel("User name : "));
        this.userNameTF = new JTextField("", 20);
        this.getContentPane().add(this.userNameTF);
        this.getContentPane().add(new JLabel("Password : "));
        this.passwordTF = new JPasswordField("", 20);
        this.getContentPane().add(this.passwordTF);
        JButton butt = new JButton("Save");
        butt.addActionListener(this);
        butt.setActionCommand("save");
        this.getContentPane().add(butt);
        butt = new JButton("Cancel");
        butt.addActionListener(this);
        butt.setActionCommand("cancel");
        this.getContentPane().add(butt);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("save")) {
            this.save();
        }
        this.dispose();
    }

    protected void save() {
        try {
            Host host = new Host(this.hostNameTF.getText(), this.userNameTF.getText(), new String(this.passwordTF.getPassword()));
            Host.addHost(host);
        }
        catch (StarterException e) {
            StarterEnv.throwException(e);
        }
    }
}

