/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.starter.EditorApplet;
import com.sap.sapdb.benchmark.tp2.util.starter.FileEditor;
import com.sap.sapdb.benchmark.tp2.util.starter.Host;
import com.sap.sapdb.benchmark.tp2.util.starter.SeqFileEditor;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

class EditorNode
extends StarterNode
implements ActionListener {
    private EditorApplet editor = null;

    public EditorNode(EditorApplet relatedSeqFileEditor) {
        super(relatedSeqFileEditor.getRelatedFile().getName());
        this.editor = relatedSeqFileEditor;
    }

    public EditorApplet getEditor() {
        return this.editor;
    }

    public void update() {
        String userObj = this.editor.getRelatedFile().getName();
        if (this.editor.isChangedSinceLastSave()) {
            userObj = String.valueOf(userObj) + "*";
        }
        this.setUserObject(userObj);
    }

    protected void remove() {
        this.starterGUI.removeStarterApplet(this.editor);
        StarterNode parent = (StarterNode)this.getParent();
        this.removeFromParent();
        this.starterGUI.nodeStructureChanged(parent);
        if (parent.getChildCount() == 0) {
            StarterNode grandParent = (StarterNode)parent.getParent();
            parent.removeFromParent();
            this.starterGUI.nodeStructureChanged(grandParent);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            if (evt.getActionCommand().equals("removeFile")) {
                this.remove();
            } else if (evt.getActionCommand().equals("saveFile")) {
                this.editor.save();
            } else if (evt.getActionCommand().equals("saveFileAs")) {
                JFileChooser chooser = new JFileChooser(this.editor.getRelatedFile().getParent());
                chooser.setDialogTitle("Save sequence file as ...");
                int returnVal = chooser.showSaveDialog(this.starterGUI);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    this.editor.saveAs(file);
                    EditorApplet editor = null;
                    String ext = StarterEnv.extractExt(file);
                    editor = ext.equals("seq") ? new SeqFileEditor(file) : new FileEditor(file);
                    StarterEnv.getStarterTreeModel().addEditor(editor);
                    StarterEnv.getStarterGUI().addStarterApplet(editor);
                }
            } else if (evt.getActionCommand().equals("delete")) {
                int optionChosen = JOptionPane.showConfirmDialog(this.starterGUI, "Are you sure you want to delete " + this.editor.getRelatedFile());
                switch (optionChosen) {
                    case 0: {
                        this.remove();
                        this.editor.getRelatedFile().delete();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (StarterException e) {
            StarterEnv.throwException(e);
        }
        catch (IOException e) {
            StarterEnv.throwException(e);
        }
    }

    public JPopupMenu getPopup() {
        this.popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("Remove");
        item.addActionListener(this);
        item.setActionCommand("removeFile");
        this.popup.add(item);
        this.popup.addSeparator();
        item = new JMenuItem(this.editor.getSaveAction());
        this.popup.add(item);
        item = new JMenuItem("Save as ...");
        item.addActionListener(this);
        item.setActionCommand("saveFileAs");
        this.popup.add(item);
        item = new JMenuItem("Delete");
        item.addActionListener(this);
        item.setActionCommand("delete");
        this.popup.add(item);
        this.popup.addSeparator();
        JMenu menu = new JMenu("Send by FTP");
        Iterator it = Host.listHosts();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            JMenu dirMenu = new JMenu(host.getHostName());
            Iterator dirs = host.listDirs();
            while (dirs.hasNext()) {
                String dir = (String)dirs.next();
                item = new JMenuItem(dir);
                item.addActionListener(new SendFile(host, dir));
                item.setActionCommand(host.getHostName());
                dirMenu.add(item);
            }
            menu.add(dirMenu);
        }
        this.popup.add(menu);
        return this.popup;
    }

    private class SendFile
    implements ActionListener {
        private String dir = null;
        private Host host = null;

        public SendFile(Host host, String dir) {
            this.dir = dir;
            this.host = host;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                this.host.putFile(this.dir, EditorNode.this.editor.getName(), EditorNode.this.editor.getContentAsString());
                JOptionPane.showMessageDialog(StarterEnv.getStarterGUI(), String.valueOf(EditorNode.this.editor.getName()) + " was transferred to ftp://" + this.host.getHostName() + this.dir);
            }
            catch (IOException e) {
                StarterEnv.throwException(e);
            }
            catch (StarterException e) {
                StarterEnv.throwException(e);
            }
        }
    }
}

