/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.starter.EditorNode;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterApplet;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterGUI;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

abstract class EditorApplet
extends StarterApplet {
    protected File relatedFile = null;
    protected EditorNode relatedNode = null;
    protected StarterGUI starterGUI = null;
    private JButton fileNameLabel = null;
    private boolean changedSinceLastSave = false;
    private Action saveAction = null;
    private Action viewAction = null;

    public EditorApplet(File relatedFile) {
        this.relatedFile = relatedFile;
        this.starterGUI = StarterEnv.getStarterGUI();
        this.relatedNode = new EditorNode(this);
        this.saveAction = new SaveAction();
        this.viewAction = new ViewAction();
        this.initGUI();
    }

    public String getName() {
        return this.relatedFile.getName();
    }

    public EditorNode getEditorNode() {
        return this.relatedNode;
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel(new GridLayout(1, 1));
        JPanel panel = new JPanel(new FlowLayout(0));
        this.fileNameLabel = new JButton(this.relatedFile.getPath());
        this.fileNameLabel.setAction(this.viewAction);
        this.fileNameLabel.setText(this.relatedFile.getPath());
        panel.add(this.fileNameLabel);
        header.add(panel);
        header.setBorder(BorderFactory.createTitledBorder("Sequence file "));
        this.add("North", header);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(83, 2), this.saveAction.getValue("Name"));
        this.getActionMap().put(this.saveAction.getValue("Name"), this.saveAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(87, 2), this.viewAction.getValue("Name"));
        this.getActionMap().put(this.viewAction.getValue("Name"), this.viewAction);
    }

    protected abstract String getContentAsString() throws StarterException;

    public void save() throws IOException, StarterException {
        this.saveAs(this.relatedFile);
        this.changedSinceLastSave = false;
        this.starterGUI.nodeChanged(this.relatedNode);
        this.fileNameLabel.setText(this.relatedFile.getPath());
    }

    public void saveAs(File file) throws IOException, StarterException {
        FileWriter fw = new FileWriter(file);
        fw.write(this.getContentAsString());
        fw.close();
    }

    public Action getSaveAction() {
        return this.saveAction;
    }

    public void notifyChange() {
        this.changedSinceLastSave = true;
        this.fileNameLabel.setText(String.valueOf(this.relatedFile.getPath()) + "*");
        this.starterGUI.nodeChanged(this.relatedNode);
    }

    public File getRelatedFile() {
        return this.relatedFile;
    }

    public boolean isChangedSinceLastSave() {
        return this.changedSinceLastSave;
    }

    private class ViewAction
    extends AbstractAction {
        public ViewAction() {
            super("View");
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                String title = EditorApplet.this.relatedFile.getPath();
                if (EditorApplet.this.changedSinceLastSave) {
                    title = String.valueOf(title) + "*";
                }
                JDialog viewer = new JDialog(EditorApplet.this.starterGUI, title, true);
                viewer.getContentPane().setLayout(new BorderLayout());
                JTextArea textArea = new JTextArea();
                textArea.setEditable(false);
                textArea.setTabSize(2);
                textArea.setText(EditorApplet.this.getContentAsString());
                JScrollPane scroll = new JScrollPane(textArea);
                viewer.getContentPane().add("Center", scroll);
                viewer.setSize(500, 600);
                viewer.show();
            }
            catch (StarterException e) {
                StarterEnv.throwException(e);
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save");
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                EditorApplet.this.save();
            }
            catch (StarterException e) {
                StarterEnv.throwException(e);
            }
            catch (IOException e) {
                StarterEnv.throwException(e);
            }
        }
    }
}

