/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.common.PropertyException;
import com.sap.sapdb.benchmark.tp2.common.Tp2TestProperties;
import com.sap.sapdb.benchmark.tp2.util.starter.CaseEditorTable;
import com.sap.sapdb.benchmark.tp2.util.starter.SeqFileEditor;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class CaseEditor
extends DefaultTableModel {
    private static final int PROPNAME_COL = 0;
    private static final int PROPVALUE_COL = 1;
    public static final String USER_NAME_KEY = "benchmark.case.user";
    private static final Color veryLightGray = new Color(225, 225, 225);
    private Tp2TestProperties tp2Properties = null;
    private CaseEditorPanel caseEditorPanel = null;
    private MouseListener caseTabListener = null;
    private boolean showUnchangedDefaults = false;
    private CaseEditor itSelf = null;
    private SeqFileEditor relatedSeqFileEditor = null;
    private JTextField userNameTF = null;
    private JTextField caseNameTF = null;
    private JTextField packageNameTF = null;

    public CaseEditor(SeqFileEditor relatedSeqFileEditor, String packageName, String caseName, String userName, SortedMap propertiesArg) throws StarterException {
        try {
            this.itSelf = this;
            this.relatedSeqFileEditor = relatedSeqFileEditor;
            this.tp2Properties = new Tp2TestProperties();
            if (propertiesArg != null) {
                this.tp2Properties.putPropertiesMap(propertiesArg);
            }
            this.packageNameTF = new JTextField(packageName, 25);
            this.caseNameTF = new JTextField(caseName, 15);
            this.userNameTF = new JTextField(userName, 10);
        }
        catch (PropertyException e) {
            throw new StarterException("Could not initialize CaseEditor", e);
        }
    }

    public JPanel getCaseEditorPanel() {
        if (this.caseEditorPanel == null) {
            this.caseEditorPanel = new CaseEditorPanel();
        }
        return this.caseEditorPanel;
    }

    public String getPackageName() {
        return this.packageNameTF.getText();
    }

    public String getUserName() {
        return this.userNameTF.getText();
    }

    public String getCaseName() {
        return this.caseNameTF.getText();
    }

    public SortedMap getNonDefaultProperties() throws StarterException {
        try {
            TreeMap<String, String> result = new TreeMap<String, String>();
            Iterator it = this.tp2Properties.listSetToNonDefaultKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                result.put(key, this.tp2Properties.getProperty(key));
            }
            return result;
        }
        catch (PropertyException e) {
            throw new StarterException("Properties problem", e);
        }
    }

    public CaseEditor copy() throws StarterException {
        return new CaseEditor(this.relatedSeqFileEditor, new String(this.packageNameTF.getText()), new String(this.caseNameTF.getText()), new String(this.userNameTF.getText()), this.getNonDefaultProperties());
    }

    private String getPropName(int rowIndex) {
        String result = null;
        if (this.showUnchangedDefaults) {
            Iterator it = this.tp2Properties.listSetKeys();
            int i = 0;
            while (i <= rowIndex) {
                if (i == rowIndex) {
                    result = (String)it.next();
                    break;
                }
                it.next();
                ++i;
            }
        } else {
            Iterator it = this.tp2Properties.listSetToNonDefaultKeys();
            int i = 0;
            while (i <= rowIndex) {
                if (i == rowIndex) {
                    result = (String)it.next();
                    break;
                }
                it.next();
                ++i;
            }
        }
        return result;
    }

    private Object getPropValue(int rowIndex) throws PropertyException {
        return this.tp2Properties.getProperty(this.getPropName(rowIndex));
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        int rowCnt = 0;
        if (this.tp2Properties == null) {
            return 0;
        }
        if (this.showUnchangedDefaults) {
            Iterator it = this.tp2Properties.listSetKeys();
            while (it.hasNext()) {
                it.next();
                ++rowCnt;
            }
            return rowCnt;
        }
        return this.tp2Properties.nbrOfSetToNonDefault();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (columnIndex == 0) {
                return this.getPropName(rowIndex);
            }
            if (columnIndex == 1) {
                return this.getPropValue(rowIndex);
            }
            return null;
        }
        catch (PropertyException e) {
            StarterEnv.throwException(e);
            return null;
        }
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Value";
            }
        }
        return "[UNKNOWN]";
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        try {
            this.tp2Properties.setProperty(this.getValueAt(rowIndex, 0).toString(), value.toString());
            this.relatedSeqFileEditor.notifyChange();
            this.fireTableDataChanged();
        }
        catch (PropertyException e) {
            StarterEnv.throwException(e);
        }
    }

    public MouseListener getCaseTabListener() {
        return this.caseTabListener;
    }

    public void setCaseTabListener(MouseListener caseTabListener) {
        this.caseTabListener = caseTabListener;
    }

    private class CaseEditorPanel
    extends JPanel
    implements MouseListener,
    KeyListener {
        private JPanel headerPanel = null;
        private JTable table = null;

        public CaseEditorPanel() {
            this.setLayout(new BorderLayout());
            this.addMouseListener(this);
            this.table = new CaseEditorTable(CaseEditor.this.itSelf);
            this.table.addMouseListener(this);
            this.table.getColumnModel().getColumn(0).setCellRenderer(new PropNameRenderer());
            this.table.getColumnModel().getColumn(1).setCellEditor(new CaseCellEditor());
            this.table.getColumnModel().getColumn(1).setCellRenderer(new PropValueRenderer());
            JScrollPane tableScroll = new JScrollPane(this.table);
            this.add("Center", tableScroll);
            this.headerPanel = new JPanel(new GridLayout(3, 1));
            JPanel panel = new JPanel(new FlowLayout(0));
            panel.add(new JLabel("Package : "));
            CaseEditor.this.packageNameTF.addKeyListener(this);
            panel.add(CaseEditor.this.packageNameTF);
            this.headerPanel.add(panel);
            panel = new JPanel(new FlowLayout(0));
            panel.add(new JLabel("Case : "));
            CaseEditor.this.caseNameTF.addKeyListener(this);
            panel.add(CaseEditor.this.caseNameTF);
            this.headerPanel.add(panel);
            panel = new JPanel(new FlowLayout(0));
            panel.add(new JLabel("User : "));
            CaseEditor.this.userNameTF.addKeyListener(this);
            panel.add(CaseEditor.this.userNameTF);
            this.headerPanel.add(panel);
            this.updateHeaderBorder();
            this.add("North", this.headerPanel);
        }

        private void updateHeaderBorder() {
            this.headerPanel.setBorder(BorderFactory.createTitledBorder(String.valueOf(CaseEditor.this.packageNameTF.getText()) + "." + CaseEditor.this.caseNameTF.getText()));
        }

        public void mousePressed(MouseEvent evt) {
            try {
                if (evt.getModifiers() == 4) {
                    JPopupMenu menu = new JPopupMenu();
                    if (evt.getSource().equals(this.table)) {
                        this.addCommonMenuItems(menu);
                        menu.add(new JSeparator());
                        int row = this.table.rowAtPoint(new Point(evt.getX(), evt.getY()));
                        String key = CaseEditor.this.getPropName(row);
                        if (Tp2TestProperties.hasDefault(key)) {
                            if (!CaseEditor.this.tp2Properties.getProperty(key).equals(Tp2TestProperties.getDefault(key))) {
                                JMenuItem item = new JMenuItem("Reset to default");
                                item.addActionListener(new RemoveKey(key));
                                menu.add(item);
                            }
                        } else {
                            JMenuItem item = new JMenuItem("Remove key");
                            item.addActionListener(new RemoveKey(key));
                            menu.add(item);
                        }
                        menu.show(this.table, evt.getX(), evt.getY());
                    } else {
                        this.addCommonMenuItems(menu);
                        menu.show(this, evt.getX(), evt.getY());
                    }
                } else if (evt.getModifiers() == 16 && evt.getClickCount() == 2) {
                    Point hitPt = new Point(evt.getX(), evt.getY());
                    int row = this.table.rowAtPoint(hitPt);
                    int col = this.table.columnAtPoint(hitPt);
                    if (col == 0) {
                        new PropDialog(row, evt.getX(), evt.getY());
                    }
                }
            }
            catch (PropertyException e) {
                StarterEnv.throwException(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        private void addCommonMenuItems(JPopupMenu menu) {
            JMenuItem item = null;
            item = CaseEditor.this.showUnchangedDefaults ? new JMenuItem("Hide defaults") : new JMenuItem("Show defaults");
            item.addActionListener(new ShowHideDefaults());
            menu.add(item);
            menu.add(new NewPropMenu());
        }

        public void keyPressed(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
            if (evt.getModifiers() != 2) {
                CaseEditor.this.itSelf.relatedSeqFileEditor.notifyChange();
            }
        }

        public void keyReleased(KeyEvent evt) {
            this.updateHeaderBorder();
        }
    }

    private class ShowHideDefaults
    implements ActionListener {
        ShowHideDefaults() {
        }

        public void actionPerformed(ActionEvent evt) {
            CaseEditor.this.showUnchangedDefaults = !CaseEditor.this.showUnchangedDefaults;
            CaseEditor.this.fireTableDataChanged();
        }
    }

    private class RemoveKey
    implements ActionListener {
        private String key = null;

        public RemoveKey(String key) {
            this.key = key;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                CaseEditor.this.tp2Properties.setProperty(this.key, null);
                CaseEditor.this.relatedSeqFileEditor.notifyChange();
                CaseEditor.this.fireTableDataChanged();
            }
            catch (PropertyException e) {
                StarterEnv.throwException(e);
            }
        }
    }

    private class NewPropMenu
    extends JMenu
    implements ActionListener {
        public NewPropMenu() {
            super("New");
            try {
                Iterator it = CaseEditor.this.tp2Properties.listNonSetKeys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (key.equals(CaseEditor.USER_NAME_KEY)) continue;
                    JMenuItem item = new JMenuItem(key);
                    item.setActionCommand(key);
                    item.addActionListener(this);
                    item.setToolTipText(Tp2TestProperties.getDescription(key));
                    this.add(item);
                }
            }
            catch (PropertyException e) {
                e.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                String key = evt.getActionCommand();
                CaseEditor.this.tp2Properties.setProperty(key, "");
                CaseEditor.this.relatedSeqFileEditor.notifyChange();
                CaseEditor.this.fireTableDataChanged();
            }
            catch (PropertyException e) {
                StarterEnv.throwException(e);
            }
        }
    }

    private class CaseCellEditor
    extends DefaultCellEditor
    implements ActionListener,
    ItemListener {
        public CaseCellEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            try {
                if (column == 1) {
                    String key = CaseEditor.this.getPropName(row);
                    Tp2TestProperties cfr_ignored_0 = CaseEditor.this.tp2Properties;
                    if (Tp2TestProperties.isBooleanProperty(key)) {
                        JCheckBox cbx = new JCheckBox();
                        if (value.equals("true")) {
                            cbx.setSelected(true);
                        } else {
                            cbx.setSelected(false);
                        }
                        this.editorComponent = cbx;
                        cbx.addActionListener(this);
                    } else {
                        Tp2TestProperties cfr_ignored_1 = CaseEditor.this.tp2Properties;
                        if (Tp2TestProperties.hasPossibleValues(key)) {
                            Tp2TestProperties cfr_ignored_2 = CaseEditor.this.tp2Properties;
                            Iterator it = Tp2TestProperties.getPossibleValues(key).iterator();
                            JComboBox cb = new JComboBox();
                            while (it.hasNext()) {
                                cb.addItem(it.next());
                            }
                            cb.setSelectedItem(value);
                            cb.addItemListener(this);
                            this.editorComponent = cb;
                        } else {
                            this.editorComponent = new JTextField(value.toString());
                        }
                    }
                }
            }
            catch (PropertyException e) {
                StarterEnv.throwException(e);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public Object getCellEditorValue() {
            if (this.editorComponent instanceof JCheckBox) {
                if (((JCheckBox)this.editorComponent).isSelected()) {
                    return "true";
                }
                return "false";
            }
            if (this.editorComponent instanceof JComboBox) {
                return ((JComboBox)this.editorComponent).getSelectedItem();
            }
            if (this.editorComponent instanceof JTextField) {
                return ((JTextField)this.editorComponent).getText();
            }
            return super.getCellEditorValue();
        }

        public void itemStateChanged(ItemEvent evt) {
            this.stopCellEditing();
        }

        public void actionPerformed(ActionEvent evt) {
            this.stopCellEditing();
        }
    }

    private class PropNameRenderer
    implements TableCellRenderer {
        private JLabel labelCpnt = new JLabel();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                this.labelCpnt.setText(value.toString());
                this.labelCpnt.setToolTipText(Tp2TestProperties.getDescription(CaseEditor.this.getPropName(row)));
                this.labelCpnt.setForeground(Color.black);
                if (Tp2TestProperties.hasDefault(CaseEditor.this.getPropName(row).toString())) {
                    this.labelCpnt.setForeground(Color.gray);
                }
            }
            catch (PropertyException e) {
                StarterEnv.throwException(e);
            }
            return this.labelCpnt;
        }
    }

    private class PropValueRenderer
    implements TableCellRenderer {
        private JLabel labelCpnt = new JLabel();
        private JPanel labelPanel = new JPanel(new BorderLayout());
        private JCheckBox chbxCpnt = null;

        public PropValueRenderer() {
            this.labelPanel.setBackground(Color.white);
            this.labelPanel.add("Center", this.labelCpnt);
            this.chbxCpnt = new JCheckBox();
            this.chbxCpnt.setBackground(Color.white);
            this.chbxCpnt.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                String key = CaseEditor.this.getPropName(row);
                Tp2TestProperties cfr_ignored_0 = CaseEditor.this.tp2Properties;
                if (Tp2TestProperties.isBooleanProperty(key)) {
                    if (value.equals("true")) {
                        this.chbxCpnt.setSelected(true);
                    } else {
                        this.chbxCpnt.setSelected(false);
                    }
                    this.chbxCpnt.setBackground(Color.white);
                    if (Tp2TestProperties.hasDefault(key) && Tp2TestProperties.getDefault(key).equals(value)) {
                        this.chbxCpnt.setBackground(veryLightGray);
                    }
                    return this.chbxCpnt;
                }
                this.labelCpnt.setText(value.toString());
                this.labelPanel.setBackground(Color.white);
                this.labelCpnt.setForeground(Color.black);
                if (Tp2TestProperties.hasDefault(key) && Tp2TestProperties.getDefault(key).equals(value)) {
                    this.labelPanel.setBackground(veryLightGray);
                }
            }
            catch (PropertyException e) {
                StarterEnv.throwException(e);
            }
            return this.labelPanel;
        }
    }

    private class PropDialog
    extends JDialog
    implements ActionListener {
        private JTextArea text = null;
        private int row;

        public PropDialog(int row, int x, int y) throws PropertyException {
            super((Frame)StarterEnv.getStarterGUI(), true);
            this.row = row;
            String key = CaseEditor.this.getPropName(row);
            Tp2TestProperties cfr_ignored_0 = CaseEditor.this.tp2Properties;
            if (!Tp2TestProperties.hasPossibleValues(key)) {
                Tp2TestProperties cfr_ignored_1 = CaseEditor.this.tp2Properties;
                if (!Tp2TestProperties.isBooleanProperty(key)) {
                    this.getContentPane().setLayout(new BorderLayout());
                    this.getContentPane().add("North", new JLabel(key));
                    this.setTitle(key);
                    this.text = new JTextArea();
                    StringTokenizer ST = new StringTokenizer(CaseEditor.this.getValueAt(row, 1).toString(), ";");
                    StringBuffer valStr = new StringBuffer("");
                    while (ST.hasMoreTokens()) {
                        valStr.append(ST.nextToken());
                        if (!ST.hasMoreTokens()) continue;
                        valStr.append(";").append("\n");
                    }
                    this.text.setText(valStr.toString());
                    JScrollPane areaScrollPane = new JScrollPane(this.text);
                    areaScrollPane.setVerticalScrollBarPolicy(20);
                    areaScrollPane.setHorizontalScrollBarPolicy(30);
                    this.getContentPane().add("Center", areaScrollPane);
                    JButton butt = new JButton("Update value");
                    butt.addActionListener(this);
                    butt.setActionCommand("ok");
                    this.getContentPane().add("South", butt);
                    this.setSize(200, 200);
                    this.setLocation(x, y);
                    this.show();
                }
            }
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getActionCommand().equals("ok")) {
                StringTokenizer ST = new StringTokenizer(this.text.getText(), "\n");
                StringBuffer valStr = new StringBuffer("");
                while (ST.hasMoreTokens()) {
                    valStr.append(ST.nextToken());
                }
                CaseEditor.this.setValueAt(valStr, this.row, 1);
                this.dispose();
            }
        }
    }
}

