/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util;

import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import java.util.StringTokenizer;

class PsProcess
implements Comparable {
    protected static int processIdPlace = 1;
    protected static int cpuTimePlace = 3;
    protected static int namePlace = 4;
    private int processId;
    private int cpuTime;
    private String name;

    public PsProcess(String line) throws Tp2Exception {
        this.init(line);
    }

    protected void init(String line) throws Tp2Exception {
        try {
            StringTokenizer ST = new StringTokenizer(line, " \t");
            int place = 0;
            while (ST.hasMoreTokens()) {
                String currToken = ST.nextToken();
                if (++place == processIdPlace) {
                    try {
                        this.processId = Integer.parseInt(currToken);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (place == cpuTimePlace) {
                    this.cpuTime = 0;
                    StringTokenizer timeST = new StringTokenizer(currToken, ":");
                    while (timeST.hasMoreTokens()) {
                        try {
                            this.cpuTime = this.cpuTime * 60 + Integer.parseInt(timeST.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (place != namePlace) continue;
                this.name = currToken;
            }
        }
        catch (Exception e) {
            throw new Tp2Exception("Unexpected exception in Tp2Ps.init()", 0, e);
        }
    }

    public int getCpuTime() {
        return this.cpuTime;
    }

    public String getName() {
        return this.name;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int compareTo(Object obj) {
        if (obj instanceof PsProcess) {
            return this.getProcessId() - ((PsProcess)obj).getProcessId();
        }
        return 0;
    }
}

