/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.CompInt;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.benchmark.tp2.test.Tp2ProcessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;

class Tp2ProcessFactory {
    private static final String CONSOLE_PREFIX = "Tp2ProcessFactory";
    private static final long COMMAND_LOCK_TIMEOUT = 5000L;
    private static Tp2ProcessFactory currentTp2ProcessFactory = null;
    private Process starterProcess;
    private BufferedReader in;
    private PrintStream out;
    private TreeMap processes;
    private boolean busy;

    public static void initCurrent(String[] starterCommand, TestEnv testEnv) throws Tp2Exception {
        try {
            if (currentTp2ProcessFactory != null) {
                currentTp2ProcessFactory.abortCurrent();
            }
        }
        catch (Tp2Exception tp2Exception) {
            // empty catch block
        }
        currentTp2ProcessFactory = new Tp2ProcessFactory(starterCommand, testEnv);
    }

    public static void closeCurrent() throws Tp2Exception {
        if (currentTp2ProcessFactory != null) {
            currentTp2ProcessFactory.close();
        }
    }

    public static void abortCurrent() throws Tp2Exception {
        if (currentTp2ProcessFactory != null) {
            currentTp2ProcessFactory.abort();
        }
    }

    public static Process createProcess(int simulatedUserId) throws Tp2Exception {
        Process proc = currentTp2ProcessFactory.exec(simulatedUserId);
        BenchEnv.stdOut(CONSOLE_PREFIX, "Started user[" + simulatedUserId + "] (" + proc + ")", 20);
        return proc;
    }

    private Tp2ProcessFactory(String[] starterCommand, TestEnv testEnv) throws Tp2Exception {
        block4: {
            this.starterProcess = null;
            this.in = null;
            this.out = null;
            this.processes = null;
            this.busy = false;
            try {
                this.processes = new TreeMap();
                String command = "";
                int i = 0;
                while (i < starterCommand.length) {
                    command = String.valueOf(command) + " " + starterCommand[i];
                    ++i;
                }
                BenchEnv.stdOut(CONSOLE_PREFIX, "Command: " + command, 20);
                this.starterProcess = BenchEnv.currentJavaVersionNotUnder("1.3") ? Runtime.getRuntime().exec(starterCommand, null, new File(testEnv.getCaseEnv().getCaseLogDir())) : Runtime.getRuntime().exec(starterCommand);
                this.out = new PrintStream(this.starterProcess.getOutputStream());
                this.in = new BufferedReader(new InputStreamReader(this.starterProcess.getInputStream()));
                String ready = this.in.readLine();
                if (ready != null) {
                    BenchEnv.stdOut(CONSOLE_PREFIX, "Tp2ProcessFactory initialized (returned " + ready + ")", 20);
                    break block4;
                }
                this.starterProcess.destroy();
                throw new Tp2Exception("Initialization of Tp2ProcessFactory failed because the starter did not return READY", 3);
            }
            catch (IOException e) {
                throw new Tp2Exception("Initialization of Tp2ProcessFactory failed", 3, e);
            }
        }
    }

    private synchronized String sendCommand(String command, int value) throws Tp2ProcessException {
        long loopBegin = System.currentTimeMillis();
        while (this.busy) {
            try {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - loopBegin <= 5000L) continue;
                throw new Tp2ProcessException("COMMUNICATION", "Aborted command loop after time out.");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.busy = true;
        try {
            this.out.println(command);
            this.out.flush();
            BenchEnv.stdOut(CONSOLE_PREFIX, "Cmd : " + command, 20);
            this.out.println(value);
            this.out.flush();
            BenchEnv.stdOut(CONSOLE_PREFIX, "Val : " + value, 20);
            String result = null;
            result = this.in.readLine();
            BenchEnv.stdOut(CONSOLE_PREFIX, "Ret : " + result, 20);
            if (result != null) {
                if (result.indexOf("ERROR") >= 0) {
                    String errorType = null;
                    StringTokenizer ST = new StringTokenizer(result, "_");
                    ST.nextToken();
                    if (!ST.hasMoreTokens()) {
                        this.busy = false;
                        this.notifyAll();
                        throw new Tp2ProcessException("SYNTAX", "Error in bad format");
                    }
                    errorType = ST.nextToken();
                    String errorMsg = this.in.readLine();
                    this.busy = false;
                    this.notifyAll();
                    throw new Tp2ProcessException(errorType, errorMsg);
                }
                this.busy = false;
                this.notifyAll();
                return result;
            }
            Tp2Env.stdErr("Result sent by client was null. Connection is probably broken.");
            if (this.starterProcess != null) {
                try {
                    int exitValue = this.starterProcess.exitValue();
                    Tp2Env.stdErr("Starter process exitValue: " + exitValue);
                }
                catch (IllegalThreadStateException e) {
                    Tp2Env.stdErr("The starterProcess is not finished. Killing it...");
                    this.starterProcess.destroy();
                    this.starterProcess = null;
                }
            } else {
                Tp2Env.stdErr("starterProcess is null");
            }
            this.busy = false;
            this.notifyAll();
            throw new Tp2ProcessException("COMMUNICATION", "Connection to the starter was broken");
        }
        catch (IOException e) {
            this.busy = false;
            this.notifyAll();
            throw new Tp2ProcessException("COMMUNICATION", e.toString());
        }
    }

    private Process exec(int userId) throws Tp2Exception {
        try {
            String procId = this.sendCommand("START", userId);
            Tp2Process result = new Tp2Process(Integer.parseInt(procId));
            this.processes.put(new CompInt(userId), result);
            return result;
        }
        catch (Tp2ProcessException e) {
            throw new Tp2Exception("User was not started.", 2, e);
        }
    }

    private void close() throws Tp2Exception {
        try {
            if (this.starterProcess != null) {
                BenchEnv.stdOut(CONSOLE_PREFIX, "Closing current Tp2ProcessFactory...", 20);
                this.starterProcess.destroy();
                this.starterProcess = null;
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void abort() throws Tp2Exception {
        Iterator it = this.processes.values().iterator();
        while (it.hasNext()) {
            ((Tp2Process)it.next()).destroy();
        }
        this.processes.clear();
        this.processes = null;
        this.close();
    }

    private class Tp2Process
    extends Process {
        private int processId = 0;
        private Integer exitValue = null;

        public Tp2Process(int processId) {
            this.processId = processId;
        }

        public void destroy() {
            try {
                this.exitValue = new Integer(Tp2ProcessFactory.this.sendCommand("KILL", this.processId));
            }
            catch (Tp2ProcessException e) {
                Tp2Env.stdErr("Killing of process " + this.processId + " failed because of " + e);
            }
        }

        public int waitFor() throws InterruptedException {
            try {
                if (this.exitValue != null) {
                    return this.exitValue;
                }
                this.exitValue = new Integer(Tp2ProcessFactory.this.sendCommand("WAITFOR", this.processId));
                return this.exitValue;
            }
            catch (Tp2ProcessException e) {
                Tp2Env.stdErr("Could not waitFor() process " + this.processId + " because of " + e);
                return -666;
            }
        }

        public int exitValue() {
            try {
                if (this.exitValue != null) {
                    return this.exitValue;
                }
                String cmdRes = Tp2ProcessFactory.this.sendCommand("EXITVALUE", this.processId);
                if (cmdRes.equals("NOTFINISHED")) {
                    throw new IllegalThreadStateException("Process " + this.processId + " not finished");
                }
                this.exitValue = new Integer(cmdRes);
                return this.exitValue;
            }
            catch (Tp2ProcessException e) {
                Tp2Env.stdErr("Could not get exitValue() of process " + this.processId + " because of " + e);
                return -666;
            }
        }

        public int getProcessId() {
            return this.processId;
        }

        public String toString() {
            return "Tp2Process[pId=" + this.getProcessId() + "]";
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public InputStream getInputStream() {
            return null;
        }

        public InputStream getErrorStream() {
            return null;
        }
    }
}

