/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.OutputLevels;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.testframe.driver.TestDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

class Tp2Env
implements OutputLevels {
    public static final String backupId = "TP2_SV_D";
    public static final String backupFile = "tp2Backup";
    private static Runtime runtime = null;
    private static boolean initialized = false;
    private static long globalBeginTime;
    private static long maxGlobalDuration;
    private static boolean maxGlobalDurationSet;
    private static String jTestHome;
    private static String testsHome;
    private static String tp2Home;
    private static String logHome;
    private static File localUsualDurationsPropFile;
    private static Properties localUsualDurations;

    static {
        maxGlobalDurationSet = false;
        jTestHome = null;
        testsHome = null;
        tp2Home = null;
        logHome = null;
        localUsualDurationsPropFile = null;
        localUsualDurations = null;
    }

    Tp2Env() {
    }

    public static void initTp2Env() throws Tp2Exception {
        globalBeginTime = System.currentTimeMillis();
        runtime = Runtime.getRuntime();
        jTestHome = String.valueOf(TestDriver.getJTestRoot()) + File.separator;
        tp2Home = String.valueOf(jTestHome) + File.separator + "tp2" + File.separator;
        File tp2HomeF = new File(tp2Home);
        tp2HomeF.mkdirs();
        logHome = String.valueOf(tp2Home) + File.separator + "log" + File.separator;
        testsHome = String.valueOf(jTestHome) + File.separator + "tests" + File.separator;
        localUsualDurationsPropFile = new File(String.valueOf(Tp2Env.getTp2Home()) + "tp2SystemLocal.properties");
        try {
            localUsualDurations = new Properties();
            if (localUsualDurationsPropFile.exists()) {
                localUsualDurations.load(new FileInputStream(localUsualDurationsPropFile));
            } else {
                localUsualDurations.setProperty("cumulatedInitDuration", "40000");
                localUsualDurations.setProperty("cumulatedRunUtilitiesDuration", "30000");
                localUsualDurations.setProperty("nbrInitDuration", "1");
                localUsualDurations.setProperty("nbrRunUtilitiesDuration", "1");
                localUsualDurations.store(new FileOutputStream(localUsualDurationsPropFile), "First initialization of system local properties of TP2 benchmark");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getJTestHome() {
        return jTestHome;
    }

    public static String getTp2Home() {
        return tp2Home;
    }

    public static String getTestsHome() {
        return testsHome;
    }

    public static String getCaseLogDir(int caseId) {
        String caseLogDir = null;
        caseLogDir = !StorableObject.isNonPersistent() ? String.valueOf(logHome) + caseId + File.separator : NonPersistent.getLogDir();
        File caseLogDirFile = new File(caseLogDir);
        if (!caseLogDirFile.exists()) {
            caseLogDirFile.mkdirs();
        }
        return caseLogDir;
    }

    public static long getGlobalBeginTime() {
        return globalBeginTime;
    }

    public static void stdOut(Object obj) {
        Tp2Env.stdOut(obj, 1);
    }

    public static void stdOut(Object obj, int outputLevel) {
        BenchEnv.stdOut("TP2", obj, outputLevel);
    }

    public static void stdErr(Object obj) {
        BenchEnv.stdErr("TP2", obj);
    }

    public static String memoryReport() {
        double megaByte = 1048576.0;
        double precision = 100.0;
        double freeMemory = (double)runtime.freeMemory() / 1048576.0;
        Double totalMemory = new Double((double)runtime.totalMemory() / 1048576.0);
        Double usedMemory = new Double(totalMemory - freeMemory);
        StringBuffer result = new StringBuffer("");
        result.append(" Java memory:");
        result.append(" used=").append(usedMemory.intValue()).append(".").append(new Double((usedMemory - (double)usedMemory.intValue()) * 100.0).intValue());
        result.append(" total=").append(totalMemory.intValue()).append(".").append(new Double((totalMemory - (double)totalMemory.intValue()) * 100.0).intValue());
        return result.toString();
    }

    public static void setMaxGlobalDuration(long maxGlobalDuration) {
        if (!maxGlobalDurationSet) {
            Tp2Env.maxGlobalDuration = maxGlobalDuration;
            maxGlobalDurationSet = true;
        } else if (maxGlobalDuration < Tp2Env.maxGlobalDuration) {
            Tp2Env.maxGlobalDuration = maxGlobalDuration;
        }
    }

    public static boolean isMaxGlobalDurationSet() {
        return maxGlobalDurationSet;
    }

    public static String getMaxGlobalDurationFormatted() {
        return BenchEnv.formatDuration(maxGlobalDuration / 1000L);
    }

    public static String getGlobalEndTimeFormatted() {
        return BenchEnv.formatTime(maxGlobalDuration + globalBeginTime, true);
    }

    public static void testIfShouldAbort(long expectedDurationOfNextStep) throws Tp2Exception {
        if (maxGlobalDurationSet && maxGlobalDuration < System.currentTimeMillis() - globalBeginTime + expectedDurationOfNextStep + 60000L) {
            Tp2Env.stdOut("#");
            Tp2Env.stdOut("# Interrupts the test because it should not last more than " + BenchEnv.formatDuration(maxGlobalDuration / 1000L));
            Tp2Env.stdOut("#");
            throw new Tp2Exception("Because of global time limit test should abort.", 3);
        }
    }

    public static long getLocalUsualRunUtilitiesDuration() {
        return Long.parseLong(localUsualDurations.getProperty("cumulatedRunUtilitiesDuration")) / Long.parseLong(localUsualDurations.getProperty("nbrRunUtilitiesDuration")) / 1000L;
    }

    public static int getNbrOfRunUtilitiesDurationMeasures() {
        return Integer.parseInt(localUsualDurations.getProperty("nbrRunUtilitiesDuration"));
    }

    public static void updateLocalUsualRunUtilitiesDuration(long runUtilitiesDuration) {
        localUsualDurations.setProperty("cumulatedRunUtilitiesDuration", Long.toString(runUtilitiesDuration + Long.parseLong(localUsualDurations.getProperty("cumulatedRunUtilitiesDuration"))));
        int nbrRunUtilitiesDuration = Integer.parseInt(localUsualDurations.getProperty("nbrRunUtilitiesDuration"));
        localUsualDurations.setProperty("nbrRunUtilitiesDuration", Integer.toString(++nbrRunUtilitiesDuration));
        Tp2Env.storeLocalUsualDurations();
    }

    public static long getLocalUsualInitDuration() {
        return Long.parseLong(localUsualDurations.getProperty("cumulatedInitDuration")) / Long.parseLong(localUsualDurations.getProperty("nbrInitDuration")) / 1000L;
    }

    public static int getNbrOfInitDurationMeasures() {
        return Integer.parseInt(localUsualDurations.getProperty("nbrInitDuration"));
    }

    public static void updateLocalUsualInitDuration(long initDuration) {
        localUsualDurations.setProperty("cumulatedInitDuration", Long.toString(initDuration + Long.parseLong(localUsualDurations.getProperty("cumulatedInitDuration"))));
        localUsualDurations.setProperty("nbrInitDuration", Integer.toString(1 + Integer.parseInt(localUsualDurations.getProperty("nbrInitDuration"))));
        Tp2Env.storeLocalUsualDurations();
    }

    private static void storeLocalUsualDurations() {
        try {
            localUsualDurations.store(new FileOutputStream(localUsualDurationsPropFile), "Update of the system local properties of the TP2 benchmark - " + BenchEnv.getCurrentTimeFormatted(true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

