/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.CaseEnv;
import com.sap.sapdb.benchmark.tp2.test.SimulatedUser;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.benchmark.tp2.test.Tp2ProcessFactory;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SystemUser
extends SimulatedUser {
    public static final long WAITLOCK_LIMIT = 30000L;
    private static Runtime runtime = null;
    private static Connection preSyncConnection = null;
    private static Connection postSyncConnection = null;
    private static Connection preTabLockConnection = null;
    private Process userProcess = null;

    static {
        runtime = Runtime.getRuntime();
    }

    public static void initTestRun(TestEnv testEnv) throws Tp2Exception {
        try {
            CaseEnv caseEnv = testEnv.getCaseEnv();
            if (preSyncConnection == null || preSyncConnection.isClosed()) {
                preSyncConnection = caseEnv.createTestDBConnection();
            }
            Statement preSyncStmt = preSyncConnection.createStatement();
            try {
                preSyncStmt.executeUpdate("DROP TABLE readyusers");
                preSyncStmt.equals("commit");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            preSyncStmt.executeUpdate("CREATE TABLE readyusers ( ID \tINTEGER)");
            preSyncStmt.equals("commit");
            if (preTabLockConnection == null || preTabLockConnection.isClosed()) {
                preTabLockConnection = caseEnv.createTestDBConnection();
            }
            preTabLockConnection.setAutoCommit(false);
            Statement preTabLockStmt = preTabLockConnection.createStatement();
            try {
                preTabLockStmt.executeUpdate("DROP TABLE lockusers");
                preTabLockStmt.execute("commit");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            preTabLockStmt.executeUpdate("CREATE TABLE lockusers (FIELD VARCHAR(200))");
            preTabLockStmt.executeUpdate("INSERT INTO lockusers VALUES ('This is the table that synchronizes the benchmark users by setting an exclusive table lock on this table and first releasing it after all users tried to access the table')");
            preTabLockStmt.execute("commit");
            preTabLockStmt.executeUpdate("LOCK TABLE lockusers IN EXCLUSIVE MODE");
        }
        catch (SQLException sqle) {
            throw new Tp2Exception("Problem when creating the syncronization table lockusers", 2, sqle);
        }
        if (testEnv.getCaseEnv().isUsingTp2Processes()) {
            String executableName = testEnv.getCaseEnv().getBenchmark().getExecutableName(testEnv.getAccessType());
            Tp2ProcessFactory.initCurrent(SystemUser.getGeneralCommand(String.valueOf(Tp2Env.getTp2Home()) + "Tp2Starter", String.valueOf(Tp2Env.getTp2Home()) + executableName, testEnv), testEnv);
            Tp2Env.stdOut("Initialized Tp2ProcessFactory", 20);
        }
    }

    public static void deleteLockFromTable(int userCount, TestEnv testEnv) throws Tp2Exception {
        Tp2Env.stdOut("Releasing exclusive lock from table LOCKUSERS  ...", 20);
        long begin = System.currentTimeMillis();
        boolean ready = false;
        CaseEnv caseEnv = testEnv.getCaseEnv();
        try {
            while (!ready) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    ready = true;
                    int[] readyIds = new int[userCount];
                    int i = 0;
                    while (i < readyIds.length) {
                        readyIds[i] = -1;
                        ++i;
                    }
                    long missing = userCount;
                    if (preSyncConnection == null) {
                        preSyncConnection = caseEnv.createTestDBConnection();
                    }
                    Statement preSyncStmt = preSyncConnection.createStatement();
                    try {
                        ResultSet rs = preSyncStmt.executeQuery("SELECT * FROM readyusers");
                        while (rs.next()) {
                            --missing;
                            readyIds[rs.getInt((String)"id")] = 1;
                        }
                        if (missing > 0L) {
                            ready = false;
                        }
                        preSyncStmt.close();
                        BenchEnv.stdOut("WAITLOCK", String.valueOf(BenchEnv.getCurrentTimeFormatted(false)) + " : " + missing + " users are missing", 20);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    if (System.currentTimeMillis() - begin > 30000L) {
                        BenchEnv.stdErr("WAITLOCK", "Aborting WAITLOCK loop after 30000ms");
                        StringBuffer existingUsers = new StringBuffer(" ");
                        StringBuffer missingUsers = new StringBuffer(" ");
                        int j = 0;
                        while (j < readyIds.length) {
                            if (readyIds[j] == -1) {
                                missingUsers.append(String.valueOf(j) + " ");
                            } else {
                                existingUsers.append(String.valueOf(j) + " ");
                            }
                            ++j;
                        }
                        throw new Tp2Exception("Aborted WAITLOCK loop because it lasts more than 30s (missingUsers=[" + missingUsers + "])", 2);
                    }
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    System.err.println(e);
                    throw new Tp2Exception("WAITLOCK loop aborted because of an unexpected exception: " + e, 2, e);
                }
            }
            long end = System.currentTimeMillis();
            Tp2Env.stdOut("Remove exclusive table lock from table LOCKUSERS after having waited " + (end - begin) / 1000L + "s" + (end - begin) % 1000L + "ms", 10);
            Statement preTabLockStmt = preTabLockConnection.createStatement();
            preTabLockStmt.execute("rollback");
        }
        catch (SQLException se) {
            System.out.println("SQLException - \nErrorcode: " + se.getErrorCode() + "\n Message: " + se.getMessage());
        }
    }

    private static String[] getGeneralCommand(String index0, String index1, TestEnv testEnv) throws Tp2Exception {
        String[] result = null;
        CaseEnv caseEnv = testEnv.getCaseEnv();
        String host = null;
        String transacImplFlag = null;
        if (testEnv.getAccessType().getInterface() == 0) {
            host = caseEnv.getServerNode().getHostName();
        } else if (testEnv.getAccessType().getInterface() == 256) {
            host = "localhost";
        } else if (testEnv.getAccessType().getInterface() == 1024) {
            host = caseEnv.getServerNode().getHostName();
        } else if (testEnv.getAccessType().getInterface() == 1280) {
            host = caseEnv.getServerNode().getHostName();
        } else {
            throw new Tp2Exception("Access type " + testEnv.getAccessType() + " is not an interface compatible with SystemUser", 3);
        }
        if (testEnv.getAccessType().getTransacImpl() == 32) {
            transacImplFlag = "S";
        } else if (testEnv.getAccessType().getTransacImpl() == 0) {
            transacImplFlag = "P";
        } else if (testEnv.getAccessType().getTransacImpl() == 16) {
            transacImplFlag = "C";
        }
        int scaleDefault = -1;
        int noOfExecutions = Integer.parseInt(caseEnv.getProp("tp2.ext.noOfExecutions"));
        int id = -1;
        try {
            id = Integer.parseInt(index1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String[] resultT = new String[]{index0, index1, Integer.toString(testEnv.getTestDuration()), testEnv.getCaseEnv().getTestDB().getName(), host, caseEnv.getNativeLogFilePath(id), transacImplFlag, Integer.toString(scaleDefault), Integer.toString(noOfExecutions)};
        result = resultT;
        int ix = 0;
        while (ix < result.length) {
            Tp2Env.stdOut("Used parameters[" + ix + "]: " + result[ix], 20);
            ++ix;
        }
        return result;
    }

    private static String[] getGeneralCommand(String index0, String index1, TestEnv testEnv, int scaleFactor) throws Tp2Exception {
        String[] result = null;
        CaseEnv caseEnv = testEnv.getCaseEnv();
        String host = null;
        String transacImplFlag = null;
        Tp2Env.stdOut("TP2 user uses schemas (determined by scaleFactor): " + Integer.toString(scaleFactor), 20);
        if (testEnv.getAccessType().getInterface() == 0) {
            host = caseEnv.getServerNode().getHostName();
        } else if (testEnv.getAccessType().getInterface() == 256) {
            host = "localhost";
        } else if (testEnv.getAccessType().getInterface() == 1024) {
            host = caseEnv.getServerNode().getHostName();
        } else if (testEnv.getAccessType().getInterface() == 1280) {
            host = caseEnv.getServerNode().getHostName();
        } else {
            throw new Tp2Exception("Access type " + testEnv.getAccessType() + " is not an interface compatible with SystemUser", 3);
        }
        if (testEnv.getAccessType().getTransacImpl() == 32) {
            transacImplFlag = "S";
        } else if (testEnv.getAccessType().getTransacImpl() == 0) {
            transacImplFlag = "P";
        } else if (testEnv.getAccessType().getTransacImpl() == 16) {
            transacImplFlag = "C";
        }
        int id = -1;
        int noOfExecutions = Integer.parseInt(caseEnv.getProp("tp2.ext.noOfExecutions"));
        try {
            id = Integer.parseInt(index1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String[] resultT = new String[]{index0, index1, Integer.toString(testEnv.getTestDuration()), testEnv.getCaseEnv().getTestDB().getName(), host, caseEnv.getNativeLogFilePath(id), transacImplFlag, Integer.toString(scaleFactor), Integer.toString(noOfExecutions)};
        result = resultT;
        int ix = 0;
        while (ix < result.length) {
            Tp2Env.stdOut("Used parameters[" + ix + "]: " + result[ix], 20);
            ++ix;
        }
        return result;
    }

    public SystemUser(int id, TestEnv testEnv) {
        super(id, testEnv);
    }

    public void runUser() throws Tp2Exception {
        try {
            if (this.getTestEnv().getCaseEnv().isUsingTp2Processes()) {
                this.userProcess = Tp2ProcessFactory.createProcess(this.getId());
            } else {
                if (BenchEnv.currentJavaVersionNotUnder("1.3")) {
                    String[] tmp = this.getCommand();
                    this.userProcess = runtime.exec(this.getCommand(), null, new File(Tp2Env.getTp2Home()));
                } else {
                    this.userProcess = runtime.exec(this.getCommand());
                }
                this.userProcess.getOutputStream().close();
            }
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (IOException e) {
            throw new Tp2Exception("Problem when starting program", 2, e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.currentState = 3;
    }

    public void runUser(int scaleFactor) throws Tp2Exception {
        try {
            if (this.getTestEnv().getCaseEnv().isUsingTp2Processes()) {
                this.userProcess = Tp2ProcessFactory.createProcess(this.getId());
            } else {
                this.userProcess = BenchEnv.currentJavaVersionNotUnder("1.3") ? runtime.exec(this.getCommand(scaleFactor), null, new File(Tp2Env.getTp2Home())) : runtime.exec(this.getCommand(scaleFactor));
                this.userProcess.getOutputStream().close();
            }
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (IOException e) {
            throw new Tp2Exception("Problem when starting program", 2, e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.currentState = 3;
    }

    public boolean isFinished() {
        if (this.currentState == 4) {
            return true;
        }
        try {
            if (this.userProcess != null) {
                int exitValue = this.userProcess.exitValue();
                this.currentState = exitValue == 0 ? 4 : 5;
                return true;
            }
            this.currentState = 5;
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public void abort() {
        if (this.userProcess != null) {
            this.userProcess.destroy();
        }
        this.isFinished();
    }

    public int getExitValue() throws IllegalThreadStateException {
        if (this.userProcess != null) {
            return this.userProcess.exitValue();
        }
        return 10;
    }

    private String[] getCommand() throws Tp2Exception {
        AccessType accessType = this.getTestEnv().getAccessType();
        String executableName = this.getTestEnv().getCaseEnv().getBenchmark().getExecutableName(accessType);
        return SystemUser.getGeneralCommand(String.valueOf(Tp2Env.getTp2Home()) + executableName, Integer.toString(this.getId()), this.getTestEnv());
    }

    private String[] getCommand(int scaleFactor) throws Tp2Exception {
        AccessType accessType = this.getTestEnv().getAccessType();
        String executableName = this.getTestEnv().getCaseEnv().getBenchmark().getExecutableName(accessType);
        return SystemUser.getGeneralCommand(String.valueOf(Tp2Env.getTp2Home()) + executableName, Integer.toString(this.getId()), this.getTestEnv(), scaleFactor);
    }

    public void finalize() {
        if (this.userProcess != null) {
            try {
                this.userProcess.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            this.userProcess.destroy();
            try {
                this.userProcess.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            this.userProcess = null;
        }
    }
}

