/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;

public abstract class SimulatedUser
implements Comparable {
    public static final int EMPTY = 0;
    public static final int INITIALIZED = 1;
    public static final int READY = 2;
    public static final int RUNNING = 3;
    public static final int FINISHED_OK = 4;
    public static final int FINISHED_BAD = 5;
    public static final String SIMULATED_USER_NAME = "bench";
    public static final String SIMULATED_USER_PASSWORD = "bench";
    protected static boolean waitingForBegin = false;
    protected int currentState = 0;
    private int id;
    private TestEnv testEnv = null;

    public static String convertState(int state) {
        if (state == 0) {
            return "EMPTY";
        }
        if (state == 1) {
            return "INITIALIZED";
        }
        if (state == 2) {
            return "READY";
        }
        if (state == 3) {
            return "RUNNING";
        }
        if (state == 4) {
            return "FINISHED_OK";
        }
        if (state == 5) {
            return "FINISHED_BAD";
        }
        return "UNKNOWN";
    }

    public static void setWaitingForBegin(boolean waitForBegin) {
        waitingForBegin = waitForBegin;
    }

    protected SimulatedUser(int id, TestEnv testEnv) {
        this.id = id;
        this.testEnv = testEnv;
        this.currentState = 1;
    }

    public abstract int getExitValue() throws IllegalThreadStateException;

    public abstract void abort();

    public abstract void runUser() throws Tp2Exception;

    public abstract void runUser(int var1) throws Tp2Exception;

    public int getId() {
        return this.id;
    }

    public boolean isFinished() {
        return this.currentState == 4 || this.currentState == 5;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public TestEnv getTestEnv() {
        return this.testEnv;
    }

    public int compareTo(Object obj) {
        if (obj instanceof SimulatedUser) {
            return this.getId() - ((SimulatedUser)obj).getId();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimulatedUser) {
            return this.getId() == ((SimulatedUser)obj).getId();
        }
        return false;
    }
}

