/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.SimulatedUser;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class JavaUser
extends SimulatedUser
implements Runnable {
    private static ThreadGroup javaUserThreads = null;
    protected Connection connection = null;
    private Thread userThread = null;
    private int transactionCount = 0;
    private int errorCount = 0;
    private boolean abort = false;

    static {
        javaUserThreads = new ThreadGroup("JavaUserThreads");
    }

    public JavaUser(int id, TestEnv testEnv) throws Tp2Exception {
        super(id, testEnv);
        try {
            if (this.getTestEnv().getAccessType().getInterface() == 512) {
                try {
                    System.loadLibrary("sapdbcbin");
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                this.connection = DriverManager.getConnection("jdbc:sapdb:" + this.getTestEnv().getCaseEnv().getTestDB().getName() + "?transport=native", "bench", "bench");
            } else {
                this.connection = DriverManager.getConnection("jdbc:sapdb:" + this.getTestEnv().getCaseEnv().getTestDB().getName() + "?transport=socket", "bench", "bench");
            }
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new Tp2Exception("Could not initialize JDBC connection", 2, e);
        }
    }

    protected abstract void executeTransaction() throws SQLException;

    protected abstract void executeTransactionPlDBProc() throws SQLException;

    protected abstract void executeTransactionCppDBProc() throws SQLException;

    protected void closeSQL() throws SQLException {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block20: {
            this.currentState = 2;
            while (true) {
                if (!waitingForBegin) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.currentState = 3;
            long begin = System.currentTimeMillis();
            long now = System.currentTimeMillis();
            while (true) {
                Object var6_8;
                if (now - begin >= (long)(this.getTestEnv().getTestDuration() * 1000) || this.abort) {
                    if (!this.abort) break;
                    this.currentState = 5;
                    break block20;
                }
                try {
                    try {
                        if (this.getTestEnv().getAccessType().getTransacImpl() == 32) {
                            this.executeTransaction();
                        } else if (this.getTestEnv().getAccessType().getTransacImpl() == 0) {
                            this.executeTransactionPlDBProc();
                        } else if (this.getTestEnv().getAccessType().getTransacImpl() == 16) {
                            this.executeTransactionCppDBProc();
                        } else {
                            Tp2Env.stdErr("No userType consistent with JavaUser was defined (JavaUser[" + this.getId() + "]");
                        }
                        ++this.transactionCount;
                    }
                    catch (SQLException e) {
                        ++this.errorCount;
                    }
                }
                catch (Throwable throwable) {
                    var6_8 = null;
                    Thread.currentThread();
                    Thread.yield();
                    now = System.currentTimeMillis();
                    throw throwable;
                }
                {
                    var6_8 = null;
                }
                Thread.currentThread();
                Thread.yield();
                now = System.currentTimeMillis();
            }
            try {
                this.getTestEnv().preStoreResults(this.getId(), this.getTestEnv().getTestDuration(), this.transactionCount, this.errorCount);
                this.currentState = 4;
            }
            catch (Exception e) {
                this.currentState = 5;
            }
        }
        try {
            this.closeSQL();
            if (this.connection == null) return;
            this.connection.close();
            return;
        }
        catch (SQLException e) {
            Tp2Env.stdErr("Problem in JavaUser[" + this.getId() + "] when closing ressources : " + e);
        }
    }

    public void runUser() {
        this.userThread = new Thread(javaUserThreads, this, "JavaUser[" + this.getId() + "]");
        this.userThread.setPriority(1);
        this.userThread.start();
    }

    public int getExitValue() throws IllegalThreadStateException {
        if (this.currentState == 4) {
            return 0;
        }
        if (this.currentState == 5) {
            return 1;
        }
        throw new IllegalThreadStateException("JavaUser is not finished. Current state is " + JavaUser.convertState(this.currentState));
    }

    public void abort() {
        if (this.currentState != 4 && this.currentState != 5) {
            this.abort = true;
        }
    }
}

