/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.CompInt;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.common.Tp2Result;
import com.sap.sapdb.benchmark.tp2.test.SingleTest;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.benchmark.tp2.util.SimpleXMLHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class CaseLog {
    private static final int BUFFER_SIZE = 2000;
    private static final int MAX_LINES_COPIED_FROM_NATIVE_LOG = 100000;
    private File caseLog = null;
    private StringBuffer logBuf = new StringBuffer(2000);
    private String nativeLogPrefix = null;
    private File nativeLogOld = null;
    private File nativeLogTemp = null;
    private String nextComponentCloseTag = null;
    private SingleTest currentSingleTest = null;

    public CaseLog(int caseId, String beginTimeStr) throws Tp2Exception {
        this.caseLog = new File(String.valueOf(Tp2Env.getCaseLogDir(caseId)) + "tp2_caseLog_" + caseId + "-" + beginTimeStr + ".xml");
        this.nativeLogPrefix = String.valueOf(Tp2Env.getCaseLogDir(caseId)) + "tp2_nativeLog_" + caseId + "-" + beginTimeStr;
        this.nativeLogOld = new File(String.valueOf(Tp2Env.getCaseLogDir(caseId)) + "tp2_nativeLog_" + caseId + "-" + beginTimeStr + ".old.xml");
        this.nativeLogTemp = new File(String.valueOf(Tp2Env.getCaseLogDir(caseId)) + "tp2_nativeLog_" + caseId + "-" + beginTimeStr + ".xml");
        try {
            FileWriter FW = new FileWriter(this.caseLog);
            FW.write("<CaseLog beginTime=\"" + beginTimeStr + "\">\n");
            FW.close();
        }
        catch (IOException e) {
            throw new Tp2Exception("Could not initialize log", 3, e);
        }
        BenchEnv.stdOut("LOG", "Created new CaseLog " + this.caseLog, 20);
    }

    public void log(Object obj) {
        this.logBuf.append(obj.toString());
    }

    public void logError(String cmpnt, String msg, Exception cause) {
        this.logBuf.append("<Error>\n");
        this.logBuf.append("\t<Time>" + BenchEnv.getCurrentTimeFormatted(true) + "</Time>\n");
        this.logBuf.append("\t<Component>" + cmpnt + "</Component>\n");
        this.logBuf.append("\t<Msg>" + msg + "</Msg>\n");
        if (cause != null) {
            this.logBuf.append("\t<RootException class=\"" + cause.getClass() + "\">\n");
            this.logBuf.append("\t\t<ErrorMsg><![CDATA[\n");
            this.logBuf.append(cause.getMessage());
            this.logBuf.append("\n");
            this.logBuf.append("\t\t]]></ErrorMsg>\n");
            this.logBuf.append("\t\t<StackTrace><![CDATA[\n");
            try {
                StringWriter strW = new StringWriter();
                cause.printStackTrace(new PrintWriter(strW));
                this.logBuf.append(strW.toString());
                strW.close();
                this.logBuf.append("\t\t]]></StackTrace>\n");
            }
            catch (IOException eIO) {
                this.logBuf.append("\t\t]]></StackTrace>\n");
                this.logBuf.append("<Msg>Problem when writing log: " + cause + "</Msg>\n</Error>\n");
            }
            this.logBuf.append("\t</RootException>\n");
        }
        this.logBuf.append("</Error>\n");
    }

    public void logResult(Tp2Result result, boolean fullResult) throws Tp2Exception {
        if (fullResult) {
            this.logBuf.append(result.getFullInfoAsXml());
        } else {
            this.logBuf.append(result.getInfoAsXml());
        }
    }

    public void logAsCDATA(Object obj) {
        this.logBuf.append("<![CDATA[\n");
        this.logBuf.append(obj.toString()).append('\n');
        this.logBuf.append("]]>\n");
    }

    public void openSingleTestComponent(SingleTest singleTest) throws Tp2Exception {
        this.currentSingleTest = singleTest;
        this.openComponent("SingleTest", "userCount=\"" + this.currentSingleTest.getTestEnv().getUserCount() + "\" duration=\"" + this.currentSingleTest.getTestEnv().getTestDuration() + "\"");
    }

    public void openComponent(String tagName, String infos) throws Tp2Exception {
        if (this.isComponentOpen()) {
            BenchEnv.stdErr("LOG", "There was already an open component tag in caseLog. Append close tag " + this.nextComponentCloseTag + " in order to open tag " + tagName);
            this.closeComponent();
        }
        if (infos != null) {
            this.logBuf.append("<" + tagName + " " + infos + ">\n");
        } else {
            this.logBuf.append("<" + tagName + ">\n");
        }
        this.nextComponentCloseTag = "</" + tagName + ">";
    }

    public void closeComponent() throws Tp2Exception {
        if (this.isComponentOpen()) {
            this.insertNativeLog();
            this.logBuf.append(String.valueOf(this.nextComponentCloseTag) + "\n");
            this.flush();
            this.nextComponentCloseTag = null;
        }
        this.currentSingleTest = null;
    }

    public boolean isComponentOpen() {
        return this.nextComponentCloseTag != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertNativeLog() {
        boolean somethingWritten = false;
        try {
            FileWriter out = new FileWriter(this.nativeLogTemp);
            out.write("<NativeLog>\n");
            somethingWritten = false;
            File onlyOneFile = new File(this.getNativeLogFilePath(-1));
            if (onlyOneFile.exists()) {
                somethingWritten = this.appendSingleNativeLog(out, onlyOneFile);
            } else if (this.currentSingleTest != null) {
                int i = 0;
                while (i < this.currentSingleTest.getTestEnv().getUserCount()) {
                    File nativeLogFile = new File(this.getNativeLogFilePath(i));
                    if (nativeLogFile.exists()) {
                        out.write("\n<UserErrors userId=\"" + i + "\">\n");
                        somethingWritten = this.appendSingleNativeLog(out, nativeLogFile);
                        out.write("</UserErrors>\n\n");
                    }
                    ++i;
                }
            }
            out.write("</NativeLog>");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.logError("CaseLog.insertNativeLog", "Problem when reading the single native log files", e);
            return;
        }
        if (!somethingWritten) return;
        try {
            try {
                NativeLogHandler handler = new NativeLogHandler();
                handler.parse(this.nativeLogTemp);
                Iterator codes = handler.getErrorCodes();
                if (codes.hasNext()) {
                    this.logBuf.append("<NativeLog>\n");
                    block8: while (true) {
                        if (!codes.hasNext()) {
                            this.logBuf.append("</NativeLog>\n");
                        }
                        CompInt code = (CompInt)codes.next();
                        this.logBuf.append("<NativeError code=\"" + code + "\" totalErrorCount=\"" + handler.getTotalErrorCount(code) + "\">");
                        SortedMap idMap = handler.getIdList(code);
                        Iterator ids = idMap.keySet().iterator();
                        while (true) {
                            if (!ids.hasNext()) {
                                this.logBuf.append("</NativeError>\n");
                                continue block8;
                            }
                            CompInt id = (CompInt)ids.next();
                            this.logBuf.append("<ErrorCount userId=\"" + id + "\">").append(idMap.get(id)).append("</ErrorCount>\n");
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logError("CaseLog.insertNativeLog", "Problem when inserting native log in caseLog", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.nativeLogTemp.renameTo(this.nativeLogOld);
            throw throwable;
        }
        {
            Object var8_13 = null;
            this.nativeLogTemp.renameTo(this.nativeLogOld);
        }
    }

    private boolean appendSingleNativeLog(Writer out, File singleNativeLog) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(singleNativeLog));
        String line = null;
        boolean somethingWritten = false;
        int lineCnt = 0;
        while ((line = in.readLine()) != null) {
            if (lineCnt % 2 == 0 && lineCnt >= 100000) {
                this.logError("CaseLog.appendSingleNativeLog", "Native file too big. There was more than " + lineCnt + " lines", null);
                break;
            }
            if (!somethingWritten) {
                somethingWritten = true;
            }
            out.write(String.valueOf(line) + "\n");
            ++lineCnt;
        }
        in.close();
        out.flush();
        singleNativeLog.delete();
        return somethingWritten;
    }

    public void flush() throws Tp2Exception {
        try {
            FileWriter FW = new FileWriter(this.caseLog.getPath(), true);
            FW.write(this.logBuf.toString());
            FW.flush();
            this.logBuf = new StringBuffer(2000);
            FW.close();
        }
        catch (IOException e) {
            this.logError("CaseLog.flush", "Could not flush log", e);
            this.dumpBuffer();
        }
    }

    public void close() throws Tp2Exception {
        if (this.isComponentOpen()) {
            this.closeComponent();
        }
        this.logBuf.append("\n</CaseLog>\n");
        this.flush();
    }

    public void dumpBuffer() {
        System.out.println("\n******************** Log buffer dump (begin) ********************");
        System.out.println(this.logBuf.toString());
        System.out.println("******************** Log buffer dump (end) ********************\n");
    }

    public File getCaseLogFile() {
        return this.caseLog;
    }

    public String getNativeLogFilePath(int id) {
        if (id < 0) {
            return String.valueOf(this.nativeLogPrefix) + ".log";
        }
        return String.valueOf(this.nativeLogPrefix) + "_" + id + ".log";
    }

    class NativeLogHandler
    extends SimpleXMLHandler {
        private SortedMap errors = new TreeMap();
        private CompInt currId = null;

        protected void startTag(String tagName, Attributes attr) throws SAXException {
        }

        protected void endTag(String tagName) throws SAXException {
            try {
                if (tagName.equals("Component")) {
                    StringTokenizer ST = new StringTokenizer(this.getTagText(), "_");
                    ST.nextToken();
                    this.currId = new CompInt(Integer.parseInt(ST.nextToken()));
                } else if (tagName.equals("Code")) {
                    SortedMap map;
                    CompInt code = new CompInt(Integer.parseInt(this.getTagText()));
                    if (!this.errors.containsKey(code)) {
                        this.errors.put(code, new TreeMap());
                    }
                    if ((map = (SortedMap)this.errors.get(code)).containsKey(this.currId)) {
                        map.put(this.currId, new CompInt(((CompInt)map.get(this.currId)).getValue() + 1));
                    } else {
                        map.put(this.currId, new CompInt(1));
                    }
                } else if (tagName.equals("Message")) {
                    CaseLog.this.logError("NativeLogHandler", "Message in simulated user " + this.currId + " : " + this.getTagText(), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Iterator getErrorCodes() {
            return this.errors.keySet().iterator();
        }

        public SortedMap getIdList(CompInt code) {
            return (SortedMap)this.errors.get(code);
        }

        public int getTotalErrorCount(CompInt code) {
            int errorCount = 0;
            SortedMap idMap = this.getIdList(code);
            Iterator ids = idMap.keySet().iterator();
            while (ids.hasNext()) {
                CompInt id = (CompInt)ids.next();
                errorCount += ((CompInt)idMap.get(id)).getValue();
            }
            return errorCount;
        }
    }
}

