/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.jsp;

import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.MaxcpuWp;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.ShortBuild;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.Version;
import com.sap.sapdb.benchmark.common.where.FilteredView;
import com.sap.sapdb.benchmark.common.where.WhereException;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.AverageResult;
import com.sap.sapdb.benchmark.tp2.common.StructuredResults;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.jsp.DBDescComparator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.SortedMap;
import java.util.SortedSet;

public class AverageSetGroup
extends FilteredView {
    private StructuredResults sResults = null;
    private DBDescComparator dbDescComparator = null;
    private boolean paramCompar;

    public AverageSetGroup(ServerNode serverNode, int viewType, boolean paramCompar) {
        this.sResults = new StructuredResults(serverNode, viewType);
        this.paramCompar = paramCompar;
    }

    public String getPreparedQuery() throws WhereException {
        StringBuffer res = new StringBuffer("");
        res.append("SELECT \ndef.usercount AS user_count,\ndef.user_type AS user_type,\ndef.test_time AS test_time, \ndbdesc.major AS major,\ndbdesc.minor AS minor,\ndbdesc.correction_level AS correction_level,\ndbdesc.maxcpu AS maxcpu,\nAVG(res.tps) AS Tps_avg,\n(STDDEV(res.tps)*100)/AVG(res.tps) AS tps_dev,\nCOUNT(res.def_id) AS test_count,\nSUM(res.errors) AS error_count,\n");
        if (this.sResults.isDBDescView()) {
            res.append("dbdesc.build AS build,\ndbdesc.id AS dbdesc_id,\ndbdesc.dbparameters_id AS dbparameters_id");
        } else if (this.sResults.isShortBuildView()) {
            res.append(String.valueOf(ShortBuild.extractShortBuildField("dbdesc")) + " AS short_build\n");
        }
        res.append(" FROM \nsessions sess,\nusers,\nservernodes nodes,\ndbdescriptions dbdesc,\ntp2_definitions def,\ntp2_results res,\ntp2_sessions_results lnk\n WHERE \n lnk.session_id = sess.id\n AND lnk.def_id = def.id\n AND sess.user_id = users.id\n AND dbdesc.id = def.dbdescription_id\n AND nodes.id = def.servernode_id\n AND res.def_id = def.id \n AND " + this.getPreparedWherePart() + "\n");
        if (this.sResults.isDBDescView()) {
            res.append(" GROUP BY dbdesc.id, def.user_type, def.test_time, def.usercount,\ndbdesc.major,dbdesc.minor,dbdesc.correction_level,dbdesc.build,\ndbdesc.dbparameters_id,dbdesc.maxcpu");
        } else if (this.sResults.isShortBuildView()) {
            res.append(" GROUP BY def.user_type, def.usercount,\ndbdesc.major,dbdesc.minor,dbdesc.correction_level,\n" + ShortBuild.extractShortBuildField("dbdesc") + ",dbdesc.maxcpu");
        }
        return res.toString();
    }

    private void handleNextForDbDescView() throws SQLException, Tp2Exception {
        ResultSet RS = this.executeQuery();
        while (RS.next()) {
            DBDescription currDd = new DBDescription(RS.getInt("dbdesc_id"), RS.getInt("major"), RS.getInt("minor"), RS.getInt("correction_level"), RS.getString("build"), RS.getInt("dbparameters_id"), RS.getInt("maxcpu"));
            AccessType currAt = new AccessType(RS.getString("user_type"));
            AverageResult ar = new AverageResult(RS.getInt("user_count"), RS.getFloat("tps_avg"), RS.getFloat("tps_dev"), RS.getInt("test_count"), RS.getTimestamp("test_time"), RS.getInt("error_count"), String.valueOf(this.getCurrentFilterInstance().getAsStaticWherePart()) + " AND " + currDd.getAsStaticWherePart("dbdesc") + " AND " + currAt.getAsStaticWherePart("def") + " AND " + "def" + ".usercount=" + RS.getInt("user_count") + " ");
            this.sResults.handleNextForDbDescView(currDd, currAt, ar);
            if (!this.paramCompar) continue;
            this.dbDescComparator.addDBDescription(currDd);
        }
        RS.close();
    }

    private void handleNextForShortBuildView() throws SQLException, Tp2Exception {
        ResultSet RS = this.executeQuery();
        while (RS.next()) {
            ShortBuild sb = new ShortBuild(new Version(RS.getInt("major"), RS.getInt("minor"), RS.getInt("correction_level")), RS.getString("short_build"));
            MaxcpuWp maxcpu = new MaxcpuWp(RS.getInt("maxcpu"));
            AccessType currAt = new AccessType(RS.getString("user_type"));
            AverageResult ar = new AverageResult(RS.getInt("user_count"), RS.getFloat("tps_avg"), RS.getFloat("tps_dev"), RS.getInt("test_count"), RS.getTimestamp("test_time"), RS.getInt("error_count"), String.valueOf(this.getCurrentFilterInstance().getAsStaticWherePart()) + " AND " + sb.getAsStaticWherePart("dbdesc") + " AND " + maxcpu.getAsStaticWherePart("dbdesc") + " AND " + currAt.getAsStaticWherePart("def") + " AND " + "def" + ".usercount=" + RS.getInt("user_count") + " ");
            this.sResults.handleNextForShortBuildView(sb, maxcpu, currAt, ar);
        }
        RS.close();
    }

    public void retrieve() throws SQLException, Tp2Exception, WhereException {
        this.prepare(StorableObject.getConnection());
        if (this.sResults.isDBDescView()) {
            if (this.paramCompar) {
                this.dbDescComparator = new DBDescComparator();
            }
            while (this.next()) {
                this.handleNextForDbDescView();
            }
            this.sResults.initSpansForDbDescView();
        } else if (this.sResults.isShortBuildView()) {
            while (this.next()) {
                this.handleNextForShortBuildView();
            }
            this.sResults.initSpansForShortBuildView();
        }
    }

    public SortedSet getAccessTypes() {
        return this.sResults.getAccessTypes();
    }

    public SortedMap getBuildsSpans() {
        return this.sResults.getBuildsSpans();
    }

    public SortedMap getDbDescsView() {
        return this.sResults.getDbDescsView();
    }

    public SortedMap getVersionsSpans() {
        return this.sResults.getVersionsSpans();
    }

    public SortedMap getShortBuildsSpans() {
        return this.sResults.getShortBuildsSpans();
    }

    public SortedMap getShortBuildsView() {
        return this.sResults.getShortBuildsView();
    }

    public SortedSet getUserCountList() {
        return this.sResults.getUserCountList();
    }

    public int getTestCount() {
        return this.sResults.getTestCount();
    }

    public int getViewType() {
        return this.sResults.getViewType();
    }

    public ServerNode getServerNode() {
        return this.sResults.getServerNode();
    }

    public DBDescComparator getDbDescComparator() {
        return this.dbDescComparator;
    }
}

