/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.common;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.Build;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.ShortBuild;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.AverageResult;
import com.sap.sapdb.benchmark.tp2.common.AverageSet;
import com.sap.sapdb.benchmark.tp2.common.StructuredResults;
import com.sap.sapdb.benchmark.tp2.common.Tp2Result;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class NonPersistentReport {
    private StructuredResults sResults = new StructuredResults(NonPersistent.getServerNode(), 0);
    static /* synthetic */ Class class$0;

    public void writeReport() {
        try {
            this.retrieve();
            ServerNode currHost = NonPersistent.getServerNode();
            StringBuffer resultList = new StringBuffer("");
            int arId = 0;
            PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(NonPersistent.getResultsDir()) + "report.html"));
            out.print("<HTML>\n");
            out.print("<HEADER><TITLE>Non persistent report</TITLE></HEADER>\n");
            out.print("<BODY style=\"FONT-FAMILY:sans-serif; FONT-SIZE:12px\">\n");
            out.print("<P style=\"FONT-SIZE:20px; FONT-WEIGHT:bold; TEXT-ALIGN:center\">TP2 NonPersistent report - " + this.convDate(new Date()) + "</P><HR>\n");
            int nbrOfAS = 0;
            if (this.sResults.getViewType() == 0) {
                nbrOfAS = this.sResults.getDbDescsView().size();
            }
            if (nbrOfAS > 0) {
                boolean accessTypesHeader;
                out.print("<P style=\"FONT-SIZE:14px; FONT-WEIGHT:bold\">" + currHost.getHostName() + " (" + currHost.getOsName() + ") - " + this.sResults.getTestCount() + " tests</P>\n");
                boolean bl = accessTypesHeader = this.sResults.getAccessTypes().size() != 1;
                if (accessTypesHeader) {
                    out.print("Access :<BR><TABLE style=\"FONT-SIZE:10px\" border=\"1\">\n");
                    Iterator atIt = this.sResults.getAccessTypes().iterator();
                    while (atIt.hasNext()) {
                        AccessType at = (AccessType)atIt.next();
                        out.print("<TR><TD style=\"TEXT-ALIGN:right\">" + at.getCode() + "</TD>");
                        out.print("<TD style=\"TEXT-ALIGN:left\">" + at.getCodeStr() + "</TD></TR>\n");
                    }
                    out.print("</TABLE>\n");
                } else {
                    out.print("<P>Access : " + ((AccessType)this.sResults.getAccessTypes().first()).getCodeStr() + "</P>\n");
                }
                out.print("<TABLE style=\"FONT-SIZE:12px\" border=\"1\">");
                out.print("<TR style=\"BACKGROUND-COLOR: #eeeeee\"><TD>Version</TD>");
                Iterator vIt = this.sResults.getVersionsSpans().entrySet().iterator();
                while (vIt.hasNext()) {
                    Map.Entry entry = vIt.next();
                    out.print("<TD title=\"" + entry.getKey() + "\" colspan=\"" + entry.getValue() + "\">" + entry.getKey() + "</TD>");
                }
                out.print("</TR>\n");
                if (this.sResults.getViewType() == 0) {
                    out.print("<TR style=\"BACKGROUND-COLOR: #eeeeee\"><TD>Build</TD>");
                    SortedMap map = this.sResults.getBuildsSpans();
                    Iterator bIt = map.keySet().iterator();
                    while (bIt.hasNext()) {
                        Build build = (Build)bIt.next();
                        ShortBuild sBuild = build.getShortBuild();
                        out.print("<TD colspan=\"" + map.get(build) + "\" title=\"" + build + "\">" + sBuild.getShortBuildAsString() + "-...</TD>");
                    }
                    out.print("</TR>\n");
                    out.print("<TR style=\"BACKGROUND-COLOR: #eeeeee\"><TD>DB Desc</TD>");
                    Iterator ddIt = this.sResults.getDbDescsView().entrySet().iterator();
                    while (ddIt.hasNext()) {
                        Map.Entry entry = ddIt.next();
                        DBDescription dd = (DBDescription)entry.getKey();
                        out.print("<TD colspan=\"" + ((SortedMap)entry.getValue()).size() + "\" title=\"" + dd.getBuildObject() + "#" + dd.getId() + "\">");
                        out.print("<A href=\"dbDescription_" + dd.getId() + ".html\">#" + dd.getId() + "[" + dd.getMAXCPU() + "]</A></TD>");
                        this.writeDBDescFile(dd);
                    }
                    out.print("</TR>\n");
                }
                if (accessTypesHeader) {
                    out.print("<TR  style=\"BACKGROUND-COLOR: #eeeeee\"><TD>Access</TD>");
                    Iterator atIt = null;
                    if (this.sResults.getViewType() == 0) {
                        atIt = this.sResults.getDbDescsView().entrySet().iterator();
                    } else if (this.sResults.getViewType() == 1) {
                        atIt = this.sResults.getShortBuildsView().entrySet().iterator();
                    }
                    while (atIt.hasNext()) {
                        Map.Entry entry = atIt.next();
                        Iterator ats = ((SortedMap)entry.getValue()).keySet().iterator();
                        while (ats.hasNext()) {
                            AccessType at = (AccessType)ats.next();
                            out.print("<TD title=\"" + at.getCodeStr() + "\">" + at.getCode() + "</TD>");
                        }
                    }
                    out.print("</TR>\n");
                }
                Iterator ucIt = this.sResults.getUserCountList().iterator();
                int cnt = 0;
                while (ucIt.hasNext()) {
                    String ucStr = ucIt.next().toString();
                    out.print("<TR><TD style=\"FONT-WEIGHT: bold;TEXT-ALIGN:right\">" + ucStr + "</TD>");
                    Iterator asIt1 = null;
                    if (this.sResults.getViewType() == 0) {
                        asIt1 = this.sResults.getDbDescsView().entrySet().iterator();
                    } else if (this.sResults.getViewType() == 1) {
                        asIt1 = this.sResults.getShortBuildsView().entrySet().iterator();
                    }
                    while (asIt1.hasNext()) {
                        Map.Entry entry1 = asIt1.next();
                        Iterator asIt2 = ((SortedMap)entry1.getValue()).entrySet().iterator();
                        while (asIt2.hasNext()) {
                            Map.Entry entry2 = asIt2.next();
                            AverageSet as = (AverageSet)entry2.getValue();
                            if (as.isEmpty()) continue;
                            AverageResult ar = as.get(ucStr);
                            if (ar == null) {
                                out.print("<TD align=\"center\">-</TD>");
                                continue;
                            }
                            out.print("<TD align=\"right\" title=\"" + ar.getTestCount() + " / " + ar.getTpsDev() + "%\">");
                            out.print("<A style=\"COLOR:" + ar.getColor() + "\" href=\"#averageResult_" + arId + "\">" + ar.getTpsAvg() + "</A></TD>\n");
                            resultList.append("<A name=\"averageResult_" + arId + "\" style=\"FONT-SIZE:12px; FONT-WEIGHT:bold\">");
                            resultList.append("Details #" + arId + " : " + ar.getUserCount() + " users");
                            resultList.append("</A><BR>");
                            resultList.append("<TABLE style=\"FONT-SIZE:12px\" border=\"1\">\n");
                            resultList.append("<TR  style=\"BACKGROUND-COLOR: #eeeeee\"><TD>Id</TD><TD>TPS</TD><TD>DB Description</TD><TD>x_cons show all</TD><TD>Dur.</TD><TD>Time</TD><TD>Access type</TD></TR>");
                            Iterator resIt = ar.getResults().iterator();
                            while (resIt.hasNext()) {
                                Tp2Result res = (Tp2Result)resIt.next();
                                resultList.append("<TR><TD style=\"COLOR: #000000\">" + res.getId() + "</TD>");
                                resultList.append("<TD style=\"FONT-WEIGHT:bold\">" + res.getTps() + "</TD>");
                                resultList.append("<TD><A style=\"COLOR: #000000\" href=\"dbDescription_" + res.getDBDescription().getId() + ".html\">" + res.getDBDescription().getBuildObjectWithIdAndMAXCPU() + "</A></TD>");
                                resultList.append("<TD><A style=\"COLOR: #000000\" href=\"./xConsShowAll/xConsShowAll_" + res.getId() + ".html\">x_cons show all</A></TD>");
                                resultList.append("<TD style=\"COLOR: #000000\">" + res.getDuration() + "</TD>");
                                resultList.append("<TD style=\"COLOR: #000000\">" + this.convDate(res.getTestTime()) + "</TD>");
                                resultList.append("<TD style=\"COLOR: #000000\">" + res.getAccessType() + "</TD>");
                                resultList.append("</TR>\n");
                            }
                            resultList.append("</TABLE><HR>\n");
                            ++arId;
                        }
                    }
                    ++cnt;
                    out.print("</TR>\n");
                }
                out.print("</TABLE><HR>\n");
                out.flush();
            }
            out.print(resultList.toString());
            out.print("</BODY>\n</HTML>\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void retrieve() {
        TreeMap map = new TreeMap();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sap.sapdb.benchmark.tp2.common.Tp2Result");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = NonPersistent.list(clazz);
        if (this.sResults.isDBDescView()) {
            DBDescViewId id;
            while (it.hasNext()) {
                Tp2Result result = (Tp2Result)it.next();
                id = new DBDescViewId(result.getDBDescription(), result.getAccessType(), result.getUserCount());
                if (!map.containsKey(id)) {
                    map.put(id, new TreeSet());
                }
                SortedSet set = (SortedSet)map.get(id);
                set.add(result);
            }
            Iterator ids = map.keySet().iterator();
            while (ids.hasNext()) {
                id = (DBDescViewId)ids.next();
                AverageResult ar = new AverageResult(id.userCount, (SortedSet)map.get(id));
                this.sResults.handleNextForDbDescView(id.dbDesc, id.accessType, ar);
            }
            this.sResults.initSpansForDbDescView();
        }
    }

    private void writeDBDescFile(DBDescription dbDesc) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(NonPersistent.getResultsDir()) + "dbDescription_" + dbDesc.getId() + ".html"));
        out.print("<HTML>\n");
        out.print("<HEADER><TITLE>DBdescription #" + dbDesc.getId() + "</TITLE></HEADER>\n");
        out.print("<BODY style=\"FONT-FAMILY:sans-serif; FONT-SIZE:10px\">\n");
        out.print("<P style=\"FONT-SIZE:20px; FONT-WEIGHT:bold; TEXT-ALIGN:center\">DBDescription #" + dbDesc.getId() + "</P>\n");
        out.print("Build : " + dbDesc.getBuildObject());
        out.print("<HR>");
        try {
            out.print("<TABLE style=\"FONT-SIZE:10px\" border=\"1\">");
            out.print("<TR><TD  style=\"BACKGROUND-COLOR: #eeeeee\">Parameter</TD><TD  style=\"BACKGROUND-COLOR: #eeeeee\">Value</TD></TR>");
            Iterator it = dbDesc.getDBParameters().getAsSortedMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                out.print("<TR><TD>" + entry.getKey() + "</TD><TD>" + entry.getValue() + "</TD></TR>\n");
            }
            out.print("</TABLE>\n");
        }
        catch (SQLException e) {
            out.print(e.toString());
        }
        out.print("</BODY>\n</HTML>\n");
        out.close();
    }

    private String convDate(Date date) {
        if (date == null) {
            return "-";
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return String.valueOf(BenchEnv.formatNbr(cal.get(5))) + "." + BenchEnv.formatNbr(cal.get(2) + 1) + "." + BenchEnv.formatNbr(cal.get(1) % 100) + " " + BenchEnv.formatNbr(cal.get(11)) + "h" + BenchEnv.formatNbr(cal.get(12));
    }

    private class DBDescViewId
    implements Comparable {
        private DBDescription dbDesc = null;
        private AccessType accessType = null;
        private int userCount = 0;

        public DBDescViewId(DBDescription dbDesc, AccessType accessType, int userCount) {
            this.dbDesc = dbDesc;
            this.accessType = accessType;
            this.userCount = userCount;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DBDescViewId) {
                DBDescViewId id = (DBDescViewId)obj;
                return this.userCount == id.userCount && this.dbDesc.equals(id.dbDesc) && this.accessType.equals(id.accessType);
            }
            return false;
        }

        public int compareTo(Object obj) {
            if (obj instanceof DBDescViewId) {
                DBDescViewId id = (DBDescViewId)obj;
                if (this.userCount == id.userCount) {
                    int ddC = this.dbDesc.compareTo(id.dbDesc);
                    if (ddC == 0) {
                        return this.accessType.compareTo(id.accessType);
                    }
                    return ddC;
                }
                return this.userCount - id.userCount;
            }
            return 0;
        }
    }
}

