/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.common;

import com.sap.sapdb.benchmark.common.CompInt;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.MaxcpuWp;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.ShortBuild;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.AverageResult;
import java.sql.Timestamp;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class AverageSet
implements Comparable {
    private SortedMap arList = new TreeMap();
    private ServerNode serverNode = null;
    private AccessType accessType = null;
    private int viewType = 0;
    private DBDescription dbDesc = null;
    private ShortBuild shortBuild = null;
    private MaxcpuWp maxcpu = null;
    private int testCount = 0;
    private Timestamp testDate = null;
    private int errorCount = 0;
    private boolean empty = true;

    public AverageSet(ServerNode serverNode, DBDescription dbDesc, AccessType accessType) {
        this.serverNode = serverNode;
        this.dbDesc = dbDesc;
        this.accessType = accessType;
        this.testCount = 0;
        this.testDate = null;
        this.viewType = 0;
    }

    public AverageSet(ServerNode serverNode, ShortBuild shortBuild, MaxcpuWp maxcpu, AccessType accessType) {
        this.serverNode = serverNode;
        this.shortBuild = shortBuild;
        this.maxcpu = maxcpu;
        this.accessType = accessType;
        this.testCount = 0;
        this.testDate = null;
        this.viewType = 1;
    }

    public void add(AverageResult ar) {
        CompInt uc = new CompInt(ar.getUserCount());
        if (!this.arList.containsKey(uc)) {
            this.arList.put(uc, ar);
        } else {
            AverageResult oldAr = (AverageResult)this.arList.get(uc);
            this.arList.put(uc, AverageResult.sum(ar, oldAr));
        }
        this.empty = false;
        this.testCount += ar.getTestCount();
        this.testDate = ar.getTestDate();
    }

    public AverageResult get(String userCountStr) {
        int uc = Integer.parseInt(userCountStr);
        return (AverageResult)this.arList.get(new CompInt(uc));
    }

    public SortedSet list() {
        return new TreeSet(this.arList.values());
    }

    public int size() {
        return this.arList.size();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public ServerNode getServerNode() {
        return this.serverNode;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public Timestamp getTestDate() {
        return this.testDate;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getViewType() {
        return this.viewType;
    }

    public DBDescription getDbDesc() {
        return this.dbDesc;
    }

    public ShortBuild getShortBuild() {
        return this.shortBuild;
    }

    public MaxcpuWp getMaxcpu() {
        return this.maxcpu;
    }

    public String getDescription() {
        if (this.viewType == 0) {
            return this.dbDesc.getBuildObject() + "#" + this.dbDesc.getId() + "[" + this.dbDesc.getMAXCPU() + "] @ " + this.serverNode.getShortHostName() + " - Access: " + this.accessType.getCode();
        }
        if (this.viewType == 1) {
            return String.valueOf(this.shortBuild.toString()) + "[" + this.maxcpu + "] @ " + this.serverNode.getShortHostName() + " - Access: " + this.accessType.getCode();
        }
        return "[No description available for viewType=" + this.viewType + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof AverageSet) {
            AverageSet as = (AverageSet)obj;
            if (this.viewType != as.getViewType()) {
                return false;
            }
            if (this.viewType == 0) {
                return this.getServerNode().equals(as.getServerNode()) && this.getDbDesc().equals(as.getDbDesc()) && this.getAccessType().equals(as.getAccessType());
            }
            if (this.viewType == 1) {
                return this.getServerNode().equals(as.getServerNode()) && this.getShortBuild().equals(as.getShortBuild()) && this.getMaxcpu().equals(as.getMaxcpu()) && this.getAccessType().equals(as.getAccessType());
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof AverageSet) {
            AverageSet as = (AverageSet)obj;
            if (this.viewType != as.getViewType()) {
                return 0;
            }
            int snC = this.getServerNode().compareTo(as.getServerNode());
            if (snC == 0) {
                if (this.viewType == 0) {
                    int dbC = this.getDbDesc().compareTo(as.getDbDesc());
                    if (dbC == 0) {
                        return this.getAccessType().compareTo(as.getAccessType());
                    }
                    return dbC;
                }
                if (this.viewType == 1) {
                    int sbC = this.getShortBuild().compareTo(as.getShortBuild());
                    if (sbC == 0) {
                        int mC = this.getMaxcpu().compareTo(as.getMaxcpu());
                        if (mC == 0) {
                            return this.getAccessType().compareTo(as.getAccessType());
                        }
                        return mC;
                    }
                    return sbC;
                }
                return 0;
            }
            return snC;
        }
        return 0;
    }
}

