/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.common;

import com.sap.sapdb.benchmark.common.where.WhereProducer;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class AccessType
implements Comparable,
WhereProducer {
    public static final int CPC_DIRECT = 0;
    public static final int CPC_VSERVER = 256;
    public static final int JDBC_NATIVE = 512;
    public static final int JDBC_SOCKET = 768;
    public static final int ODBC = 1024;
    public static final int SQLDBC = 1280;
    public static final int PL_DBPROC = 0;
    public static final int CPP_DBPROC = 16;
    public static final int STATEMENT = 32;
    public static final int SYSTEM = 0;
    public static final int JAVA = 1;
    private int mInterface = 0;
    private int transacImpl = 0;
    private int userImpl = 0;

    public static int convertStr2Interface(String interfaceStr) throws Tp2Exception {
        if (interfaceStr.equals("CPC_DIRECT")) {
            return 0;
        }
        if (interfaceStr.equals("CPC_VSERVER")) {
            return 256;
        }
        if (interfaceStr.equals("JDBC_SOCKET")) {
            return 768;
        }
        if (interfaceStr.equals("JDBC_NATIVE")) {
            return 512;
        }
        if (interfaceStr.equals("ODBC")) {
            return 1024;
        }
        if (interfaceStr.equals("SQLDBC")) {
            return 1280;
        }
        throw new Tp2Exception("Undefined interface: " + interfaceStr, 3);
    }

    public static int convertStr2TransacImpl(String transacImplStr) throws Tp2Exception {
        if (transacImplStr.equals("STATEMENT")) {
            return 32;
        }
        if (transacImplStr.equals("PL_DBPROC")) {
            return 0;
        }
        if (transacImplStr.equals("CPP_DBPROC")) {
            return 16;
        }
        throw new Tp2Exception("Undefined transaction implementation: " + transacImplStr, 3);
    }

    public static int convertStr2UserImpl(String userImplStr) throws Tp2Exception {
        if (userImplStr.equals("SYSTEM")) {
            return 0;
        }
        if (userImplStr.equals("JAVA")) {
            return 1;
        }
        throw new Tp2Exception("Undefined user implementation: " + userImplStr, 3);
    }

    public static String convertInterface2Str(int mInterface) throws Tp2Exception {
        if (mInterface == 0) {
            return "CPC_DIRECT";
        }
        if (mInterface == 256) {
            return "CPC_VSERVER";
        }
        if (mInterface == 768) {
            return "JDBC_SOCKET";
        }
        if (mInterface == 512) {
            return "JDBC_NATIVE";
        }
        if (mInterface == 1024) {
            return "ODBC";
        }
        if (mInterface == 1280) {
            return "SQLDBC";
        }
        throw new Tp2Exception("String not defined for interface=" + mInterface, 2);
    }

    public static String convertTransacImpl2Str(int transacImpl) throws Tp2Exception {
        if (transacImpl == 32) {
            return "STATEMENT";
        }
        if (transacImpl == 0) {
            return "PL_DBPROC";
        }
        if (transacImpl == 16) {
            return "CPP_DBPROC";
        }
        throw new Tp2Exception("String not defined for transacImpl=" + transacImpl, 2);
    }

    public static String convertUserImpl2Str(int userImpl) throws Tp2Exception {
        if (userImpl == 0) {
            return "SYSTEM";
        }
        if (userImpl == 1) {
            return "JAVA";
        }
        throw new Tp2Exception("String not defined for userImpl=" + userImpl, 2);
    }

    public static void main(String[] arg) {
        try {
            System.out.println(new AccessType("CPC_DIRECT-CPP_DBPROC-SYSTEM").getCodeStr());
        }
        catch (Tp2Exception e) {
            e.printStackTrace();
        }
    }

    public AccessType(int mInterface, int transacImpl, int userImpl) throws Tp2Exception {
        this.initFromCodes(mInterface, transacImpl, userImpl);
    }

    public AccessType(int code) throws Tp2Exception {
        this.initFromCodes(code & 0xF00, code & 0xF0, code & 0xF);
    }

    public AccessType(String interfaceStr, String transacImplStr, String userImplStr) throws Tp2Exception {
        this.initFromStr(interfaceStr, transacImplStr, userImplStr);
    }

    public AccessType(String codeStr) throws Tp2Exception {
        StringTokenizer ST = new StringTokenizer(codeStr, "-");
        String interfaceStr = ST.nextToken();
        if (!ST.hasMoreTokens()) {
            throw new Tp2Exception("Access type code string (" + codeStr + ") in bad format", 3);
        }
        String transacImplStr = ST.nextToken();
        if (!ST.hasMoreTokens()) {
            throw new Tp2Exception("Access type code string (" + codeStr + ") in bad format", 3);
        }
        String userImplStr = ST.nextToken();
        this.initFromStr(interfaceStr, transacImplStr, userImplStr);
    }

    private void initFromStr(String interfaceStr, String transacImplStr, String userImplStr) throws Tp2Exception {
        this.initFromCodes(AccessType.convertStr2Interface(interfaceStr), AccessType.convertStr2TransacImpl(transacImplStr), AccessType.convertStr2UserImpl(userImplStr));
    }

    private void initFromCodes(int mInterface, int transacImpl, int userImpl) throws Tp2Exception {
        if (mInterface == 768 || mInterface == 512 ? userImpl != 1 : userImpl == 1) {
            throw new Tp2Exception("Interface " + AccessType.convertInterface2Str(mInterface) + " is not compatible with user " + AccessType.convertUserImpl2Str(userImpl), 2);
        }
        this.mInterface = mInterface;
        this.transacImpl = transacImpl;
        this.userImpl = userImpl;
    }

    public String toString() {
        return this.getCodeStr();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessType) {
            return ((AccessType)obj).getCode() == this.getCode();
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof AccessType) {
            return this.getCode() - ((AccessType)obj).getCode();
        }
        return 0;
    }

    public String getAsStaticWherePart(String tableName) {
        return String.valueOf(tableName) + ".user_type='" + this.getCodeStr() + "'";
    }

    public String getPreparedWherePart(String tableName) {
        return AccessType.getClassPreparedWherePart(tableName);
    }

    public static String getClassPreparedWherePart(String tableName) {
        return String.valueOf(tableName) + ".user_type=?";
    }

    public int setPeparedStatementValues(PreparedStatement pStmt, int relIndex) throws SQLException {
        pStmt.setString(relIndex, this.getCodeStr());
        return relIndex + 1;
    }

    public int getInterface() {
        return this.mInterface;
    }

    public int getTransacImpl() {
        return this.transacImpl;
    }

    public int getUserImpl() {
        return this.userImpl;
    }

    public int getCode() {
        return this.mInterface | this.transacImpl | this.userImpl;
    }

    public String getInterfaceStr() {
        try {
            return AccessType.convertInterface2Str(this.mInterface);
        }
        catch (Tp2Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTransacImplStr() {
        try {
            return AccessType.convertTransacImpl2Str(this.mInterface);
        }
        catch (Tp2Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUserImplStr() {
        try {
            return AccessType.convertUserImpl2Str(this.mInterface);
        }
        catch (Tp2Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCodeStr() {
        try {
            return String.valueOf(AccessType.convertInterface2Str(this.mInterface)) + "-" + AccessType.convertTransacImpl2Str(this.transacImpl) + "-" + AccessType.convertUserImpl2Str(this.userImpl);
        }
        catch (Tp2Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDescription() {
        String res = "";
        if (this.userImpl == 0) {
            res = String.valueOf(res) + "Executable ";
        } else if (this.userImpl == 1) {
            res = String.valueOf(res) + "Java thread ";
        }
        res = String.valueOf(res) + "executing ";
        if (this.transacImpl == 32) {
            res = String.valueOf(res) + "statements ";
        } else if (this.transacImpl == 0) {
            res = String.valueOf(res) + "PL DB procedures ";
        } else if (this.transacImpl == 16) {
            res = String.valueOf(res) + "C++ DB procedures ";
        }
        res = String.valueOf(res) + "through ";
        if (this.mInterface == 0) {
            res = String.valueOf(res) + "CPC (direct) ";
        } else if (this.mInterface == 256) {
            res = String.valueOf(res) + "CPC (vserver) ";
        } else if (this.mInterface == 512) {
            res = String.valueOf(res) + "JDBC (native) ";
        } else if (this.mInterface == 768) {
            res = String.valueOf(res) + "JDBC (socket) ";
        } else if (this.mInterface == 1024) {
            res = String.valueOf(res) + "ODBC ";
        } else if (this.mInterface == 1280) {
            res = String.valueOf(res) + "SQLDBC ";
        }
        return res;
    }

    public boolean isSystemUser() {
        return this.userImpl == 0;
    }

    public boolean isCpcInterface() {
        return this.mInterface == 0 || this.mInterface == 256;
    }

    public boolean isJdbcInterface() {
        return this.mInterface == 768 || this.mInterface == 512;
    }
}

