/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.cases;

import com.sap.sapdb.benchmark.tp2.cases.Fitness;
import com.sap.sapdb.benchmark.tp2.cases.ParameterSet;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.common.Tp2Result;
import com.sap.sapdb.benchmark.tp2.test.BadResultException;
import com.sap.sapdb.benchmark.tp2.test.Tp2TestCase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class ParamOptim
extends Tp2TestCase {
    private ParameterSet firstSet = null;
    private Vector toDo = null;
    private TreeMap alreadyDone = null;
    private int initialCfgCount = 0;
    private int[] userCountProg = null;
    private File xlsReport = null;

    protected void runCase() throws Tp2Exception {
        this.prepareOptim();
        this.stdOut(String.valueOf(this.initialCfgCount) + " different configurations will be tested");
        ParameterSet currentSet = this.findNearest(this.firstSet);
        int count = 0;
        while (!this.toDo.isEmpty()) {
            try {
                currentSet.putParameters(ParamOptim.getDatabase());
                float newFitness = 0.0f;
                Tp2Result[][] results = new Tp2Result[this.getTryCount()][this.userCountProg.length];
                int testsDone = 0;
                int j = 0;
                while (j < this.getTryCount()) {
                    int i = 0;
                    while (i < this.userCountProg.length) {
                        try {
                            results[j][i] = this.runTest(this.userCountProg[i]);
                            newFitness += results[j][i].getTpsAsFloat();
                            ++testsDone;
                        }
                        catch (BadResultException e) {
                            this.stdErr(e);
                        }
                        ++i;
                    }
                    ++j;
                }
                this.alreadyDone.put(new Fitness(newFitness /= (float)testsDone), currentSet);
                this.toDo.remove(currentSet);
                try {
                    int[] paramVal = currentSet.getParameters();
                    PrintWriter out = new PrintWriter((Writer)new FileWriter(this.xlsReport.getPath(), true), true);
                    StringBuffer resultLine = new StringBuffer("");
                    resultLine.append(count);
                    int k = 0;
                    while (k < ParameterSet.getParameterCount()) {
                        resultLine.append("\t").append(paramVal[k]);
                        ++k;
                    }
                    resultLine.append("\t" + newFitness);
                    int i = 0;
                    while (i < this.userCountProg.length) {
                        int cnt = 0;
                        float sum = 0.0f;
                        int j2 = 0;
                        while (j2 < this.getTryCount()) {
                            if (results[j2][i] != null) {
                                sum += results[j2][i].getTpsAsFloat();
                                ++cnt;
                            }
                            ++j2;
                        }
                        if (cnt == 0) {
                            resultLine.append("\tFAILED");
                        } else {
                            resultLine.append("\t" + sum / (float)cnt);
                        }
                        ++i;
                    }
                    resultLine.append("\n");
                    out.print(resultLine.toString());
                    this.stdOut("# Computation done:\n " + resultLine.toString());
                    out.close();
                }
                catch (IOException e) {
                    this.getCaseEnv().logError("ParamOptim", "Problem when writing results", e);
                }
            }
            catch (TestDatabaseException e) {
                e.printStackTrace(System.err);
                this.toDo.remove(currentSet);
            }
            currentSet = this.findNextParameterSet();
            ++count;
        }
    }

    private void prepareOptim() throws Tp2Exception {
        String[] paramNames = new String[]{"_PRIO_BASE_COM", "_PRIO_BASE_U2U", "_PRIO_FACTOR"};
        int[][] paramProgs = null;
        if (this.getCaseEnv().isPropSet("tp2.ext.paramProgram")) {
            Vector cfgValVect;
            StringTokenizer ST1 = new StringTokenizer(this.getCaseEnv().getProp("tp2.ext.paramProgram"), ";");
            TreeMap<String, Vector> paramProgsMap = new TreeMap<String, Vector>();
            while (ST1.hasMoreTokens()) {
                StringTokenizer ST2 = new StringTokenizer(ST1.nextToken(), "=");
                String paramName = ST2.nextToken();
                StringTokenizer ST3 = new StringTokenizer(ST2.nextToken(), ",");
                cfgValVect = new Vector();
                while (ST3.hasMoreTokens()) {
                    cfgValVect.add(ST3.nextToken());
                }
                paramProgsMap.put(paramName, cfgValVect);
            }
            paramNames = new String[paramProgsMap.size()];
            paramProgs = new int[paramProgsMap.size()][];
            Iterator names = paramProgsMap.keySet().iterator();
            int index = 0;
            while (names.hasNext()) {
                String name;
                paramNames[index] = name = (String)names.next();
                cfgValVect = (Vector)paramProgsMap.get(name);
                paramProgs[index] = new int[cfgValVect.size()];
                int i = 0;
                while (i < cfgValVect.size()) {
                    paramProgs[index][i] = Integer.parseInt((String)cfgValVect.get(i));
                    ++i;
                }
                ++index;
            }
        }
        ParameterSet.setParameterNames(paramNames);
        this.toDo = new Vector();
        this.alreadyDone = new TreeMap();
        this.stdOut("\n*****\n* TP2 - DB parameters optimization (" + ParameterSet.getParameterNamesAsOutput() + ")\n*****");
        int[] current = new int[ParameterSet.getParameterCount()];
        int i = 0;
        while (i < paramProgs[0].length) {
            this.fillToDo(current, 0, paramProgs, i);
            ++i;
        }
        int[] firstGen = new int[ParameterSet.getParameterCount()];
        int i2 = 0;
        while (i2 < firstGen.length) {
            firstGen[i2] = paramProgs[i2][0];
            ++i2;
        }
        this.firstSet = new ParameterSet(firstGen);
        int[] def = new int[]{30};
        this.userCountProg = this.createUserCountProgramFromProperties(def);
        this.xlsReport = new File(String.valueOf(this.getTp2Home()) + "parametersOptimizer-" + this.getCaseEnv().getSessionId() + ".xls");
        if (!this.xlsReport.exists()) {
            try {
                PrintWriter out = new PrintWriter((Writer)new FileWriter(this.xlsReport), true);
                out.write("Optimizer report\n");
                out.write("\n");
                out.write("Session\t" + this.getTp2Case().getSession().getId() + "\n");
                out.write("Desc.\t" + this.getTp2Case().getSession().getDescription() + "\n");
                out.write("Host\t" + this.getTp2Case().getServerNode().getShortHostName() + "\n");
                out.write("Date\t" + this.getTp2Case().getBeginDate() + "\n");
                out.write("\n");
                StringBuffer resultLine = new StringBuffer("");
                resultLine.append("Count");
                int i3 = 0;
                while (i3 < ParameterSet.getParameterCount()) {
                    resultLine.append("\t").append(paramNames[i3]);
                    ++i3;
                }
                resultLine.append("\tFitness");
                i3 = 0;
                while (i3 < this.userCountProg.length) {
                    resultLine.append("\t" + this.userCountProg[i3]);
                    ++i3;
                }
                resultLine.append("\n");
                out.print(resultLine.toString());
                out.close();
            }
            catch (IOException e) {
                this.getCaseEnv().logError("ParamOptim", "Problem when writing report header", e);
            }
        }
    }

    private void fillToDo(int[] current, int paramIndex, int[][] cfgVal, int cfgIndex) {
        if (paramIndex == ParameterSet.getParameterCount() - 1) {
            current[paramIndex] = cfgVal[paramIndex][cfgIndex];
            int[] paramVal = new int[ParameterSet.getParameterCount()];
            String values = "";
            int i = 0;
            while (i < ParameterSet.getParameterCount()) {
                paramVal[i] = current[i];
                values = String.valueOf(values) + current[i] + ",";
                ++i;
            }
            this.toDo.add(new ParameterSet(paramVal));
            this.stdOut("Added " + values, 20);
            ++this.initialCfgCount;
            return;
        }
        current[paramIndex] = cfgVal[paramIndex][cfgIndex];
        int j = 0;
        while (j < cfgVal[paramIndex + 1].length) {
            this.fillToDo(current, paramIndex + 1, cfgVal, j);
            ++j;
        }
    }

    private ParameterSet findNextParameterSet() {
        if (this.alreadyDone.isEmpty()) {
            return (ParameterSet)this.toDo.get(0);
        }
        return this.findNearest((ParameterSet)this.alreadyDone.get(this.alreadyDone.lastKey()));
    }

    private ParameterSet findNearest(ParameterSet paramSet) {
        double currDist = -1.0;
        ParameterSet result = null;
        int i = 0;
        while (i < this.toDo.size()) {
            double dist = paramSet.distance((ParameterSet)this.toDo.get(i));
            if (i == 0 || dist < currDist) {
                currDist = dist;
                result = (ParameterSet)this.toDo.get(i);
            }
            ++i;
        }
        return result;
    }
}

