/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.cases;

import com.sap.sapdb.benchmark.tp2.cases.InteractiveCmd;
import com.sap.sapdb.benchmark.tp2.cases.InteractiveException;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.Tp2TestCase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class InteractiveCase
extends Tp2TestCase {
    private boolean exit = false;

    protected void runCase() throws Tp2Exception {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (!this.exit) {
                System.out.print("\n[CONSOLE]> ");
                String cmdStr = in.readLine();
                if (cmdStr == null && (cmdStr = (in = new BufferedReader(new InputStreamReader(System.in))).readLine()) == null) {
                    this.exit = true;
                    break;
                }
                try {
                    InteractiveCmd cmd = new InteractiveCmd(cmdStr);
                    if (cmd.getCmdName().equals("exit")) {
                        this.exit = true;
                        break;
                    }
                    this.executeCmd(cmd);
                }
                catch (InteractiveException e) {
                    this.consErr(e.getMessage());
                    this.printUsage();
                }
                catch (Exception e) {
                    this.consErr("Unexpected exception: " + e);
                    e.printStackTrace();
                }
            }
            in.close();
        }
        catch (IOException e) {
            this.exit = true;
            throw new Tp2Exception("Unexpected exception crashed the interactive test", 3, e);
        }
    }

    protected void executeCmd(InteractiveCmd cmd) throws Tp2Exception, InteractiveException, Exception {
        if (cmd.getCmdName().equals("run")) {
            if (!cmd.hasOption("-uc")) {
                throw new InteractiveException("Please set -uc option for user count");
            }
            if (this.runTestSafe(Integer.parseInt(cmd.getOption("-uc")))) {
                this.consOut("Test run was OK");
            } else {
                this.consOut("Test run FAILED");
            }
        } else if (cmd.getCmdName().equals("param_directput")) {
            String paramName = cmd.getOption(0);
            String paramValue = cmd.getOption(1);
            try {
                this.consOut("param_directput " + paramName + " " + paramValue + " => " + InteractiveCase.getDatabase().executeDBMcmd("param_directput " + paramName + " " + paramValue));
                this.consOut("param_checkall => " + InteractiveCase.getDatabase().executeDBMcmd("param_checkall"));
                this.consOut("DB param " + paramName + " set to " + InteractiveCase.getDatabase().executeDBMcmd("param_directget " + paramName));
            }
            catch (TestDatabaseException e) {
                throw new InteractiveException("param_directput failed beacause of " + (Object)((Object)e));
            }
        } else if (cmd.getCmdName().equals("param_get")) {
            String subStr = null;
            if (cmd.hasOption(0)) {
                subStr = cmd.getOption(0).toUpperCase();
            }
            try {
                String params = InteractiveCase.getDatabase().executeDBMcmd("param_directgetall");
                StringTokenizer STbr = new StringTokenizer(params, "\n");
                TreeMap<String, String> paramsList = new TreeMap<String, String>();
                int spaceSize = 33;
                while (STbr.hasMoreTokens()) {
                    String line = STbr.nextToken();
                    StringTokenizer STblk = new StringTokenizer(line, " \t");
                    String paramName = STblk.nextToken();
                    String paramValue = "";
                    if (STblk.hasMoreTokens()) {
                        paramValue = STblk.nextToken();
                    }
                    if (subStr != null) {
                        if (paramName.indexOf(subStr) < 0) continue;
                        paramsList.put(paramName, paramValue);
                        continue;
                    }
                    paramsList.put(paramName, paramValue);
                }
                Iterator keys = paramsList.keySet().iterator();
                while (keys.hasNext()) {
                    String paramName = (String)keys.next();
                    StringBuffer space = new StringBuffer("");
                    int i = 0;
                    while (i < spaceSize - paramName.length()) {
                        space.append(" ");
                        ++i;
                    }
                    this.consOut(String.valueOf(paramName) + space.toString() + paramsList.get(paramName));
                }
            }
            catch (TestDatabaseException e) {
                throw new InteractiveException("param_get failed because of " + (Object)((Object)e));
            }
        } else {
            throw new InteractiveException("Unknown command '" + cmd + "'");
        }
    }

    public void printUsage() {
        this.consOut(" * IntercativeCase commands:");
        this.consOut(" * run -uc <userCount>                runs one SingleTest");
        this.consOut(" * param_directput <name> <value>     sets a DB parameter");
        this.consOut(" * param_get                          lists all DB parameters");
        this.consOut(" * param_get <string>                 lists all DB parameters containing <string>");
        this.consOut(" * exit                               ends the case");
    }

    protected void consOut(Object obj) {
        System.out.println("[CONSOLE] " + obj.toString());
    }

    protected void consErr(Object obj) {
        System.out.println("[CONSOLE ERR] " + obj.toString());
    }
}

