/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.where.WhereProducer;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class Version
implements WhereProducer,
Comparable,
Serializable {
    private int major;
    private int minor;
    private int correctionLevel;

    public Version(int major, int minor, int correctionLevel) {
        this.major = major;
        this.minor = minor;
        this.correctionLevel = correctionLevel;
    }

    public Version(String versionStr) {
        StringTokenizer ST = new StringTokenizer(versionStr, ".");
        this.major = Integer.parseInt(ST.nextToken());
        this.minor = Integer.parseInt(ST.nextToken());
        this.correctionLevel = Integer.parseInt(ST.nextToken());
    }

    public String getAsStaticWherePart(String table) {
        String res = "";
        res = String.valueOf(res) + table + ".major=" + this.major + " AND ";
        res = String.valueOf(res) + table + ".minor=" + this.minor + " AND ";
        res = String.valueOf(res) + table + ".correction_level=" + this.correctionLevel + " ";
        return res;
    }

    public static String getClassPreparedWherePart(String table) {
        String res = "";
        res = String.valueOf(res) + table + ".major=? AND ";
        res = String.valueOf(res) + table + ".minor=? AND ";
        res = String.valueOf(res) + table + ".correction_level=? ";
        return res;
    }

    public String getPreparedWherePart(String table) {
        return Version.getClassPreparedWherePart(table);
    }

    public int setPeparedStatementValues(PreparedStatement pStmt, int relIndex) throws SQLException {
        pStmt.setInt(relIndex, this.major);
        pStmt.setInt(relIndex + 1, this.minor);
        pStmt.setInt(relIndex + 2, this.correctionLevel);
        return relIndex + 3;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getCorrectionLevel() {
        return this.correctionLevel;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + BenchEnv.formatNbr(this.correctionLevel);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version vers = (Version)obj;
            return this.major == vers.getMajor() && this.minor == vers.getMinor() && this.correctionLevel == vers.getCorrectionLevel();
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Version) {
            Version vers = (Version)obj;
            if (vers.getMajor() == this.getMajor()) {
                if (this.getMinor() == vers.getMinor()) {
                    return vers.getCorrectionLevel() - this.getCorrectionLevel();
                }
                return vers.getMinor() - this.getMinor();
            }
            return vers.getMajor() - this.getMajor();
        }
        return 0;
    }
}

