/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.BenchmarkException;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.PropertyContainer;
import com.sap.sapdb.benchmark.common.Session;
import com.sap.sapdb.benchmark.common.StorableObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.SortedMap;
import java.util.TreeMap;

public class User
extends StorableObject {
    private String name = null;
    private String description = null;
    private String mail = null;
    static /* synthetic */ Class class$0;

    public static User createUser(String name, String description, String mail) throws SQLException {
        if (!User.isNonPersistent()) {
            Statement stmt = User.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT id FROM users WHERE name='" + name + "'");
            if (RS.next()) {
                return User.loadUser(RS.getInt("id"));
            }
            if (mail != null) {
                stmt.executeUpdate("INSERT INTO users SET name='" + name + "',description='" + description + "',mail='" + mail + "'");
            } else {
                stmt.executeUpdate("INSERT INTO users SET name='" + name + "',description='" + description + "'");
            }
            RS = stmt.executeQuery("SELECT id FROM users WHERE name='" + name + "'");
            if (RS.next()) {
                int id = RS.getInt("id");
                RS.close();
                stmt.close();
                User.getConnection().commit();
                return User.loadUser(id);
            }
            RS.close();
            stmt.close();
            User.getConnection().rollback();
            throw new SQLException("User was not properly created");
        }
        User user = NonPersistent.selectUser(name);
        if (user != null) {
            return user;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sap.sapdb.benchmark.common.User");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        user = new User(NonPersistent.getNextId(clazz), name, description, mail);
        NonPersistent.insert(user);
        return user;
    }

    public static User loadUser(int id) throws SQLException {
        if (!User.isNonPersistent()) {
            Statement stmt = User.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT id,name,description,mail FROM users WHERE id=" + id);
            if (RS.next()) {
                String name = RS.getString("name");
                String description = RS.getString("description");
                String mail = RS.getString("mail");
                RS.close();
                stmt.close();
                User.getConnection().commit();
                return new User(id, name, description, mail);
            }
            RS.close();
            stmt.close();
            User.getConnection().rollback();
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sap.sapdb.benchmark.common.User");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (User)NonPersistent.select(clazz, id);
    }

    public static User loadUser(String userName) throws SQLException {
        if (!User.isNonPersistent()) {
            Statement stmt = User.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT id FROM users WHERE name='" + userName + "'");
            if (RS.next()) {
                int id = RS.getInt("id");
                User result = User.loadUser(id);
                RS.close();
                stmt.close();
                User.getConnection().commit();
                return result;
            }
            RS.close();
            stmt.close();
            User.getConnection().rollback();
            return null;
        }
        return NonPersistent.selectUser(userName);
    }

    public static User findOrCreateUser(PropertyContainer propCont) throws BenchmarkException {
        try {
            String name = null;
            User result = null;
            name = propCont.getPropertyWithDefault("benchmark.case.user", "DEF_MARK");
            if (!name.equals("DEF_MARK")) {
                result = User.loadUser(name);
                if (result != null) {
                    return result;
                }
                return User.createDUserOnly(name);
            }
            name = System.getProperty("user.name");
            result = User.loadUser(name);
            if (result == null) {
                return User.createDUserOnly(name);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BenchmarkException("Could not find or create a new User because of " + e, e);
        }
    }

    private static User createDUserOnly(String nameToTestAndCreate) throws BenchmarkException {
        User result = null;
        if (nameToTestAndCreate.length() < 1) {
            throw new BenchmarkException("Cannot automatically create a User (" + nameToTestAndCreate + ") that is not a d-user");
        }
        if (nameToTestAndCreate.substring(0, 1).toUpperCase().equals("D")) {
            try {
                Integer.parseInt(nameToTestAndCreate.substring(1));
                String name = "d" + nameToTestAndCreate.substring(1);
                result = User.createUser(name, "SAP employee (" + name + ")", "[NO MAIL]");
            }
            catch (NumberFormatException e) {
                throw new BenchmarkException("Cannot automatically create a user (" + nameToTestAndCreate + ") that is not a d-user", e);
            }
            catch (SQLException e) {
                throw new BenchmarkException("Could not create a new User because of " + e, e);
            }
        } else {
            throw new BenchmarkException("Cannot automatically create a User (" + nameToTestAndCreate + ") that is not a d-user");
        }
        return result;
    }

    public User(int id, String name, String description, String mail) {
        super(id);
        this.name = name;
        this.description = description;
        this.mail = mail;
    }

    public void setGlobalSession(Session newGlobalSession) throws SQLException {
        Statement stmt = User.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("SELECT session_id  FROM global_sessions global, sessions sess WHERE global.session_id=sess.id  AND sess.benchmark_type='" + newGlobalSession.getBenchmarkType() + "'" + " AND global.user_id=" + this.getId());
        if (RS.next()) {
            Session formerGlobalSess = Session.loadSession(RS.getInt("session_id"));
            if (!formerGlobalSess.isClosed()) {
                formerGlobalSess.close();
            }
            stmt.executeUpdate("DELETE global_sessions WHERE session_id IN (SELECT global.session_id  FROM global_sessions global, sessions sess WHERE global.session_id=sess.id  AND sess.benchmark_type='" + newGlobalSession.getBenchmarkType() + "'" + " AND global.user_id=" + this.getId() + ")");
        }
        RS.close();
        stmt.execute("INSERT INTO global_sessions SET session_id=" + newGlobalSession.getId() + ", user_id=" + this.getId());
        User.getConnection().commit();
        stmt.close();
        if (newGlobalSession != null && newGlobalSession.isClosed()) {
            newGlobalSession.open();
        }
    }

    public Session createGlobalSession(String description, String benchmarkType) throws SQLException {
        Session newSession = Session.createSession(description, this, benchmarkType);
        this.setGlobalSession(newSession);
        return newSession;
    }

    public Session getGlobalSession(String benchmarkType) throws SQLException {
        Statement stmt = User.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("SELECT global.session_id  FROM global_sessions global, sessions sess WHERE global.session_id=sess.id  AND sess.benchmark_type='" + benchmarkType + "'" + " AND global.user_id=" + this.getId());
        if (RS.next()) {
            Session sess = Session.loadSession(RS.getInt("session_id"));
            if (sess.isClosed()) {
                sess.open();
            }
            return sess;
        }
        return null;
    }

    public SortedMap getGlobalSessions() throws SQLException {
        TreeMap<String, Session> result = new TreeMap<String, Session>();
        Statement stmt = User.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("SELECT global.session_id, sess.benchmark_type  FROM global_sessions global, sessions sess WHERE global.session_id=sess.id  AND global.user_id=" + this.getId());
        while (RS.next()) {
            Session sess = Session.loadSession(RS.getInt("session_id"));
            result.put(sess.getBenchmarkType(), sess);
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws SQLException {
        if (!User.isNonPersistent()) {
            Statement stmt = User.getConnection().createStatement();
            stmt.executeUpdate("UPDATE users SET description='" + description + "' WHERE id=" + this.getId());
            stmt.close();
            User.getConnection().commit();
        }
        this.description = description;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) throws SQLException {
        if (!User.isNonPersistent()) {
            Statement stmt = User.getConnection().createStatement();
            stmt.executeUpdate("UPDATE users SET mail='" + mail + "' WHERE id=" + this.getId());
            stmt.close();
            User.getConnection().commit();
        }
        this.mail = mail;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SQLException {
        if (!User.isNonPersistent()) {
            Statement stmt = User.getConnection().createStatement();
            stmt.executeUpdate("UPDATE users SET name='" + name + "' WHERE id=" + this.getId());
            stmt.close();
            User.getConnection().commit();
        }
        this.name = name;
    }

    public String toString() {
        return "User[" + this.getName() + "]";
    }

    public int compareTo(Object obj) {
        if (obj instanceof User) {
            return this.getName().compareTo(((User)obj).getName());
        }
        return this.toString().compareTo(obj.toString());
    }
}

