/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.Version;
import com.sap.sapdb.benchmark.common.where.WhereProducer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class ShortBuild
implements WhereProducer,
Comparable {
    private Version version = null;
    private String shortBuildAsString = null;

    public ShortBuild(Version version, String shortBuildAsString) {
        this.version = version;
        int intB = Integer.parseInt(shortBuildAsString);
        if (intB >= 1000) {
            throw new NumberFormatException("Short build is greater than 999");
        }
        this.shortBuildAsString = shortBuildAsString;
    }

    public ShortBuild(String str) {
        StringTokenizer ST = new StringTokenizer(str, "b");
        this.version = new Version(ST.nextToken());
        this.shortBuildAsString = ST.nextToken();
    }

    public String getAsStaticWherePart(String table) {
        return String.valueOf(this.version.getAsStaticWherePart(table)) + " AND " + ShortBuild.extractShortBuildField(table) + "='" + this.shortBuildAsString + "' ";
    }

    public static String getClassPreparedWherePart(String table) {
        String res = "";
        res = String.valueOf(res) + Version.getClassPreparedWherePart(table);
        res = String.valueOf(res) + " AND " + ShortBuild.extractShortBuildField(table) + "=? ";
        return res;
    }

    public String getPreparedWherePart(String table) {
        return ShortBuild.getClassPreparedWherePart(table);
    }

    public int setPeparedStatementValues(PreparedStatement pStmt, int relIndex) throws SQLException {
        relIndex = this.version.setPeparedStatementValues(pStmt, relIndex);
        pStmt.setString(relIndex, this.shortBuildAsString);
        return relIndex + 1;
    }

    public static String extractShortBuildField(String table) {
        return "SUBSTR(" + table + ".build,1,3)";
    }

    public String getShortBuildAsString() {
        return this.shortBuildAsString;
    }

    public int getShortBuildAsInt() {
        return Integer.parseInt(this.shortBuildAsString);
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return String.valueOf(this.version.toString()) + "b" + this.shortBuildAsString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShortBuild) {
            ShortBuild sb = (ShortBuild)obj;
            return this.getVersion().equals(sb.getVersion()) && this.shortBuildAsString.equals(sb.getShortBuildAsString());
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof ShortBuild) {
            ShortBuild sb = (ShortBuild)obj;
            int vC = this.getVersion().compareTo(sb.getVersion());
            if (vC == 0) {
                return sb.getShortBuildAsInt() - this.getShortBuildAsInt();
            }
            return vC;
        }
        return 0;
    }
}

