/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.dbtech.util.Tracer;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.StorableObject;
import java.security.MessageDigest;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class DBParameters
extends StorableObject {
    private SortedMap parameters = null;
    static /* synthetic */ Class class$0;

    public static DBParameters getDBParameters(Connection testDBConn) throws SQLException {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        Statement testStmt = testDBConn.createStatement();
        ResultSet RS = testStmt.executeQuery("SELECT description,value FROM dbparameters order by description");
        while (RS.next()) {
            parameters.put(RS.getString("description"), RS.getString("value"));
        }
        return DBParameters.getDBParameters(parameters);
    }

    public static DBParameters getDBParameters(SortedMap parameters) throws SQLException {
        if (!DBParameters.isNonPersistent()) {
            Iterator it = new TreeMap(parameters).entrySet().iterator();
            String hashValue = "";
            String longValue = "";
            String context = "";
            boolean first = true;
            int cnt = 0;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!(entry.getKey().equals("DIAG_HISTORY_PATH") || entry.getKey().equals("RUNDIRECTORY") || entry.getKey().equals("_DIAG_SEM") || entry.getKey().equals("_COMMENT") || entry.getKey().equals("KERNELVERSION") || entry.getKey().equals("__PARAM_CHANGED___") || entry.getKey().equals("__PARAM_VERIFIED__"))) {
                    if (first) {
                        first = false;
                    } else {
                        longValue = String.valueOf(longValue) + ",";
                    }
                    longValue = String.valueOf(longValue) + entry.getKey() + "=" + entry.getValue();
                    ++cnt;
                    continue;
                }
                parameters.remove(entry.getKey());
            }
            context = longValue.trim();
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                byte[] data = md5.digest(context.getBytes());
                context = Tracer.Hex2String((byte[])data);
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
            hashValue = context;
            String compareSql = "SELECT id FROM dbparameters_hashed  WHERE hashed_params = '" + hashValue + "'";
            Statement stmt = DBParameters.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery(compareSql);
            int id = -1;
            if (RS.next()) {
                id = RS.getInt("id");
            } else {
                CallableStatement call = DBParameters.getConnection().prepareCall("SELECT dbparameters_seq.NEXTVAL INTO :nextval FROM DUAL");
                call.registerOutParameter(1, 4);
                call.execute();
                id = call.getInt(1);
                call.close();
                PreparedStatement insertStmt = DBParameters.getConnection().prepareStatement("INSERT INTO dbparameters SET id=?, name=?, value=?");
                it = parameters.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    insertStmt.setInt(1, id);
                    insertStmt.setString(2, entry.getKey().toString());
                    insertStmt.setString(3, entry.getValue().toString());
                    insertStmt.addBatch();
                }
                insertStmt.executeBatch();
                insertStmt.clearBatch();
                Statement hashStmt = DBParameters.getConnection().createStatement();
                String insSQL = "INSERT INTO dbparameters_hashed SET id=" + id + ", hashed_params='" + hashValue + "', string_params='" + longValue + "'";
                hashStmt.executeUpdate(insSQL);
                hashStmt.execute("Commit");
            }
            RS.close();
            stmt.close();
            DBParameters.getConnection().commit();
            return new DBParameters(id, parameters);
        }
        DBParameters result = NonPersistent.findDBParameters(parameters);
        if (result == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sap.sapdb.benchmark.common.DBParameters");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DBParameters dbParam = new DBParameters(NonPersistent.getNextId(clazz), parameters);
            NonPersistent.insert(dbParam);
            return dbParam;
        }
        return result;
    }

    public static DBParameters loadDBParameters(int id) throws SQLException {
        if (!DBParameters.isNonPersistent()) {
            Statement stmt = DBParameters.getConnection().createStatement();
            TreeMap<String, String> parameters = new TreeMap<String, String>();
            ResultSet RS = stmt.executeQuery("SELECT name,value FROM dbparameters WHERE id=" + id);
            while (RS.next()) {
                parameters.put(RS.getString("name"), RS.getString("value"));
            }
            DBParameters result = new DBParameters(id, parameters);
            RS.close();
            stmt.close();
            DBParameters.getConnection().commit();
            return result;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sap.sapdb.benchmark.common.DBParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (DBParameters)NonPersistent.select(clazz, id);
    }

    private DBParameters(int id, SortedMap parameters) {
        super(id);
        this.parameters = parameters;
    }

    public Set getDifferentParameters(DBParameters otherDBParam) {
        TreeSet result = new TreeSet();
        Iterator it = otherDBParam.getEntries();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (entry.getValue().equals(this.getParameter((String)entry.getKey()))) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public String getParameter(String parameterName) {
        return (String)this.parameters.get(parameterName);
    }

    public SortedMap getAsSortedMap() {
        return new TreeMap(this.parameters);
    }

    public Iterator getEntries() {
        return this.parameters.entrySet().iterator();
    }
}

