/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.ShortBuild;
import com.sap.sapdb.benchmark.common.Version;
import com.sap.sapdb.benchmark.common.where.WhereProducer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class Build
implements WhereProducer,
Comparable {
    private ShortBuild shortBuild = null;
    private String[] buildParts = null;

    public Build(Version version, String longBuild) {
        StringTokenizer ST = new StringTokenizer(longBuild, "-");
        String shortBuildStr = ST.nextToken();
        this.shortBuild = new ShortBuild(version, shortBuildStr);
        this.buildParts = new String[3];
        this.buildParts[0] = ST.nextToken();
        this.buildParts[1] = ST.nextToken();
        this.buildParts[2] = ST.nextToken();
    }

    public String getAsStaticWherePart(String table) {
        return String.valueOf(this.shortBuild.getVersion().getAsStaticWherePart(table)) + " AND build='" + this.getBuildAsString() + "' ";
    }

    public static String getClassPreparedWherePart(String table) {
        String res = "";
        res = String.valueOf(res) + Version.getClassPreparedWherePart(table);
        res = String.valueOf(res) + " AND build=? ";
        return res;
    }

    public String getPreparedWherePart(String table) {
        return Build.getClassPreparedWherePart(table);
    }

    public int setPeparedStatementValues(PreparedStatement pStmt, int relIndex) throws SQLException {
        relIndex = this.shortBuild.getVersion().setPeparedStatementValues(pStmt, relIndex);
        pStmt.setString(relIndex, this.getBuildAsString());
        return relIndex + 1;
    }

    public String getBuildAsString() {
        return String.valueOf(this.shortBuild.getShortBuildAsString()) + "-" + this.buildParts[0] + "-" + this.buildParts[1] + "-" + this.buildParts[2];
    }

    public String getBuildPart(int place) {
        if (place == 1) {
            return this.shortBuild.getShortBuildAsString();
        }
        return this.buildParts[place - 2];
    }

    public int getBuildPartAsInt(int place) {
        return Integer.parseInt(this.getBuildPart(place));
    }

    public ShortBuild getShortBuild() {
        return this.shortBuild;
    }

    public Version getVersion() {
        return this.shortBuild.getVersion();
    }

    public String toString() {
        return String.valueOf(this.shortBuild.toString()) + "-" + this.buildParts[0] + "-" + this.buildParts[1] + "-" + this.buildParts[2];
    }

    public boolean equals(Object obj) {
        if (obj instanceof Build) {
            Build b = (Build)obj;
            return this.getShortBuild().equals(b.getShortBuild()) && this.buildParts[0].equals(b.getBuildPart(2)) && this.buildParts[1].equals(b.getBuildPart(3)) && this.buildParts[2].equals(b.getBuildPart(4));
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Build) {
            Build b = (Build)obj;
            int sbC = this.getShortBuild().compareTo(b.getShortBuild());
            if (sbC == 0) {
                int i = 2;
                while (i < 4) {
                    int bpC = b.getBuildPartAsInt(i) - this.getBuildPartAsInt(i);
                    if (bpC != 0) {
                        return bpC;
                    }
                    ++i;
                }
            } else {
                return sbC;
            }
        }
        return this.toString().compareTo(obj.toString());
    }
}

