/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.OutputLevels;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class BenchEnv
implements OutputLevels {
    private static int outputLevel = 1;

    public static String formatDuration(long duration) {
        long sec = duration % 60L;
        long tMin = duration / 60L;
        long min = tMin % 60L;
        long hour = tMin / 60L;
        return String.valueOf(hour) + "h" + min + "min" + sec + "s";
    }

    public static String formatTime(GregorianCalendar cal, boolean withYearMonthDay) {
        StringBuffer result = new StringBuffer("");
        if (withYearMonthDay) {
            result.append(BenchEnv.formatDate(cal));
            result.append("_");
        }
        result.append(BenchEnv.formatNbr(cal.get(11))).append("h");
        result.append(BenchEnv.formatNbr(cal.get(12))).append("m");
        result.append(BenchEnv.formatNbr(cal.get(13))).append("s");
        return result.toString();
    }

    public static String formatTime(long time, boolean withYearMonthDay) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(time));
        return BenchEnv.formatTime(cal, withYearMonthDay);
    }

    public static String getCurrentTimeFormatted(boolean withYearMonthDay) {
        return BenchEnv.formatTime(new GregorianCalendar(), withYearMonthDay);
    }

    public static String formatDate(GregorianCalendar cal) {
        StringBuffer result = new StringBuffer("");
        result.append(BenchEnv.formatNbr(cal.get(1))).append("_");
        result.append(BenchEnv.formatNbr(cal.get(2) + 1)).append("_");
        result.append(BenchEnv.formatNbr(cal.get(5)));
        return result.toString();
    }

    public static String getCurrentDateFormatted() {
        return BenchEnv.formatDate(new GregorianCalendar());
    }

    public static String formatNbr(int nbr) {
        if (nbr < 10) {
            return "0" + nbr;
        }
        return Integer.toString(nbr);
    }

    public static boolean currentJavaVersionNotUnder(String version) {
        try {
            StringTokenizer ST = new StringTokenizer(System.getProperty("java.version"), ".");
            int currVersion = Integer.parseInt(ST.nextToken()) * 10 + Integer.parseInt(ST.nextToken());
            ST = new StringTokenizer(version, ".");
            int compVersion = Integer.parseInt(ST.nextToken()) * 10 + Integer.parseInt(ST.nextToken());
            return compVersion <= currVersion;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public static int getOutputLevel() {
        return outputLevel;
    }

    public static void setOutputLevel(String outputLevelStr) {
        if (outputLevelStr.equals("verbose")) {
            outputLevel = 10;
        } else if (outputLevelStr.equals("normal")) {
            outputLevel = 1;
        } else if (outputLevelStr.equals("debug")) {
            outputLevel = 20;
        } else if (outputLevelStr.equals("noOutput")) {
            outputLevel = 0;
        }
    }

    public static void stdOut(String prefix, Object obj, int debug) {
        if (debug <= outputLevel) {
            System.out.println("[" + prefix + "] " + obj);
        }
    }

    public static void stdOut(String prefix, Object obj) {
        BenchEnv.stdOut(prefix, obj, 1);
    }

    public static void stdErr(String prefix, Object obj) {
        if (outputLevel != 0) {
            System.err.println("[" + prefix + " ERR] " + obj);
        }
    }
}

