/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.upgradetest.Configuration;
import com.sap.sapdb.upgradetest.Constants;
import com.sap.sapdb.upgradetest.ControlContext;
import com.sap.sapdb.upgradetest.MyAbstractActionListener;
import com.sap.sapdb.upgradetest.MyComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ReleaseSelector
extends JPanel
implements Constants {
    final MyComboBox platformsComboBox;
    final MyComboBox releasesComboBox;
    final MyComboBox buildsComboBox;
    final MyComboBox qastatusComboBox;
    final MyComboBox timestampComboBox;
    final MyComboBox makeKeyComboBox;
    final MyComboBox lcreleasesComboBox;
    final MyComboBox lcqastatusComboBox;
    final MyComboBox lctimestampComboBox;
    final MyComboBox lcMakeKeyComboBox;
    final MyComboBox profileComboBox;
    final JLabel lcaBranchInfoLabel = new JLabel("");
    final JLabel lcPoolLabel = new JLabel("");
    final JLabel changeListLabel = new JLabel("");
    final JLabel lcaPoolLabel = new JLabel("");
    final JLabel lcaVariantLabel = new JLabel("");
    final ControlContext controlContext;

    String getVersion() {
        Object ob = this.releasesComboBox.getSelectedItem();
        return ob == null ? null : ob.toString();
    }

    private void clearLCASelection() {
        this.lcreleasesComboBox.removeAllItems();
        this.lcqastatusComboBox.removeAllItems();
        this.lctimestampComboBox.removeAllItems();
        this.lcMakeKeyComboBox.removeAllItems();
        this.lcaPoolLabel.setText("");
        this.lcaVariantLabel.setText("");
        this.lcaBranchInfoLabel.setText("");
    }

    private static Vector fillVector(ResultSet res) throws SQLException {
        Vector<Object> v = new Vector<Object>();
        while (res.next()) {
            v.add(res.getObject(1));
        }
        return v;
    }

    private static void updateComboBox(Vector v, MyComboBox bx) {
        bx.setSelectedItem(null);
        bx.removeAllItems();
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            bx.addItem(iter.next());
        }
        if (v.isEmpty()) {
            bx.setSelectedItem(null);
        }
    }

    public ReleaseSelector(ControlContext aControlContext) {
        this.controlContext = aControlContext;
        this.lcPoolLabel.setToolTipText("LCPOOL ID");
        this.changeListLabel.setToolTipText("Change List");
        this.lcaPoolLabel.setToolTipText("LCAPOOL ID");
        this.lcaVariantLabel.setToolTipText("LCA VARIANT");
        this.lcaBranchInfoLabel.setToolTipText("LCA BRANCH INFO");
        this.profileComboBox = new MyComboBox("Select sdbinst profile", new Object[]{"Server", "APO LiveCache"}, this.controlContext);
        this.platformsComboBox = new MyComboBox("Select a platform", Configuration.allPlaforms(), this.controlContext);
        this.releasesComboBox = new MyComboBox("Select database release", this.controlContext);
        this.buildsComboBox = new MyComboBox("Select build", this.controlContext);
        this.qastatusComboBox = new MyComboBox("Select QA-Status", this.controlContext);
        this.timestampComboBox = new MyComboBox("Select timestamp", this.controlContext);
        this.makeKeyComboBox = new MyComboBox("Select make id", this.controlContext);
        this.lcreleasesComboBox = new MyComboBox("Select LCA Release", this.controlContext);
        this.lcqastatusComboBox = new MyComboBox("Select LCA QA-Status", this.controlContext);
        this.lctimestampComboBox = new MyComboBox("Select timestamp", this.controlContext);
        this.lcMakeKeyComboBox = new MyComboBox("Select make key", this.controlContext);
        this.platformsComboBox.setSelectedItem(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.gridx = 1;
        cs.gridy = 1;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("MaxDB"), cs);
        cs.gridx = 2;
        cs.gridy = 1;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.platformsComboBox, cs);
        cs.gridx = 3;
        cs.gridy = 1;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.releasesComboBox, cs);
        cs.gridx = 4;
        cs.gridy = 1;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.buildsComboBox, cs);
        cs.gridx = 5;
        cs.gridy = 1;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.qastatusComboBox, cs);
        cs.gridx = 6;
        cs.gridy = 1;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.timestampComboBox, cs);
        cs.gridx = 7;
        cs.gridy = 1;
        cs.anchor = 18;
        cs.fill = 0;
        cs.gridwidth = 1;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.makeKeyComboBox, cs);
        cs.gridx = 8;
        cs.gridy = 1;
        cs.anchor = 17;
        cs.fill = 0;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.lcPoolLabel, cs);
        cs.gridx = 9;
        cs.gridy = 1;
        cs.anchor = 17;
        cs.fill = 0;
        cs.weightx = 1.0;
        cs.gridwidth = 0;
        cs.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.changeListLabel, cs);
        cs.gridx = 1;
        cs.gridy = 2;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("APO"), cs);
        cs.gridx = 3;
        cs.gridy = 2;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.lcreleasesComboBox, cs);
        cs.gridx = 5;
        cs.gridy = 2;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.lcqastatusComboBox, cs);
        cs.gridx = 6;
        cs.gridy = 2;
        cs.anchor = 18;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.lctimestampComboBox, cs);
        cs.gridx = 7;
        cs.gridy = 2;
        cs.anchor = 18;
        cs.fill = 0;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.lcMakeKeyComboBox, cs);
        cs.gridx = 8;
        cs.gridy = 2;
        cs.anchor = 17;
        cs.fill = 0;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.lcaPoolLabel, cs);
        cs.gridx = 9;
        cs.gridy = 2;
        cs.anchor = 17;
        cs.fill = 0;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.lcaBranchInfoLabel, cs);
        cs.gridx = 10;
        cs.gridy = 2;
        cs.anchor = 17;
        cs.fill = 0;
        cs.weightx = 1.0;
        cs.gridwidth = 0;
        cs.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.lcaVariantLabel, cs);
        cs.gridx = 1;
        cs.gridy = 3;
        cs.anchor = 18;
        cs.fill = 0;
        cs.weightx = 0.0;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("PRF"), cs);
        cs.gridx = 2;
        cs.gridy = 3;
        cs.anchor = 18;
        cs.fill = 0;
        cs.weightx = 1.0;
        cs.weighty = 1.0;
        cs.gridwidth = 0;
        cs.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.profileComboBox, cs);
        this.platformsComboBox.addItemListener(new MyAbstractActionListener("Platforms", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                Configuration.Platform pl = (Configuration.Platform)bx.getSelectedItem();
                ResultSet rs = ReleaseSelector.this.controlContext.executeSQL("SELECT DISTINCT VERSION  FROM MAKES WHERE IDOBJSTATUS >= 1000 AND IDPLATFORM = " + pl.toCode() + " ORDER BY VERSION DESC");
                Vector v = ReleaseSelector.fillVector(rs);
                if (pl.hasRelease73()) {
                    v.add("7300");
                }
                ReleaseSelector.updateComboBox(v, ReleaseSelector.this.releasesComboBox);
            }
        });
        this.releasesComboBox.addItemListener(new MyAbstractActionListener("Release", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                String rel = bx.getSelectedItem().toString();
                Configuration.Platform pl = (Configuration.Platform)ReleaseSelector.this.platformsComboBox.getSelectedItem();
                if ("7300".equals(rel)) {
                    Vector<String> v = new Vector<String>();
                    int[] builds = pl.relevant73();
                    for (int i = 0; i < builds.length; ++i) {
                        v.add(Configuration.buildNumber(builds[i]));
                    }
                    ReleaseSelector.updateComboBox(v, ReleaseSelector.this.buildsComboBox);
                } else {
                    ResultSet rs = ReleaseSelector.this.controlContext.executeSQL("SELECT DISTINCT BUILDPFX FROM MAKES WHERE IDOBJSTATUS >= 1000 AND   VERSION = '" + rel + "'" + " AND IDPLATFORM = " + pl.toCode() + " ORDER by BUILDPFX DESC");
                    ReleaseSelector.updateComboBox(ReleaseSelector.fillVector(rs), ReleaseSelector.this.buildsComboBox);
                }
            }
        });
        this.buildsComboBox.addItemListener(new MyAbstractActionListener("Build", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                String version = ReleaseSelector.this.getVersion();
                if ("7300".equals(version)) {
                    Vector<Configuration.QASTATUS> v = new Vector<Configuration.QASTATUS>();
                    v.add(Configuration.RAMP);
                    ReleaseSelector.updateComboBox(v, ReleaseSelector.this.qastatusComboBox);
                } else {
                    Object build = bx.getSelectedItem();
                    Configuration.Platform pl = (Configuration.Platform)ReleaseSelector.this.platformsComboBox.getSelectedItem();
                    String rel = ReleaseSelector.this.releasesComboBox.getSelectedItem().toString();
                    ResultSet rs = ReleaseSelector.this.controlContext.executeSQL("SELECT DISTINCT  IDQASTATUS FROM MAKES WHERE IDOBJSTATUS >= 1000 AND   VERSION = '" + rel + "' " + " AND IDPLATFORM = " + pl.toCode() + " AND BUILDPFX = '" + build + "'" + " ORDER by IDQASTATUS DESC");
                    Vector<Configuration.QASTATUS> v = new Vector<Configuration.QASTATUS>();
                    while (rs.next()) {
                        v.add(Configuration.getQAStatus(rs.getInt(1)));
                    }
                    ReleaseSelector.updateComboBox(v, ReleaseSelector.this.qastatusComboBox);
                }
            }
        });
        this.qastatusComboBox.addItemListener(new MyAbstractActionListener("QA", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                Configuration.QASTATUS astatus = (Configuration.QASTATUS)bx.getSelectedItem();
                String build = ReleaseSelector.this.buildsComboBox.getSelectedItem().toString();
                Configuration.Platform pl = (Configuration.Platform)ReleaseSelector.this.platformsComboBox.getSelectedItem();
                String rel = ReleaseSelector.this.releasesComboBox.getSelectedItem().toString();
                ResultSet rs = ReleaseSelector.this.controlContext.executeSQL("SELECT DISTINCT  TS FROM MAKES WHERE IDOBJSTATUS >= 1000 AND version = '" + rel + "' " + " AND idplatform = " + pl.toCode() + " AND buildpfx = '" + build + "'" + " AND idqastatus = " + astatus.toCode() + " AND lcpoolid not in  (" + "'cncl','dltd','NONE','!RUN','skip','?'" + ")" + " ORDER BY TS DESC");
                ReleaseSelector.updateComboBox(ReleaseSelector.fillVector(rs), ReleaseSelector.this.timestampComboBox);
            }
        });
        this.timestampComboBox.addItemListener(new MyAbstractActionListener("QA", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                Object time = bx.getSelectedItem();
                Configuration.QASTATUS astatus = (Configuration.QASTATUS)ReleaseSelector.this.qastatusComboBox.getSelectedItem();
                String build = ReleaseSelector.this.buildsComboBox.getSelectedItem().toString();
                Configuration.Platform pl = (Configuration.Platform)ReleaseSelector.this.platformsComboBox.getSelectedItem();
                String rel = ReleaseSelector.this.releasesComboBox.getSelectedItem().toString();
                ResultSet rs = ReleaseSelector.this.controlContext.executeSQL("SELECT ID,LCPOOLID,CHANGELIST FROM MAKES WHERE IDOBJSTATUS >= 1000 AND VERSION = '" + rel + "' " + " AND IDPLATFORM = " + pl.toCode() + " AND BUILDPFX = '" + build + "'" + " AND IDQASTATUS = " + astatus.toCode() + " AND TS = '" + time + "'");
                Vector<Object> v = new Vector<Object>();
                String lcpool = null;
                String changeList = null;
                while (rs.next()) {
                    v.add(rs.getObject(1));
                    lcpool = rs.getString(2);
                    changeList = rs.getString(3);
                }
                ReleaseSelector.this.lcPoolLabel.setText(lcpool != null ? lcpool : "");
                ReleaseSelector.this.changeListLabel.setText(changeList != null ? changeList : "");
                ReleaseSelector.updateComboBox(v, ReleaseSelector.this.makeKeyComboBox);
            }

            void itemDeselected(ItemEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                SwingUtilities.invokeLater(new Runnable(this, bx){
                    private final /* synthetic */ MyComboBox val$bx;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$bx = val$bx;
                    }

                    public void run() {
                        try {
                            if (this.val$bx.getItemCount() == 0) {
                                5.access$200(this.this$1).lcPoolLabel.setText("");
                                5.access$200(this.this$1).changeListLabel.setText("");
                                ReleaseSelector.access$100(new Vector<E>(), 5.access$200(this.this$1).makeKeyComboBox);
                                ReleaseSelector.access$300(5.access$200(this.this$1));
                                5.access$200(this.this$1).profileComboBox.setSelectedItem("Server");
                            }
                        }
                        catch (Exception ex) {
                            5.access$200(this.this$1).controlContext.error(ex, "");
                        }
                    }
                });
            }

            static /* synthetic */ ReleaseSelector access$200(5 x0) {
                return x0.ReleaseSelector.this;
            }
        });
        this.makeKeyComboBox.addItemListener(new MyAbstractActionListener("MAKEKEY", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                Object makeKey = bx.getSelectedItem();
                ResultSet rs = ReleaseSelector.this.controlContext.executeSQL("SELECT DISTINCT VERSION FROM LCAMAKES WHERE IDOBJSTATUS >= 1000 AND IDMAKE = " + makeKey + " ORDER by VERSION DESC");
                ReleaseSelector.updateComboBox(ReleaseSelector.fillVector(rs), ReleaseSelector.this.lcreleasesComboBox);
                if (ReleaseSelector.this.lcreleasesComboBox.getItemCount() == 0 || makeKey == null) {
                    ReleaseSelector.this.clearLCASelection();
                    ReleaseSelector.this.profileComboBox.setSelectedItem("Server");
                } else {
                    ReleaseSelector.this.profileComboBox.setSelectedItem("APO LiveCache");
                }
            }
        });
        this.lcreleasesComboBox.addItemListener(new MyAbstractActionListener("LCRELEASE", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                JComboBox bx = (JComboBox)e.getSource();
                Object rel = bx.getSelectedItem();
                Object make = ReleaseSelector.this.makeKeyComboBox.getSelectedItem();
                ResultSet rs = ReleaseSelector.this.controlContext.executeSQL("SELECT DISTINCT IDQASTATUS FROM LCAMAKES WHERE IDOBJSTATUS >= 1000 AND IDMAKE = " + make + " AND VERSION = '" + rel + "'" + " ORDER by IDQASTATUS DESC");
                Vector<Configuration.QASTATUS> v = new Vector<Configuration.QASTATUS>();
                while (rs.next()) {
                    v.add(Configuration.getQAStatus(rs.getInt(1)));
                }
                ReleaseSelector.updateComboBox(v, ReleaseSelector.this.lcqastatusComboBox);
            }
        });
        this.lcqastatusComboBox.addItemListener(new MyAbstractActionListener("LCQA", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                JComboBox bx = (JComboBox)e.getSource();
                Configuration.QASTATUS qast = (Configuration.QASTATUS)bx.getSelectedItem();
                Object rel = ReleaseSelector.this.lcreleasesComboBox.getSelectedItem();
                Object make = ReleaseSelector.this.makeKeyComboBox.getSelectedItem();
                ResultSet rs = ReleaseSelector.this.controlContext.executeSQL("SELECT ts FROM lcamakes WHERE idobjstatus >= 1000 AND idmake = " + make + " AND version = '" + rel + "'" + " AND idqastatus = " + qast.toCode() + " AND lcpoolid not in  (" + "'cncl','dltd','NONE','!RUN','skip','?'" + ")" + " ORDER by ts DESC");
                ReleaseSelector.updateComboBox(ReleaseSelector.fillVector(rs), ReleaseSelector.this.lctimestampComboBox);
            }
        });
        this.lctimestampComboBox.addItemListener(new MyAbstractActionListener("LCTIMESTAMP", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                JComboBox bx = (JComboBox)e.getSource();
                Object ts = bx.getSelectedItem();
                Object rel = ReleaseSelector.this.lcreleasesComboBox.getSelectedItem();
                Object make = ReleaseSelector.this.makeKeyComboBox.getSelectedItem();
                Configuration.QASTATUS qast = (Configuration.QASTATUS)ReleaseSelector.this.lcqastatusComboBox.getSelectedItem();
                ResultSet res = ReleaseSelector.this.controlContext.executeSQL("SELECT id,branchinfo,lcpoolid,type FROM lcamakes WHERE idobjstatus >= 1000 AND idmake = " + make + " AND version = '" + rel + "'" + " AND idqastatus = " + qast.toCode() + " AND ts = '" + ts + "'");
                Vector<Object> v = new Vector<Object>();
                String lcBranchInfo = null;
                String lcaPool = null;
                String aType = null;
                while (res.next()) {
                    v.add(res.getObject(1));
                    lcBranchInfo = res.getString(2);
                    lcaPool = res.getString(3);
                    aType = res.getString(4);
                }
                ReleaseSelector.updateComboBox(v, ReleaseSelector.this.lcMakeKeyComboBox);
                ReleaseSelector.this.lcaBranchInfoLabel.setText(lcBranchInfo != null ? lcBranchInfo : "");
                ReleaseSelector.this.lcaPoolLabel.setText(lcaPool != null ? lcaPool : "");
                ReleaseSelector.this.lcaVariantLabel.setText(aType != null ? aType : "");
            }
        });
    }

    Configuration.SoftwareDescription createSoftwareDescription(File tempDir, String toolsDir, File indepProg, File indepData, File depFile) {
        File packdistrib;
        String version = this.getVersion();
        Configuration.QASTATUS status = this.getQAStatus();
        Configuration.SoftwareDescription softwareDescription = new Configuration.SoftwareDescription();
        Configuration.Platform apf = this.getPlatform();
        softwareDescription.packdistrib = packdistrib = new File(toolsDir, "bin/packdistrib.pl");
        softwareDescription.platform = apf;
        softwareDescription.indepProg = indepProg;
        softwareDescription.indepData = indepData;
        softwareDescription.tempDir = tempDir;
        softwareDescription.unpackDir = Configuration.constructPackageDir(tempDir, version, status, apf);
        String normVersion = this.getNormalizedVersion();
        softwareDescription.depPath = depFile;
        softwareDescription.status = status;
        softwareDescription.version = normVersion;
        softwareDescription.lcpool = this.getLCPool();
        softwareDescription.apoversion = this.getLCVersion();
        softwareDescription.apostatus = this.getLCQAStatus();
        softwareDescription.apolcpool = this.getLCAPool();
        softwareDescription.lcaVariant = this.getLCAVariant();
        softwareDescription.branchInfo = this.getLCABranchInfo();
        softwareDescription.build = this.getBuild();
        softwareDescription.makeKey = this.getMakeKey();
        softwareDescription.apoMakeKey = this.getApoMakeKey();
        softwareDescription.profile = this.getProfile();
        return softwareDescription;
    }

    Configuration.QASTATUS getQAStatus() {
        return (Configuration.QASTATUS)this.qastatusComboBox.getSelectedItem();
    }

    String getBuild() {
        Object ob = this.buildsComboBox.getSelectedItem();
        return ob == null ? null : ob.toString();
    }

    String getLCVersion() {
        Object ob = this.lcreleasesComboBox.getSelectedItem();
        return ob == null ? null : ob.toString();
    }

    String getLCPool() {
        String txt = this.lcPoolLabel.getText();
        return "".equals(txt) ? null : txt;
    }

    String getChangeList() {
        String txt = this.changeListLabel.getText();
        return "".equals(txt) ? null : txt;
    }

    String getLCAPool() {
        String txt = this.lcaPoolLabel.getText();
        return "".equals(txt) ? null : txt;
    }

    String getLCABranchInfo() {
        String txt = this.lcaBranchInfoLabel.getText();
        return "".equals(txt) ? null : txt;
    }

    Configuration.QASTATUS getLCQAStatus() {
        return (Configuration.QASTATUS)this.lcqastatusComboBox.getSelectedItem();
    }

    Configuration.Platform getPlatform() {
        return (Configuration.Platform)this.platformsComboBox.getSelectedItem();
    }

    String getNormalizedVersion() {
        return this.getNormalizedVersion(this.getVersion());
    }

    private String getNormalizedVersion(String version) {
        Configuration.QASTATUS status = this.getQAStatus();
        String build = this.getBuild();
        return Configuration.getNormalizedVersion(version, build, status);
    }

    String getLCAVariant() {
        String txt = this.lcaVariantLabel.getText();
        return "".equals(txt) ? null : txt;
    }

    String getMakeKey() {
        Object ob = this.makeKeyComboBox.getSelectedItem();
        return ob == null ? null : ob.toString();
    }

    String getApoMakeKey() {
        Object ob = this.lcMakeKeyComboBox.getSelectedItem();
        return ob == null ? null : ob.toString();
    }

    String getProfile() {
        return this.profileComboBox.getSelectedItem().toString();
    }
}

