/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.upgradetest.CanEnable;
import com.sap.sapdb.upgradetest.ComplexParameter;
import com.sap.sapdb.upgradetest.Configuration;
import com.sap.sapdb.upgradetest.ConfigurationException;
import com.sap.sapdb.upgradetest.Constants;
import com.sap.sapdb.upgradetest.ControlContext;
import com.sap.sapdb.upgradetest.Executor;
import com.sap.sapdb.upgradetest.ExecutorEvent;
import com.sap.sapdb.upgradetest.ExecutorListener;
import com.sap.sapdb.upgradetest.ExecutorListenerAdapter;
import com.sap.sapdb.upgradetest.ExecutorListenerDelegator;
import com.sap.sapdb.upgradetest.ExecutorServer;
import com.sap.sapdb.upgradetest.ExecutorServerImpl;
import com.sap.sapdb.upgradetest.InstChecker;
import com.sap.sapdb.upgradetest.InstallerTester;
import com.sap.sapdb.upgradetest.Logger;
import com.sap.sapdb.upgradetest.MyAbstractActionListener;
import com.sap.sapdb.upgradetest.MyComboBox;
import com.sap.sapdb.upgradetest.ReleaseSelector;
import com.sap.sapdb.upgradetest.RemoteExecutor;
import com.sap.sapdb.upgradetest.RemoteExecutorList;
import com.sap.sapdb.upgradetest.RemoteInputStream;
import com.sap.sapdb.upgradetest.RemoteInputStreamImpl;
import com.sap.sapdb.upgradetest.SerializableFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class InstallerTester
extends JFrame
implements Constants {
    Configuration config;
    RemoteExecutor currentExecutor;
    ExecutorListener currentExecutorListener;
    ExecutorServer executorServer;
    private final ControlContext controlContext = new ControlContext(this);
    private volatile long cancelInProgress = -1L;
    static final long serialVersionUID = 8618704335691469719L;
    static final String LOCALHOST = "localhost";
    private static int instanceCounter = 0;
    private static final String APPNAME = "InstallerTester";
    private static final String LOCALHOST_TITLE = "InstallerTester on localhost";
    private static RemoteExecutorList startedRemoteExecutors = new RemoteExecutorList();
    static final File USERCONFIG = new File(System.getProperty("user.home"), "InstallerTester.properties");
    static final TestServer LOCALHOSTTESTER = new LOCALHOSTTESTERCLASS();
    static final TestServer HS0030 = new HS0030CLASS();
    static final TestServer HS0116 = new HS0116CLASS();
    static final TestServer IS0025 = new IS0025CLASS();
    static final TestServer IS0042 = new IS0042CLASS();
    static final TestServer IS4009 = new IS4009CLASS();
    static final TestServer LDP001 = new LDP001CLASS();
    static final TestServer LD0319 = new LD0319CLASS();
    static final TestServer LD0406 = new LD0406CLASS();
    static final TestServer LS3007 = new LS3007CLASS();
    static final TestServer LS3101 = new LS3101CLASS();
    static final TestServer LS3662 = new LS3662CLASS();
    static final TestServer US4010 = new US4010CLASS();
    static final TestServer DS0116 = new DS0116CLASS();
    static final TestServer PWDF2904 = new PWDF2904CLASS();
    static final TestServer[] KNOWN_TESTER_HOSTS = new TestServer[]{LOCALHOSTTESTER, HS0030, HS0116, IS0025, IS0042, IS4009, LDP001, LD0319, LD0406, LS3007, LS3101, LS3662, US4010, DS0116, PWDF2904};
    final ReleaseSelector installationSelector = new ReleaseSelector(this.controlContext);
    final ReleaseSelector upgradeTargetSelector;
    final ReleaseSelector upgradeOriginSelector;
    final JTextField depPathTextField;
    final JLabel depLabel;
    final JTextField indepDataPathTextField;
    final JLabel indepDataLabel;
    final JTextField indepProgPathTextField;
    final JLabel indepProgLabel;
    final JTextField packTextField;
    final JLabel patchSourceLabel;
    final JTextField patchSourceTextField;
    final JButton selectPatchSourceButton;
    final MyAbstractActionListener selectPatchSourceAction;
    final JButton patchButton;
    final MyAbstractActionListener patchAction;
    final JLabel toolsLabel;
    final JTextField toolsTextField;
    final JLabel perlLabel;
    final JTextField perlTextField;
    final JButton localToolsButton;
    final MyAbstractActionListener localToolsAction;
    private final JMenuBar menuBar;
    private final JMenu menu1;
    private final MyAbstractActionListener newWindowAction;
    private final MyAbstractActionListener exitAction;
    final JLabel patchTargetLabel;
    final JTextField patchTargetTextField;
    final JLabel packLabel;
    final JLabel label;
    final JTabbedPane loggerPane;
    final JTextPane sqlLog;
    final JTextPane aLog;
    final JTextPane trace;
    final JTextPane updateLog;
    final JTextPane createScriptTextPane;
    final JToolBar serverToolBar;
    final JComboBox knownHostsComboBox;
    final JTextField hostTextField;
    final JTextField rmiPortTextField;
    final AbstractAction hostAction;
    final MyAbstractActionListener connectAction;
    final MyAbstractActionListener shutdownAction;
    final MyAbstractActionListener bootAction;
    final MyAbstractActionListener analyzeAction;
    final JToolBar chrootToolBar;
    final JToolBar processToolBar;
    final AbstractAction killAction;
    final MyAbstractActionListener cutAction;
    final MyAbstractActionListener joinAction;
    final JComboBox chrootComboBox;
    final MyAbstractActionListener xtermAction;
    final MyAbstractActionListener xtermRootAction;
    final MyAbstractActionListener showTestsAction;
    final JToolBar dataBaseToolBar;
    final JTextField uxXServerPortTextField;
    final JTextField dbHostTextField;
    final JTextField dbNameTextField;
    final JTextField dbmTextField;
    final JPasswordField dbmPasswordField;
    final JToolBar dataBaseToolBar2;
    final JTextField dbaTextField;
    final JPasswordField dbaPasswordField;
    final JTextField osUserTextField;
    final JPasswordField osUserPasswordField;
    final JToolBar filesToolBar;
    final JToolBar installationToolBar;
    final JToolBar upgradeToolBar;
    final JToolBar templateTestToolBar;
    final MyAbstractActionListener upgradeTestAction;
    static final SerializableFileFilter DEFAULTFILEFILTER = new SerializableFileFilter(){

        public boolean accept(File f) {
            return true;
        }
    };
    FileItem[] filesOnHost;
    final JComboBox filesComboBox;
    final JTextField filesTextField;
    final MyAbstractActionListener showFileAction;
    final MyAbstractActionListener existsAction;
    static final String WRK = "wrk";
    static final String UPGRTSTS = "upgrtst";
    static final String PROTS = "prots";
    static final String TEMPLATEPROTS = "tpltst";
    final String[] knownDirs;
    final JComboBox dirsComboBox;
    final MyAbstractActionListener listDirsAction;
    final AbstractAction uxPortAction;
    final AbstractAction packdistribAction;
    final AbstractAction unpackdistribAction;
    final AbstractAction sdbinstAction;
    final AbstractAction sdbuninstAction;
    final AbstractAction startXServerAction;
    final AbstractAction stopXServerAction;
    final AbstractAction crDBAction;
    final AbstractAction delDBAction;
    final AbstractAction backupDBAction;
    final AbstractAction fakeLCBackupAction;
    final AbstractAction sdbupdAction;
    final AbstractAction fclrAction;
    final AbstractAction clrAction;
    static final String ALL = "All";
    static final String ALL_MAX_APO = "All, max apo";
    static final String ALL_NO_P = "All, no patch";
    static final String ALL_NO_P_MAX_APO = "All, no patch,max apo";
    static final String MIN = "Min";
    static final String MIN_NO_P = "Min, no patch)";
    final MyComboBox upgradeSequenceComboBox;
    final AbstractAction viewUpgradeSequenceAction;
    final AbstractAction upgradeSequenceAction;
    final AbstractAction upgradesAction;
    final JComboBox knownTemplatesComboBox;
    final AbstractAction templatesAction;
    final AbstractAction templateTestAction;

    private boolean cancelInProgress() {
        return this.cancelInProgress != -1L;
    }

    private static void startRemoteExecutor(RemoteExecutor exec) throws RemoteException {
        exec.start();
        startedRemoteExecutors.add(exec);
    }

    private static void destroyRemoteExecutors() {
        RemoteExecutor[] exes = startedRemoteExecutors.toArray();
        for (int i = 0; i < exes.length; ++i) {
            RemoteExecutor ex = exes[i];
            try {
                ex.destroy();
                startedRemoteExecutors.remove(ex);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void initInstallationsSelector() {
        this.installationSelector.buildsComboBox.addItemListener(new MyAbstractActionListener("Build", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        String version = 1.access$000(this.this$1).installationSelector.getNormalizedVersion();
                        InstallerTester.access$100(1.access$000(this.this$1), version);
                        InstallerTester.access$300(1.access$000(this.this$1), version, InstallerTester.access$200(1.access$000(this.this$1)));
                    }
                });
            }

            static /* synthetic */ InstallerTester access$000(1 x0) {
                return x0.InstallerTester.this;
            }
        });
        this.installationSelector.qastatusComboBox.addItemListener(new MyAbstractActionListener("QA", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                File f = InstallerTester.this.constructPackageDir();
                InstallerTester.this.packTextField.setText(InstallerTester.this.executorServer.canonicalPath(f));
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            3.access$500(this.this$1).updateActions();
                        }
                        catch (Exception ex) {
                            3.access$500(this.this$1).error(ex, "Internal error updating gui\n");
                        }
                    }
                });
            }

            static /* synthetic */ InstallerTester access$500(3 x0) {
                return x0.InstallerTester.this;
            }
        });
        this.installationSelector.platformsComboBox.addItemListener(new MyAbstractActionListener("Platforms", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                MyComboBox bx = (MyComboBox)e.getSource();
                Configuration.Platform pl = (Configuration.Platform)bx.getSelectedItem();
                InstallerTester.this.config.setCurrentPlatform(pl);
            }
        });
        this.installationSelector.profileComboBox.addItemListener(new MyAbstractActionListener("Platforms", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        String version = 6.access$600(this.this$1).installationSelector.getNormalizedVersion();
                        InstallerTester.access$300(6.access$600(this.this$1), version, InstallerTester.access$200(6.access$600(this.this$1)));
                    }
                });
            }

            static /* synthetic */ InstallerTester access$600(6 x0) {
                return x0.InstallerTester.this;
            }
        });
    }

    public void initUpgradeSelector(ReleaseSelector as) {
        as.qastatusComboBox.addItemListener(new MyAbstractActionListener("QA", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            8.access$700(this.this$1).updateActions();
                        }
                        catch (RemoteException ex) {
                            8.access$700(this.this$1).error(ex, "Internal error updating gui elements\n");
                        }
                    }
                });
            }

            static /* synthetic */ InstallerTester access$700(8 x0) {
                return x0.InstallerTester.this;
            }
        });
    }

    static boolean isKnownHost(String ahost) {
        if (ahost != null) {
            ahost = ahost.trim();
        }
        for (int i = 0; i < KNOWN_TESTER_HOSTS.length; ++i) {
            if (!InstallerTester.KNOWN_TESTER_HOSTS[i].name.equals(ahost)) continue;
            return true;
        }
        return false;
    }

    static TestServer getTestServer(String hostName) {
        TestServer testerServer = new TestServer();
        for (int i = 0; i < KNOWN_TESTER_HOSTS.length; ++i) {
            TestServer ts = KNOWN_TESTER_HOSTS[i];
            if (!ts.name.equals(hostName)) continue;
            testerServer = ts;
            break;
        }
        return testerServer;
    }

    private boolean askLocalTools() throws IOException {
        boolean gotTools = false;
        JFileChooser fch = new JFileChooser(new File(this.getToolsDir()));
        fch.setFileSelectionMode(1);
        fch.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "Directory";
            }

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        int retVal = fch.showOpenDialog(this);
        if (retVal == 0 && fch.getSelectedFile() != null) {
            File selectedFile = fch.getSelectedFile();
            Properties props = InstallerTester.readUserConfig(new Properties());
            props.setProperty("env.tool", selectedFile.getCanonicalPath());
            InstallerTester.writeUserConfig(props);
            this.log("Wrote user configuration to ");
            this.log(USERCONFIG + "\n", "path");
            this.toolsTextField.setText(selectedFile.getCanonicalPath());
            this.perlTextField.setText(this.createPerlCall(!Configuration.isWindows(props), this.toolsTextField.getText()));
            gotTools = true;
        }
        return gotTools;
    }

    private static Properties readUserConfig(Properties props) throws IOException {
        if (USERCONFIG.exists()) {
            props.load(new FileInputStream(USERCONFIG));
        }
        return props;
    }

    private static void writeUserConfig(Properties props) throws IOException {
        props.store(new FileOutputStream(USERCONFIG), "InstallerTester Properties");
    }

    private void patchFile(File fromFile, File toFile) throws IOException {
        RemoteInputStreamImpl is = new RemoteInputStreamImpl(fromFile);
        if (this.executorServer.isRemote()) {
            UnicastRemoteObject.exportObject(is);
        }
        this.executorServer.write(is, toFile, 1024);
    }

    private void performConnectAction(String hostName) throws SQLException, RemoteException, ProcessInitException, IOException, NotBoundException {
        if (hostName == null || "".equals(hostName) || LOCALHOST.equalsIgnoreCase(hostName)) {
            this.initLocally();
            String msg = "Now running locally\n";
            this.knownHostsComboBox.setSelectedItem(LOCALHOSTTESTER);
            this.clearLog();
            this.log(msg);
        } else {
            Object connectedHost = null;
            Configuration.Platform pf = Configuration.getPlatformByQADB(hostName);
            if (pf == null) {
                this.log("Host '" + hostName + "' not found on QADB\n", "error", this.aLog);
            }
            this.initRemote(hostName, pf);
        }
        this.updateActions();
    }

    private void performInstCheck() throws RemoteException, ProcessInitException {
        InstChecker is = new InstChecker();
        final RemoteExecutor remexec = this.executorServer.createRemoteExecutor(is);
        ExecutorListenerDelegator listener = new ExecutorListenerDelegator(new ExecutorListenerAdapter(){

            public void executorStatus(ExecutorEvent e) throws RemoteException {
                String status = e.getExecutorStateChange();
                if ("finished".equals(status)) {
                    InstChecker instChecker = (InstChecker)remexec.getExecutor();
                    String indepPrograms = instChecker.getIndepPrograms();
                    String indepData = instChecker.getIndepData();
                    Properties sysProps = instChecker.getSysProps();
                    InstallerTester.this.log("OS: ");
                    InstallerTester.this.log("'" + sysProps.getProperty("os.name") + "' '" + sysProps.getProperty("os.arch") + "' '" + sysProps.getProperty("os.version") + "'\n", "path");
                    String[] dbs = instChecker.getDBS();
                    if (indepPrograms != null) {
                        InstallerTester.this.log("Independ Programs: ");
                        InstallerTester.this.log(indepPrograms + "\n", "path");
                        InstallerTester.this.setIndepPrograms(indepPrograms);
                    }
                    if (indepData != null) {
                        InstallerTester.this.log("Independ Data: ");
                        InstallerTester.this.log(indepData + "\n", "path");
                        InstallerTester.this.setIndepData(indepData);
                    }
                    String jtestRoot = sysProps.getProperty("jtest.root");
                    InstallerTester.this.log("Test Installation: ");
                    InstallerTester.this.log(jtestRoot, "path");
                    InstallerTester.this.log("\n");
                    String toolsDir = sysProps.getProperty("env.tool");
                    InstallerTester.this.log("Tools Installation: ");
                    InstallerTester.this.log(toolsDir, "path");
                    InstallerTester.this.log("\n");
                    if (dbs.length > 0) {
                        InstallerTester.this.log("Found the following database(s):\n");
                        for (int i = 0; i < dbs.length; ++i) {
                            InstallerTester.this.log(dbs[i] + "\n");
                        }
                    }
                }
            }
        });
        if (this.executorServer.isRemote()) {
            UnicastRemoteObject.exportObject(listener);
        }
        remexec.addExecutorListener(listener);
        this.startCurrentRemoteExecutor(remexec, is);
    }

    String getChroot() {
        return this.chrootComboBox.getSelectedItem().toString();
    }

    private void openXterm(boolean root) throws Exception {
        String perlScript;
        String host = this.getHostName();
        TestServer server = InstallerTester.getTestServer(host);
        String string = perlScript = root ? server.getRootXterm() : server.getRemuserXterm();
        if (host == null || host.trim().equals("")) {
            JOptionPane.showMessageDialog(this, "Selected a host first!", "No host selected", 0);
            return;
        }
        String ip = InetAddress.getLocalHost().getHostAddress();
        String chroot = this.getChroot();
        Executor exec = Configuration.createXtermExecutor(host, this.getLocalToolsDir(), "/devtool/local/bin/perl", chroot, ip + ":0.0", perlScript);
        exec.addExecutorListener(new GuiExecutorListener());
        InstallerTester.startRemoteExecutor(exec);
    }

    private void verifyRunningUpgradeTests() throws SQLException {
        Timestamp ts;
        this.log("GETTING INFO ABOUT RUNNING UPGRADE TESTS \n");
        String hostName = this.getHostName();
        String sql = "SELECT *   FROM javatestinfo WHERE testname='upgradetest.UpgradeTest' AND  driverfqhn = '" + hostName + "' AND  isrunning =  TRUE";
        ResultSet res = this.executeSQL(sql);
        if (res.next()) {
            ts = res.getTimestamp(5);
            this.log("Found running  upgradetest on selected host " + hostName + ", started at " + ts + "\n", "error");
        }
        if ((res = this.executeSQL(sql = "SELECT *   FROM javatestinfo WHERE testname='upgradetest.UpgradeTest' AND  isrunning =  TRUE")).next()) {
            this.log("SUMMARY:\n");
            do {
                ts = res.getTimestamp(5);
                String host = res.getString(3);
                this.log(host + ": " + " started at " + ts + "\n");
            } while (res.next());
        } else {
            this.log("No running upgrade tests!\n");
        }
    }

    private void chrootInfo() throws SQLException {
        this.clearLog();
        String chroot = this.getChroot();
        if ("07".equals(chroot)) {
            this.verifyRunningUpgradeTests();
        }
        String sql = "select * from chr_monitor where chrdir = '" + chroot + "'";
        ResultSet res = this.executeSQL(sql);
        int hostCount = 0;
        if (res.next()) {
            this.log("EXISTING CHANGEROOTS Number " + chroot + " IN QADB:\n");
            do {
                ++hostCount;
                String host = res.getString("HOST");
                String version = res.getString("VERSION");
                String build = res.getString("BUILDPFX");
                String statusString = res.getString("QASTATUS");
                Configuration.QASTATUS status = Configuration.getQAStatus(statusString);
                String descr = res.getString("READTEXT");
                String normalizedVersion = Configuration.getNormalizedVersion(version, build, status);
                this.log(host + ": " + normalizedVersion + " " + status + " (" + descr + ")\n");
            } while (res.next());
            this.log("(" + hostCount + " hosts)\n");
        } else {
            this.log("(No upgrade changeroots found in QADBA)\n");
        }
    }

    private Hashtable getDBMProperties() {
        String port;
        Hashtable<String, String> dbmprops = new Hashtable<String, String>();
        Configuration.Platform plf = this.installationSelector.getPlatform();
        dbmprops.put("dbname", this.dbNameTextField.getText());
        dbmprops.put("user", this.dbmTextField.getText() + "," + new String(this.dbmPasswordField.getPassword()));
        String host = this.dbHostTextField.getText();
        dbmprops.put("host", host);
        try {
            port = ":" + Integer.parseInt(this.uxXServerPortTextField.getText());
        }
        catch (NumberFormatException ex) {
            port = "";
        }
        if (plf.isUnix()) {
            dbmprops.put("host", host + port);
        } else {
            dbmprops.put("host", host);
        }
        return dbmprops;
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    boolean isLocal() {
        String hostName = this.getHostName();
        return hostName == null || "".equals(hostName) || LOCALHOST.equals(hostName);
    }

    void setExecutorServer(ExecutorServer as) throws IOException, ProcessInitException {
        this.executorServer = as;
        this.currentExecutor = null;
        if (this.executorServer != null) {
            Properties sysProps;
            String toolsDir;
            File prog = this.config.getIndepProg();
            File data = this.config.getIndepData();
            String progPath = this.executorServer.canonicalPath(prog);
            String dataPath = this.executorServer.canonicalPath(data);
            this.indepProgPathTextField.setText(progPath);
            this.indepDataPathTextField.setText(dataPath);
            Properties props = this.executorServer.getSystemProperties();
            String remoteTestEnv = props.getProperty("jtest.root");
            File file = new File(remoteTestEnv, "tests/upgradetest.jar");
            this.patchTargetTextField.setText(this.executorServer.canonicalPath(file));
            RemoteExecutor currentExecutor = as.getCurrentExecutor();
            if (ExecutorServerImpl.isUndoneExecutor(currentExecutor)) {
                this.setCurrentExecutor(currentExecutor);
                String shortName = currentExecutor.getExecutor().shortName;
            }
            if ((toolsDir = (sysProps = this.executorServer.getSystemProperties()).getProperty("env.tool")) == null && !this.executorServer.isRemote()) {
                toolsDir = InstallerTester.readUserConfig(new Properties()).getProperty("env.tool");
            }
            this.toolsTextField.setText(toolsDir);
            this.perlTextField.setText(this.createPerlCall(!Configuration.isWindows(sysProps), toolsDir));
        } else {
            this.indepProgPathTextField.setText("");
            this.indepDataPathTextField.setText("");
            this.patchTargetTextField.setText("");
            this.toolsTextField.setText("");
            this.perlTextField.setText("perl");
            this.localToolsButton.setEnabled(true);
        }
    }

    void startCurrentExecutor(Executor executor) throws ProcessInitException, RemoteException {
        if (executor != null) {
            this.clearLog(this.aLog);
            RemoteExecutor remoteExecutor = this.executorServer.createRemoteExecutor(executor);
            this.startCurrentRemoteExecutor(remoteExecutor, executor);
        } else {
            if (this.hasRunningProcess()) {
                throw new ProcessInitException("There is a running process!");
            }
            if (executor == null) {
                this.nullifyExecutor();
            }
        }
    }

    private void startCurrentRemoteExecutor(RemoteExecutor remoteExecutor, Executor executor) throws RemoteException, ProcessInitException {
        if (this.hasRunningProcess()) {
            throw new ProcessInitException("There is a running process!");
        }
        this.currentExecutor = remoteExecutor;
        this.currentExecutorListener = new ExecutorListenerDelegator(new GuiExecutorListener());
        if (this.executorServer.isRemote()) {
            UnicastRemoteObject.exportObject(this.currentExecutorListener);
        }
        this.currentExecutor.addExecutorListener(this.currentExecutorListener);
        this.currentExecutor.start();
        this.log("\n", this.updateLog);
        this.dateLog("Started " + executor.shortName + "\n", this.updateLog);
    }

    private void nullifyExecutor() throws RemoteException {
        if (this.currentExecutor != null && this.currentExecutorListener != null) {
            this.currentExecutor.removeExecutorListener(this.currentExecutorListener);
        }
        this.currentExecutor = null;
    }

    void setCurrentExecutor(RemoteExecutor remoteExecutor) throws ProcessInitException, RemoteException {
        if (this.hasRunningProcess()) {
            throw new ProcessInitException("There is a running process!");
        }
        this.clearLog(this.aLog);
        if (remoteExecutor != null) {
            this.currentExecutorListener = new ExecutorListenerDelegator(new GuiExecutorListener());
            if (this.executorServer.isRemote()) {
                UnicastRemoteObject.exportObject(this.currentExecutorListener);
            }
            remoteExecutor.addExecutorListener(this.currentExecutorListener);
        }
        this.currentExecutor = remoteExecutor;
    }

    private void showFile(String fileName, boolean isDir, SerializableFileFilter ff) throws IOException {
        File f = new File(fileName);
        this.showFile(fileName, f, isDir, ff);
    }

    private void showFile(String fileName, File f, boolean isDir, SerializableFileFilter ff) throws IOException {
        if (!isDir) {
            if (this.executorServer.exists(f)) {
                RemoteInputStream ris = this.executorServer.stream(f);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ExecutorServerImpl.internalWrite(ris, bos, 8192);
                String s = new String(bos.toByteArray());
                this.clearLog();
                this.log("Contents of " + fileName + ":\n", "path");
                this.log(s);
            } else {
                this.errorMessage(fileName + " does not exist on this host!\n");
            }
        }
    }

    Configuration.SoftwareDescription createBasicSoftwareDescription(String version, Configuration.QASTATUS status) throws RemoteException {
        File packdistrib;
        Configuration.SoftwareDescription softwareVersion = new Configuration.SoftwareDescription();
        Configuration.Platform apf = this.installationSelector.getPlatform();
        File tempDir = new File(this.executorServer.getSystemProperties().getProperty("java.io.tmpdir"));
        String toolsDir = this.getToolsDir();
        softwareVersion.packdistrib = packdistrib = new File(toolsDir, "bin/packdistrib.pl");
        softwareVersion.platform = apf;
        softwareVersion.indepProg = this.indepProgDir();
        softwareVersion.indepData = this.indepDataDir();
        softwareVersion.tempDir = tempDir;
        softwareVersion.unpackDir = Configuration.constructPackageDir(tempDir, version, status, apf);
        return softwareVersion;
    }

    Configuration.SoftwareDescription createSoftwareDescription(ReleaseSelector releaseSelector) throws RemoteException {
        File indepProg = this.indepProgDir();
        File indepData = this.indepDataDir();
        File depFile = this.config.getDependendPathForVersionOsIndependend(releaseSelector.getNormalizedVersion());
        String toolsDir = this.getToolsDir();
        File tempDir = new File(this.executorServer.getSystemProperties().getProperty("java.io.tmpdir"));
        return releaseSelector.createSoftwareDescription(tempDir, toolsDir, indepProg, indepData, depFile);
    }

    Configuration.SoftwareDescription createSoftwareDescription(UpgradeComboBoxItem releaseSelection, UpgradeComboBoxLCAItem lcaReleaseSelection) throws RemoteException {
        File depFile;
        String normVersion = Configuration.getNormalizedVersion(releaseSelection.version, releaseSelection.build, releaseSelection.status);
        Configuration.SoftwareDescription softwareVersion = this.createBasicSoftwareDescription(normVersion, releaseSelection.status);
        softwareVersion.depPath = depFile = this.config.getDependendPathForVersionOsIndependend(normVersion);
        softwareVersion.status = releaseSelection.status;
        softwareVersion.version = normVersion;
        softwareVersion.lcpool = releaseSelection.lcpool;
        softwareVersion.platform = releaseSelection.platform;
        if (lcaReleaseSelection != null) {
            softwareVersion.apoversion = lcaReleaseSelection.lcaversion;
            softwareVersion.apostatus = lcaReleaseSelection.lcaqastatus;
            softwareVersion.apolcpool = lcaReleaseSelection.lcapoolid;
            softwareVersion.lcaVariant = lcaReleaseSelection.lcaVariant;
            softwareVersion.branchInfo = lcaReleaseSelection.branchInfo;
        }
        softwareVersion.profile = this.installationSelector.getProfile();
        return softwareVersion;
    }

    private String initLocally() {
        try {
            this.setExecutorServer(new ExecutorServerImpl());
            this.statusBar("Running locally");
            this.setTitle(LOCALHOST_TITLE);
            this.dateLog("Running locally\n", this.updateLog);
            this.syncConfig();
        }
        catch (Exception ex) {
            this.error(ex, "Error initializing executor interface\n");
            return null;
        }
        if (Configuration.isWindows()) {
            this.installationSelector.platformsComboBox.setSelectedItem(Configuration.NTINTEL);
            this.upgradeTargetSelector.platformsComboBox.setSelectedItem(Configuration.NTINTEL);
            this.upgradeOriginSelector.platformsComboBox.setSelectedItem(Configuration.NTINTEL);
        } else {
            this.installationSelector.platformsComboBox.setSelectedItem(null);
            this.upgradeTargetSelector.platformsComboBox.setSelectedItem(null);
            this.upgradeOriginSelector.platformsComboBox.setSelectedItem(null);
        }
        return LOCALHOST;
    }

    private void initRemote(String hostName, Configuration.Platform pf) throws IOException, NotBoundException, ProcessInitException {
        String msg;
        String address = "//" + hostName + "/ExecutorServer";
        this.setExecutorServer((ExecutorServer)Naming.lookup(address));
        this.setTitle("InstallerTester on " + hostName);
        this.statusBar("Connected to " + hostName);
        this.syncConfig();
        String logMsg = msg = "Connected to " + hostName + " (" + (pf != null ? pf.descText : "unknown platform") + ")\n";
        if (this.currentExecutor != null) {
            try {
                String shortName = this.currentExecutor.getExecutor().shortName;
                logMsg = logMsg + "Connected to running process '" + shortName + "'\n";
            }
            catch (RemoteException ex) {
                this.error(ex, "Error connecting remote server\n");
            }
        }
        this.clearLog();
        this.log(logMsg);
        this.dateLog(logMsg, this.updateLog);
        if (pf != null) {
            this.installationSelector.platformsComboBox.setSelectedItem(pf);
            this.upgradeTargetSelector.platformsComboBox.setSelectedItem(pf);
            this.upgradeOriginSelector.platformsComboBox.setSelectedItem(pf);
        }
        this.knownHostsComboBox.setSelectedItem(InstallerTester.getTestServer(hostName));
    }

    private void syncConfig() {
        InstChecker instChecker = null;
        try {
            instChecker = this.instChecker();
        }
        catch (RemoteException ex) {
            this.log("InstChecker failed: " + ex.getMessage(), "error");
        }
        if (instChecker != null) {
            String indepPrograms = instChecker.getIndepPrograms();
            String indepData = instChecker.getIndepData();
            if (indepPrograms != null) {
                this.setIndepPrograms(indepPrograms);
            }
            if (indepData != null) {
                this.setIndepData(indepData);
            }
        }
    }

    private InstChecker instChecker() throws RemoteException {
        InstChecker instChecker = new InstChecker();
        RemoteExecutor remexec = this.executorServer.createRemoteExecutor(instChecker);
        instChecker = (InstChecker)remexec.getExecutor();
        return instChecker;
    }

    private void connectionError(Exception ex, String host) {
        String msg = "RMI-Connection to " + host + " could not be established, you are sure the server is running?\n";
        this.error(ex, msg);
        this.dateLog("Connection to " + host + " could not be established \n", "error", this.updateLog);
    }

    private File constructPackageDir() throws RemoteException {
        File tempDir = new File(this.executorServer.getSystemProperties().getProperty("java.io.tmpdir"));
        return Configuration.constructPackageDir(tempDir, this.installationSelector.getNormalizedVersion(), this.installationSelector.getQAStatus(), this.installationSelector.getPlatform());
    }

    private File packageDir() throws RemoteException {
        return new File(this.packTextField.getText());
    }

    private File depDir() throws RemoteException {
        return new File(this.depPathTextField.getText());
    }

    private File indepProgDir() throws RemoteException {
        return new File(this.indepProgPathTextField.getText());
    }

    private void setIndepPrograms(String s) {
        this.indepProgPathTextField.setText(s);
    }

    private File indepDataDir() throws RemoteException {
        return new File(this.indepDataPathTextField.getText());
    }

    private void setIndepData(String s) {
        this.indepDataPathTextField.setText(s);
    }

    private void clearLog() {
        this.clearLog(this.aLog);
    }

    private void clearLog(JTextPane textPane) {
        textPane.setText("");
        textPane.setCaretPosition(0);
    }

    void log(String s) {
        this.log(s, null, this.aLog);
        this.loggerPane.setSelectedIndex(0);
    }

    void dateLog(String s) {
        this.dateLog(s, null, this.aLog);
        this.loggerPane.setSelectedIndex(0);
    }

    void log(String s, String sort) {
        this.log(s, sort, this.aLog);
        this.loggerPane.setSelectedIndex(0);
    }

    void dateLog(String s, String sort) {
        this.dateLog(s, sort, this.aLog);
        this.loggerPane.setSelectedIndex(0);
    }

    void log(String s, JTextPane pane) {
        this.log(s, null, pane);
    }

    void dateLog(String s, JTextPane pane) {
        this.dateLog(s, null, pane);
    }

    public InstallerTester() {
        super(LOCALHOST_TITLE);
        this.initInstallationsSelector();
        this.upgradeTargetSelector = new ReleaseSelector(this.controlContext);
        this.initUpgradeSelector(this.upgradeTargetSelector);
        this.upgradeOriginSelector = new ReleaseSelector(this.controlContext);
        this.initUpgradeSelector(this.upgradeOriginSelector);
        this.depPathTextField = new FixedWidthTextField("", 0, true, true);
        this.depLabel = new JLabel("DEP");
        this.indepDataPathTextField = new FixedWidthTextField("", 0, true, false);
        this.indepDataLabel = new JLabel("DAT");
        this.indepProgPathTextField = new FixedWidthTextField("", 0, true, false);
        this.indepProgLabel = new JLabel("PROG");
        this.packTextField = new FixedWidthTextField("", 0, true, true);
        this.patchSourceLabel = new JLabel("PSRC");
        this.patchSourceLabel.setToolTipText("Patch source");
        this.patchSourceTextField = new FixedWidthTextField("", 0, false, false, "Patch source");
        this.selectPatchSourceButton = new JButton();
        this.selectPatchSourceAction = new MyAbstractActionListener("SELECT", this.selectPatchSourceButton, "Select patch source", this.controlContext){

            public void myAction(ActionEvent e) throws IOException {
                JFileChooser fch = new JFileChooser(new File(InstallerTester.this.patchSourceTextField.getText()));
                int retVal = fch.showOpenDialog(InstallerTester.this);
                if (retVal == 0) {
                    File selectedFile = fch.getSelectedFile();
                    InstallerTester.this.patchSourceTextField.setText(selectedFile.getCanonicalPath());
                }
            }
        };
        this.patchButton = new JButton();
        this.patchAction = new MyAbstractActionListener("PATCH", this.patchButton, "Perform patch", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                File fromFile = new File(InstallerTester.this.patchSourceTextField.getText());
                File toFile = new File(InstallerTester.this.patchTargetTextField.getText());
                Cursor oldCursor = InstallerTester.this.getCursor();
                InstallerTester.this.setCursor(new Cursor(3));
                try {
                    InstallerTester.this.patchFile(fromFile, toFile);
                }
                catch (IOException ex) {
                    InstallerTester.this.setCursor(oldCursor);
                    throw ex;
                }
                InstallerTester.this.setCursor(oldCursor);
                String amsg = "Wrote file " + toFile.getName() + " on " + InstallerTester.this.hostTextField.getText() + "\n";
                InstallerTester.this.log(amsg);
                InstallerTester.this.dateLog(amsg, InstallerTester.this.updateLog);
            }
        };
        this.toolsLabel = new JLabel("TOOL");
        this.toolsLabel.setToolTipText("Tools directory");
        this.toolsTextField = new FixedWidthTextField("", 0, false, false, "Tools directory");
        this.perlLabel = new JLabel("PERL");
        this.toolsLabel.setToolTipText("Perl directory");
        this.perlTextField = new FixedWidthTextField("", 0, false, false, "Perl call");
        this.localToolsButton = new JButton();
        this.localToolsAction = new MyAbstractActionListener("LOCAL", this.localToolsButton, "Set local tools directory", true, false, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                InstallerTester.this.askLocalTools();
            }
        };
        this.menuBar = new JMenuBar();
        this.menu1 = new JMenu(APPNAME);
        this.newWindowAction = new MyAbstractActionListener("New InstallerTester", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                InstallerTester tst = new InstallerTester();
                tst.setSize(650, 800);
                tst.setVisible(true);
                tst.welcome();
                tst.initializeEnvironment();
            }
        };
        this.exitAction = new MyAbstractActionListener("Exit", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                InstallerTester.this.exit();
            }
        };
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.menu1);
        this.menu1.add(this.newWindowAction);
        this.menu1.add(this.exitAction);
        this.patchTargetLabel = new JLabel("PTRG");
        this.patchTargetLabel.setToolTipText("Patch target");
        this.patchTargetTextField = new FixedWidthTextField("", 0, false, false, "Patch target");
        this.packLabel = new JLabel("PACK");
        this.label = new JLabel(APPNAME);
        this.loggerPane = new JTabbedPane();
        this.sqlLog = new JTextPane();
        this.aLog = new JTextPane();
        this.trace = new JTextPane();
        this.updateLog = new JTextPane();
        this.createScriptTextPane = new JTextPane();
        this.serverToolBar = new JToolBar();
        this.serverToolBar.setFloatable(false);
        this.knownHostsComboBox = new JComboBox(KNOWN_TESTER_HOSTS){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.width = 90;
                return d;
            }

            public void setSelectedItem(Object ob) {
                super.setSelectedItem(ob);
                if (ob != null) {
                    InstallerTester.this.hostTextField.setText(ob.toString());
                }
            }
        };
        this.serverToolBar.add(this.knownHostsComboBox);
        this.knownHostsComboBox.addItemListener(new MyAbstractActionListener("Known Hosts", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
            }
        });
        this.hostTextField = new FixedWidthTextField("", 80, true, false, false, "Enter host name", this.serverToolBar);
        this.serverToolBar.addSeparator(new Dimension(5, 5));
        this.serverToolBar.add(new JLabel("Port"));
        this.serverToolBar.addSeparator(new Dimension(5, 5));
        this.rmiPortTextField = new FixedWidthTextField("", 40, false, false, false, "Port of executor server", this.serverToolBar);
        this.rmiPortTextField.setText("1099");
        this.rmiPortTextField.setEditable(false);
        this.serverToolBar.addSeparator(new Dimension(5, 5));
        this.hostAction = new MyAbstractActionListener("HOSTSELECTION", true, false, this.hostTextField, "Write hostname and press enter!", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                JTextField tf = (JTextField)e.getSource();
                String hostName = tf.getText();
                InstallerTester.this.performConnectAction(hostName);
            }
        };
        this.connectAction = new MyAbstractActionListener("CONNECT", true, false, false, this.serverToolBar, "Connect remote  server", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Cursor oldCursor = InstallerTester.this.getCursor();
                InstallerTester.this.setCursor(new Cursor(3));
                try {
                    InstallerTester.this.performConnectAction(InstallerTester.this.hostTextField.getText());
                }
                catch (Exception ex) {
                    InstallerTester.this.setCursor(oldCursor);
                    throw ex;
                }
                InstallerTester.this.setCursor(oldCursor);
            }
        };
        this.shutdownAction = new MyAbstractActionListener("DOWN", true, false, false, this.serverToolBar, "Shut down remote server", this.controlContext){

            public void myAction(ActionEvent e) throws RemoteException {
                String host = InstallerTester.this.hostTextField.getText();
                InstallerTester.this.executorServer.shutdown();
                InstallerTester.this.initLocally();
                InstallerTester.this.clearLog();
                String amsg = "Server on host '" + host + "' has been shutdown.\n";
                InstallerTester.this.log(amsg);
                InstallerTester.this.dateLog(amsg, InstallerTester.this.updateLog);
                InstallerTester.this.updateActions();
            }
        };
        this.bootAction = new MyAbstractActionListener("BOOT", true, false, false, this.serverToolBar, "Boot remote server", this.controlContext){

            public void myAction(ActionEvent e) throws SQLException, IOException {
                String sel;
                ResultSet res;
                String host = InstallerTester.this.hostTextField.getText();
                if (InstallerTester.LOCALHOST.equalsIgnoreCase(host)) {
                    InstallerTester.this.log("Cannot start server on localhost\n", "error");
                    return;
                }
                if (host == null || host.trim().equals("")) {
                    InstallerTester.this.log("You must select a host before booting the server.\n", "error");
                    return;
                }
                String chrootCommand = InstallerTester.getTestServer(host).getChroot();
                String chrid = InstallerTester.this.getChroot();
                String releasePath = "7700DEV";
                if (InstallerTester.isKnownHost(host) && (res = InstallerTester.this.executeSQL(sel = "select *   from CHR_MONITOR  where HOST = '" + host + "' AND CHRDIR='" + chrid + "'")).next()) {
                    releasePath = res.getString("VERSION") + res.getString("QASTATUS");
                }
                Configuration cfr_ignored_0 = InstallerTester.this.config;
                Executor exec = Configuration.createStartExecutorServerExecutor(host, InstallerTester.this.getLocalToolsDir(), "/devtool/TOOL/tool", "/SAP_DB/chr/" + chrid, Configuration.javaPathFromQADB(host), "/SAP_DB/" + releasePath + "/test/jtest", chrootCommand);
                exec.addExecutorListener(new BootExecutorListener());
                InstallerTester.startRemoteExecutor(exec);
            }
        };
        this.analyzeAction = new MyAbstractActionListener("ANALYZE", true, false, false, this.serverToolBar, "Analyze server", this.controlContext){

            public void myAction(ActionEvent e) throws RemoteException, ProcessInitException {
                InstallerTester.this.performInstCheck();
            }
        };
        this.chrootToolBar = new JToolBar();
        this.chrootToolBar.setFloatable(false);
        this.processToolBar = new JToolBar();
        this.processToolBar.setFloatable(false);
        this.killAction = new KillActionListener("CANCEL", this.processToolBar, "Kill current process", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                if (InstallerTester.this.cancelInProgress()) {
                    InstallerTester.this.log("Cannot cancel twice\n", "error");
                    return;
                }
                if (InstallerTester.this.hasRunningProcess()) {
                    Thread thr = new Thread(new Runnable(this){
                        private final /* synthetic */ 24 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            try {
                                InstallerTester.access$2102(24.access$2000(this.this$1), System.currentTimeMillis());
                                24.access$2000(this.this$1).updateActions();
                                24.access$2000(this.this$1).currentExecutor.destroy();
                                InstallerTester.access$2102(24.access$2000(this.this$1), -1L);
                            }
                            catch (RemoteException ex) {
                                SwingUtilities.invokeLater(new Runnable(this, ex){
                                    private final /* synthetic */ RemoteException val$ex;
                                    private final /* synthetic */ 26 this$2;
                                    {
                                        this.this$2 = this$2;
                                        this.val$ex = val$ex;
                                    }

                                    public void run() {
                                        24.access$2000(26.access$2200(this.this$2)).error(this.val$ex, "Error killing process");
                                    }
                                });
                            }
                        }

                        static /* synthetic */ 24 access$2200(26 x0) {
                            return x0.this$1;
                        }
                    });
                    thr.start();
                    thr = new Thread(new Runnable(this){
                        private final /* synthetic */ 24 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ex) {
                                return;
                            }
                            while (InstallerTester.access$1900(24.access$2000(this.this$1))) {
                                long time = System.currentTimeMillis();
                                long elapsed = (time - InstallerTester.access$2100(24.access$2000(this.this$1))) / 1000L;
                                SwingUtilities.invokeLater(new Runnable(this, elapsed){
                                    private final /* synthetic */ long val$elapsed;
                                    private final /* synthetic */ 28 this$2;
                                    {
                                        this.this$2 = this$2;
                                        this.val$elapsed = val$elapsed;
                                    }

                                    public void run() {
                                        24.access$2000(28.access$2300(this.this$2)).log("Waiting for process to die since " + this.val$elapsed + " seconds\n");
                                    }
                                });
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException ex) {
                                    break;
                                }
                            }
                        }

                        static /* synthetic */ 24 access$2300(28 x0) {
                            return x0.this$1;
                        }
                    });
                    thr.start();
                }
            }

            static /* synthetic */ InstallerTester access$2000(24 x0) {
                return x0.InstallerTester.this;
            }
        };
        this.cutAction = new MyAbstractActionListener("DISCONNECT", false, false, false, this.processToolBar, "Disconnect from process", this.controlContext){

            public void myAction(ActionEvent e) throws RemoteException {
                if (InstallerTester.this.hasRunningProcess()) {
                    InstallerTester.this.nullifyExecutor();
                    InstallerTester.this.updateActions();
                    InstallerTester.this.log("Disconnected from running process\n");
                } else {
                    InstallerTester.this.log("Not connected to a running process\n", "error");
                }
            }
        };
        this.joinAction = new MyAbstractActionListener("JOIN", true, false, false, this.processToolBar, "Join running process", this.controlContext){

            public void myAction(ActionEvent e) throws RemoteException, ProcessInitException {
                RemoteExecutor remexec = InstallerTester.this.executorServer.getCurrentExecutor();
                if (remexec != null && remexec.isRunning()) {
                    InstallerTester.this.setCurrentExecutor(remexec);
                    String shortName = InstallerTester.this.currentExecutor.getExecutor().shortName;
                    InstallerTester.this.log("Connected to running process '" + shortName + "'\n");
                    InstallerTester.this.updateActions();
                } else {
                    InstallerTester.this.log("No running process found on " + InstallerTester.this.getHostName() + "\n", "error");
                }
            }
        };
        this.chrootComboBox = new JComboBox(new Object[]{"01", "02", "03", "04", "05", "06", "07"}){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.width = 90;
                return d;
            }
        };
        this.chrootToolBar.add(this.chrootComboBox);
        this.chrootComboBox.setSelectedItem("07");
        this.xtermAction = new MyAbstractActionListener("REMUSER", false, false, false, this.chrootToolBar, "Open an xterm (remuser)", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                boolean NOT_AS_ROOT = false;
                InstallerTester.this.openXterm(NOT_AS_ROOT);
            }
        };
        this.xtermRootAction = new MyAbstractActionListener("ROOT", false, false, false, this.chrootToolBar, "Open an xterm (root)", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                boolean AS_ROOT = true;
                InstallerTester.this.openXterm(AS_ROOT);
            }
        };
        this.showTestsAction = new MyAbstractActionListener("INFO", false, false, false, this.chrootToolBar, "Show info about chroot", this.controlContext){

            public void myAction(ActionEvent e) throws SQLException {
                InstallerTester.this.chrootInfo();
            }
        };
        this.dataBaseToolBar = new JToolBar();
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar.setFloatable(false);
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar.add(new JLabel("Port"));
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.uxXServerPortTextField = new FixedWidthTextField("", 40, false, false, true, "Port of x_server", this.dataBaseToolBar);
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar.add(new JLabel("DBHOST"));
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dbHostTextField = new FixedWidthTextField("", 80, false, false, false, "host of database", this.dataBaseToolBar);
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar.add(new JLabel("DB"));
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dbNameTextField = new FixedWidthTextField("", 60, false, false, false, "Database name", this.dataBaseToolBar);
        this.dbNameTextField.setText("TESTDB");
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar.add(new JLabel("DBM"));
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dbmTextField = new FixedWidthTextField("", 40, false, false, false, "Name of database manager", this.dataBaseToolBar);
        this.dbmTextField.setText("dbm");
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dbmPasswordField = new JPasswordField("dbm"){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.width = 40;
                return d;
            }
        };
        this.dataBaseToolBar.add(new JLabel("Passw"));
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dbmPasswordField.setColumns(8);
        this.dbmPasswordField.setToolTipText("Password of database manager");
        this.dataBaseToolBar.add(this.dbmPasswordField);
        this.dataBaseToolBar.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar2 = new JToolBar();
        this.dataBaseToolBar2.setFloatable(false);
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar2.add(new JLabel("DBA"));
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.dbaTextField = new FixedWidthTextField("", 40, false, false, false, "Name of database administrator", this.dataBaseToolBar2);
        this.dbaTextField.setText("dba");
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar2.add(new JLabel("Passw"));
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.dbaPasswordField = new JPasswordField("dba"){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.width = 40;
                return d;
            }
        };
        this.dbaPasswordField.setColumns(8);
        this.dbaPasswordField.setToolTipText("Password of database administrator");
        this.dataBaseToolBar2.add(this.dbaPasswordField);
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.dataBaseToolBar2.add(new JLabel("OS-User"));
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.osUserTextField = new FixedWidthTextField("", 80, false, false, false, "Name of operating system user", this.dataBaseToolBar2);
        this.osUserTextField.setText("remuser");
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.osUserPasswordField = new JPasswordField("Remuser"){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.width = 80;
                return d;
            }
        };
        this.dataBaseToolBar2.add(new JLabel("Passw"));
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.osUserPasswordField.setColumns(8);
        this.osUserPasswordField.setToolTipText("Password of database manager");
        this.dataBaseToolBar2.add(this.osUserPasswordField);
        this.dataBaseToolBar2.addSeparator(new Dimension(5, 5));
        this.filesToolBar = new JToolBar();
        this.installationToolBar = new JToolBar();
        this.upgradeToolBar = new JToolBar();
        this.templateTestToolBar = new JToolBar();
        this.label.setBorder(new BevelBorder(1));
        this.depLabel.setToolTipText("Dependend software directory");
        this.depPathTextField.setToolTipText("Dependend software directory");
        this.indepDataLabel.setToolTipText("Independend data directory");
        this.indepDataPathTextField.setToolTipText("Independend data directory");
        this.indepProgLabel.setToolTipText("Independend programs directory");
        this.indepProgPathTextField.setToolTipText("Independend programs directory");
        this.packLabel.setToolTipText("Package directory");
        this.packTextField.setToolTipText("Package directory");
        this.filesToolBar.setFloatable(false);
        this.installationToolBar.setFloatable(false);
        this.upgradeToolBar.setFloatable(false);
        this.templateTestToolBar.setFloatable(false);
        this.knownHostsComboBox.setSelectedItem(LOCALHOSTTESTER);
        this.upgradeTestAction = new MyAbstractActionListener("SINGLE", true, true, false, this.upgradeToolBar, "Test this upgrade", this.controlContext){

            public void myAction(ActionEvent e) throws RemoteException, ProcessInitException, IOException {
                Configuration.SoftwareDescription target;
                Configuration.SoftwareDescription origin = InstallerTester.this.createSoftwareDescription(InstallerTester.this.upgradeOriginSelector);
                origin.target = target = InstallerTester.this.createSoftwareDescription(InstallerTester.this.upgradeTargetSelector);
                Executor exec = InstallerTester.this.config.createUpdateTestExecutor(origin, InstallerTester.this.getPerl());
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.filesOnHost = new FileItem[]{new FileItem("/etc/opt/sdb", "/etc/opt/sdb", false), new FileItem("SAP_DBTech.ini", "/usr/spool/sql/ini/SAP_DBTech.ini", false)};
        this.filesComboBox = new JComboBox(this.filesOnHost){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.width = 130;
                return d;
            }
        };
        this.filesToolBar.add(this.filesComboBox);
        this.filesTextField = new FixedWidthTextField("", 200, false, false, false, "Enter file name", this.filesToolBar);
        this.filesComboBox.addItemListener(new MyAbstractActionListener("Known Hosts", true, false, this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                JComboBox bx = (JComboBox)e.getSource();
                FileItem fi = (FileItem)bx.getSelectedItem();
                if (fi != null) {
                    InstallerTester.this.filesTextField.setText(fi.file);
                } else {
                    InstallerTester.this.filesTextField.setText("");
                }
            }
        });
        FileItem fi = (FileItem)this.filesComboBox.getSelectedItem();
        this.filesTextField.setText(fi.file);
        this.filesTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                JTextField tf = (JTextField)e.getSource();
                tf.selectAll();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.showFileAction = new MyAbstractActionListener("SHOW", false, false, false, this.filesToolBar, "Show file", this.controlContext){

            public void myAction(ActionEvent e) throws IOException {
                String fileName = InstallerTester.this.filesTextField.getText().trim();
                boolean isDir = false;
                FileItem f = (FileItem)InstallerTester.this.filesComboBox.getSelectedItem();
                SerializableFileFilter ff = DEFAULTFILEFILTER;
                if (f != null && f.file.equals(fileName)) {
                    isDir = f.isDir;
                    ff = f.fileFilter;
                }
                InstallerTester.this.showFile(fileName, isDir, ff);
            }
        };
        this.existsAction = new MyAbstractActionListener("EXISTS", false, false, false, this.filesToolBar, "CheckExistence ", this.controlContext){

            public void myAction(ActionEvent e) throws IOException {
                String fileName = InstallerTester.this.filesTextField.getText().trim();
                String host = InstallerTester.this.getHostName();
                host = host != null && !"".equals(host) ? " on " + host + " " : "";
                InstallerTester.this.log("File '" + fileName + "'");
                if (InstallerTester.this.executorServer.exists(new File(fileName))) {
                    InstallerTester.this.log(" exists " + host + "\n", "status");
                } else {
                    InstallerTester.this.log(" does not exist " + host + "\n", "error");
                }
            }
        };
        this.knownDirs = new String[]{WRK, UPGRTSTS, PROTS, TEMPLATEPROTS};
        this.dirsComboBox = new JComboBox(this.knownDirs){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.width = 70;
                return d;
            }
        };
        this.filesToolBar.addSeparator(new Dimension(20, 20));
        this.filesToolBar.add(this.dirsComboBox);
        this.listDirsAction = new MyAbstractActionListener("LIST", false, false, false, this.filesToolBar, "List directory contents", this.controlContext){

            public void myAction(ActionEvent e) throws IOException {
                Object selectedItem = InstallerTester.this.dirsComboBox.getSelectedItem();
                Properties props = InstallerTester.this.executorServer.getSystemProperties();
                if (InstallerTester.WRK.equals(selectedItem)) {
                    this.listWorkDir(props);
                } else if (InstallerTester.UPGRTSTS.equals(selectedItem)) {
                    this.listUpgradeTests(props);
                } else if (InstallerTester.PROTS.equals(selectedItem)) {
                    this.listProtocols(props);
                } else if (InstallerTester.TEMPLATEPROTS.equals(selectedItem)) {
                    this.showTemplateTest(props);
                }
            }

            private void showTemplateTest(Properties props) throws RemoteException, IOException {
                File f = new File(props.getProperty("jtest.root"), "tests/output/upgradetest/TemplateTest/templatetest.log");
                InstallerTester.this.showFile(f.toString(), f, false, null);
            }

            private void listUpgradeTests(Properties props) throws RemoteException, IOException {
                String name;
                File f = new File(props.getProperty("jtest.root"), "tests/output/upgradetest/UpgradeTest");
                File[] fileList = InstallerTester.this.executorServer.listFiles(null, f);
                if (fileList == null) {
                    InstallerTester.this.errorMessage("No files found!\n");
                    return;
                }
                JComboBox<String> bx = new JComboBox<String>();
                for (int i = 0; i < fileList.length; ++i) {
                    name = fileList[i].getName();
                    if (!name.startsWith("UpgradeTest_at")) continue;
                    bx.addItem(name);
                }
                if (bx.getItemCount() > 0) {
                    int retVal = JOptionPane.showOptionDialog(InstallerTester.this, bx, "Test selection", 2, 3, null, null, null);
                    if (retVal == 0) {
                        name = bx.getSelectedItem().toString();
                        File prot = new File(f, name + "/" + name + ".log");
                        InstallerTester.this.clearLog();
                        InstallerTester.this.showFile(prot.toString(), prot, false, null);
                    }
                } else {
                    InstallerTester.this.errorMessage("No running tests found!");
                }
            }

            private void listProtocols(Properties props) throws RemoteException, IOException {
                String name;
                File f = new File(props.getProperty("jtest.root"), "protocols");
                File[] fileList = InstallerTester.this.executorServer.listFiles(null, f);
                if (fileList == null) {
                    InstallerTester.this.errorMessage("No files found!\n");
                    return;
                }
                JComboBox<String> bx = new JComboBox<String>();
                for (int i = 0; i < fileList.length; ++i) {
                    name = fileList[i].getName();
                    if (!name.endsWith(".prt")) continue;
                    bx.addItem(name);
                }
                if (bx.getItemCount() > 0) {
                    int retVal = JOptionPane.showOptionDialog(InstallerTester.this, bx, "Protocol selection", 2, 3, null, null, null);
                    if (retVal == 0) {
                        name = bx.getSelectedItem().toString();
                        File prot = new File(f, name);
                        InstallerTester.this.clearLog();
                        InstallerTester.this.showFile(prot.toString(), prot, false, null);
                    }
                } else {
                    InstallerTester.this.errorMessage("No protocolls found!");
                }
            }

            private void listWorkDir(Properties props) throws RemoteException {
                File f = new File(InstallerTester.this.indepDataDir() + "/wrk");
                this.displayDir(f, props);
            }

            private void displayDir(File f, Properties props) throws RemoteException {
                File[] fileList = InstallerTester.this.executorServer.listFiles(null, f);
                boolean isWindows = Configuration.isWindows(props);
                if (fileList != null) {
                    InstallerTester.this.clearLog();
                    String fn = f.toString();
                    if (!isWindows) {
                        fn = fn.replace('\\', '/');
                    }
                    InstallerTester.this.log("Contents of " + fn + ":\n", "path");
                    for (int i = 0; i < fileList.length; ++i) {
                        File af = fileList[i];
                        String afs = af.toString();
                        if (!isWindows) {
                            afs = afs.replace('\\', '/');
                        }
                        InstallerTester.this.log(afs + "\n");
                    }
                } else {
                    InstallerTester.this.log("Directory " + f + " not found!\n", "error");
                }
            }
        };
        this.uxPortAction = new MyAbstractActionListener("XServer Port", true, false, true, this.uxXServerPortTextField, "Write X-Server port and press enter!", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                JTextField tf = (JTextField)e.getSource();
                String port = tf.getText();
                Integer.parseInt(port);
                InstallerTester.this.config.setXServerPortUx(port);
                String msg = "Have set X-Server port to " + port + "\n";
                InstallerTester.this.log(msg);
                InstallerTester.this.dateLog(msg, InstallerTester.this.updateLog);
            }
        };
        this.packdistribAction = new MyAbstractActionListener("DSTR", true, true, this.installationToolBar, "Call packdistrib", this.controlContext){
            static final long serialVersionUID = -6714127555195969554L;

            public void myAction(ActionEvent e) throws Exception {
                File packageDir = InstallerTester.this.packageDir();
                Executor exec = InstallerTester.this.packdistrib(packageDir);
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.unpackdistribAction = new MyAbstractActionListener("-DSTR", true, true, this.installationToolBar, "Remove package directory", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                File packageDir = InstallerTester.this.packageDir();
                String fileName = InstallerTester.this.executorServer.canonicalPath(packageDir);
                if (InstallerTester.this.executorServer.recursiveDelete(packageDir)) {
                    InstallerTester.this.log("Deleted " + fileName + "\n");
                } else {
                    InstallerTester.this.errorMessage("NOT deleted " + fileName + "\n");
                }
            }
        };
        this.sdbinstAction = new MyAbstractActionListener("SDB ", true, true, this.installationToolBar, "Install software", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                File packageDir = InstallerTester.this.packageDir();
                Executor exec = InstallerTester.this.sdbinst(packageDir);
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.sdbuninstAction = new MyAbstractActionListener("-SDB ", true, false, this.installationToolBar, "Unnstall software", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Executor exec = InstallerTester.this.config.createSDBUNINSTExecutor(InstallerTester.this.indepProgDir());
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.startXServerAction = new MyAbstractActionListener("XSRV", true, true, this.installationToolBar, "Start XServer", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Executor exec = InstallerTester.this.config.createStartXServerExecutor(InstallerTester.this.createSoftwareDescription(InstallerTester.this.installationSelector));
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.stopXServerAction = new MyAbstractActionListener("-XSRV", true, false, this.installationToolBar, "Stop XServer", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Executor exec = InstallerTester.this.config.createStopXServerExecutor(InstallerTester.this.indepProgDir(), InstallerTester.this.installationSelector.getPlatform());
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.crDBAction = new MyAbstractActionListener("DB  ", true, true, this.installationToolBar, "Create instance", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                InstallerTester.this.createInstance();
            }
        };
        this.delDBAction = new MyAbstractActionListener("-DB ", true, true, this.installationToolBar, "Drop instance", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                InstallerTester.this.dropInstance();
            }
        };
        this.backupDBAction = new MyAbstractActionListener("BCK ", true, true, this.installationToolBar, "Backup the database", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Executor exec = InstallerTester.this.config.createScriptExecutor("backup", InstallerTester.this.installationSelector.getNormalizedVersion(), InstallerTester.this.installationSelector.getPlatform(), InstallerTester.this.getDBMProperties());
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.fakeLCBackupAction = new MyAbstractActionListener("FBCK", true, true, this.installationToolBar, "Fake __$__LCFLAG in database", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Executor exec = InstallerTester.this.config.createScriptExecutor("fake_lcbackup", InstallerTester.this.installationSelector.getNormalizedVersion(), InstallerTester.this.installationSelector.getPlatform(), InstallerTester.this.getDBMProperties());
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.sdbupdAction = new MyAbstractActionListener("UPD ", true, true, this.installationToolBar, "Call SDBUPD", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Executor exec = InstallerTester.this.config.createUpdateExecutor(InstallerTester.this.packageDir(), InstallerTester.this.installationSelector.getNormalizedVersion());
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.fclrAction = new MyAbstractActionListener("FCLR", true, true, false, this.installationToolBar, "Force Clear Installation Rubble", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                InstallerTester.this.startCurrentExecutor(InstallerTester.this.config.createCleanerExecutor(InstallerTester.this.createSoftwareDescription(InstallerTester.this.installationSelector), true));
            }
        };
        this.clrAction = new MyAbstractActionListener("CLR", true, true, false, this.installationToolBar, "Clear Installation Rubble", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                InstallerTester.this.startCurrentExecutor(InstallerTester.this.config.createCleanerExecutor(InstallerTester.this.createSoftwareDescription(InstallerTester.this.installationSelector), false));
            }
        };
        this.upgradeSequenceComboBox = new MyComboBox("Select UpgradeSequence", true, true, false, new Object[]{ALL, ALL_NO_P, ALL_MAX_APO, ALL_NO_P_MAX_APO, MIN, MIN_NO_P}, this.upgradeToolBar, this.controlContext);
        this.viewUpgradeSequenceAction = new MyAbstractActionListener("VUPGR", true, true, false, this.upgradeToolBar, "View selected upgrade sequence", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                String sequence = InstallerTester.this.upgradeSequenceComboBox.getSelectedItem().toString();
                Configuration.SoftwareDescription middleRelease = InstallerTester.this.createSoftwareDescription(InstallerTester.this.installationSelector);
                boolean includePatches = InstallerTester.ALL.equals(sequence) || InstallerTester.MIN.equals(sequence);
                boolean maxApo = InstallerTester.ALL_MAX_APO.equals(sequence) || InstallerTester.ALL_NO_P_MAX_APO.equals(sequence);
                Configuration.SoftwareDescription[] sws = InstallerTester.ALL.equals(sequence) || InstallerTester.ALL_MAX_APO.equals(sequence) || InstallerTester.ALL_NO_P.equals(sequence) || InstallerTester.ALL_NO_P_MAX_APO.equals(sequence) ? InstallerTester.this.config.upgradePaths(middleRelease, includePatches, maxApo) : InstallerTester.this.config.upgradePathsMaximalBuild(middleRelease, includePatches);
                InstallerTester.this.clearLog();
                InstallerTester.this.log("Found " + sws.length + " upgrades\n");
                for (int i = 0; i < sws.length; ++i) {
                    Configuration.SoftwareDescription as = sws[i];
                    InstallerTester.this.log(i + 1 + ".) ");
                    InstallerTester.this.log(as.upgradeString());
                    if (!as.isUpgradeEqualPlatform()) {
                        InstallerTester.this.log(" (" + as.platforms() + ") ");
                    }
                    InstallerTester.this.log("\n");
                }
                InstallerTester.this.aLog.setCaretPosition(0);
            }
        };
        this.upgradeSequenceAction = new MyAbstractActionListener("UPGR", true, true, false, this.upgradeToolBar, "Run selected upgradeSequencel", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Configuration.SoftwareDescription middleRelease = InstallerTester.this.createSoftwareDescription(InstallerTester.this.installationSelector);
                String sequence = InstallerTester.this.upgradeSequenceComboBox.getSelectedItem().toString();
                boolean includePatches = InstallerTester.ALL.equals(sequence) || InstallerTester.MIN.equals(sequence);
                boolean maxApo = InstallerTester.ALL_MAX_APO.equals(sequence) || InstallerTester.ALL_NO_P_MAX_APO.equals(sequence);
                Executor exec = InstallerTester.ALL.equals(sequence) || InstallerTester.ALL_MAX_APO.equals(sequence) || InstallerTester.ALL_NO_P.equals(sequence) || InstallerTester.ALL_NO_P_MAX_APO.equals(sequence) ? InstallerTester.this.config.createUpdateTestSequenceExecutor(middleRelease, includePatches, maxApo, InstallerTester.this.getPerl()) : InstallerTester.this.config.createUpdateTestSequenceExecutorMaximalBuild(middleRelease, includePatches, InstallerTester.this.getPerl());
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.upgradesAction = new MyAbstractActionListener("MTR", true, true, this.upgradeToolBar, "Show upgrade matrix", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                InstallerTester.this.config.createAutoConfig(InstallerTester.this.installationSelector.getMakeKey(), false);
                InstallerTester.this.clearLog(InstallerTester.this.aLog);
                int testCount = InstallerTester.this.config.getTestCount();
                InstallerTester.this.log("UPGRADE TEST MATRIX (" + testCount + " upgrades):\n\n", null, InstallerTester.this.aLog);
                for (int i = testCount - 1; i >= 0; --i) {
                    InstallerTester.this.log(InstallerTester.this.config.getUpgradeTestConfiguration(i).toString() + "\n", null, InstallerTester.this.aLog);
                }
                InstallerTester.this.aLog.setCaretPosition(0);
            }
        };
        this.knownTemplatesComboBox = new MyComboBox("Select your template", Configuration.KNOWN_TEMPLATES, this.templateTestToolBar, 0.0f, this.controlContext){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.width = 90;
                return d;
            }
        };
        this.templatesAction = new MyAbstractActionListener("TPL", this.templateTestToolBar, "Template installation", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Configuration.Template tmpl = (Configuration.Template)InstallerTester.this.knownTemplatesComboBox.getSelectedItem();
                Executor exec = InstallerTester.this.config.createTemplateExecutor(InstallerTester.this.packageDir(), InstallerTester.this.depDir(), InstallerTester.this.indepProgDir(), InstallerTester.this.indepDataDir(), tmpl);
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        this.templateTestAction = new MyAbstractActionListener("TPLST", this.templateTestToolBar, "Start Template tests", this.controlContext){

            public void myAction(ActionEvent e) throws Exception {
                Executor exec = InstallerTester.this.config.createTemplateTestExecutor(InstallerTester.this.createSoftwareDescription(InstallerTester.this.installationSelector), InstallerTester.this.getPerl());
                InstallerTester.this.startCurrentExecutor(exec);
            }
        };
        ++instanceCounter;
        this.initGui();
    }

    void dateLog(String s, String style, JTextPane textPane) {
        this.log("[" + new Date() + "] " + s, style, textPane);
    }

    void log(String s, String style, JTextPane textPane) {
        StyledDocument doc = textPane.getStyledDocument();
        if (style == null) {
            style = "default";
        }
        String mystyle = style;
        try {
            doc.insertString(doc.getLength(), s, doc.getStyle(mystyle));
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    ResultSet executeSQL(String s) throws SQLException {
        return this.controlContext.executeSQL(s);
    }

    private Component textLogs() {
        this.addTextPane(this.loggerPane, this.aLog, "Messages");
        this.addTextPane(this.loggerPane, this.sqlLog, "Sql");
        this.addTextPane(this.loggerPane, this.trace, "Trace");
        this.addTextPane(this.loggerPane, this.updateLog, "Log");
        return this.loggerPane;
    }

    private void addTextPane(JTabbedPane tabbedPane, JTextPane at, String text) {
        at.setEditable(false);
        this.initStyles(at.getStyledDocument());
        tabbedPane.add(text, new JScrollPane(at));
    }

    private void exit() {
        this.dispose();
        if (--instanceCounter == 0) {
            InstallerTester.destroyRemoteExecutors();
            System.exit(0);
        }
    }

    private static Vector fillVector(ResultSet res) throws SQLException {
        Vector<Object> v = new Vector<Object>();
        while (res.next()) {
            v.add(res.getObject(1));
        }
        return v;
    }

    private static void updateComboBox(Vector v, MyComboBox bx) {
        bx.setSelectedItem(null);
        bx.removeAllItems();
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            bx.addItem(iter.next());
        }
        if (v.isEmpty()) {
            bx.setSelectedItem(null);
        }
    }

    void error(Throwable exc, String msg) {
        this.error(exc, this.trace, msg);
    }

    void error(Throwable exc, JTextPane pane, String msg) {
        this.errorMessage(msg);
        this.dateLog("\n", pane);
        this.log(exc.getClass() + ": " + exc.getMessage() + ":\n", "error", pane);
        StringWriter sw = new StringWriter();
        exc.printStackTrace(new PrintWriter(sw));
        this.log(sw.toString(), null, pane);
    }

    String errorMessage(String s) {
        this.log(s, "error", this.aLog);
        return s;
    }

    String statusBar(String s) {
        this.label.setForeground(Color.black);
        this.label.setText(s);
        return s;
    }

    public static void db(Object ob) {
        System.out.println(ob);
    }

    private void initStyles(StyledDocument s) {
        this.initDefaultCharacterStyles(s);
        this.initDefaultParagraphStyles(s);
    }

    private void initDefaultCharacterStyles(StyledDocument s) {
        Style SQL = s.addStyle("sql-query", null);
        StyleConstants.setBold(SQL, true);
        Style CONSOLE = s.addStyle("console", null);
        StyleConstants.setFontFamily(CONSOLE, "Monospaced");
        StyleConstants.setFontSize(CONSOLE, 9);
        Style LOG = s.addStyle("log", null);
        StyleConstants.setForeground(LOG, new Color(Integer.parseInt("0000CC", 16)));
        StyleConstants.setFontSize(LOG, 13);
        Style PATH = s.addStyle("path", null);
        StyleConstants.setFontFamily(PATH, "Monospaced");
        StyleConstants.setItalic(PATH, true);
        StyleConstants.setForeground(PATH, Color.blue);
        Style HELP = s.addStyle("help", null);
        StyleConstants.setForeground(HELP, new Color(Integer.parseInt("339900", 16)));
        Style ERROR = s.addStyle("error", null);
        StyleConstants.setForeground(ERROR, Color.red);
        Style STATUS = s.addStyle("status", null);
        StyleConstants.setForeground(STATUS, Color.green);
    }

    private void initDefaultParagraphStyles(StyledDocument s) {
        Style def = s.getStyle("default");
        StyleConstants.setFontFamily(def, "Monospaced");
        Style S = s.addStyle("par", def);
        StyleConstants.setFontFamily(S, "Helvetica");
        StyleConstants.setFontSize(S, 10);
        StyleConstants.setSpaceAbove(S, 1.0f);
        StyleConstants.setSpaceBelow(S, 1.0f);
        Style XML = s.addStyle("xml", def);
        StyleConstants.setFontSize(XML, 12);
        StyleConstants.setBold(XML, true);
        StyleConstants.setSpaceAbove(XML, 1.0f);
        StyleConstants.setSpaceBelow(XML, 1.0f);
        Style H1 = s.addStyle("h1", def);
        StyleConstants.setFontFamily(H1, "Helvetica");
        StyleConstants.setBold(H1, true);
        StyleConstants.setSpaceAbove(H1, 10.0f);
        StyleConstants.setSpaceBelow(H1, 10.0f);
        StyleConstants.setFontSize(H1, 24);
        StyleConstants.setForeground(H1, Color.black);
        StyleConstants.setBackground(H1, Color.yellow);
        Style H2 = s.addStyle("h2", def);
        StyleConstants.setFontFamily(H2, "Helvetica");
        StyleConstants.setBold(H2, true);
        StyleConstants.setSpaceAbove(H2, 10.0f);
        StyleConstants.setSpaceBelow(H2, 10.0f);
        StyleConstants.setFontSize(H2, 18);
        Style H3 = s.addStyle("h3", def);
        StyleConstants.setFontFamily(H3, "Helvetica");
        StyleConstants.setItalic(H3, true);
        StyleConstants.setSpaceAbove(H3, 5.0f);
        StyleConstants.setSpaceBelow(H3, 5.0f);
        StyleConstants.setFontSize(H3, 14);
        Style H4 = s.addStyle("h4", def);
        StyleConstants.setFontFamily(H4, "Helvetica");
        StyleConstants.setItalic(H4, true);
        StyleConstants.setSpaceAbove(H4, 5.0f);
        StyleConstants.setSpaceBelow(H4, 5.0f);
        StyleConstants.setFontSize(H4, 12);
    }

    void welcome() {
        String welcome = "Welcome to the installation tester utility written by Alexander Weinmann.\nThis utility can help you to test upgrades and installations of the MaxDB.\nIn the area above select APO and MaxDB release.\n\n";
        this.log(welcome, "help", this.aLog);
    }

    void initializeEnvironment() throws IOException, ConfigurationException, ParserConfigurationException, SAXException, ProcessInitException {
        String tools = InstallerTester.readUserConfig(System.getProperties()).getProperty("env.tool");
        if (tools == null) {
            JOptionPane.showMessageDialog(this, "Local tools directory not found!\nSelect tools now ...", "Tools not found!", 0);
            boolean gotem = this.askLocalTools();
            if (!gotem) {
                this.errorMessage("Tools not found\n");
            }
        } else {
            this.log("LOCAL TOOLS DIRECTORY: ", this.updateLog);
            this.log(tools + "\n", "path", this.updateLog);
        }
        String test = System.getProperty("jtest.root");
        if (test != null) {
            this.log("TEST DIRECTORY:  ", this.updateLog);
            this.log(test + "\n", "path", this.updateLog);
            File props = new File(test, "tests/parameters/UpgradeTest.par");
            File dataInputPath = new File(test, "tests/input/upgradetest/UpgradeTest");
            File upgradeTestJarFile = new File(test, "tests/upgradetest.jar");
            upgradeTestJarFile = upgradeTestJarFile.exists() ? upgradeTestJarFile : new File(test);
            this.patchSourceTextField.setText(upgradeTestJarFile.getCanonicalPath());
        }
        InputStream configStream = ClassLoader.getSystemResourceAsStream("upgradetest.xml");
        if (configStream == null) {
            InstallerTester.db("Sorry: Configuration not found (internal error),  exiting.");
            return;
        }
        this.config = new Configuration(new Properties(), configStream);
        URL configURL = ClassLoader.getSystemResource("upgradetest.xml");
        this.log("CONFIGURATION:   ", this.updateLog);
        this.log(configURL + "\n\n", "path", this.updateLog);
        this.uxXServerPortTextField.setText(this.config.getXServerPortUx());
        ExecutorServerImpl server = new ExecutorServerImpl();
        this.setExecutorServer(server);
        Configuration.addSQLListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                InstallerTester.this.log(e.getPropertyName() + "\n\n", "sql-query", InstallerTester.this.sqlLog);
            }
        });
        this.performInstCheck();
    }

    private Component serverPanel() {
        JPanel serverPanel = new JPanel();
        serverPanel.setLayout(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.gridy = 1;
        cs.gridx = 1;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(5, 5, 0, 0);
        this.serverToolBar.setBorder(new TitledBorder("Host"));
        serverPanel.add((Component)this.serverToolBar, cs);
        cs.gridy = 2;
        cs.gridx = 1;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(5, 5, 0, 0);
        this.chrootToolBar.setBorder(new TitledBorder("ChangeRoot"));
        serverPanel.add((Component)this.chrootToolBar, cs);
        cs.gridy = 3;
        cs.gridx = 1;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(5, 5, 0, 0);
        this.processToolBar.setBorder(new TitledBorder("Process"));
        serverPanel.add((Component)this.processToolBar, cs);
        cs.gridy = 4;
        cs.gridx = 1;
        cs.weightx = 1.0;
        cs.weighty = 1.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 5, 0, 0);
        this.filesToolBar.setBorder(new TitledBorder("Files"));
        serverPanel.add((Component)this.filesToolBar, cs);
        return serverPanel;
    }

    private Component testsPanel() {
        JPanel testsPanel = new JPanel();
        testsPanel.setLayout(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.gridy = 1;
        cs.gridx = 1;
        cs.weightx = 1.0;
        cs.weighty = 1.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(5, 5, 0, 0);
        this.templateTestToolBar.setBorder(new TitledBorder("Template Tests"));
        testsPanel.add((Component)this.templateTestToolBar, cs);
        return testsPanel;
    }

    private Component upgradePanel() {
        JPanel upgradePanel = new JPanel();
        upgradePanel.setLayout(new GridBagLayout());
        upgradePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints cs = new GridBagConstraints();
        cs.gridy = 1;
        cs.gridx = 1;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Start", this.upgradeOriginSelector);
        tabbedPane.addTab("Target", this.upgradeTargetSelector);
        upgradePanel.add((Component)tabbedPane, cs);
        cs.gridy = 2;
        cs.gridx = 1;
        cs.weightx = 1.0;
        cs.weighty = 1.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        upgradePanel.add((Component)this.upgradeToolBar, cs);
        return upgradePanel;
    }

    private Component installationPanel() {
        JPanel installationPanel = new JPanel();
        installationPanel.setLayout(new GridBagLayout());
        installationPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Release", this.installationSelector);
        JPanel databasePanel = new JPanel();
        databasePanel.setLayout(new GridBagLayout());
        GridBagConstraints cs2 = new GridBagConstraints();
        cs2.gridy = 1;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 18;
        cs2.fill = 2;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        databasePanel.add((Component)this.dataBaseToolBar, cs2);
        cs2.gridy = 2;
        cs2.gridx = 1;
        cs2.weightx = 1.0;
        cs2.weighty = 1.0;
        cs2.anchor = 18;
        cs2.fill = 2;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        databasePanel.add((Component)this.dataBaseToolBar2, cs2);
        tabbedPane.addTab("Database", databasePanel);
        tabbedPane.addTab("DB Script", new JScrollPane(this.createScriptTextPane));
        tabbedPane.addTab("Paths", this.pathPanel());
        GridBagConstraints cs = new GridBagConstraints();
        cs.gridy = 1;
        cs.gridx = 1;
        cs.weightx = 0.0;
        cs.weighty = 1.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        installationPanel.add((Component)tabbedPane, cs);
        cs.gridy = 2;
        cs.gridx = 1;
        cs.weightx = 1.0;
        cs.weighty = 0.0;
        cs.anchor = 18;
        cs.fill = 2;
        cs.gridwidth = 1;
        cs.insets = new Insets(0, 0, 0, 0);
        installationPanel.add((Component)this.installationToolBar, cs);
        return installationPanel;
    }

    public void initGui() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Connection", this.serverPanel());
        tabbedPane.addTab("Installation", this.installationPanel());
        tabbedPane.addTab("Upgrade-Tests", this.upgradePanel());
        tabbedPane.addTab("Other Tests", this.testsPanel());
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.gridy = 1;
        cs.gridx = 1;
        cs.weightx = 1.0;
        cs.weighty = 0.0;
        cs.anchor = 17;
        cs.fill = 2;
        cs.gridwidth = 0;
        cs.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)tabbedPane, cs);
        cs.gridy = 2;
        cs.gridx = 1;
        cs.weightx = 0.0;
        cs.weighty = 1.0;
        cs.anchor = 18;
        cs.fill = 1;
        cs.gridwidth = 0;
        cs.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add(this.textLogs(), cs);
        cs.gridy = 3;
        cs.gridx = 1;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.anchor = 16;
        cs.fill = 2;
        cs.gridwidth = 0;
        cs.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.label, cs);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                int result;
                Exception anex = null;
                try {
                    if (InstallerTester.this.hasRunningProcess() && (result = JOptionPane.showConfirmDialog(InstallerTester.this, "Process running, really exit?", "Running process", 0)) != 0) {
                        InstallerTester.this.log("Exit cancelled\n");
                        return;
                    }
                    InstallerTester.this.nullifyExecutor();
                    InstallerTester.this.setExecutorServer(null);
                }
                catch (Exception ex) {
                    anex = ex;
                    InstallerTester.this.error(ex, "Error closing window\n");
                }
                if (anex != null) {
                    result = JOptionPane.showConfirmDialog(InstallerTester.this, "Could not clean up (" + anex.getMessage() + ").\n Really exit?", "Cleaning error", 0);
                    if (result == 0) {
                        InstallerTester.this.exit();
                    } else {
                        InstallerTester.this.log("Exit cancelled\n");
                    }
                } else {
                    InstallerTester.this.exit();
                }
            }
        });
        try {
            this.updateActions();
        }
        catch (RemoteException ex) {
            this.error(ex, "Error in initialization phase\n");
        }
    }

    private Component pathPanel() {
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new GridBagLayout());
        pathPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints cs2 = new GridBagConstraints();
        cs2.gridy = 1;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.depLabel, cs2);
        cs2.gridy = 1;
        cs2.gridx = 2;
        cs2.weightx = 1.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 2;
        cs2.gridwidth = 0;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.depPathTextField, cs2);
        cs2.gridy = 2;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.indepProgLabel, cs2);
        cs2.gridy = 2;
        cs2.gridx = 2;
        cs2.weightx = 1.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 2;
        cs2.gridwidth = 0;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.indepProgPathTextField, cs2);
        cs2.gridy = 3;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.indepDataLabel, cs2);
        cs2.gridy = 3;
        cs2.gridx = 2;
        cs2.weightx = 1.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 2;
        cs2.gridwidth = 0;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.indepDataPathTextField, cs2);
        cs2.gridy = 4;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.packLabel, cs2);
        cs2.gridy = 4;
        cs2.gridx = 2;
        cs2.weightx = 1.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 2;
        cs2.gridwidth = 0;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.packTextField, cs2);
        cs2.gridy = 5;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.patchSourceLabel, cs2);
        cs2.gridy = 5;
        cs2.gridx = 2;
        cs2.weightx = 1.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 2;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.patchSourceTextField, cs2);
        cs2.gridy = 5;
        cs2.gridx = 3;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.selectPatchSourceButton, cs2);
        cs2.gridy = 5;
        cs2.gridx = 4;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 0;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.patchButton, cs2);
        cs2.gridy = 6;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.patchTargetLabel, cs2);
        cs2.gridy = 6;
        cs2.gridx = 2;
        cs2.weightx = 1.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 2;
        cs2.gridwidth = 0;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.patchTargetTextField, cs2);
        cs2.gridy = 7;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.toolsLabel, cs2);
        cs2.gridy = 7;
        cs2.gridx = 2;
        cs2.weightx = 1.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 2;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.toolsTextField, cs2);
        cs2.gridy = 7;
        cs2.gridx = 3;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 0;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.localToolsButton, cs2);
        cs2.gridy = 8;
        cs2.gridx = 1;
        cs2.weightx = 0.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 0;
        cs2.gridwidth = 1;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.perlLabel, cs2);
        cs2.gridy = 8;
        cs2.gridx = 2;
        cs2.weightx = 1.0;
        cs2.weighty = 0.0;
        cs2.anchor = 17;
        cs2.fill = 2;
        cs2.gridwidth = 0;
        cs2.insets = new Insets(0, 0, 0, 0);
        pathPanel.add((Component)this.perlTextField, cs2);
        return pathPanel;
    }

    public static void main(String[] args) throws Exception {
        Logger.USE_STDOUT = false;
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        InstallerTester tst = new InstallerTester();
        tst.setSize(650, 800);
        tst.setVisible(true);
        tst.welcome();
        tst.initializeEnvironment();
    }

    void dropInstance() throws ProcessInitException, IOException {
        Executor exe = this.config.createDBDropExecutor(this.installationSelector.getNormalizedVersion(), this.installationSelector.getPlatform(), this.getDBMProperties());
        this.startCurrentExecutor(exe);
    }

    void createInstance() throws ProcessInitException, IOException {
        Executor exe = this.config.createDBCreateExecutor(this.createSoftwareDescription(this.installationSelector), this.getInstanceType(), this.getCreateScript(), this.getDBMProperties());
        this.startCurrentExecutor(exe);
    }

    boolean hasRunningProcess() throws RemoteException {
        return this.currentExecutor != null && this.currentExecutor.isRunning();
    }

    void updateActions() throws RemoteException {
        Iterator iter = this.controlContext.canEnablesIterator();
        boolean hasVersion = this.installationSelector.getVersion() != null;
        boolean hasUpgradeVersions = this.upgradeTargetSelector.getVersion() != null && this.upgradeOriginSelector.getVersion() != null;
        boolean isRunning = this.hasRunningProcess();
        boolean isCanceling = this.cancelInProgress();
        this.packdistribAction.setEnabled(Configuration.isGoodLCPoolId(this.installationSelector.getLCPool()));
        this.installationSelector.lcPoolLabel.setEnabled(!isRunning);
        this.installationSelector.changeListLabel.setEnabled(!isRunning);
        this.installationSelector.lcaPoolLabel.setEnabled(!isRunning);
        this.installationSelector.lcaVariantLabel.setEnabled(!isRunning);
        this.installationSelector.lcaBranchInfoLabel.setEnabled(!isRunning);
        Configuration.Platform pf = this.installationSelector.getPlatform();
        while (iter.hasNext()) {
            CanEnable l = (CanEnable)iter.next();
            boolean goodOs = true;
            if (pf != null && l.needsUnix() && !pf.isUnix()) {
                goodOs = false;
            } else if (pf == null && l.needsUnix()) {
                goodOs = false;
            }
            if (hasVersion) {
                if (isRunning) {
                    l.setEnabled(!l.blockWhileRunning() && goodOs);
                    continue;
                }
                l.setEnabled(goodOs);
                continue;
            }
            if (hasVersion) continue;
            if (isRunning) {
                l.setEnabled(!l.blockWhileRunning() && !l.needsVersion() && goodOs);
                continue;
            }
            l.setEnabled(!l.needsVersion() && goodOs);
        }
        this.killAction.setEnabled(isRunning && !isCanceling);
        iter = this.controlContext.comboBoxesIterator();
        while (iter.hasNext()) {
            JComboBox bx = (JComboBox)iter.next();
            bx.setEnabled(!isRunning);
        }
        this.knownHostsComboBox.setEnabled(!isRunning);
        String version = this.installationSelector.getVersion();
        boolean canTemplates = !isRunning && version != null && "76".compareTo(version) <= 0;
        this.knownTemplatesComboBox.setEnabled(canTemplates);
        this.templatesAction.setEnabled(canTemplates);
        this.templateTestAction.setEnabled(canTemplates);
        if (this.executorServer != null && this.executorServer.isRemote()) {
            this.localToolsButton.setEnabled(false);
        } else {
            this.shutdownAction.setEnabled(false);
            this.localToolsButton.setEnabled(true);
        }
        this.upgradeTestAction.setEnabled(hasUpgradeVersions && !isRunning);
        this.cutAction.setEnabled(isRunning && !isCanceling);
        this.joinAction.setEnabled(!isRunning && !isCanceling);
    }

    Executor packdistrib(File unpackDir) throws IOException, InterruptedException {
        String version = this.installationSelector.getNormalizedVersion();
        Configuration.QASTATUS status = this.installationSelector.getQAStatus();
        String lcversion = this.installationSelector.getLCVersion();
        Configuration.QASTATUS lcstatus = this.installationSelector.getLCQAStatus();
        String profile = this.installationSelector.getProfile();
        String lcBranchInfo = this.installationSelector.lcaBranchInfoLabel.getText();
        String apool = this.installationSelector.getLCPool();
        apool = apool != null && !"".equals(apool) ? apool : null;
        String lcaVariant = this.installationSelector.lcaVariantLabel.getText();
        lcaVariant = lcaVariant != null && !"".equals(lcaVariant) ? lcaVariant : null;
        String lcaPool = this.installationSelector.getLCAPool();
        Configuration.Platform chosenPlatform = this.installationSelector.getPlatform();
        String toolsDir = this.getToolsDir();
        File packdistrib = new File(toolsDir, "bin/packdistrib.pl");
        return this.config.createPackdistribExecutor(profile, version, lcversion, status, lcstatus, unpackDir, lcBranchInfo, chosenPlatform, packdistrib, apool, Configuration.isGoodLCPoolId(lcaPool) ? lcaPool : null, lcaVariant, this.getPerl());
    }

    private ComplexParameter getPerl() throws RemoteException, IOException {
        String fileString = this.perlTextField.getText();
        File fileObject = new File(fileString);
        return fileObject.isAbsolute() ? new ComplexParameter("", new File(this.perlTextField.getText())) : new ComplexParameter(fileString, null);
    }

    private String createPerlCall(boolean unix, String toolsDir) throws RemoteException, IOException {
        String perl = this.executorServer.isRemote() ? (unix ? "/devtool/local/bin/perl" : toolsDir + "\\Perl\\bin\\perl") : this.getLocalToolsDir() + "\\Perl\\bin\\perl";
        return perl;
    }

    Executor sdbinst(File unpackDir) throws IOException, InterruptedException {
        File packageDir = this.packageDir();
        String profile = this.installationSelector.getProfile();
        Executor exec = this.config.createSDBINSTExecutor(packageDir, this.indepProgDir(), this.indepDataDir(), this.depDir(), profile, this.installationSelector.getNormalizedVersion());
        return exec;
    }

    String getToolsDir() {
        return this.toolsTextField.getText();
    }

    String getLocalToolsDir() throws IOException {
        return InstallerTester.readUserConfig(System.getProperties()).getProperty("env.tool");
    }

    private void updateScript(String version, String instanceType) {
        String script = this.config.dbCreateScriptForInstanceType(version, instanceType, null);
        this.createScriptTextPane.setText(script);
    }

    private String getCreateScript() {
        return this.createScriptTextPane.getText();
    }

    private void updatePaths(String version) {
        if (version != null) {
            String normalizedVersion = this.installationSelector.getNormalizedVersion();
            File depFile = this.config.getDependendPathForVersionOsIndependend(normalizedVersion);
            String canonicalPath = depFile.toString();
            try {
                canonicalPath = this.executorServer.canonicalPath(depFile);
            }
            catch (RemoteException ex) {
                this.error(ex, "Error getting os dependend path name");
            }
            this.depPathTextField.setText(canonicalPath);
        } else {
            this.depPathTextField.setText("");
        }
    }

    private String getInstanceType() {
        return this.installationSelector.getLCVersion() != null ? "lc" : "oltp";
    }

    static /* synthetic */ void access$100(InstallerTester x0, String x1) {
        x0.updatePaths(x1);
    }

    static /* synthetic */ String access$200(InstallerTester x0) {
        return x0.getInstanceType();
    }

    static /* synthetic */ void access$300(InstallerTester x0, String x1, String x2) {
        x0.updateScript(x1, x2);
    }

    static /* synthetic */ long access$2102(InstallerTester x0, long x1) {
        x0.cancelInProgress = x1;
        return x0.cancelInProgress;
    }

    static /* synthetic */ long access$2100(InstallerTester x0) {
        return x0.cancelInProgress;
    }

    abstract class KillActionListener
    extends MyAbstractActionListener {
        KillActionListener(String txt, JToolBar tb, String toolTip, ControlContext ct) {
            super(txt, tb, toolTip, ct);
        }

        void initButton(JToolBar tb, String toolTipText) {
            JButton b = new JButton(this, this){
                private final /* synthetic */ KillActionListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void setEnabled(boolean b) {
                    super.setEnabled(b);
                    if (b) {
                        this.setBorder(new CompoundBorder(new LineBorder(Color.red, 2, true), new JButton().getBorder()));
                    } else {
                        this.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new JButton().getBorder()));
                    }
                }
            };
            b.setToolTipText(toolTipText);
            tb.add(b);
        }
    }

    class MyButton
    extends JButton
    implements CanEnable {
        boolean blockWhileRunning = false;
        boolean needsVersion = false;
        boolean needsUnix = false;

        public boolean blockWhileRunning() {
            return this.blockWhileRunning;
        }

        public boolean needsVersion() {
            return this.needsVersion;
        }

        public boolean needsUnix() {
            return this.needsUnix;
        }

        MyButton(JComponent c, String txt) {
            super(txt);
            c.add(this);
            InstallerTester.this.controlContext.addCanEnable(this);
        }

        MyButton(String txt, JComponent c, boolean aBlockWhileRunning, boolean aNeedsVersion, boolean aNeedsUnix, String toolTip) {
            super(txt);
            c.add(this);
            InstallerTester.this.controlContext.addCanEnable(this);
            this.blockWhileRunning = aBlockWhileRunning;
            this.needsVersion = aNeedsVersion;
            this.needsUnix = aNeedsUnix;
            this.setToolTipText(toolTip);
        }

        MyButton(String txt, boolean aBlockWhileRunning, boolean aNeedsVersion, boolean aNeedsUnix, String toolTip) {
            super(txt);
            InstallerTester.this.controlContext.addCanEnable(this);
            this.blockWhileRunning = aBlockWhileRunning;
            this.needsVersion = aNeedsVersion;
            this.needsUnix = aNeedsUnix;
            this.setToolTipText(toolTip);
        }
    }

    static class FileItem {
        boolean isDir = false;
        String name;
        String file;
        SerializableFileFilter fileFilter = DEFAULTFILEFILTER;

        FileItem(String as, String af, boolean dirFlag) {
            this.name = as;
            this.file = af;
            this.isDir = dirFlag;
        }

        FileItem(String as, String af, boolean dirFlag, SerializableFileFilter ff) {
            this(as, af, dirFlag);
            this.fileFilter = ff;
        }

        public String toString() {
            return this.name;
        }
    }

    class BootExecutorListener
    extends ExecutorListenerAdapter {
        BootExecutorListener() {
        }

        public void dbm(ExecutorEvent e) throws RemoteException {
        }

        public void log(ExecutorEvent e) throws RemoteException {
            String logLine = e.getText();
            SwingUtilities.invokeLater(new Runnable(this, logLine){
                private final /* synthetic */ String val$logLine;
                private final /* synthetic */ BootExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$logLine = val$logLine;
                }

                public void run() {
                    String l = this.val$logLine.endsWith("\n") ? this.val$logLine : this.val$logLine + "\n";
                    BootExecutorListener.access$2900(this.this$1).log(l, "log", BootExecutorListener.access$2900((BootExecutorListener)this.this$1).updateLog);
                }
            });
        }

        public void stdout(ExecutorEvent e) throws RemoteException {
            String line = e.getText();
            SwingUtilities.invokeLater(new Runnable(this, line){
                private final /* synthetic */ String val$line;
                private final /* synthetic */ BootExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$line = val$line;
                }

                public void run() {
                    String l = this.val$line.endsWith("\n") ? this.val$line : this.val$line + "\n";
                    BootExecutorListener.access$2900(this.this$1).log(this.val$line + "\n", "console", BootExecutorListener.access$2900((BootExecutorListener)this.this$1).updateLog);
                    if (l.indexOf("Done binding, server is up!") >= 0) {
                        BootExecutorListener.access$2900(this.this$1).log("Server booted on " + BootExecutorListener.access$2900(this.this$1).getHostName() + "\n", "status");
                    } else if (l.indexOf("AlreadyBoundException occured") >= 0) {
                        BootExecutorListener.access$2900(this.this$1).log("Server already running on " + BootExecutorListener.access$2900(this.this$1).getHostName() + "\n", "status");
                    } else if (l.indexOf("Error exporting remote object") >= 0) {
                        BootExecutorListener.access$2900(this.this$1).log("Error starting server  on " + BootExecutorListener.access$2900(this.this$1).getHostName() + ":\n" + l, "error");
                    }
                }
            });
        }

        public void stderr(ExecutorEvent e) throws RemoteException {
            String line = e.getText();
            SwingUtilities.invokeLater(new Runnable(this, line){
                private final /* synthetic */ String val$line;
                private final /* synthetic */ BootExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$line = val$line;
                }

                public void run() {
                    String l = this.val$line.endsWith("\n") ? this.val$line : this.val$line + "\n";
                    BootExecutorListener.access$2900(this.this$1).log("[STDERR] " + this.val$line + "\n", "error", BootExecutorListener.access$2900((BootExecutorListener)this.this$1).aLog);
                    BootExecutorListener.access$2900(this.this$1).log("[STDERR] " + this.val$line + "\n", "error", BootExecutorListener.access$2900((BootExecutorListener)this.this$1).updateLog);
                }
            });
        }

        public void executorStatus(ExecutorEvent e) throws RemoteException {
            String status = e.getExecutorStateChange();
            String finishedStatus = e.getFinishedStatus();
            String text = e.getText();
            SwingUtilities.invokeLater(new Runnable(this, status){
                private final /* synthetic */ String val$status;
                private final /* synthetic */ BootExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$status = val$status;
                }

                public void run() {
                    try {
                        this.runEx();
                    }
                    catch (RemoteException ex) {
                        BootExecutorListener.access$2900(this.this$1).error(ex, "Error updating executor status\n");
                    }
                }

                public void runEx() throws RemoteException {
                    if ("started".equals(this.val$status)) {
                        BootExecutorListener.access$2900(this.this$1).updateActions();
                    } else if ("finished".equals(this.val$status)) {
                        BootExecutorListener.access$2900(this.this$1).updateActions();
                    } else if (!"subprocess started".equals(this.val$status) && !"subprocess finished".equals(this.val$status)) {
                        if ("fork started".equals(this.val$status)) {
                            BootExecutorListener.access$2900(this.this$1).log("Boot Utility started on " + BootExecutorListener.access$2900(this.this$1).getHostName() + ".\n");
                        } else if ("fork finished".equals(this.val$status)) {
                            BootExecutorListener.access$2900(this.this$1).log("Boot Utility exited on " + BootExecutorListener.access$2900(this.this$1).getHostName() + ".\n");
                        }
                    }
                }
            });
        }

        public void exceptionOccurred(ExecutorEvent e) throws RemoteException {
            Throwable anex = e.getThrowable();
            SwingUtilities.invokeLater(new Runnable(this, anex){
                private final /* synthetic */ Throwable val$anex;
                private final /* synthetic */ BootExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$anex = val$anex;
                }

                public void run() {
                    String cls = this.val$anex.getClass().getName();
                    String msg = cls + ":\n" + this.val$anex.getMessage() + "\n";
                    BootExecutorListener.access$2900(this.this$1).log(msg, "error", BootExecutorListener.access$2900((BootExecutorListener)this.this$1).updateLog);
                    BootExecutorListener.access$2900(this.this$1).error(this.val$anex, msg);
                }
            });
        }

        static /* synthetic */ InstallerTester access$2900(BootExecutorListener x0) {
            return x0.InstallerTester.this;
        }
    }

    class GuiExecutorListener
    extends ExecutorListenerAdapter {
        int logLevel = 0;

        GuiExecutorListener() {
        }

        public void dbm(ExecutorEvent e) throws RemoteException {
        }

        public void log(ExecutorEvent e) throws RemoteException {
            String logLine = e.getText();
            SwingUtilities.invokeLater(new Runnable(this, logLine){
                private final /* synthetic */ String val$logLine;
                private final /* synthetic */ GuiExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$logLine = val$logLine;
                }

                public void run() {
                    String l = this.val$logLine.endsWith("\n") ? this.val$logLine : this.val$logLine + "\n";
                    GuiExecutorListener.access$2800(this.this$1).log(l, "log", GuiExecutorListener.access$2800((GuiExecutorListener)this.this$1).updateLog);
                }
            });
        }

        public void stdout(ExecutorEvent e) throws RemoteException {
            String line = e.getText();
            SwingUtilities.invokeLater(new Runnable(this, line){
                private final /* synthetic */ String val$line;
                private final /* synthetic */ GuiExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$line = val$line;
                }

                public void run() {
                    String l = this.val$line.endsWith("\n") ? this.val$line : this.val$line + "\n";
                    GuiExecutorListener.access$2800(this.this$1).log(this.val$line + "\n", "console", GuiExecutorListener.access$2800((GuiExecutorListener)this.this$1).updateLog);
                }
            });
        }

        public void stderr(ExecutorEvent e) throws RemoteException {
            String line = e.getText();
            SwingUtilities.invokeLater(new Runnable(this, line){
                private final /* synthetic */ String val$line;
                private final /* synthetic */ GuiExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$line = val$line;
                }

                public void run() {
                    String l = this.val$line.endsWith("\n") ? this.val$line : this.val$line + "\n";
                    GuiExecutorListener.access$2800(this.this$1).log("[STDERR] " + this.val$line + "\n", "error", GuiExecutorListener.access$2800((GuiExecutorListener)this.this$1).aLog);
                    GuiExecutorListener.access$2800(this.this$1).log("[STDERR] " + this.val$line + "\n", "error", GuiExecutorListener.access$2800((GuiExecutorListener)this.this$1).updateLog);
                }
            });
        }

        public void executorStatus(ExecutorEvent e) throws RemoteException {
            String status = e.getExecutorStateChange();
            String finishedStatus = e.getFinishedStatus();
            String text = e.getText();
            SwingUtilities.invokeLater(new Runnable(this, status, text, finishedStatus){
                private final /* synthetic */ String val$status;
                private final /* synthetic */ String val$text;
                private final /* synthetic */ String val$finishedStatus;
                private final /* synthetic */ GuiExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$status = val$status;
                    this.val$text = val$text;
                    this.val$finishedStatus = val$finishedStatus;
                }

                private String indent() {
                    StringBuffer b = new StringBuffer("");
                    for (int i = 1; i < this.this$1.logLevel; ++i) {
                        b.append("  ");
                    }
                    return b.toString();
                }

                public void run() {
                    try {
                        this.runEx();
                    }
                    catch (RemoteException ex) {
                        GuiExecutorListener.access$2800(this.this$1).error(ex, "Error updating executor status\n");
                    }
                }

                public void runEx() throws RemoteException {
                    if ("started".equals(this.val$status)) {
                        ++this.this$1.logLevel;
                        GuiExecutorListener.access$2800(this.this$1).updateActions();
                        GuiExecutorListener.access$2800(this.this$1).log(this.indent() + this.val$text + "\n", "status");
                    } else if ("finished".equals(this.val$status)) {
                        GuiExecutorListener.access$2800(this.this$1).updateActions();
                        if ("finished normally".equals(this.val$finishedStatus)) {
                            GuiExecutorListener.access$2800(this.this$1).log(this.indent() + this.val$finishedStatus + "\n", "status");
                        } else {
                            GuiExecutorListener.access$2800(this.this$1).log(this.indent() + this.val$finishedStatus + "\n", "error");
                        }
                        --this.this$1.logLevel;
                    } else if ("subprocess started".equals(this.val$status)) {
                        ++this.this$1.logLevel;
                        GuiExecutorListener.access$2800(this.this$1).log(this.indent() + this.val$text + " .. ", "status");
                    } else if ("subprocess finished".equals(this.val$status)) {
                        if ("finished normally".equals(this.val$finishedStatus)) {
                            GuiExecutorListener.access$2800(this.this$1).log(this.val$finishedStatus + "\n", "status");
                        } else {
                            GuiExecutorListener.access$2800(this.this$1).log(this.val$finishedStatus + "\n", "error");
                        }
                        --this.this$1.logLevel;
                    } else if ("fork started".equals(this.val$status)) {
                        String amsg = "forked ";
                        GuiExecutorListener.access$2800(this.this$1).log(" " + amsg + " .. ", "status");
                    } else if ("fork finished".equals(this.val$status)) {
                        String amsg = "fork end";
                        GuiExecutorListener.access$2800(this.this$1).log(" " + amsg + " .. ", "status");
                    }
                }
            });
        }

        public void exceptionOccurred(ExecutorEvent e) throws RemoteException {
            Throwable anex = e.getThrowable();
            SwingUtilities.invokeLater(new Runnable(this, anex){
                private final /* synthetic */ Throwable val$anex;
                private final /* synthetic */ GuiExecutorListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$anex = val$anex;
                }

                public void run() {
                    String cls = this.val$anex.getClass().getName();
                    String msg = cls + ":\n" + this.val$anex.getMessage() + "\n";
                    GuiExecutorListener.access$2800(this.this$1).log(msg, "error", GuiExecutorListener.access$2800((GuiExecutorListener)this.this$1).updateLog);
                    GuiExecutorListener.access$2800(this.this$1).error(this.val$anex, msg);
                }
            });
        }

        static /* synthetic */ InstallerTester access$2800(GuiExecutorListener x0) {
            return x0.InstallerTester.this;
        }
    }

    class UpgradeComboBoxLCAItem {
        String lcaMakeKey;
        String lcapoolid;
        String lcaversion;
        String makeKey;
        String lcaVariant;
        String branchInfo;
        Configuration.QASTATUS lcaqastatus;

        UpgradeComboBoxLCAItem(String aLcaMakeKey, String aLcapoolid, String aLcaversion, String aMakeKey, Configuration.QASTATUS aqastatus, String aVariant, String abranch) {
            this.lcaMakeKey = aLcaMakeKey;
            this.lcapoolid = aLcapoolid;
            this.lcaversion = aLcaversion;
            this.makeKey = aMakeKey;
            this.lcaqastatus = aqastatus;
            this.lcaVariant = aVariant;
            this.branchInfo = abranch;
        }

        public String toString() {
            return this.lcaversion + " " + this.lcapoolid;
        }
    }

    class UpgradeComboBoxItem {
        String version;
        String makeKey;
        String build;
        String lcpool;
        Configuration.Platform platform;
        Configuration.QASTATUS status = Configuration.RAMP;

        UpgradeComboBoxItem(String aMakeKey, String aVersion, String aBuild, String alcpool, Configuration.Platform plf) {
            this.version = aVersion;
            this.makeKey = aMakeKey;
            this.build = aBuild;
            this.lcpool = alcpool;
            this.platform = plf;
        }

        public String toString() {
            return this.version.substring(0, 1) + "." + this.version.substring(1, 2) + "." + this.version.substring(2, 4) + "." + (this.build == null ? "" : this.build) + " " + (this.lcpool == null ? "" : this.lcpool);
        }
    }

    class FixedWidthTextField
    extends JTextField
    implements CanEnable {
        final int width;
        boolean needsVersion;
        boolean blocksWhileRunning;
        boolean needsUnix = false;

        public boolean needsUnix() {
            return this.needsUnix;
        }

        public boolean needsVersion() {
            return this.needsVersion;
        }

        public boolean blockWhileRunning() {
            return this.blocksWhileRunning;
        }

        FixedWidthTextField(String s, int width, boolean aBlockWhileRunning, boolean aNeedsVersion) {
            super(s);
            this.width = width;
            this.needsVersion = aNeedsVersion;
            this.blocksWhileRunning = aBlockWhileRunning;
            InstallerTester.this.controlContext.addCanEnable(this);
        }

        FixedWidthTextField(String s, int width, boolean aBlockWhileRunning, boolean aNeedsVersion, String toolTip) {
            this(s, width, aBlockWhileRunning, aNeedsVersion);
            this.setToolTipText(toolTip);
        }

        FixedWidthTextField(String s, int width, boolean aBlockWhileRunning, boolean aNeedsVersion, boolean aNeedsUx) {
            this(s, width, aBlockWhileRunning, aNeedsUx);
            this.needsUnix = aNeedsUx;
        }

        FixedWidthTextField(String s, int width, boolean aBlockWhileRunning, boolean aNeedsVersion, boolean aNeedsUx, String toolTip) {
            this(s, width, aBlockWhileRunning, aNeedsVersion, aNeedsUx);
            this.setToolTipText(toolTip);
        }

        FixedWidthTextField(String s, int width, boolean aBlockWhileRunning, boolean aNeedsVersion, boolean aNeedsUx, String toolTip, JToolBar toolBar) {
            this(s, width, aBlockWhileRunning, aNeedsVersion, aNeedsUx, toolTip);
            toolBar.add(this);
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            if (this.width > 0) {
                d.width = this.width;
            }
            return d;
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (this.width > 0) {
                d.width = this.width;
            }
            return d;
        }

        public Dimension getMaximumSize() {
            Dimension d = super.getMaximumSize();
            if (this.width > 0) {
                d.width = this.width;
            }
            return d;
        }
    }

    class ProcessInitException
    extends Exception {
        ProcessInitException(String s) {
            super(s);
        }
    }

    static class PWDF2904CLASS
    extends TestServer {
        PWDF2904CLASS() {
            super("pwdf2904");
        }
    }

    static class US4010CLASS
    extends TestServer {
        US4010CLASS() {
            super("us4010");
        }
    }

    static class DS0116CLASS
    extends TestServer {
        DS0116CLASS() {
            super("ds0116", "/usr/sbin/chroot");
        }
    }

    static class LS3662CLASS
    extends TestServer {
        LS3662CLASS() {
            super("ls3662", "/usr/bin/chroot");
        }
    }

    static class LS3101CLASS
    extends TestServer {
        LS3101CLASS() {
            super("ls3101");
        }
    }

    static class LS3007CLASS
    extends TestServer {
        LS3007CLASS() {
            super("ls3007", "/usr/bin/chroot");
        }
    }

    static class LD0406CLASS
    extends TestServer {
        LD0406CLASS() {
            super("ld0406", "/usr/bin/chroot");
        }
    }

    static class LD0319CLASS
    extends TestServer {
        LD0319CLASS() {
            super("ld0319", "/usr/bin/chroot");
        }
    }

    static class LDP001CLASS
    extends TestServer {
        LDP001CLASS() {
            super("ldp001");
        }
    }

    static class IS4009CLASS
    extends TestServer {
        IS4009CLASS() {
            super("is4009");
        }
    }

    static class IS0042CLASS
    extends TestServer {
        IS0042CLASS() {
            super("is0042");
        }
    }

    static class IS0025CLASS
    extends TestServer {
        IS0025CLASS() {
            super("is0025");
        }
    }

    static class HS0116CLASS
    extends TestServer {
        HS0116CLASS() {
            super("hs0116");
        }
    }

    static class HS0030CLASS
    extends TestServer {
        HS0030CLASS() {
            super("hs0030");
        }
    }

    static class LOCALHOSTTESTERCLASS
    extends TestServer {
        LOCALHOSTTESTERCLASS() {
            super(InstallerTester.LOCALHOST);
        }
    }

    static class TestServer {
        String name = "UNKNOWNHOST";
        String chroot = "/usr/local/bin/chroot";
        String remuserXterm = "/SAP_DB/TESTDB/chr_term.pl";
        String rootXterm = "/SAP_DB/TESTDB/chr_term_su.pl";

        String getChroot() {
            return this.chroot;
        }

        String getRemuserXterm() {
            return this.remuserXterm;
        }

        String getRootXterm() {
            return this.rootXterm;
        }

        TestServer() {
        }

        TestServer(String aname) {
            this.name = aname;
        }

        TestServer(String aname, String achr) {
            this(aname);
            this.chroot = achr;
        }

        public String toString() {
            return this.name;
        }
    }
}

