/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Execute
extends Thread {
    private String mCmd;
    private String[] mCmdArray;
    private String[] mEnvp;
    private StringBuffer mBuffer;
    private boolean mBufferLimitReached = false;
    private boolean mBufferLimitReachedButIgnoreable = false;
    private PrintWriter mWriter;
    private String mErrPrefix;
    private String mOutPrefix;
    private String mLineSep;
    private BufferedReader mErrReader;
    private BufferedReader mOutReader;
    private Process mProcess;
    private int mExitValue;
    private int mTimeout = 0;
    private boolean mIsDestroyed = false;
    private boolean mWriteStdoutToOutput = true;

    public Execute(String cmd, String[] envp) {
        this.initialize(cmd, envp, null, null);
    }

    public Execute(String cmd, String[] envp, PrintWriter pWriter) {
        this.initialize(cmd, envp, null, pWriter);
    }

    public Execute(String cmd, String[] envp, StringBuffer pBuffer) {
        this.initialize(cmd, envp, pBuffer, null);
    }

    public Execute(String[] cmd, String[] envp) {
        this.initializeCmdArray(cmd, envp, null, null);
    }

    public Execute(String[] cmd, String[] envp, PrintWriter pWriter) {
        this.initializeCmdArray(cmd, envp, null, pWriter);
    }

    public Execute(String[] cmd, String[] envp, StringBuffer pBuffer) {
        this.initializeCmdArray(cmd, envp, pBuffer, null);
    }

    private void appendErrLine(String pLine) {
        if (this.mWriteStdoutToOutput) {
            if (this.mBuffer != null) {
                if (this.mBuffer.capacity() < 100000 || this.mBufferLimitReachedButIgnoreable) {
                    this.mBuffer.append(this.mOutPrefix + pLine + this.mLineSep);
                } else if (!this.mBufferLimitReached) {
                    this.mBufferLimitReached = true;
                    this.mBuffer.append(this.mLineSep + "100.000 byte limit reached, output (STDERR) is truncated!" + this.mLineSep);
                }
            }
            if (this.mWriter != null) {
                this.mWriter.println(this.mErrPrefix + pLine);
            }
        }
    }

    private void appendException(Exception e, String msg) {
        if (this.mBuffer != null) {
            StringWriter wrt = new StringWriter();
            PrintWriter pwt = new PrintWriter(wrt);
            e.printStackTrace(pwt);
            this.mBuffer.append("*** " + msg + this.mLineSep);
            this.mBuffer.append(wrt.toString());
        }
        if (this.mWriter != null) {
            this.mWriter.println("*** " + msg);
            e.printStackTrace(this.mWriter);
        }
    }

    private void appendOutLine(String pLine) {
        if (this.mWriteStdoutToOutput) {
            if (this.mBuffer != null) {
                if (this.mBuffer.capacity() < 100000 || this.mBufferLimitReachedButIgnoreable) {
                    this.mBuffer.append(this.mOutPrefix + pLine + this.mLineSep);
                } else if (!this.mBufferLimitReached) {
                    this.mBufferLimitReached = true;
                    this.mBuffer.append(this.mLineSep + "100.000 byte limit reached, output (STDOUT) is truncated!" + this.mLineSep);
                }
            }
            if (this.mWriter != null) {
                this.mWriter.println(this.mOutPrefix + pLine);
            }
        }
    }

    public void enableWritingStdout(boolean pEnable) {
        this.mWriteStdoutToOutput = pEnable;
    }

    public void ignoreBufferLimitForStdOut(boolean pIgnoreLimit) {
        this.mBufferLimitReachedButIgnoreable = pIgnoreLimit;
    }

    public void exec() {
        try {
            this.mProcess = this.mCmdArray == null ? Runtime.getRuntime().exec(this.mCmd, this.mEnvp) : Runtime.getRuntime().exec(this.mCmdArray, this.mEnvp);
            this.start();
            Timer timer = new Timer(this.mTimeout);
            try {
                this.join();
            }
            catch (InterruptedException e) {
                this.appendException(e, "joining exec stdout thread");
            }
            try {
                this.mProcess.waitFor();
            }
            catch (InterruptedException e) {
                this.appendException(e, "waiting for exec process");
            }
            timer.pleaseStop();
            this.mExitValue = this.mProcess.exitValue();
        }
        catch (IOException e) {
            this.appendException(e, "execing process " + this.getCmdAsString());
        }
    }

    public void exec(File workDir) {
        try {
            this.mProcess = this.mCmdArray == null ? Runtime.getRuntime().exec(this.mCmd, this.mEnvp, workDir) : Runtime.getRuntime().exec(this.mCmdArray, this.mEnvp, workDir);
            this.start();
            Timer timer = new Timer(this.mTimeout);
            try {
                this.join();
            }
            catch (InterruptedException e) {
                this.appendException(e, "joining exec stdout thread");
            }
            try {
                this.mProcess.waitFor();
            }
            catch (InterruptedException e) {
                this.appendException(e, "waiting for exec process");
            }
            timer.pleaseStop();
            this.mExitValue = this.mProcess.exitValue();
        }
        catch (IOException e) {
            this.appendException(e, "execing process " + this.getCmdAsString());
        }
    }

    private String getCmdAsString() {
        if (this.mCmdArray == null) {
            return this.mCmd;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.mCmdArray.length; ++i) {
            buf.append(this.mCmdArray[i]);
        }
        return buf.toString();
    }

    public int getExitValue() {
        return this.mExitValue;
    }

    public boolean getWriteStdoutToOutput() {
        return this.mWriteStdoutToOutput;
    }

    private void initialize(String cmd, String[] envp, StringBuffer pBuffer, PrintWriter pWriter) {
        this.mExitValue = -1;
        this.mCmd = cmd;
        this.mCmdArray = null;
        this.mEnvp = envp;
        this.mBuffer = pBuffer;
        this.mWriter = pWriter;
        this.mErrPrefix = "";
        this.mOutPrefix = "";
        this.mLineSep = System.getProperty("line.separator", "\n");
    }

    private void initializeCmdArray(String[] cmdArray, String[] envp, StringBuffer pBuffer, PrintWriter pWriter) {
        this.mExitValue = -1;
        this.mCmd = null;
        this.mCmdArray = cmdArray;
        this.mEnvp = envp;
        this.mBuffer = pBuffer;
        this.mWriter = pWriter;
        this.mErrPrefix = "";
        this.mOutPrefix = "";
        this.mLineSep = System.getProperty("line.separator", "\n");
    }

    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    public void run() {
        try {
            String line;
            this.mProcess.getOutputStream().close();
            this.mErrReader = new BufferedReader(new InputStreamReader(this.mProcess.getErrorStream()));
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        String line = null;
                        while ((line = Execute.this.mErrReader.readLine()) != null) {
                            Execute.this.appendErrLine(line);
                        }
                    }
                    catch (IOException e) {
                        Execute.this.appendException(e, "Reading exec stderr stream");
                    }
                }
            });
            t.setPriority(10);
            t.start();
            this.mOutReader = new BufferedReader(new InputStreamReader(this.mProcess.getInputStream()));
            this.setPriority(10);
            while ((line = this.mOutReader.readLine()) != null) {
                this.appendOutLine(line);
            }
            this.mOutReader.close();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.appendException(e, "joining exec stderr thread");
            }
        }
        catch (IOException e) {
            this.appendException(e, "reading exec stdout stream");
        }
    }

    public void setErrPrefix(String pPrefix) {
        this.mErrPrefix = pPrefix;
    }

    public void setOutPrefix(String pPrefix) {
        this.mOutPrefix = pPrefix;
    }

    public void setTimeout(int pTimeout) {
        this.mTimeout = pTimeout;
    }

    class Timer
    extends Thread {
        long startTime = 0L;
        long elapsedTime;
        long Timeout;
        boolean keepRuning = true;

        public Timer(int timeout) {
            if (timeout != 0) {
                this.start();
                this.startTime = System.currentTimeMillis();
                this.Timeout = (long)timeout * 1000L;
            }
        }

        public void run() {
            while (this.keepRuning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.elapsedTime = System.currentTimeMillis() - this.startTime;
                if (this.elapsedTime <= this.Timeout) continue;
                System.out.println("Currently trying to destroy the process: " + Execute.this.getCmdAsString() + " (Longrunner)!");
                Execute.this.mProcess.destroy();
                System.out.println("Stopped the process: " + Execute.this.getCmdAsString() + " !");
                this.pleaseStop();
                Execute.this.appendOutLine("Subprocess destroyed after timeout");
                Execute.this.mIsDestroyed = true;
            }
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }
}

