/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestResultDatabase;
import com.sap.sapdb.testframe.testcase.VerificationObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class VerificationTestObject
extends VerificationObject {
    private static final String TEST_DATABASE_TABLE = "TT";
    private static final String TEST_DATABASE_TABLE_DATA = "TTD";
    private static int VersionCounter = Integer.MAX_VALUE;

    public VerificationTestObject(String pTestId, String pDbSys, TestResultDatabase pDatabase) {
        super(pTestId, pDbSys, pDatabase);
        this.setDatabaseTable(TEST_DATABASE_TABLE);
        this.setDatabaseTableData(TEST_DATABASE_TABLE_DATA);
        this.setVersion(VersionCounter--);
    }

    public VerificationTestObject(String pTestId, String pDbSys, TestResultDatabase pDatabase, int pVersion) {
        super(pTestId, pDbSys, pDatabase);
        this.setDatabaseTable(TEST_DATABASE_TABLE);
        this.setVersion(pVersion);
    }

    public static VerificationTestObject read(String pTestId, String pDbSysName, TestResultDatabase pDatabase, int pVersion) throws SQLException, TestDatabaseException {
        VerificationTestObject lTObject = new VerificationTestObject(pTestId, pDbSysName, pDatabase, pVersion);
        if (lTObject.selectFromDatabase() > 0) {
            return lTObject;
        }
        return null;
    }

    public synchronized int save() throws SQLException, TestDatabaseException {
        int lMax = -1;
        Connection lConnection = null;
        Statement lStmt = null;
        try {
            lConnection = this.getDatabase().connect();
            if (!this.mStoredOneTime) {
                lStmt = lConnection.createStatement();
                String lSql = "Select max(Version) from " + this.getDatabaseTable() + " where TESTID = '" + this.getTestId() + "' and DBSYSNAME = '" + this.getDbSysName() + "'";
                ResultSet lResultSet = lStmt.executeQuery(lSql);
                while (lResultSet.next()) {
                    lMax = lResultSet.getInt(1);
                }
                if (lMax < 0) {
                    throw new SQLException("Can't detect version for test result object");
                }
                this.setVersion(lMax + 1);
            }
            int lSql = super.save();
            return lSql;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (TestDatabaseException e) {
            throw e;
        }
        finally {
            lStmt.close();
            lConnection.close();
        }
    }
}

