/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import com.sap.sapdb.testframe.testcase.VerificationDataIterator;
import java.util.ArrayList;

public class VerificationDataIteratorPretty
extends VerificationDataIterator {
    protected int[] mColumnWidth;
    protected int mRowWidth;
    private String mDelimiterRow;

    protected VerificationDataIteratorPretty() {
    }

    public VerificationDataIteratorPretty(ArrayList Values2, ArrayList ColumnDescriptions, boolean ColumnNamesDefined) {
        super(Values2, ColumnDescriptions, ColumnNamesDefined);
        this.mColumnWidth = new int[this.mNumberOfColumns];
        this.mRowWidth = 0;
        this.mCurrentPos = -1;
        for (int i = 0; i < this.mNumberOfColumns; ++i) {
            this.mColumnWidth[i] = 0;
            int ColumnType = ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType();
            int longestRowEntry = 0;
            for (int ii = 0; ii < this.mValues.size(); ++ii) {
                longestRowEntry = ((ArrayList)this.mValues.get(ii)).get(i) == null ? Math.max(longestRowEntry, 4) : Math.max(longestRowEntry, ((ArrayList)this.mValues.get(ii)).get(i).toString().length());
            }
            this.mColumnWidth[i] = Math.max(Math.max(ColumnDescriptor.getTypeName(ColumnType).length(), ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getName().length()), longestRowEntry);
            if (this.mColumnWidth[i] > 20) {
                this.mColumnWidth[i] = 20;
            }
            this.mRowWidth += this.mColumnWidth[i];
        }
        StringBuffer DelimiterRow = new StringBuffer(this.mRowWidth * 2);
        DelimiterRow.append('+');
        VerificationDataIteratorPretty.appendNChars(DelimiterRow, '-', this.mRowWidth + this.mNumberOfColumns - 1);
        DelimiterRow.append('+');
        this.mDelimiterRow = DelimiterRow.toString();
    }

    public boolean hasNext() {
        return this.mCurrentPos <= this.mNumberOfRows;
    }

    public Object next() {
        String Result;
        if (this.mCurrentPos == -1) {
            int i;
            StringBuffer Head = new StringBuffer(this.mRowWidth * 6);
            Head.append(this.mDelimiterRow);
            Head.append('\n');
            for (i = 0; i < this.mNumberOfColumns; ++i) {
                Head.append('|');
                Head.append(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getName());
                VerificationDataIteratorPretty.appendNChars(Head, ' ', this.mColumnWidth[i] - ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getName().length());
            }
            Head.append("|\n");
            Head.append(this.mDelimiterRow);
            Head.append('\n');
            for (i = 0; i < this.mNumberOfColumns; ++i) {
                Head.append('|');
                Head.append(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getTypeName());
                VerificationDataIteratorPretty.appendNChars(Head, ' ', this.mColumnWidth[i] - ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getTypeName().length());
            }
            Head.append("|\n");
            Head.append(this.mDelimiterRow);
            Result = Head.toString();
        } else if (this.mCurrentPos == this.mNumberOfRows) {
            StringBuffer Foot = new StringBuffer(this.mRowWidth * 4);
            Foot.append(this.mDelimiterRow);
            Foot.append('\n');
            String Trailer = "| ";
            Trailer = this.mNumberOfRows == 1 ? Trailer + "1 row" : Trailer + this.mNumberOfRows + " rows";
            Foot.append(Trailer);
            VerificationDataIteratorPretty.appendNChars(Foot, ' ', this.mRowWidth - Trailer.length() + this.mNumberOfColumns);
            Foot.append("|\n");
            Foot.append(this.mDelimiterRow);
            Result = Foot.toString();
        } else {
            StringBuffer FormattedRow = new StringBuffer(this.mRowWidth * 2);
            ArrayList Row = (ArrayList)this.mValues.get(this.mCurrentPos);
            String Value = "";
            for (int i = 0; i < this.mNumberOfColumns; ++i) {
                FormattedRow.append('|');
                Object ValueObject = Row.get(i);
                if (ValueObject == null) {
                    Value = "NULL";
                } else if (ColumnDescriptor.isString(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType())) {
                    Value = ValueObject.toString();
                    if (Value.length() > 20) {
                        Value = Value.substring(0, 18) + "..";
                    }
                } else if (ColumnDescriptor.isNumeric(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType())) {
                    Value = ValueObject.toString();
                    if (Value.length() > 20) {
                        Value = Value.substring(0, 18) + "..";
                    }
                } else if (ColumnDescriptor.isBinary(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType()) && (Value = "X" + ValueObject.toString()).length() > 20) {
                    Value = Value.substring(0, 18) + "..";
                }
                FormattedRow.append(Value);
                VerificationDataIteratorPretty.appendNChars(FormattedRow, ' ', this.mColumnWidth[i] - Value.length());
            }
            FormattedRow.append('|');
            Result = FormattedRow.toString();
        }
        ++this.mCurrentPos;
        return Result;
    }
}

