/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.driver.TestStatementMonitor;
import com.sap.sapdb.testframe.driver.TestStatementMonitorException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TestPreparedStatement
extends TestStatement
implements PreparedStatement {
    TestPreparedStatement(TestCase pTestCase) throws SQLException {
        super(pTestCase);
    }

    public TestPreparedStatement(TestCase pTestCase, Connection pConnection, String pSql) throws SQLException {
        this(pTestCase);
        this.mStatement = pConnection.prepareStatement(pSql);
        this.mConnection = pConnection;
        this.mResultItemData.setSqlStatement(pSql);
    }

    public TestPreparedStatement(TestCase pTestCase, Connection pConnection, String pSql, int pResultSetType, int pResultSetConcurrency) throws SQLException {
        this(pTestCase);
        this.mStatement = pConnection.prepareStatement(pSql, pResultSetType, pResultSetConcurrency);
        this.mConnection = pConnection;
        if (pResultSetType != 1003) {
            this.setIsScrollable(true);
        }
        this.mResultItemData.setSqlStatement(pSql);
    }

    public TestPreparedStatement(TestCase pTestCase, Connection pConnection, String pSql, TestStatementMonitor pMonitor) throws SQLException {
        this(pTestCase);
        this.mMonitor = pMonitor;
        try {
            if (this.mMonitor != null) {
                this.mMonitor.clear();
            }
        }
        catch (TestStatementMonitorException Tsme) {
            // empty catch block
        }
        this.mStatement = pConnection.prepareStatement(pSql);
        this.mConnection = pConnection;
        this.mResultItemData.setSqlStatement(pSql);
    }

    public TestPreparedStatement(TestCase pTestCase, Connection pConnection, String pSql, TestStatementMonitor pMonitor, int pResultSetType, int pResultSetConcurrency) throws SQLException {
        this(pTestCase);
        this.mMonitor = pMonitor;
        try {
            if (this.mMonitor != null) {
                this.mMonitor.clear();
            }
        }
        catch (TestStatementMonitorException Tsme) {
            // empty catch block
        }
        this.mStatement = pConnection.prepareStatement(pSql, pResultSetType, pResultSetConcurrency);
        this.mConnection = pConnection;
        if (pResultSetType != 1003) {
            this.setIsScrollable(true);
        }
        this.mResultItemData.setSqlStatement(pSql);
    }

    public void addBatch() throws SQLException {
        ((PreparedStatement)this.mStatement).addBatch();
    }

    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.mStatement).clearParameters();
    }

    public boolean execute() throws SQLException {
        this.beforeExecution();
        try {
            boolean lIsResultSet = ((PreparedStatement)this.mStatement).execute();
            this.afterExecution(lIsResultSet);
            return lIsResultSet;
        }
        catch (SQLException e) {
            this.afterExecutionExceptionOccured(e);
            return false;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.beforeExecution();
        try {
            ResultSet lResultSet = ((PreparedStatement)this.mStatement).executeQuery();
            this.afterExecution(true);
            return lResultSet;
        }
        catch (SQLException e) {
            this.afterExecutionExceptionOccured(e);
            return null;
        }
    }

    public int executeUpdate() throws SQLException {
        this.beforeExecution();
        try {
            int lResultCounter = ((PreparedStatement)this.mStatement).executeUpdate();
            this.afterExecution(false);
            return lResultCounter;
        }
        catch (SQLException e) {
            this.afterExecutionExceptionOccured(e);
            return -1;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.mStatement).getMetaData();
    }

    public TestStatementMonitor getMonitor() {
        return this.mMonitor;
    }

    public String getParseId() {
        return TestStatementMonitor.getParseId((PreparedStatement)this.mStatement);
    }

    public void setArray(int i, Array x) throws SQLException {
        ((PreparedStatement)this.mStatement).setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.mStatement).setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        ((PreparedStatement)this.mStatement).setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.mStatement).setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        ((PreparedStatement)this.mStatement).setBlob(i, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        ((PreparedStatement)this.mStatement).setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        ((PreparedStatement)this.mStatement).setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        ((PreparedStatement)this.mStatement).setBytes(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        ((PreparedStatement)this.mStatement).setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        ((PreparedStatement)this.mStatement).setClob(i, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        ((PreparedStatement)this.mStatement).setDate(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.mStatement).setDate(parameterIndex, x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        ((PreparedStatement)this.mStatement).setDouble(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        ((PreparedStatement)this.mStatement).setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        ((PreparedStatement)this.mStatement).setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        ((PreparedStatement)this.mStatement).setLong(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        ((PreparedStatement)this.mStatement).setNull(parameterIndex, sqlType);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        ((PreparedStatement)this.mStatement).setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        ((PreparedStatement)this.mStatement).setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        ((PreparedStatement)this.mStatement).setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        ((PreparedStatement)this.mStatement).setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setRef(int i, Ref x) throws SQLException {
        ((PreparedStatement)this.mStatement).setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        ((PreparedStatement)this.mStatement).setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        ((PreparedStatement)this.mStatement).setString(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        ((PreparedStatement)this.mStatement).setTime(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.mStatement).setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        ((PreparedStatement)this.mStatement).setTimestamp(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.mStatement).setTimestamp(parameterIndex, x, cal);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("Method not supported by TestPreparedStatement- DEPRECATED");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public void setURL(int arg0, URL arg1) throws SQLException {
    }
}

