/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ExplainConstants;
import com.sap.sapdb.testframe.testcase.ExplainData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class ExplainDataIterator
implements Iterator,
ExplainConstants {
    private ArrayList mValues;
    private int mNumberOfRows;
    protected int mCurrentPosition;
    private ArrayList mStrategyList;
    private int mNumberOfItems;
    protected int mCurrentItemPosition;
    private String mTable = null;
    private String mStrategy = null;
    private String mPagecount = null;
    private ArrayList mStrategyInfo;
    private String mColumn = null;
    protected ExplainData mExplainData = null;

    ExplainDataIterator() {
        this.mNumberOfRows = 0;
        this.mCurrentPosition = 0;
        this.mStrategyList = new ArrayList();
    }

    ExplainDataIterator(ExplainData pExplainData) {
        this.mExplainData = pExplainData;
        this.mValues = pExplainData.getData();
        this.mNumberOfRows = this.mValues.size();
        this.mCurrentPosition = 0;
        this.mStrategyList = new ArrayList();
    }

    protected static void appendNChar(StringBuffer pStb, char pChar, int pNumber) {
        for (int i = 0; i < pNumber; ++i) {
            pStb.append(pChar);
        }
    }

    protected static void appendNSpaces(StringBuffer pStb, int pNumber) {
        for (int i = 0; i < pNumber; ++i) {
            pStb.append(' ');
        }
    }

    public String getColumn() {
        return this.mColumn;
    }

    int getNumberOfItems() {
        return this.mNumberOfItems;
    }

    int getNumberOfRows() {
        return this.mNumberOfRows;
    }

    public String getPagecount() {
        return this.mPagecount;
    }

    public String getStrategy() {
        return this.mStrategy;
    }

    public ArrayList getStrategyInfo() {
        return this.mStrategyInfo;
    }

    public String getTable() {
        return this.mTable;
    }

    public boolean hasNext() {
        return this.mCurrentPosition < this.mNumberOfRows;
    }

    public boolean hasNextItem() {
        return this.mCurrentItemPosition < this.mNumberOfItems;
    }

    public Object next() {
        this.mTable = null;
        this.mStrategyList.clear();
        this.mNumberOfItems = 0;
        this.mCurrentItemPosition = 0;
        ArrayList currentTable = (ArrayList)this.mValues.get(this.mCurrentPosition);
        ListIterator it = currentTable.listIterator();
        int itemCounter = 0;
        while (it.hasNext()) {
            Object Obj = it.next();
            if (itemCounter == 0) {
                this.mTable = (String)Obj;
            } else {
                this.mStrategyList.add(Obj);
                ++this.mNumberOfItems;
            }
            ++itemCounter;
        }
        String sep = ", ";
        StringBuffer Row = new StringBuffer(256);
        Row.append(this.mTable);
        for (int i = 0; i < this.mNumberOfItems; ++i) {
            ArrayList Strategy = (ArrayList)this.mStrategyList.get(i);
            if (Strategy == null || Strategy.isEmpty()) continue;
            Row.append(sep);
            Row.append((String)Strategy.get(0));
            Row.append(sep);
            Row.append((String)Strategy.get(1));
            ArrayList StrategyInfo = (ArrayList)Strategy.get(2);
            if (StrategyInfo != null && !StrategyInfo.isEmpty()) {
                ListIterator its = StrategyInfo.listIterator();
                while (its.hasNext()) {
                    Row.append(sep);
                    Row.append((String)its.next());
                }
            }
            Row.append(sep);
            Row.append((String)Strategy.get(3));
        }
        ++this.mCurrentPosition;
        return Row.toString();
    }

    public void nextItem() {
        this.mStrategy = null;
        this.mStrategyInfo = null;
        this.mColumn = null;
        this.mStrategy = (String)((ArrayList)this.mStrategyList.get(this.mCurrentItemPosition)).get(0);
        this.mPagecount = (String)((ArrayList)this.mStrategyList.get(this.mCurrentItemPosition)).get(1);
        this.mStrategyInfo = (ArrayList)((ArrayList)this.mStrategyList.get(this.mCurrentItemPosition)).get(2);
        this.mColumn = (String)((ArrayList)this.mStrategyList.get(this.mCurrentItemPosition)).get(3);
        ++this.mCurrentItemPosition;
    }

    public void remove() {
    }
}

